"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .bucketschemafield_output import (
    BucketSchemaFieldOutput,
    BucketSchemaFieldOutputTypedDict,
)
from .vectorindexdefinition import VectorIndexDefinition, VectorIndexDefinitionTypedDict
from mixpeek.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import Any, Dict, List
from typing_extensions import NotRequired, TypedDict


class StageDefinitionDefaultParametersTypedDict(TypedDict):
    pass


class StageDefinitionDefaultParameters(BaseModel):
    pass


class StageDefinitionTypedDict(TypedDict):
    r"""Model for retriever stage definition that describes how to process and search documents."""

    stage_name: str
    r"""Name of the stage"""
    description: str
    version: str
    module_path: str
    input_schema: Dict[str, BucketSchemaFieldOutputTypedDict]
    output_schema: Dict[str, BucketSchemaFieldOutputTypedDict]
    parameter_schema: Dict[str, BucketSchemaFieldOutputTypedDict]
    supported_input_types: List[str]
    max_inputs: Dict[str, int]
    default_parameters: StageDefinitionDefaultParametersTypedDict
    required_vector_indexes: NotRequired[Nullable[List[VectorIndexDefinitionTypedDict]]]
    required_payload_indexes: NotRequired[Nullable[List[Any]]]
    supported_filters: NotRequired[Nullable[List[str]]]
    r"""List of filter operations supported by this stage"""


class StageDefinition(BaseModel):
    r"""Model for retriever stage definition that describes how to process and search documents."""

    stage_name: str
    r"""Name of the stage"""

    description: str

    version: str

    module_path: str

    input_schema: Dict[str, BucketSchemaFieldOutput]

    output_schema: Dict[str, BucketSchemaFieldOutput]

    parameter_schema: Dict[str, BucketSchemaFieldOutput]

    supported_input_types: List[str]

    max_inputs: Dict[str, int]

    default_parameters: StageDefinitionDefaultParameters

    required_vector_indexes: OptionalNullable[List[VectorIndexDefinition]] = UNSET

    required_payload_indexes: OptionalNullable[List[Any]] = UNSET

    supported_filters: OptionalNullable[List[str]] = UNSET
    r"""List of filter operations supported by this stage"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "required_vector_indexes",
            "required_payload_indexes",
            "supported_filters",
        ]
        nullable_fields = [
            "required_vector_indexes",
            "required_payload_indexes",
            "supported_filters",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
