"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mixpeek.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import List
from typing_extensions import NotRequired, TypedDict


class ResultsTypedDict(TypedDict):
    pass


class Results(BaseModel):
    pass


class StageResponseTypedDict(TypedDict):
    r"""Output from a retriever stage"""

    results: List[ResultsTypedDict]
    execution_time: float
    total_results: NotRequired[Nullable[int]]
    r"""Total number of results not filtered by pagination"""


class StageResponse(BaseModel):
    r"""Output from a retriever stage"""

    results: List[Results]

    execution_time: float

    total_results: OptionalNullable[int] = UNSET
    r"""Total number of results not filtered by pagination"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["total_results"]
        nullable_fields = ["total_results"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
