"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .createblobrequest import CreateBlobRequest, CreateBlobRequestTypedDict
from mixpeek.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import List
from typing_extensions import NotRequired, TypedDict


class UpdateObjectRequestMetadataTypedDict(TypedDict):
    pass


class UpdateObjectRequestMetadata(BaseModel):
    pass


class UpdateObjectRequestTypedDict(TypedDict):
    r"""Request model for updating an existing bucket object"""

    key_prefix: NotRequired[Nullable[str]]
    r"""Updated storage key/path prefix of the object, this will be used to retrieve the object from the storage. It's at the root of the object."""
    blobs: NotRequired[Nullable[List[CreateBlobRequestTypedDict]]]
    r"""List of new or updated blobs for this object"""
    metadata: NotRequired[Nullable[UpdateObjectRequestMetadataTypedDict]]
    r"""Updated metadata for the object, this will be merged with existing metadata."""
    skip_duplicates: NotRequired[Nullable[bool]]
    r"""Skip duplicate blobs, if a blob with the same hash already exists, it will be skipped."""


class UpdateObjectRequest(BaseModel):
    r"""Request model for updating an existing bucket object"""

    key_prefix: OptionalNullable[str] = UNSET
    r"""Updated storage key/path prefix of the object, this will be used to retrieve the object from the storage. It's at the root of the object."""

    blobs: OptionalNullable[List[CreateBlobRequest]] = UNSET
    r"""List of new or updated blobs for this object"""

    metadata: OptionalNullable[UpdateObjectRequestMetadata] = UNSET
    r"""Updated metadata for the object, this will be merged with existing metadata."""

    skip_duplicates: OptionalNullable[bool] = UNSET
    r"""Skip duplicate blobs, if a blob with the same hash already exists, it will be skipped."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["key_prefix", "blobs", "metadata", "skip_duplicates"]
        nullable_fields = ["key_prefix", "blobs", "metadata", "skip_duplicates"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
