"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .namespaceusage import NamespaceUsage, NamespaceUsageTypedDict
from .plan import Plan, PlanTypedDict
from .timeseriesusage import TimeseriesUsage, TimeseriesUsageTypedDict
from .usagesummary import UsageSummary, UsageSummaryTypedDict
from datetime import datetime
from mixpeek.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import List
from typing_extensions import NotRequired, TypedDict


class UsageResponseTypedDict(TypedDict):
    r"""Complete usage response model"""

    usage_summary: UsageSummaryTypedDict
    r"""Summary of current resource usage"""
    namespace_usage: List[NamespaceUsageTypedDict]
    r"""Usage by namespace"""
    billing_period_end: datetime
    r"""End of current billing period"""
    organization_id: str
    r"""Organization ID"""
    usage_history: NotRequired[Nullable[TimeseriesUsageTypedDict]]
    r"""Historical usage data"""
    billing_period_start: NotRequired[Nullable[datetime]]
    r"""Start of current billing period"""
    current_plan: NotRequired[Nullable[PlanTypedDict]]
    r"""Current subscription plan"""


class UsageResponse(BaseModel):
    r"""Complete usage response model"""

    usage_summary: UsageSummary
    r"""Summary of current resource usage"""

    namespace_usage: List[NamespaceUsage]
    r"""Usage by namespace"""

    billing_period_end: datetime
    r"""End of current billing period"""

    organization_id: str
    r"""Organization ID"""

    usage_history: OptionalNullable[TimeseriesUsage] = UNSET
    r"""Historical usage data"""

    billing_period_start: OptionalNullable[datetime] = UNSET
    r"""Start of current billing period"""

    current_plan: OptionalNullable[Plan] = UNSET
    r"""Current subscription plan"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["usage_history", "billing_period_start", "current_plan"]
        nullable_fields = ["usage_history", "billing_period_start", "current_plan"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
