"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .clusteringmethod import ClusteringMethod
from .hdbscanparameters import HDBSCANParameters, HDBSCANParametersTypedDict
from mixpeek.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import Optional
from typing_extensions import NotRequired, TypedDict


class VectorBasedConfigTypedDict(TypedDict):
    feature_extractor_name: str
    r"""Name of the feature extractor to use for vector-based clustering"""
    clustering_method: ClusteringMethod
    sample_size: NotRequired[int]
    r"""Maximum number of documents to process"""
    hdbscan_parameters: NotRequired[Nullable[HDBSCANParametersTypedDict]]


class VectorBasedConfig(BaseModel):
    feature_extractor_name: str
    r"""Name of the feature extractor to use for vector-based clustering"""

    clustering_method: ClusteringMethod

    sample_size: Optional[int] = 1000
    r"""Maximum number of documents to process"""

    hdbscan_parameters: OptionalNullable[HDBSCANParameters] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sample_size", "hdbscan_parameters"]
        nullable_fields = ["hdbscan_parameters"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
