"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from mixpeek import models, utils
from mixpeek._hooks import HookContext
from mixpeek.types import OptionalNullable, UNSET
from mixpeek.utils import get_security_from_env
from typing import Any, List, Mapping, Optional, Union


class Retrievers(BaseSDK):
    def create(
        self,
        *,
        retriever_name: str,
        input_schema: Union[
            models.RetrieverSchemaInput, models.RetrieverSchemaInputTypedDict
        ],
        collection_ids: List[str],
        stages: Union[
            List[models.StageConfigInput], List[models.StageConfigInputTypedDict]
        ],
        x_namespace: OptionalNullable[str] = UNSET,
        description: OptionalNullable[str] = UNSET,
        metadata: Optional[
            Union[
                models.CreateRetrieverRequestMetadata,
                models.CreateRetrieverRequestMetadataTypedDict,
            ]
        ] = None,
        cache_config: OptionalNullable[
            Union[models.RetrieverCacheConfig, models.RetrieverCacheConfigTypedDict]
        ] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.RetrieverModel:
        r"""Create Retriever

        :param retriever_name: Name of the retriever
        :param input_schema: Schema definition for retriever inputs
        :param collection_ids: List of collection IDs to search in
        :param stages: List of stages to execute in order
        :param x_namespace: Optional namespace for data isolation. This can be a namespace name or namespace ID. Example: 'netflix_prod' or 'ns_1234567890'. To create a namespace, use the /namespaces endpoint.
        :param description: Description of the retriever
        :param metadata:
        :param cache_config: Configuration for retriever-level caching
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CreateRetrieverV1RetrieversRetrieversPostRequest(
            x_namespace=x_namespace,
            create_retriever_request=models.CreateRetrieverRequest(
                retriever_name=retriever_name,
                description=description,
                input_schema=utils.get_pydantic_model(
                    input_schema, models.RetrieverSchemaInput
                ),
                collection_ids=collection_ids,
                stages=utils.get_pydantic_model(stages, List[models.StageConfigInput]),
                metadata=utils.get_pydantic_model(
                    metadata, Optional[models.CreateRetrieverRequestMetadata]
                ),
                cache_config=utils.get_pydantic_model(
                    cache_config, OptionalNullable[models.RetrieverCacheConfig]
                ),
            ),
        )

        req = self._build_request(
            method="POST",
            path="/v1/retrievers/retrievers",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.create_retriever_request,
                False,
                False,
                "json",
                models.CreateRetrieverRequest,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="create_retriever_v1_retrievers_retrievers_post",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "422", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return utils.unmarshal_json(http_res.text, models.RetrieverModel)
        if utils.match_response(
            http_res, ["400", "401", "403", "404"], "application/json"
        ):
            response_data = utils.unmarshal_json(
                http_res.text, models.ErrorResponseData
            )
            raise models.ErrorResponse(data=response_data)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.HTTPValidationErrorData
            )
            raise models.HTTPValidationError(data=response_data)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.ErrorResponseData
            )
            raise models.ErrorResponse(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = utils.stream_to_text(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    async def create_async(
        self,
        *,
        retriever_name: str,
        input_schema: Union[
            models.RetrieverSchemaInput, models.RetrieverSchemaInputTypedDict
        ],
        collection_ids: List[str],
        stages: Union[
            List[models.StageConfigInput], List[models.StageConfigInputTypedDict]
        ],
        x_namespace: OptionalNullable[str] = UNSET,
        description: OptionalNullable[str] = UNSET,
        metadata: Optional[
            Union[
                models.CreateRetrieverRequestMetadata,
                models.CreateRetrieverRequestMetadataTypedDict,
            ]
        ] = None,
        cache_config: OptionalNullable[
            Union[models.RetrieverCacheConfig, models.RetrieverCacheConfigTypedDict]
        ] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.RetrieverModel:
        r"""Create Retriever

        :param retriever_name: Name of the retriever
        :param input_schema: Schema definition for retriever inputs
        :param collection_ids: List of collection IDs to search in
        :param stages: List of stages to execute in order
        :param x_namespace: Optional namespace for data isolation. This can be a namespace name or namespace ID. Example: 'netflix_prod' or 'ns_1234567890'. To create a namespace, use the /namespaces endpoint.
        :param description: Description of the retriever
        :param metadata:
        :param cache_config: Configuration for retriever-level caching
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CreateRetrieverV1RetrieversRetrieversPostRequest(
            x_namespace=x_namespace,
            create_retriever_request=models.CreateRetrieverRequest(
                retriever_name=retriever_name,
                description=description,
                input_schema=utils.get_pydantic_model(
                    input_schema, models.RetrieverSchemaInput
                ),
                collection_ids=collection_ids,
                stages=utils.get_pydantic_model(stages, List[models.StageConfigInput]),
                metadata=utils.get_pydantic_model(
                    metadata, Optional[models.CreateRetrieverRequestMetadata]
                ),
                cache_config=utils.get_pydantic_model(
                    cache_config, OptionalNullable[models.RetrieverCacheConfig]
                ),
            ),
        )

        req = self._build_request_async(
            method="POST",
            path="/v1/retrievers/retrievers",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.create_retriever_request,
                False,
                False,
                "json",
                models.CreateRetrieverRequest,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="create_retriever_v1_retrievers_retrievers_post",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "422", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return utils.unmarshal_json(http_res.text, models.RetrieverModel)
        if utils.match_response(
            http_res, ["400", "401", "403", "404"], "application/json"
        ):
            response_data = utils.unmarshal_json(
                http_res.text, models.ErrorResponseData
            )
            raise models.ErrorResponse(data=response_data)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.HTTPValidationErrorData
            )
            raise models.HTTPValidationError(data=response_data)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.ErrorResponseData
            )
            raise models.ErrorResponse(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = await utils.stream_to_text_async(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    def get(
        self,
        *,
        retriever_id: str,
        x_namespace: OptionalNullable[str] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.RetrieverModel:
        r"""Get Retriever

        :param retriever_id:
        :param x_namespace: Optional namespace for data isolation. This can be a namespace name or namespace ID. Example: 'netflix_prod' or 'ns_1234567890'. To create a namespace, use the /namespaces endpoint.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetRetrieverV1RetrieversRetrieversRetrieverIDGetRequest(
            retriever_id=retriever_id,
            x_namespace=x_namespace,
        )

        req = self._build_request(
            method="GET",
            path="/v1/retrievers/retrievers/{retriever_id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="get_retriever_v1_retrievers_retrievers__retriever_id__get",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "422", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return utils.unmarshal_json(http_res.text, models.RetrieverModel)
        if utils.match_response(
            http_res, ["400", "401", "403", "404"], "application/json"
        ):
            response_data = utils.unmarshal_json(
                http_res.text, models.ErrorResponseData
            )
            raise models.ErrorResponse(data=response_data)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.HTTPValidationErrorData
            )
            raise models.HTTPValidationError(data=response_data)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.ErrorResponseData
            )
            raise models.ErrorResponse(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = utils.stream_to_text(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    async def get_async(
        self,
        *,
        retriever_id: str,
        x_namespace: OptionalNullable[str] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.RetrieverModel:
        r"""Get Retriever

        :param retriever_id:
        :param x_namespace: Optional namespace for data isolation. This can be a namespace name or namespace ID. Example: 'netflix_prod' or 'ns_1234567890'. To create a namespace, use the /namespaces endpoint.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetRetrieverV1RetrieversRetrieversRetrieverIDGetRequest(
            retriever_id=retriever_id,
            x_namespace=x_namespace,
        )

        req = self._build_request_async(
            method="GET",
            path="/v1/retrievers/retrievers/{retriever_id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="get_retriever_v1_retrievers_retrievers__retriever_id__get",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "422", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return utils.unmarshal_json(http_res.text, models.RetrieverModel)
        if utils.match_response(
            http_res, ["400", "401", "403", "404"], "application/json"
        ):
            response_data = utils.unmarshal_json(
                http_res.text, models.ErrorResponseData
            )
            raise models.ErrorResponse(data=response_data)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.HTTPValidationErrorData
            )
            raise models.HTTPValidationError(data=response_data)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.ErrorResponseData
            )
            raise models.ErrorResponse(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = await utils.stream_to_text_async(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    def execute(
        self,
        *,
        retriever_id: str,
        inputs: Union[
            models.RetrieverQueryRequestInputs,
            models.RetrieverQueryRequestInputsTypedDict,
        ],
        x_namespace: OptionalNullable[str] = UNSET,
        filters: OptionalNullable[
            Union[models.LogicalOperatorInput, models.LogicalOperatorInputTypedDict]
        ] = UNSET,
        sorts: OptionalNullable[
            Union[List[models.SortOption], List[models.SortOptionTypedDict]]
        ] = UNSET,
        limit: Optional[int] = 10,
        offset: Optional[int] = 0,
        select: OptionalNullable[List[str]] = UNSET,
        session_id: OptionalNullable[str] = UNSET,
        return_urls: Optional[bool] = False,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.RetrieverResponse:
        r"""Execute Retriever

        :param retriever_id:
        :param inputs: Input values for the retriever query. These map to the required inputs defined in the retriever's first stage.
        :param x_namespace: Optional namespace for data isolation. This can be a namespace name or namespace ID. Example: 'netflix_prod' or 'ns_1234567890'. To create a namespace, use the /namespaces endpoint.
        :param filters: Logical operations for filtering results. Can include AND, OR, NOT conditions with field comparisons.
        :param sorts: Controls the ordering of results. Can sort by score (default) or any other document field. This sorts the results from the last stage.
        :param limit: Maximum number of results to return. Overrides the default pagination limit in the retriever definition.
        :param offset: Number of results to skip. Use with limit for pagination. For large offsets, consider using session_id for cursor-based pagination.
        :param select: Specific fields to include in the response. If not specified, returns all fields.
        :param session_id: Session identifier for interaction tracking.
        :param return_urls: When true, generates pre-signed URLs for any media assets in the results. May increase response time slightly.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = (
            models.ExecuteRetrieverV1RetrieversRetrieversRetrieverIDExecutePostRequest(
                retriever_id=retriever_id,
                x_namespace=x_namespace,
                retriever_query_request=models.RetrieverQueryRequest(
                    inputs=utils.get_pydantic_model(
                        inputs, models.RetrieverQueryRequestInputs
                    ),
                    filters=utils.get_pydantic_model(
                        filters, OptionalNullable[models.LogicalOperatorInput]
                    ),
                    sorts=utils.get_pydantic_model(
                        sorts, OptionalNullable[List[models.SortOption]]
                    ),
                    limit=limit,
                    offset=offset,
                    select=select,
                    session_id=session_id,
                    return_urls=return_urls,
                ),
            )
        )

        req = self._build_request(
            method="POST",
            path="/v1/retrievers/retrievers/{retriever_id}/execute",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.retriever_query_request,
                False,
                False,
                "json",
                models.RetrieverQueryRequest,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="execute_retriever_v1_retrievers_retrievers__retriever_id__execute_post",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "422", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return utils.unmarshal_json(http_res.text, models.RetrieverResponse)
        if utils.match_response(
            http_res, ["400", "401", "403", "404"], "application/json"
        ):
            response_data = utils.unmarshal_json(
                http_res.text, models.ErrorResponseData
            )
            raise models.ErrorResponse(data=response_data)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.HTTPValidationErrorData
            )
            raise models.HTTPValidationError(data=response_data)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.ErrorResponseData
            )
            raise models.ErrorResponse(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = utils.stream_to_text(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    async def execute_async(
        self,
        *,
        retriever_id: str,
        inputs: Union[
            models.RetrieverQueryRequestInputs,
            models.RetrieverQueryRequestInputsTypedDict,
        ],
        x_namespace: OptionalNullable[str] = UNSET,
        filters: OptionalNullable[
            Union[models.LogicalOperatorInput, models.LogicalOperatorInputTypedDict]
        ] = UNSET,
        sorts: OptionalNullable[
            Union[List[models.SortOption], List[models.SortOptionTypedDict]]
        ] = UNSET,
        limit: Optional[int] = 10,
        offset: Optional[int] = 0,
        select: OptionalNullable[List[str]] = UNSET,
        session_id: OptionalNullable[str] = UNSET,
        return_urls: Optional[bool] = False,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.RetrieverResponse:
        r"""Execute Retriever

        :param retriever_id:
        :param inputs: Input values for the retriever query. These map to the required inputs defined in the retriever's first stage.
        :param x_namespace: Optional namespace for data isolation. This can be a namespace name or namespace ID. Example: 'netflix_prod' or 'ns_1234567890'. To create a namespace, use the /namespaces endpoint.
        :param filters: Logical operations for filtering results. Can include AND, OR, NOT conditions with field comparisons.
        :param sorts: Controls the ordering of results. Can sort by score (default) or any other document field. This sorts the results from the last stage.
        :param limit: Maximum number of results to return. Overrides the default pagination limit in the retriever definition.
        :param offset: Number of results to skip. Use with limit for pagination. For large offsets, consider using session_id for cursor-based pagination.
        :param select: Specific fields to include in the response. If not specified, returns all fields.
        :param session_id: Session identifier for interaction tracking.
        :param return_urls: When true, generates pre-signed URLs for any media assets in the results. May increase response time slightly.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = (
            models.ExecuteRetrieverV1RetrieversRetrieversRetrieverIDExecutePostRequest(
                retriever_id=retriever_id,
                x_namespace=x_namespace,
                retriever_query_request=models.RetrieverQueryRequest(
                    inputs=utils.get_pydantic_model(
                        inputs, models.RetrieverQueryRequestInputs
                    ),
                    filters=utils.get_pydantic_model(
                        filters, OptionalNullable[models.LogicalOperatorInput]
                    ),
                    sorts=utils.get_pydantic_model(
                        sorts, OptionalNullable[List[models.SortOption]]
                    ),
                    limit=limit,
                    offset=offset,
                    select=select,
                    session_id=session_id,
                    return_urls=return_urls,
                ),
            )
        )

        req = self._build_request_async(
            method="POST",
            path="/v1/retrievers/retrievers/{retriever_id}/execute",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.retriever_query_request,
                False,
                False,
                "json",
                models.RetrieverQueryRequest,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="execute_retriever_v1_retrievers_retrievers__retriever_id__execute_post",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "422", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return utils.unmarshal_json(http_res.text, models.RetrieverResponse)
        if utils.match_response(
            http_res, ["400", "401", "403", "404"], "application/json"
        ):
            response_data = utils.unmarshal_json(
                http_res.text, models.ErrorResponseData
            )
            raise models.ErrorResponse(data=response_data)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.HTTPValidationErrorData
            )
            raise models.HTTPValidationError(data=response_data)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.ErrorResponseData
            )
            raise models.ErrorResponse(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = await utils.stream_to_text_async(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )
