# Generated by Django 3.2.16 on 2022-10-07 22:46

from django.core.management.sql import emit_post_migrate_signal
from django.db import migrations, models
import django.db.models.deletion

from ..constants import roles


# pylint: disable=unused-argument
def update_roles(apps, schema_editor):
    """
    Update permissions for service and management group

    :param apps: The configuration of installed applications
    :type apps: ~django.apps.registry.Apps

    :param schema_editor: The database abstraction layer that creates actual SQL code
    :type schema_editor: ~django.db.backends.base.schema.BaseDatabaseSchemaEditor
    """
    Group = apps.get_model("auth", "Group")
    Permission = apps.get_model("auth", "Permission")

    # Emit post-migrate signal to make sure the Permission objects are created before they can be assigned
    emit_post_migrate_signal(2, False, "default")

    # Clear and update permissions according to new constants
    for role_name in dict(roles.CHOICES):
        group, _ = Group.objects.get_or_create(name=role_name)
        # Clear permissions
        group.permissions.clear()
        # Set permissions
        group.permissions.add(
            *Permission.objects.filter(codename__in=roles.PERMISSIONS[role_name])
        )


class Migration(migrations.Migration):
    """
    Add the POICategory and POICategoryTranslation models
    """

    dependencies = [
        ("cms", "0038_region_summ_ai_enabled"),
    ]

    operations = [
        migrations.CreateModel(
            name="POICategory",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
            ],
            options={
                "verbose_name": "location category",
                "verbose_name_plural": "location categories",
                "default_permissions": ("change", "delete", "view"),
            },
        ),
        migrations.CreateModel(
            name="POICategoryTranslation",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="The name of the POI category.",
                        max_length=250,
                        verbose_name="category name",
                    ),
                ),
                (
                    "category",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="translations",
                        to="cms.poicategory",
                        verbose_name="category",
                    ),
                ),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="poi_category_translations",
                        to="cms.language",
                        verbose_name="language",
                    ),
                ),
            ],
            options={
                "verbose_name": "location category translation",
                "verbose_name_plural": "location category translations",
                "ordering": ["category"],
                "default_permissions": ("change", "delete", "view"),
            },
        ),
        migrations.AddField(
            model_name="poi",
            name="category",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="pois",
                to="cms.poicategory",
                verbose_name="category",
            ),
        ),
        migrations.RunPython(update_roles, migrations.RunPython.noop),
    ]
