"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateProps = void 0;
const core_1 = require("@aws-cdk/core");
function validateProps(props) {
    validateRange('delivery delay', props.deliveryDelay && props.deliveryDelay.toSeconds(), 0, 900, 'seconds');
    validateRange('maximum message size', props.maxMessageSizeBytes, 1024, 262144, 'bytes');
    validateRange('message retention period', props.retentionPeriod && props.retentionPeriod.toSeconds(), 60, 1209600, 'seconds');
    validateRange('receive wait time', props.receiveMessageWaitTime && props.receiveMessageWaitTime.toSeconds(), 0, 20, 'seconds');
    validateRange('visibility timeout', props.visibilityTimeout && props.visibilityTimeout.toSeconds(), 0, 43200, 'seconds');
    validateRange('dead letter target maximum receive count', props.deadLetterQueue && props.deadLetterQueue.maxReceiveCount, 1, +Infinity);
}
exports.validateProps = validateProps;
function validateRange(label, value, minValue, maxValue, unit) {
    if (value === undefined || core_1.Token.isUnresolved(value)) {
        return;
    }
    const unitSuffix = unit ? ` ${unit}` : '';
    if (value < minValue) {
        throw new Error(`${label} must be ${minValue}${unitSuffix} or more, but ${value} was provided`);
    }
    if (value > maxValue) {
        throw new Error(`${label} must be ${maxValue}${unitSuffix} of less, but ${value} was provided`);
    }
}
//# sourceMappingURL=data:application/json;base64,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