# mypy-boto3-dynamodb

[![PyPI - mypy-boto3-dynamodb](https://img.shields.io/pypi/v/mypy-boto3-dynamodb.svg?color=blue)](https://pypi.org/project/mypy-boto3-dynamodb)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-dynamodb.svg?color=blue)](https://pypi.org/project/mypy-boto3-dynamodb)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

- [mypy-boto3-dynamodb](#mypy-boto3-dynamodb)
  - [How to use](#how-to-use)
  - [Automated type discovery](#automated-type-discovery)


Type annotations for
[boto3.DynamoDB 1.13.24](https://boto3.amazonaws.com/v1/documentation/api/1.13.24/reference/services/dynamodb.html#DynamoDB) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.0.2](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-dynamodb](#mypy-boto3-dynamodb)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
  - [How it works](#how-it-works)

## How to use

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `DynamoDB` service.

```bash
python -m pip install boto3-stubs[dynamodb]

# update installed packages index for automated type discovery
python -m mypy_boto3
```

Use `boto3` with `mypy_boto3_dynamodb` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3_dynamodb import DynamoDBClient

# Now mypy can check if your code is valid.
client: DynamoDBClient = boto3.client("dynamodb")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: DynamoDBClient = session.client("dynamodb")

# Do you prefer resource approach? We've got you covered!
from mypy_boto3_dynamodb import DynamoDBServiceResource

resource: dynamodb.DynamoDBServiceResource = boto3.resource("dynamodb")


# Waiters are also supported

import mypy_boto3_dynamodb.waiter as dynamodb_waiters

table_exists_waiter: dynamodb_waiters.TableExistsWaiter = client.get_waiter("table_exists")
table_not_exists_waiter: dynamodb_waiters.TableNotExistsWaiter = client.get_waiter("table_not_exists")


# Annotated paginators are included as well

import mypy_boto3_dynamodb.paginator as dynamodb_paginators

list_backups_paginator: dynamodb_paginators.ListBackupsPaginator = client.get_paginator("list_backups")
list_tables_paginator: dynamodb_paginators.ListTablesPaginator = client.get_paginator("list_tables")
list_tags_of_resource_paginator: dynamodb_paginators.ListTagsOfResourcePaginator = client.get_paginator("list_tags_of_resource")
query_paginator: dynamodb_paginators.QueryPaginator = client.get_paginator("query")
scan_paginator: dynamodb_paginators.ScanPaginator = client.get_paginator("scan")
```

## Automated type discovery

`mypy_boto3` package can generate index for `mypy_boto3_dynamodb` and other installed services.

```bash
# Run this command when you add or remove service packages
python -m mypy_boto3
```

Generated index provides overloads for `boto3.client` and `boto3.service`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully
- `VSCode` does not currently support function overloads

Also, generated index allows you to import types from `mypy_boto3`:

```python
# you can replace imports
import mypy_boto3_dynamodb as dynamodb
from mypy_boto3_dynamodb import DynamoDBClient

# with these
from mypy_boto3 import dynamodb
from mypy_boto3.dynamodb import DynamoDBClient
```