import * as iam from '@aws-cdk/aws-iam';
import * as sfn from '@aws-cdk/aws-stepfunctions';
import { Construct } from 'constructs';
/**
 * Properties to define a EMR Containers DeleteVirtualCluster Task.
 *
 * @stability stable
 */
export interface EmrContainersDeleteVirtualClusterProps extends sfn.TaskStateBaseProps {
    /**
     * The ID of the virtual cluster that will be deleted.
     *
     * @stability stable
     */
    readonly virtualClusterId: sfn.TaskInput;
}
/**
 * Deletes an EMR Containers virtual cluster as a Task.
 *
 * @see https://docs.amazonaws.cn/en_us/step-functions/latest/dg/connect-emr-eks.html
 * @stability stable
 */
export declare class EmrContainersDeleteVirtualCluster extends sfn.TaskStateBase {
    private readonly props;
    private static readonly SUPPORTED_INTEGRATION_PATTERNS;
    /**
     * @stability stable
     */
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    /**
     * @stability stable
     */
    protected readonly taskPolicies?: iam.PolicyStatement[];
    private readonly integrationPattern;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: EmrContainersDeleteVirtualClusterProps);
    /**
     * @internal
     */
    protected _renderTask(): any;
    private createPolicyStatements;
}
