# Generated by Django 3.2.13 on 2022-06-22 08:16

import django.core.serializers.json
from django.db import migrations, models
import django.db.models.deletion
import nautobot.core.fields
import nautobot.dcim.fields
import nautobot.extras.models.mixins
import nautobot.extras.models.statuses
import nautobot.utilities.fields
import taggit.managers
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("circuits", "0008_add_natural_indexing"),
        ("dcim", "0009_add_natural_indexing"),
        ("extras", "0033_add__optimized_indexing"),
        ("ipam", "0007_add_natural_indexing"),
    ]

    operations = [
        migrations.CreateModel(
            name="AutonomousSystem",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                ("created", models.DateField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "_custom_field_data",
                    models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder),
                ),
                ("asn", nautobot.dcim.fields.ASNField(unique=True)),
                ("description", models.CharField(blank=True, max_length=200)),
                (
                    "provider",
                    models.ForeignKey(
                        blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to="circuits.provider"
                    ),
                ),
                (
                    "status",
                    nautobot.extras.models.statuses.StatusField(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="nautobot_bgp_models_autonomoussystem_related",
                        to="extras.status",
                    ),
                ),
                ("tags", taggit.managers.TaggableManager(through="extras.TaggedItem", to="extras.Tag")),
            ],
            options={
                "verbose_name": "Autonomous system",
                "ordering": ["asn"],
            },
            bases=(models.Model, nautobot.extras.models.mixins.DynamicGroupMixin),
        ),
        migrations.CreateModel(
            name="BGPRoutingInstance",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                ("created", models.DateField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "_custom_field_data",
                    models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder),
                ),
                (
                    "extra_attributes",
                    models.JSONField(blank=True, encoder=django.core.serializers.json.DjangoJSONEncoder, null=True),
                ),
                ("description", models.CharField(blank=True, max_length=200)),
                (
                    "autonomous_system",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT, to="nautobot_bgp_models.autonomoussystem"
                    ),
                ),
                (
                    "device",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="bgp_routing_instances",
                        to="dcim.device",
                    ),
                ),
                (
                    "router_id",
                    models.ForeignKey(
                        blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to="ipam.ipaddress"
                    ),
                ),
                ("tags", taggit.managers.TaggableManager(through="extras.TaggedItem", to="extras.Tag")),
            ],
            options={
                "verbose_name": "BGP Routing Instance",
                "unique_together": {("device", "autonomous_system")},
            },
            bases=(models.Model, nautobot.extras.models.mixins.DynamicGroupMixin),
        ),
        migrations.CreateModel(
            name="PeeringRole",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                ("created", models.DateField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "_custom_field_data",
                    models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder),
                ),
                ("name", models.CharField(max_length=100, unique=True)),
                (
                    "slug",
                    nautobot.core.fields.AutoSlugField(blank=True, max_length=100, populate_from="name", unique=True),
                ),
                ("color", nautobot.utilities.fields.ColorField(default="9e9e9e", max_length=6)),
                ("description", models.CharField(blank=True, max_length=200)),
            ],
            options={
                "verbose_name": "BGP Peering Role",
            },
            bases=(models.Model, nautobot.extras.models.mixins.DynamicGroupMixin),
        ),
        migrations.CreateModel(
            name="Peering",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                ("created", models.DateField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "_custom_field_data",
                    models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder),
                ),
                (
                    "status",
                    nautobot.extras.models.statuses.StatusField(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="nautobot_bgp_models_peering_related",
                        to="extras.status",
                    ),
                ),
            ],
            options={
                "verbose_name": "BGP Peering",
            },
            bases=(models.Model, nautobot.extras.models.mixins.DynamicGroupMixin),
        ),
        migrations.CreateModel(
            name="PeerGroupTemplate",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                ("created", models.DateField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "_custom_field_data",
                    models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder),
                ),
                (
                    "extra_attributes",
                    models.JSONField(blank=True, encoder=django.core.serializers.json.DjangoJSONEncoder, null=True),
                ),
                ("name", models.CharField(max_length=100, unique=True)),
                ("enabled", models.BooleanField(default=True)),
                ("description", models.CharField(blank=True, max_length=200)),
                ("import_policy", models.CharField(blank=True, default="", max_length=100)),
                ("export_policy", models.CharField(blank=True, default="", max_length=100)),
                (
                    "autonomous_system",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="peer_group_templates",
                        to="nautobot_bgp_models.autonomoussystem",
                    ),
                ),
                (
                    "role",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="peer_group_templates",
                        to="nautobot_bgp_models.peeringrole",
                    ),
                ),
                (
                    "secret",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="bgp_peer_group_templates",
                        to="extras.secret",
                    ),
                ),
                ("tags", taggit.managers.TaggableManager(through="extras.TaggedItem", to="extras.Tag")),
            ],
            options={
                "verbose_name": "BGP Peer Group Template",
            },
            bases=(models.Model, nautobot.extras.models.mixins.DynamicGroupMixin),
        ),
        migrations.CreateModel(
            name="PeerGroup",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                ("created", models.DateField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "_custom_field_data",
                    models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder),
                ),
                (
                    "extra_attributes",
                    models.JSONField(blank=True, encoder=django.core.serializers.json.DjangoJSONEncoder, null=True),
                ),
                ("name", models.CharField(max_length=100)),
                ("description", models.CharField(blank=True, max_length=200)),
                ("enabled", models.BooleanField(default=True)),
                ("import_policy", models.CharField(blank=True, default="", max_length=100)),
                ("export_policy", models.CharField(blank=True, default="", max_length=100)),
                (
                    "autonomous_system",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="peer_groups",
                        to="nautobot_bgp_models.autonomoussystem",
                    ),
                ),
                (
                    "role",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="peer_groups",
                        to="nautobot_bgp_models.peeringrole",
                    ),
                ),
                (
                    "routing_instance",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="peer_groups",
                        to="nautobot_bgp_models.bgproutinginstance",
                    ),
                ),
                (
                    "secret",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="bgp_peer_groups",
                        to="extras.secret",
                    ),
                ),
                (
                    "source_interface",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="bgp_peer_groups",
                        to="dcim.interface",
                    ),
                ),
                (
                    "source_ip",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="bgp_peer_groups",
                        to="ipam.ipaddress",
                    ),
                ),
                ("tags", taggit.managers.TaggableManager(through="extras.TaggedItem", to="extras.Tag")),
                (
                    "template",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="peer_groups",
                        to="nautobot_bgp_models.peergrouptemplate",
                    ),
                ),
            ],
            options={
                "verbose_name": "BGP Peer Group",
                "unique_together": {("name", "routing_instance")},
            },
            bases=(models.Model, nautobot.extras.models.mixins.DynamicGroupMixin),
        ),
        migrations.CreateModel(
            name="PeerEndpoint",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                ("created", models.DateField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "_custom_field_data",
                    models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder),
                ),
                (
                    "extra_attributes",
                    models.JSONField(blank=True, encoder=django.core.serializers.json.DjangoJSONEncoder, null=True),
                ),
                ("description", models.CharField(blank=True, max_length=200)),
                ("enabled", models.BooleanField(default=True)),
                ("import_policy", models.CharField(blank=True, default="", max_length=100)),
                ("export_policy", models.CharField(blank=True, default="", max_length=100)),
                (
                    "autonomous_system",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="endpoints",
                        to="nautobot_bgp_models.autonomoussystem",
                    ),
                ),
                (
                    "peer",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="nautobot_bgp_models.peerendpoint",
                    ),
                ),
                (
                    "peer_group",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="endpoints",
                        to="nautobot_bgp_models.peergroup",
                    ),
                ),
                (
                    "peering",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="endpoints",
                        to="nautobot_bgp_models.peering",
                    ),
                ),
                (
                    "role",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="endpoints",
                        to="nautobot_bgp_models.peeringrole",
                    ),
                ),
                (
                    "routing_instance",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="endpoints",
                        to="nautobot_bgp_models.bgproutinginstance",
                    ),
                ),
                (
                    "secret",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="bgp_peer_endpoints",
                        to="extras.secret",
                    ),
                ),
                (
                    "source_interface",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="bgp_peer_endpoints",
                        to="dcim.interface",
                    ),
                ),
                (
                    "source_ip",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="bgp_peer_endpoints",
                        to="ipam.ipaddress",
                    ),
                ),
                ("tags", taggit.managers.TaggableManager(through="extras.TaggedItem", to="extras.Tag")),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model, nautobot.extras.models.mixins.DynamicGroupMixin),
        ),
        migrations.CreateModel(
            name="AddressFamily",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                ("created", models.DateField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "_custom_field_data",
                    models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder),
                ),
                ("afi_safi", models.CharField(max_length=64)),
                ("import_policy", models.CharField(blank=True, default="", max_length=100)),
                ("export_policy", models.CharField(blank=True, default="", max_length=100)),
                ("multipath", models.BooleanField(blank=True, null=True)),
                (
                    "routing_instance",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="address_families",
                        to="nautobot_bgp_models.bgproutinginstance",
                    ),
                ),
                (
                    "vrf",
                    models.ForeignKey(
                        blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to="ipam.vrf"
                    ),
                ),
            ],
            options={
                "verbose_name": "BGP address family",
                "verbose_name_plural": "BGP Address Families",
                "ordering": ["-routing_instance", "-vrf"],
            },
            bases=(models.Model, nautobot.extras.models.mixins.DynamicGroupMixin),
        ),
    ]
