"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.getPartitionKeyNameFromTable = exports.buildDynamoDBTableWithStream = exports.buildDynamoDBTable = void 0;
const dynamodb = require("@aws-cdk/aws-dynamodb");
const dynamodb_table_defaults_1 = require("./dynamodb-table-defaults");
const utils_1 = require("./utils");
function buildDynamoDBTable(scope, props) {
    // Conditional DynamoDB Table creation
    if (!props.existingTableObj) {
        // Set the default props for DynamoDB table
        if (props.dynamoTableProps) {
            const dynamoTableProps = utils_1.overrideProps(dynamodb_table_defaults_1.DefaultTableProps, props.dynamoTableProps);
            return new dynamodb.Table(scope, 'DynamoTable', dynamoTableProps);
        }
        else {
            return new dynamodb.Table(scope, 'DynamoTable', dynamodb_table_defaults_1.DefaultTableProps);
        }
    }
    else {
        return props.existingTableObj;
    }
}
exports.buildDynamoDBTable = buildDynamoDBTable;
function buildDynamoDBTableWithStream(scope, props) {
    // Conditional DynamoDB Table creation
    if (!props.existingTableObj) {
        // Set the default props for DynamoDB table
        if (props.dynamoTableProps) {
            const dynamoTableProps = utils_1.overrideProps(dynamodb_table_defaults_1.DefaultTableWithStreamProps, props.dynamoTableProps);
            return new dynamodb.Table(scope, 'DynamoTable', dynamoTableProps);
        }
        else {
            return new dynamodb.Table(scope, 'DynamoTable', dynamodb_table_defaults_1.DefaultTableWithStreamProps);
        }
    }
    else {
        return props.existingTableObj;
    }
}
exports.buildDynamoDBTableWithStream = buildDynamoDBTableWithStream;
function getPartitionKeyNameFromTable(table) {
    const cfnTable = table.node.findChild('Resource');
    const keySchema = cfnTable.keySchema;
    const partitionKey = keySchema.find((keyPart) => keyPart.keyType === 'HASH');
    if (!partitionKey) {
        throw new Error('Partition key for table not defined');
    }
    return partitionKey.attributeName;
}
exports.getPartitionKeyNameFromTable = getPartitionKeyNameFromTable;
//# sourceMappingURL=data:application/json;base64,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