"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultGlueJobProps = void 0;
function DefaultGlueJobProps(jobRole, jobCommand, glueSecurityConfigName, _defaultArguments, _glueVersion) {
    const defaultGlueJobProps = {
        command: jobCommand,
        role: jobRole.roleArn,
        securityConfiguration: glueSecurityConfigName,
        defaultArguments: _defaultArguments,
        // glue version though optional is required for streaming etl jobs otherwise it throws an error that 'command not found'
        ...(_glueVersion !== undefined ? { glueVersion: _glueVersion } : { glueVersion: '2.0' })
    };
    return defaultGlueJobProps;
}
exports.DefaultGlueJobProps = DefaultGlueJobProps;
//# sourceMappingURL=data:application/json;base64,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