"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const assert_1 = require("@aws-cdk/assert");
const core_1 = require("@aws-cdk/core");
const iot = require("@aws-cdk/aws-iot");
const lambda = require("@aws-cdk/aws-lambda");
const defaults = require("../index");
const utils_1 = require("../lib/utils");
require("@aws-cdk/assert/jest");
test('snapshot test TopicRuleProps default params', () => {
    const stack = new core_1.Stack();
    const lambdaFunctionProps = {
        runtime: lambda.Runtime.NODEJS_12_X,
        handler: 'index.handler',
        code: lambda.Code.fromAsset(`${__dirname}/lambda`)
    };
    const fn = new lambda.Function(stack, 'LambdaFunction', lambdaFunctionProps);
    const defaultIotTopicProps = defaults.DefaultCfnTopicRuleProps([{
            lambda: {
                functionArn: fn.functionArn
            }
        }], "SELECT * FROM 'topic/#'");
    new iot.CfnTopicRule(stack, 'IotTopic', defaultIotTopicProps);
    expect(assert_1.SynthUtils.toCloudFormation(stack)).toMatchSnapshot();
});
test('test TopicRuleProps override sql and description', () => {
    const stack = new core_1.Stack();
    const action1 = {
        lambda: {
            functionArn: 'xyz'
        }
    };
    const defaultProps = defaults.DefaultCfnTopicRuleProps([action1]);
    const inProps = {
        topicRulePayload: {
            ruleDisabled: true,
            description: "Processing of vehicle messages",
            sql: "SELECT * FROM 'connectedcar/#'",
            actions: []
        }
    };
    const outProps = utils_1.overrideProps(defaultProps, inProps, true);
    new iot.CfnTopicRule(stack, 'IotTopic', outProps);
    expect(stack).toHaveResource('AWS::IoT::TopicRule', {
        TopicRulePayload: {
            Actions: [
                {
                    Lambda: {
                        FunctionArn: "xyz"
                    }
                }
            ],
            Description: "Processing of vehicle messages",
            RuleDisabled: true,
            Sql: "SELECT * FROM 'connectedcar/#'"
        }
    });
});
test('test TopicRuleProps override actions', () => {
    const stack = new core_1.Stack();
    const defaultProps = defaults.DefaultCfnTopicRuleProps([], '');
    const action = {
        lambda: {
            functionArn: 'abc'
        }
    };
    const inProps = {
        topicRulePayload: {
            ruleDisabled: true,
            sql: '',
            actions: [action]
        }
    };
    const outProps = utils_1.overrideProps(defaultProps, inProps);
    new iot.CfnTopicRule(stack, 'IotTopic', outProps);
    expect(stack).toHaveResource('AWS::IoT::TopicRule', {
        TopicRulePayload: {
            Actions: [
                {
                    Lambda: {
                        FunctionArn: "abc"
                    }
                }
            ],
            RuleDisabled: true,
            Sql: ""
        }
    });
});
//# sourceMappingURL=data:application/json;base64,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