"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const core_1 = require("@aws-cdk/core");
const kinesisFirehose = require("@aws-cdk/aws-kinesisfirehose");
const defaults = require("../");
const assert_1 = require("@aws-cdk/assert");
require("@aws-cdk/assert/jest");
// --------------------------------------------------------------
// Test default functionality
// --------------------------------------------------------------
test('Test default functionality', () => {
    // Setup the stack
    const stack = new core_1.Stack();
    const firehose = new kinesisFirehose.CfnDeliveryStream(stack, 'KinesisFirehose');
    // Setup the Kinesis Analytics application
    defaults.buildKinesisAnalyticsApp(stack, {
        kinesisFirehose: firehose,
        kinesisAnalyticsProps: {
            inputs: [{
                    inputSchema: {
                        recordColumns: [{
                                name: 'ticker_symbol',
                                sqlType: 'VARCHAR(4)',
                                mapping: '$.ticker_symbol'
                            }, {
                                name: 'sector',
                                sqlType: 'VARCHAR(16)',
                                mapping: '$.sector'
                            }, {
                                name: 'change',
                                sqlType: 'REAL',
                                mapping: '$.change'
                            }, {
                                name: 'price',
                                sqlType: 'REAL',
                                mapping: '$.price'
                            }],
                        recordFormat: {
                            recordFormatType: 'JSON'
                        },
                        recordEncoding: 'UTF-8'
                    },
                    namePrefix: 'SOURCE_SQL_STREAM'
                }]
        }
    });
    // Assertions
    expect(assert_1.SynthUtils.toCloudFormation(stack)).toMatchSnapshot();
});
//# sourceMappingURL=data:application/json;base64,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