import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ApigeeEnvgroupConfig extends cdktf.TerraformMetaArguments {
    /**
     * Hostnames of the environment group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_envgroup.html#hostnames ApigeeEnvgroup#hostnames}
     *
     * @stability stable
     */
    readonly hostnames?: string[];
    /**
     * The resource ID of the environment group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_envgroup.html#name ApigeeEnvgroup#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The Apigee Organization associated with the Apigee environment group, in the format 'organizations/{{org_name}}'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_envgroup.html#org_id ApigeeEnvgroup#org_id}
     *
     * @stability stable
     */
    readonly orgId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_envgroup.html#timeouts ApigeeEnvgroup#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ApigeeEnvgroupTimeouts;
}
/**
 * @stability stable
 */
export interface ApigeeEnvgroupTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_envgroup.html#create ApigeeEnvgroup#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_envgroup.html#delete ApigeeEnvgroup#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_envgroup.html#update ApigeeEnvgroup#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function apigeeEnvgroupTimeoutsToTerraform(struct?: ApigeeEnvgroupTimeoutsOutputReference | ApigeeEnvgroupTimeouts): any;
/**
 * @stability stable
 */
export declare class ApigeeEnvgroupTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApigeeEnvgroupTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApigeeEnvgroupTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/apigee_envgroup.html google_apigee_envgroup}.
 *
 * @stability stable
 */
export declare class ApigeeEnvgroup extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/apigee_envgroup.html google_apigee_envgroup} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ApigeeEnvgroupConfig);
    private _hostnames?;
    /**
     * @stability stable
     */
    get hostnames(): string[];
    /**
     * @stability stable
     */
    set hostnames(value: string[]);
    /**
     * @stability stable
     */
    resetHostnames(): void;
    /**
     * @stability stable
     */
    get hostnamesInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _orgId?;
    /**
     * @stability stable
     */
    get orgId(): string;
    /**
     * @stability stable
     */
    set orgId(value: string);
    /**
     * @stability stable
     */
    get orgIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ApigeeEnvgroupTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ApigeeEnvgroupTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ApigeeEnvgroupTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
