import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ApigeeOrganizationConfig extends cdktf.TerraformMetaArguments {
    /**
     * Primary GCP region for analytics data storage. For valid values, see [Create an Apigee organization](https://cloud.google.com/apigee/docs/api-platform/get-started/create-org).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_organization.html#analytics_region ApigeeOrganization#analytics_region}
     *
     * @stability stable
     */
    readonly analyticsRegion?: string;
    /**
     * Compute Engine network used for Service Networking to be peered with Apigee runtime instances.
     *
     * See [Getting started with the Service Networking API](https://cloud.google.com/service-infrastructure/docs/service-networking/getting-started).
     * Valid only when 'RuntimeType' is set to CLOUD. The value can be updated only when there are no runtime instances. For example: "default".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_organization.html#authorized_network ApigeeOrganization#authorized_network}
     *
     * @stability stable
     */
    readonly authorizedNetwork?: string;
    /**
     * Description of the Apigee organization.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_organization.html#description ApigeeOrganization#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The display name of the Apigee organization.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_organization.html#display_name ApigeeOrganization#display_name}
     *
     * @stability stable
     */
    readonly displayName?: string;
    /**
     * The project ID associated with the Apigee organization.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_organization.html#project_id ApigeeOrganization#project_id}
     *
     * @stability stable
     */
    readonly projectId: string;
    /**
     * Cloud KMS key name used for encrypting the data that is stored and replicated across runtime instances.
     *
     * Update is not allowed after the organization is created.
     * If not specified, a Google-Managed encryption key will be used.
     * Valid only when 'RuntimeType' is CLOUD. For example: 'projects/foo/locations/us/keyRings/bar/cryptoKeys/baz'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_organization.html#runtime_database_encryption_key_name ApigeeOrganization#runtime_database_encryption_key_name}
     *
     * @stability stable
     */
    readonly runtimeDatabaseEncryptionKeyName?: string;
    /**
     * Runtime type of the Apigee organization based on the Apigee subscription purchased. Default value: "CLOUD" Possible values: ["CLOUD", "HYBRID"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_organization.html#runtime_type ApigeeOrganization#runtime_type}
     *
     * @stability stable
     */
    readonly runtimeType?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_organization.html#timeouts ApigeeOrganization#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ApigeeOrganizationTimeouts;
}
/**
 * @stability stable
 */
export interface ApigeeOrganizationTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_organization.html#create ApigeeOrganization#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_organization.html#delete ApigeeOrganization#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_organization.html#update ApigeeOrganization#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function apigeeOrganizationTimeoutsToTerraform(struct?: ApigeeOrganizationTimeoutsOutputReference | ApigeeOrganizationTimeouts): any;
/**
 * @stability stable
 */
export declare class ApigeeOrganizationTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApigeeOrganizationTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApigeeOrganizationTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/apigee_organization.html google_apigee_organization}.
 *
 * @stability stable
 */
export declare class ApigeeOrganization extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/apigee_organization.html google_apigee_organization} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ApigeeOrganizationConfig);
    private _analyticsRegion?;
    /**
     * @stability stable
     */
    get analyticsRegion(): string;
    /**
     * @stability stable
     */
    set analyticsRegion(value: string);
    /**
     * @stability stable
     */
    resetAnalyticsRegion(): void;
    /**
     * @stability stable
     */
    get analyticsRegionInput(): string | undefined;
    private _authorizedNetwork?;
    /**
     * @stability stable
     */
    get authorizedNetwork(): string;
    /**
     * @stability stable
     */
    set authorizedNetwork(value: string);
    /**
     * @stability stable
     */
    resetAuthorizedNetwork(): void;
    /**
     * @stability stable
     */
    get authorizedNetworkInput(): string | undefined;
    /**
     * @stability stable
     */
    get caCertificate(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    resetDisplayName(): void;
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _projectId?;
    /**
     * @stability stable
     */
    get projectId(): string;
    /**
     * @stability stable
     */
    set projectId(value: string);
    /**
     * @stability stable
     */
    get projectIdInput(): string | undefined;
    private _runtimeDatabaseEncryptionKeyName?;
    /**
     * @stability stable
     */
    get runtimeDatabaseEncryptionKeyName(): string;
    /**
     * @stability stable
     */
    set runtimeDatabaseEncryptionKeyName(value: string);
    /**
     * @stability stable
     */
    resetRuntimeDatabaseEncryptionKeyName(): void;
    /**
     * @stability stable
     */
    get runtimeDatabaseEncryptionKeyNameInput(): string | undefined;
    private _runtimeType?;
    /**
     * @stability stable
     */
    get runtimeType(): string;
    /**
     * @stability stable
     */
    set runtimeType(value: string);
    /**
     * @stability stable
     */
    resetRuntimeType(): void;
    /**
     * @stability stable
     */
    get runtimeTypeInput(): string | undefined;
    /**
     * @stability stable
     */
    get subscriptionType(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ApigeeOrganizationTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ApigeeOrganizationTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ApigeeOrganizationTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
