import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface BigqueryReservationConfig extends cdktf.TerraformMetaArguments {
    /**
     * If false, any query using this reservation will use idle slots from other reservations within the same admin project.
     *
     * If true, a query using this reservation will execute with the slot
     * capacity specified above at most.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_reservation.html#ignore_idle_slots BigqueryReservation#ignore_idle_slots}
     *
     * @stability stable
     */
    readonly ignoreIdleSlots?: boolean | cdktf.IResolvable;
    /**
     * The geographic location where the transfer config should reside. Examples: US, EU, asia-northeast1. The default value is US.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_reservation.html#location BigqueryReservation#location}
     *
     * @stability stable
     */
    readonly location?: string;
    /**
     * The name of the reservation. This field must only contain alphanumeric characters or dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_reservation.html#name BigqueryReservation#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_reservation.html#project BigqueryReservation#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Minimum slots available to this reservation.
     *
     * A slot is a unit of computational power in BigQuery, and serves as the
     * unit of parallelism. Queries using this reservation might use more slots during runtime if ignoreIdleSlots is set to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_reservation.html#slot_capacity BigqueryReservation#slot_capacity}
     *
     * @stability stable
     */
    readonly slotCapacity: number;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_reservation.html#timeouts BigqueryReservation#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: BigqueryReservationTimeouts;
}
/**
 * @stability stable
 */
export interface BigqueryReservationTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_reservation.html#create BigqueryReservation#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_reservation.html#delete BigqueryReservation#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_reservation.html#update BigqueryReservation#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function bigqueryReservationTimeoutsToTerraform(struct?: BigqueryReservationTimeoutsOutputReference | BigqueryReservationTimeouts): any;
/**
 * @stability stable
 */
export declare class BigqueryReservationTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BigqueryReservationTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BigqueryReservationTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/bigquery_reservation.html google_bigquery_reservation}.
 *
 * @stability stable
 */
export declare class BigqueryReservation extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/bigquery_reservation.html google_bigquery_reservation} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: BigqueryReservationConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _ignoreIdleSlots?;
    /**
     * @stability stable
     */
    get ignoreIdleSlots(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set ignoreIdleSlots(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIgnoreIdleSlots(): void;
    /**
     * @stability stable
     */
    get ignoreIdleSlotsInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    resetLocation(): void;
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _slotCapacity?;
    /**
     * @stability stable
     */
    get slotCapacity(): number;
    /**
     * @stability stable
     */
    set slotCapacity(value: number);
    /**
     * @stability stable
     */
    get slotCapacityInput(): number | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): BigqueryReservationTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: BigqueryReservationTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): BigqueryReservationTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
