import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface CloudAssetProjectFeedConfig extends cdktf.TerraformMetaArguments {
    /**
     * A list of the full names of the assets to receive updates.
     *
     * You must specify either or both of
     * assetNames and assetTypes. Only asset updates matching specified assetNames and assetTypes are
     * exported to the feed. For example: //compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1.
     * See https://cloud.google.com/apis/design/resourceNames#fullResourceName for more info.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_project_feed.html#asset_names CloudAssetProjectFeed#asset_names}
     *
     * @stability stable
     */
    readonly assetNames?: string[];
    /**
     * A list of types of the assets to receive updates.
     *
     * You must specify either or both of assetNames
     * and assetTypes. Only asset updates matching specified assetNames and assetTypes are exported to
     * the feed. For example: "compute.googleapis.com/Disk"
     * See https://cloud.google.com/asset-inventory/docs/supported-asset-types for a list of all
     * supported asset types.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_project_feed.html#asset_types CloudAssetProjectFeed#asset_types}
     *
     * @stability stable
     */
    readonly assetTypes?: string[];
    /**
     * The project whose identity will be used when sending messages to the destination pubsub topic.
     *
     * It also specifies the project for API
     * enablement check, quota, and billing. If not specified, the resource's
     * project will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_project_feed.html#billing_project CloudAssetProjectFeed#billing_project}
     *
     * @stability stable
     */
    readonly billingProject?: string;
    /**
     * Asset content type.
     *
     * If not specified, no content but the asset name and type will be returned. Possible values: ["CONTENT_TYPE_UNSPECIFIED", "RESOURCE", "IAM_POLICY", "ORG_POLICY", "ACCESS_POLICY"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_project_feed.html#content_type CloudAssetProjectFeed#content_type}
     *
     * @stability stable
     */
    readonly contentType?: string;
    /**
     * This is the client-assigned asset feed identifier and it needs to be unique under a specific parent.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_project_feed.html#feed_id CloudAssetProjectFeed#feed_id}
     *
     * @stability stable
     */
    readonly feedId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_project_feed.html#project CloudAssetProjectFeed#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_project_feed.html#condition CloudAssetProjectFeed#condition}
     *
     * @stability stable
     */
    readonly condition?: CloudAssetProjectFeedCondition;
    /**
     * feed_output_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_project_feed.html#feed_output_config CloudAssetProjectFeed#feed_output_config}
     *
     * @stability stable
     */
    readonly feedOutputConfig: CloudAssetProjectFeedFeedOutputConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_project_feed.html#timeouts CloudAssetProjectFeed#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: CloudAssetProjectFeedTimeouts;
}
/**
 * @stability stable
 */
export interface CloudAssetProjectFeedCondition {
    /**
     * Description of the expression.
     *
     * This is a longer text which describes the expression,
     * e.g. when hovered over it in a UI.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_project_feed.html#description CloudAssetProjectFeed#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Textual representation of an expression in Common Expression Language syntax.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_project_feed.html#expression CloudAssetProjectFeed#expression}
     *
     * @stability stable
     */
    readonly expression: string;
    /**
     * String indicating the location of the expression for error reporting, e.g. a file  name and a position in the file.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_project_feed.html#location CloudAssetProjectFeed#location}
     *
     * @stability stable
     */
    readonly location?: string;
    /**
     * Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_project_feed.html#title CloudAssetProjectFeed#title}
     *
     * @stability stable
     */
    readonly title?: string;
}
export declare function cloudAssetProjectFeedConditionToTerraform(struct?: CloudAssetProjectFeedConditionOutputReference | CloudAssetProjectFeedCondition): any;
/**
 * @stability stable
 */
export declare class CloudAssetProjectFeedConditionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CloudAssetProjectFeedCondition | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CloudAssetProjectFeedCondition | undefined);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _expression?;
    /**
     * @stability stable
     */
    get expression(): string;
    /**
     * @stability stable
     */
    set expression(value: string);
    /**
     * @stability stable
     */
    get expressionInput(): string | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    resetLocation(): void;
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    set title(value: string);
    /**
     * @stability stable
     */
    resetTitle(): void;
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CloudAssetProjectFeedFeedOutputConfigPubsubDestination {
    /**
     * Destination on Cloud Pubsub topic.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_project_feed.html#topic CloudAssetProjectFeed#topic}
     *
     * @stability stable
     */
    readonly topic: string;
}
export declare function cloudAssetProjectFeedFeedOutputConfigPubsubDestinationToTerraform(struct?: CloudAssetProjectFeedFeedOutputConfigPubsubDestinationOutputReference | CloudAssetProjectFeedFeedOutputConfigPubsubDestination): any;
/**
 * @stability stable
 */
export declare class CloudAssetProjectFeedFeedOutputConfigPubsubDestinationOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CloudAssetProjectFeedFeedOutputConfigPubsubDestination | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CloudAssetProjectFeedFeedOutputConfigPubsubDestination | undefined);
    private _topic?;
    /**
     * @stability stable
     */
    get topic(): string;
    /**
     * @stability stable
     */
    set topic(value: string);
    /**
     * @stability stable
     */
    get topicInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CloudAssetProjectFeedFeedOutputConfig {
    /**
     * pubsub_destination block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_project_feed.html#pubsub_destination CloudAssetProjectFeed#pubsub_destination}
     *
     * @stability stable
     */
    readonly pubsubDestination: CloudAssetProjectFeedFeedOutputConfigPubsubDestination;
}
export declare function cloudAssetProjectFeedFeedOutputConfigToTerraform(struct?: CloudAssetProjectFeedFeedOutputConfigOutputReference | CloudAssetProjectFeedFeedOutputConfig): any;
/**
 * @stability stable
 */
export declare class CloudAssetProjectFeedFeedOutputConfigOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CloudAssetProjectFeedFeedOutputConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CloudAssetProjectFeedFeedOutputConfig | undefined);
    private _pubsubDestination;
    /**
     * @stability stable
     */
    get pubsubDestination(): CloudAssetProjectFeedFeedOutputConfigPubsubDestinationOutputReference;
    /**
     * @stability stable
     */
    putPubsubDestination(value: CloudAssetProjectFeedFeedOutputConfigPubsubDestination): void;
    /**
     * @stability stable
     */
    get pubsubDestinationInput(): CloudAssetProjectFeedFeedOutputConfigPubsubDestination | undefined;
}
/**
 * @stability stable
 */
export interface CloudAssetProjectFeedTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_project_feed.html#create CloudAssetProjectFeed#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_project_feed.html#delete CloudAssetProjectFeed#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_project_feed.html#update CloudAssetProjectFeed#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function cloudAssetProjectFeedTimeoutsToTerraform(struct?: CloudAssetProjectFeedTimeoutsOutputReference | CloudAssetProjectFeedTimeouts): any;
/**
 * @stability stable
 */
export declare class CloudAssetProjectFeedTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CloudAssetProjectFeedTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CloudAssetProjectFeedTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_project_feed.html google_cloud_asset_project_feed}.
 *
 * @stability stable
 */
export declare class CloudAssetProjectFeed extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_project_feed.html google_cloud_asset_project_feed} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: CloudAssetProjectFeedConfig);
    private _assetNames?;
    /**
     * @stability stable
     */
    get assetNames(): string[];
    /**
     * @stability stable
     */
    set assetNames(value: string[]);
    /**
     * @stability stable
     */
    resetAssetNames(): void;
    /**
     * @stability stable
     */
    get assetNamesInput(): string[] | undefined;
    private _assetTypes?;
    /**
     * @stability stable
     */
    get assetTypes(): string[];
    /**
     * @stability stable
     */
    set assetTypes(value: string[]);
    /**
     * @stability stable
     */
    resetAssetTypes(): void;
    /**
     * @stability stable
     */
    get assetTypesInput(): string[] | undefined;
    private _billingProject?;
    /**
     * @stability stable
     */
    get billingProject(): string;
    /**
     * @stability stable
     */
    set billingProject(value: string);
    /**
     * @stability stable
     */
    resetBillingProject(): void;
    /**
     * @stability stable
     */
    get billingProjectInput(): string | undefined;
    private _contentType?;
    /**
     * @stability stable
     */
    get contentType(): string;
    /**
     * @stability stable
     */
    set contentType(value: string);
    /**
     * @stability stable
     */
    resetContentType(): void;
    /**
     * @stability stable
     */
    get contentTypeInput(): string | undefined;
    private _feedId?;
    /**
     * @stability stable
     */
    get feedId(): string;
    /**
     * @stability stable
     */
    set feedId(value: string);
    /**
     * @stability stable
     */
    get feedIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _condition;
    /**
     * @stability stable
     */
    get condition(): CloudAssetProjectFeedConditionOutputReference;
    /**
     * @stability stable
     */
    putCondition(value: CloudAssetProjectFeedCondition): void;
    /**
     * @stability stable
     */
    resetCondition(): void;
    /**
     * @stability stable
     */
    get conditionInput(): CloudAssetProjectFeedCondition | undefined;
    private _feedOutputConfig;
    /**
     * @stability stable
     */
    get feedOutputConfig(): CloudAssetProjectFeedFeedOutputConfigOutputReference;
    /**
     * @stability stable
     */
    putFeedOutputConfig(value: CloudAssetProjectFeedFeedOutputConfig): void;
    /**
     * @stability stable
     */
    get feedOutputConfigInput(): CloudAssetProjectFeedFeedOutputConfig | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): CloudAssetProjectFeedTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: CloudAssetProjectFeedTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): CloudAssetProjectFeedTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
