import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeBackendServiceConfig extends cdktf.TerraformMetaArguments {
    /**
     * Lifetime of cookies in seconds if session_affinity is GENERATED_COOKIE.
     *
     * If set to 0, the cookie is non-persistent and lasts
     * only until the end of the browser session (or equivalent). The
     * maximum allowed value for TTL is one day.
     *
     * When the load balancing scheme is INTERNAL, this field is not used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#affinity_cookie_ttl_sec ComputeBackendService#affinity_cookie_ttl_sec}
     *
     * @stability stable
     */
    readonly affinityCookieTtlSec?: number;
    /**
     * Time for which instance will be drained (not accept new connections, but still work to finish started).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#connection_draining_timeout_sec ComputeBackendService#connection_draining_timeout_sec}
     *
     * @stability stable
     */
    readonly connectionDrainingTimeoutSec?: number;
    /**
     * Headers that the HTTP/S load balancer should add to proxied requests.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#custom_request_headers ComputeBackendService#custom_request_headers}
     *
     * @stability stable
     */
    readonly customRequestHeaders?: string[];
    /**
     * Headers that the HTTP/S load balancer should add to proxied responses.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#custom_response_headers ComputeBackendService#custom_response_headers}
     *
     * @stability stable
     */
    readonly customResponseHeaders?: string[];
    /**
     * An optional description of this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#description ComputeBackendService#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * If true, enable Cloud CDN for this BackendService.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#enable_cdn ComputeBackendService#enable_cdn}
     *
     * @stability stable
     */
    readonly enableCdn?: boolean | cdktf.IResolvable;
    /**
     * The set of URLs to the HttpHealthCheck or HttpsHealthCheck resource for health checking this BackendService.
     *
     * Currently at most one health
     * check can be specified.
     *
     * A health check must be specified unless the backend service uses an internet
     * or serverless NEG as a backend.
     *
     * For internal load balancing, a URL to a HealthCheck resource must be specified instead.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#health_checks ComputeBackendService#health_checks}
     *
     * @stability stable
     */
    readonly healthChecks?: string[];
    /**
     * Indicates whether the backend service will be used with internal or external load balancing.
     *
     * A backend service created for one type of
     * load balancing cannot be used with the other. Default value: "EXTERNAL" Possible values: ["EXTERNAL", "INTERNAL_SELF_MANAGED"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#load_balancing_scheme ComputeBackendService#load_balancing_scheme}
     *
     * @stability stable
     */
    readonly loadBalancingScheme?: string;
    /**
     * The load balancing algorithm used within the scope of the locality. The possible values are -.
     *
     * ROUND_ROBIN - This is a simple policy in which each healthy backend
     *              is selected in round robin order.
     *
     * LEAST_REQUEST - An O(1) algorithm which selects two random healthy
     *                hosts and picks the host which has fewer active requests.
     *
     * RING_HASH - The ring/modulo hash load balancer implements consistent
     *            hashing to backends. The algorithm has the property that the
     *            addition/removal of a host from a set of N hosts only affects
     *            1/N of the requests.
     *
     * RANDOM - The load balancer selects a random healthy host.
     *
     * ORIGINAL_DESTINATION - Backend host is selected based on the client
     *                       connection metadata, i.e., connections are opened
     *                       to the same address as the destination address of
     *                       the incoming connection before the connection
     *                       was redirected to the load balancer.
     *
     * MAGLEV - used as a drop in replacement for the ring hash load balancer.
     *         Maglev is not as stable as ring hash but has faster table lookup
     *         build times and host selection times. For more information about
     *         Maglev, refer to https://ai.google/research/pubs/pub44824
     *
     * This field is applicable only when the load_balancing_scheme is set to
     * INTERNAL_SELF_MANAGED. Possible values: ["ROUND_ROBIN", "LEAST_REQUEST", "RING_HASH", "RANDOM", "ORIGINAL_DESTINATION", "MAGLEV"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#locality_lb_policy ComputeBackendService#locality_lb_policy}
     *
     * @stability stable
     */
    readonly localityLbPolicy?: string;
    /**
     * Name of the resource.
     *
     * Provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035. Specifically, the name must be 1-63 characters long and match
     * the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
     * first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#name ComputeBackendService#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Name of backend port.
     *
     * The same name should appear in the instance
     * groups referenced by this service. Required when the load balancing
     * scheme is EXTERNAL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#port_name ComputeBackendService#port_name}
     *
     * @stability stable
     */
    readonly portName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#project ComputeBackendService#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The protocol this BackendService uses to communicate with backends.
     *
     * The default is HTTP. **NOTE**: HTTP2 is only valid for beta HTTP/2 load balancer
     * types and may result in errors if used with the GA API. Possible values: ["HTTP", "HTTPS", "HTTP2", "TCP", "SSL", "GRPC"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#protocol ComputeBackendService#protocol}
     *
     * @stability stable
     */
    readonly protocol?: string;
    /**
     * The security policy associated with this backend service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#security_policy ComputeBackendService#security_policy}
     *
     * @stability stable
     */
    readonly securityPolicy?: string;
    /**
     * Type of session affinity to use.
     *
     * The default is NONE. Session affinity is
     * not applicable if the protocol is UDP. Possible values: ["NONE", "CLIENT_IP", "CLIENT_IP_PORT_PROTO", "CLIENT_IP_PROTO", "GENERATED_COOKIE", "HEADER_FIELD", "HTTP_COOKIE"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#session_affinity ComputeBackendService#session_affinity}
     *
     * @stability stable
     */
    readonly sessionAffinity?: string;
    /**
     * How many seconds to wait for the backend before considering it a failed request.
     *
     * Default is 30 seconds. Valid range is [1, 86400].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#timeout_sec ComputeBackendService#timeout_sec}
     *
     * @stability stable
     */
    readonly timeoutSec?: number;
    /**
     * backend block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#backend ComputeBackendService#backend}
     *
     * @stability stable
     */
    readonly backend?: ComputeBackendServiceBackend[];
    /**
     * cdn_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#cdn_policy ComputeBackendService#cdn_policy}
     *
     * @stability stable
     */
    readonly cdnPolicy?: ComputeBackendServiceCdnPolicy;
    /**
     * circuit_breakers block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#circuit_breakers ComputeBackendService#circuit_breakers}
     *
     * @stability stable
     */
    readonly circuitBreakers?: ComputeBackendServiceCircuitBreakers;
    /**
     * consistent_hash block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#consistent_hash ComputeBackendService#consistent_hash}
     *
     * @stability stable
     */
    readonly consistentHash?: ComputeBackendServiceConsistentHash;
    /**
     * iap block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#iap ComputeBackendService#iap}
     *
     * @stability stable
     */
    readonly iap?: ComputeBackendServiceIap;
    /**
     * log_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#log_config ComputeBackendService#log_config}
     *
     * @stability stable
     */
    readonly logConfig?: ComputeBackendServiceLogConfig;
    /**
     * outlier_detection block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#outlier_detection ComputeBackendService#outlier_detection}
     *
     * @stability stable
     */
    readonly outlierDetection?: ComputeBackendServiceOutlierDetection;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#timeouts ComputeBackendService#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeBackendServiceTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeBackendServiceBackend {
    /**
     * Specifies the balancing mode for this backend.
     *
     * For global HTTP(S) or TCP/SSL load balancing, the default is
     * UTILIZATION. Valid values are UTILIZATION, RATE (for HTTP(S))
     * and CONNECTION (for TCP/SSL). Default value: "UTILIZATION" Possible values: ["UTILIZATION", "RATE", "CONNECTION"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#balancing_mode ComputeBackendService#balancing_mode}
     *
     * @stability stable
     */
    readonly balancingMode?: string;
    /**
     * A multiplier applied to the group's maximum servicing capacity (based on UTILIZATION, RATE or CONNECTION).
     *
     * Default value is 1, which means the group will serve up to 100%
     * of its configured capacity (depending on balancingMode). A
     * setting of 0 means the group is completely drained, offering
     * 0% of its available Capacity. Valid range is [0.0,1.0].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#capacity_scaler ComputeBackendService#capacity_scaler}
     *
     * @stability stable
     */
    readonly capacityScaler?: number;
    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#description ComputeBackendService#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The fully-qualified URL of an Instance Group or Network Endpoint Group resource.
     *
     * In case of instance group this defines the list
     * of instances that serve traffic. Member virtual machine
     * instances from each instance group must live in the same zone as
     * the instance group itself. No two backends in a backend service
     * are allowed to use same Instance Group resource.
     *
     * For Network Endpoint Groups this defines list of endpoints. All
     * endpoints of Network Endpoint Group must be hosted on instances
     * located in the same zone as the Network Endpoint Group.
     *
     * Backend services cannot mix Instance Group and
     * Network Endpoint Group backends.
     *
     * Note that you must specify an Instance Group or Network Endpoint
     * Group resource using the fully-qualified URL, rather than a
     * partial URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#group ComputeBackendService#group}
     *
     * @stability stable
     */
    readonly group: string;
    /**
     * The max number of simultaneous connections for the group. Can be used with either CONNECTION or UTILIZATION balancing modes.
     *
     * For CONNECTION mode, either maxConnections or one
     * of maxConnectionsPerInstance or maxConnectionsPerEndpoint,
     * as appropriate for group type, must be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#max_connections ComputeBackendService#max_connections}
     *
     * @stability stable
     */
    readonly maxConnections?: number;
    /**
     * The max number of simultaneous connections that a single backend network endpoint can handle.
     *
     * This is used to calculate the
     * capacity of the group. Can be used in either CONNECTION or
     * UTILIZATION balancing modes.
     *
     * For CONNECTION mode, either
     * maxConnections or maxConnectionsPerEndpoint must be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#max_connections_per_endpoint ComputeBackendService#max_connections_per_endpoint}
     *
     * @stability stable
     */
    readonly maxConnectionsPerEndpoint?: number;
    /**
     * The max number of simultaneous connections that a single backend instance can handle.
     *
     * This is used to calculate the
     * capacity of the group. Can be used in either CONNECTION or
     * UTILIZATION balancing modes.
     *
     * For CONNECTION mode, either maxConnections or
     * maxConnectionsPerInstance must be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#max_connections_per_instance ComputeBackendService#max_connections_per_instance}
     *
     * @stability stable
     */
    readonly maxConnectionsPerInstance?: number;
    /**
     * The max requests per second (RPS) of the group.
     *
     * Can be used with either RATE or UTILIZATION balancing modes,
     * but required if RATE mode. For RATE mode, either maxRate or one
     * of maxRatePerInstance or maxRatePerEndpoint, as appropriate for
     * group type, must be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#max_rate ComputeBackendService#max_rate}
     *
     * @stability stable
     */
    readonly maxRate?: number;
    /**
     * The max requests per second (RPS) that a single backend network endpoint can handle.
     *
     * This is used to calculate the capacity of
     * the group. Can be used in either balancing mode. For RATE mode,
     * either maxRate or maxRatePerEndpoint must be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#max_rate_per_endpoint ComputeBackendService#max_rate_per_endpoint}
     *
     * @stability stable
     */
    readonly maxRatePerEndpoint?: number;
    /**
     * The max requests per second (RPS) that a single backend instance can handle.
     *
     * This is used to calculate the capacity of
     * the group. Can be used in either balancing mode. For RATE mode,
     * either maxRate or maxRatePerInstance must be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#max_rate_per_instance ComputeBackendService#max_rate_per_instance}
     *
     * @stability stable
     */
    readonly maxRatePerInstance?: number;
    /**
     * Used when balancingMode is UTILIZATION. This ratio defines the CPU utilization target for the group. Valid range is [0.0, 1.0].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#max_utilization ComputeBackendService#max_utilization}
     *
     * @stability stable
     */
    readonly maxUtilization?: number;
}
export declare function computeBackendServiceBackendToTerraform(struct?: ComputeBackendServiceBackend): any;
/**
 * @stability stable
 */
export interface ComputeBackendServiceCdnPolicyCacheKeyPolicy {
    /**
     * If true requests to different hosts will be cached separately.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#include_host ComputeBackendService#include_host}
     *
     * @stability stable
     */
    readonly includeHost?: boolean | cdktf.IResolvable;
    /**
     * If true, http and https requests will be cached separately.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#include_protocol ComputeBackendService#include_protocol}
     *
     * @stability stable
     */
    readonly includeProtocol?: boolean | cdktf.IResolvable;
    /**
     * If true, include query string parameters in the cache key according to query_string_whitelist and query_string_blacklist.
     *
     * If neither is set, the entire query
     * string will be included.
     *
     * If false, the query string will be excluded from the cache
     * key entirely.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#include_query_string ComputeBackendService#include_query_string}
     *
     * @stability stable
     */
    readonly includeQueryString?: boolean | cdktf.IResolvable;
    /**
     * Names of query string parameters to exclude in cache keys.
     *
     * All other parameters will be included. Either specify
     * query_string_whitelist or query_string_blacklist, not both.
     * '&' and '=' will be percent encoded and not treated as
     * delimiters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#query_string_blacklist ComputeBackendService#query_string_blacklist}
     *
     * @stability stable
     */
    readonly queryStringBlacklist?: string[];
    /**
     * Names of query string parameters to include in cache keys.
     *
     * All other parameters will be excluded. Either specify
     * query_string_whitelist or query_string_blacklist, not both.
     * '&' and '=' will be percent encoded and not treated as
     * delimiters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#query_string_whitelist ComputeBackendService#query_string_whitelist}
     *
     * @stability stable
     */
    readonly queryStringWhitelist?: string[];
}
export declare function computeBackendServiceCdnPolicyCacheKeyPolicyToTerraform(struct?: ComputeBackendServiceCdnPolicyCacheKeyPolicyOutputReference | ComputeBackendServiceCdnPolicyCacheKeyPolicy): any;
/**
 * @stability stable
 */
export declare class ComputeBackendServiceCdnPolicyCacheKeyPolicyOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeBackendServiceCdnPolicyCacheKeyPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeBackendServiceCdnPolicyCacheKeyPolicy | undefined);
    private _includeHost?;
    /**
     * @stability stable
     */
    get includeHost(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set includeHost(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIncludeHost(): void;
    /**
     * @stability stable
     */
    get includeHostInput(): boolean | cdktf.IResolvable | undefined;
    private _includeProtocol?;
    /**
     * @stability stable
     */
    get includeProtocol(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set includeProtocol(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIncludeProtocol(): void;
    /**
     * @stability stable
     */
    get includeProtocolInput(): boolean | cdktf.IResolvable | undefined;
    private _includeQueryString?;
    /**
     * @stability stable
     */
    get includeQueryString(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set includeQueryString(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIncludeQueryString(): void;
    /**
     * @stability stable
     */
    get includeQueryStringInput(): boolean | cdktf.IResolvable | undefined;
    private _queryStringBlacklist?;
    /**
     * @stability stable
     */
    get queryStringBlacklist(): string[];
    /**
     * @stability stable
     */
    set queryStringBlacklist(value: string[]);
    /**
     * @stability stable
     */
    resetQueryStringBlacklist(): void;
    /**
     * @stability stable
     */
    get queryStringBlacklistInput(): string[] | undefined;
    private _queryStringWhitelist?;
    /**
     * @stability stable
     */
    get queryStringWhitelist(): string[];
    /**
     * @stability stable
     */
    set queryStringWhitelist(value: string[]);
    /**
     * @stability stable
     */
    resetQueryStringWhitelist(): void;
    /**
     * @stability stable
     */
    get queryStringWhitelistInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface ComputeBackendServiceCdnPolicyNegativeCachingPolicy {
    /**
     * The HTTP status code to define a TTL against.
     *
     * Only HTTP status codes 300, 301, 308, 404, 405, 410, 421, 451 and 501
     * can be specified as values, and you cannot specify a status code more than once.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#code ComputeBackendService#code}
     *
     * @stability stable
     */
    readonly code?: number;
    /**
     * The TTL (in seconds) for which to cache responses with the corresponding status code.
     *
     * The maximum allowed value is 1800s
     * (30 minutes), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#ttl ComputeBackendService#ttl}
     *
     * @stability stable
     */
    readonly ttl?: number;
}
export declare function computeBackendServiceCdnPolicyNegativeCachingPolicyToTerraform(struct?: ComputeBackendServiceCdnPolicyNegativeCachingPolicy): any;
/**
 * @stability stable
 */
export interface ComputeBackendServiceCdnPolicy {
    /**
     * Specifies the cache setting for all responses from this backend.
     *
     * The possible values are: USE_ORIGIN_HEADERS, FORCE_CACHE_ALL and CACHE_ALL_STATIC Possible values: ["USE_ORIGIN_HEADERS", "FORCE_CACHE_ALL", "CACHE_ALL_STATIC"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#cache_mode ComputeBackendService#cache_mode}
     *
     * @stability stable
     */
    readonly cacheMode?: string;
    /**
     * Specifies the maximum allowed TTL for cached content served by this origin.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#client_ttl ComputeBackendService#client_ttl}
     *
     * @stability stable
     */
    readonly clientTtl?: number;
    /**
     * Specifies the default TTL for cached content served by this origin for responses that do not have an existing valid TTL (max-age or s-max-age).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#default_ttl ComputeBackendService#default_ttl}
     *
     * @stability stable
     */
    readonly defaultTtl?: number;
    /**
     * Specifies the maximum allowed TTL for cached content served by this origin.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#max_ttl ComputeBackendService#max_ttl}
     *
     * @stability stable
     */
    readonly maxTtl?: number;
    /**
     * Negative caching allows per-status code TTLs to be set, in order to apply fine-grained caching for common errors or redirects.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#negative_caching ComputeBackendService#negative_caching}
     *
     * @stability stable
     */
    readonly negativeCaching?: boolean | cdktf.IResolvable;
    /**
     * Serve existing content from the cache (if available) when revalidating content with the origin, or when an error is encountered when refreshing the cache.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#serve_while_stale ComputeBackendService#serve_while_stale}
     *
     * @stability stable
     */
    readonly serveWhileStale?: number;
    /**
     * Maximum number of seconds the response to a signed URL request will be considered fresh, defaults to 1hr (3600s).
     *
     * After this
     * time period, the response will be revalidated before
     * being served.
     *
     * When serving responses to signed URL requests, Cloud CDN will
     * internally behave as though all responses from this backend had a
     * "Cache-Control: public, max-age=[TTL]" header, regardless of any
     * existing Cache-Control header. The actual headers served in
     * responses will not be altered.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#signed_url_cache_max_age_sec ComputeBackendService#signed_url_cache_max_age_sec}
     *
     * @stability stable
     */
    readonly signedUrlCacheMaxAgeSec?: number;
    /**
     * cache_key_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#cache_key_policy ComputeBackendService#cache_key_policy}
     *
     * @stability stable
     */
    readonly cacheKeyPolicy?: ComputeBackendServiceCdnPolicyCacheKeyPolicy;
    /**
     * negative_caching_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#negative_caching_policy ComputeBackendService#negative_caching_policy}
     *
     * @stability stable
     */
    readonly negativeCachingPolicy?: ComputeBackendServiceCdnPolicyNegativeCachingPolicy[];
}
export declare function computeBackendServiceCdnPolicyToTerraform(struct?: ComputeBackendServiceCdnPolicyOutputReference | ComputeBackendServiceCdnPolicy): any;
/**
 * @stability stable
 */
export declare class ComputeBackendServiceCdnPolicyOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeBackendServiceCdnPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeBackendServiceCdnPolicy | undefined);
    private _cacheMode?;
    /**
     * @stability stable
     */
    get cacheMode(): string;
    /**
     * @stability stable
     */
    set cacheMode(value: string);
    /**
     * @stability stable
     */
    resetCacheMode(): void;
    /**
     * @stability stable
     */
    get cacheModeInput(): string | undefined;
    private _clientTtl?;
    /**
     * @stability stable
     */
    get clientTtl(): number;
    /**
     * @stability stable
     */
    set clientTtl(value: number);
    /**
     * @stability stable
     */
    resetClientTtl(): void;
    /**
     * @stability stable
     */
    get clientTtlInput(): number | undefined;
    private _defaultTtl?;
    /**
     * @stability stable
     */
    get defaultTtl(): number;
    /**
     * @stability stable
     */
    set defaultTtl(value: number);
    /**
     * @stability stable
     */
    resetDefaultTtl(): void;
    /**
     * @stability stable
     */
    get defaultTtlInput(): number | undefined;
    private _maxTtl?;
    /**
     * @stability stable
     */
    get maxTtl(): number;
    /**
     * @stability stable
     */
    set maxTtl(value: number);
    /**
     * @stability stable
     */
    resetMaxTtl(): void;
    /**
     * @stability stable
     */
    get maxTtlInput(): number | undefined;
    private _negativeCaching?;
    /**
     * @stability stable
     */
    get negativeCaching(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set negativeCaching(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetNegativeCaching(): void;
    /**
     * @stability stable
     */
    get negativeCachingInput(): boolean | cdktf.IResolvable | undefined;
    private _serveWhileStale?;
    /**
     * @stability stable
     */
    get serveWhileStale(): number;
    /**
     * @stability stable
     */
    set serveWhileStale(value: number);
    /**
     * @stability stable
     */
    resetServeWhileStale(): void;
    /**
     * @stability stable
     */
    get serveWhileStaleInput(): number | undefined;
    private _signedUrlCacheMaxAgeSec?;
    /**
     * @stability stable
     */
    get signedUrlCacheMaxAgeSec(): number;
    /**
     * @stability stable
     */
    set signedUrlCacheMaxAgeSec(value: number);
    /**
     * @stability stable
     */
    resetSignedUrlCacheMaxAgeSec(): void;
    /**
     * @stability stable
     */
    get signedUrlCacheMaxAgeSecInput(): number | undefined;
    private _cacheKeyPolicy;
    /**
     * @stability stable
     */
    get cacheKeyPolicy(): ComputeBackendServiceCdnPolicyCacheKeyPolicyOutputReference;
    /**
     * @stability stable
     */
    putCacheKeyPolicy(value: ComputeBackendServiceCdnPolicyCacheKeyPolicy): void;
    /**
     * @stability stable
     */
    resetCacheKeyPolicy(): void;
    /**
     * @stability stable
     */
    get cacheKeyPolicyInput(): ComputeBackendServiceCdnPolicyCacheKeyPolicy | undefined;
    private _negativeCachingPolicy?;
    /**
     * @stability stable
     */
    get negativeCachingPolicy(): ComputeBackendServiceCdnPolicyNegativeCachingPolicy[];
    /**
     * @stability stable
     */
    set negativeCachingPolicy(value: ComputeBackendServiceCdnPolicyNegativeCachingPolicy[]);
    /**
     * @stability stable
     */
    resetNegativeCachingPolicy(): void;
    /**
     * @stability stable
     */
    get negativeCachingPolicyInput(): ComputeBackendServiceCdnPolicyNegativeCachingPolicy[] | undefined;
}
/**
 * @stability stable
 */
export interface ComputeBackendServiceCircuitBreakers {
    /**
     * The maximum number of connections to the backend cluster. Defaults to 1024.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#max_connections ComputeBackendService#max_connections}
     *
     * @stability stable
     */
    readonly maxConnections?: number;
    /**
     * The maximum number of pending requests to the backend cluster. Defaults to 1024.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#max_pending_requests ComputeBackendService#max_pending_requests}
     *
     * @stability stable
     */
    readonly maxPendingRequests?: number;
    /**
     * The maximum number of parallel requests to the backend cluster. Defaults to 1024.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#max_requests ComputeBackendService#max_requests}
     *
     * @stability stable
     */
    readonly maxRequests?: number;
    /**
     * Maximum requests for a single backend connection.
     *
     * This parameter
     * is respected by both the HTTP/1.1 and HTTP/2 implementations. If
     * not specified, there is no limit. Setting this parameter to 1
     * will effectively disable keep alive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#max_requests_per_connection ComputeBackendService#max_requests_per_connection}
     *
     * @stability stable
     */
    readonly maxRequestsPerConnection?: number;
    /**
     * The maximum number of parallel retries to the backend cluster. Defaults to 3.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#max_retries ComputeBackendService#max_retries}
     *
     * @stability stable
     */
    readonly maxRetries?: number;
}
export declare function computeBackendServiceCircuitBreakersToTerraform(struct?: ComputeBackendServiceCircuitBreakersOutputReference | ComputeBackendServiceCircuitBreakers): any;
/**
 * @stability stable
 */
export declare class ComputeBackendServiceCircuitBreakersOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeBackendServiceCircuitBreakers | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeBackendServiceCircuitBreakers | undefined);
    private _maxConnections?;
    /**
     * @stability stable
     */
    get maxConnections(): number;
    /**
     * @stability stable
     */
    set maxConnections(value: number);
    /**
     * @stability stable
     */
    resetMaxConnections(): void;
    /**
     * @stability stable
     */
    get maxConnectionsInput(): number | undefined;
    private _maxPendingRequests?;
    /**
     * @stability stable
     */
    get maxPendingRequests(): number;
    /**
     * @stability stable
     */
    set maxPendingRequests(value: number);
    /**
     * @stability stable
     */
    resetMaxPendingRequests(): void;
    /**
     * @stability stable
     */
    get maxPendingRequestsInput(): number | undefined;
    private _maxRequests?;
    /**
     * @stability stable
     */
    get maxRequests(): number;
    /**
     * @stability stable
     */
    set maxRequests(value: number);
    /**
     * @stability stable
     */
    resetMaxRequests(): void;
    /**
     * @stability stable
     */
    get maxRequestsInput(): number | undefined;
    private _maxRequestsPerConnection?;
    /**
     * @stability stable
     */
    get maxRequestsPerConnection(): number;
    /**
     * @stability stable
     */
    set maxRequestsPerConnection(value: number);
    /**
     * @stability stable
     */
    resetMaxRequestsPerConnection(): void;
    /**
     * @stability stable
     */
    get maxRequestsPerConnectionInput(): number | undefined;
    private _maxRetries?;
    /**
     * @stability stable
     */
    get maxRetries(): number;
    /**
     * @stability stable
     */
    set maxRetries(value: number);
    /**
     * @stability stable
     */
    resetMaxRetries(): void;
    /**
     * @stability stable
     */
    get maxRetriesInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface ComputeBackendServiceConsistentHashHttpCookieTtl {
    /**
     * Span of time that's a fraction of a second at nanosecond resolution.
     *
     * Durations less than one second are represented
     * with a 0 seconds field and a positive nanos field. Must
     * be from 0 to 999,999,999 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#nanos ComputeBackendService#nanos}
     *
     * @stability stable
     */
    readonly nanos?: number;
    /**
     * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#seconds ComputeBackendService#seconds}
     *
     * @stability stable
     */
    readonly seconds: number;
}
export declare function computeBackendServiceConsistentHashHttpCookieTtlToTerraform(struct?: ComputeBackendServiceConsistentHashHttpCookieTtlOutputReference | ComputeBackendServiceConsistentHashHttpCookieTtl): any;
/**
 * @stability stable
 */
export declare class ComputeBackendServiceConsistentHashHttpCookieTtlOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeBackendServiceConsistentHashHttpCookieTtl | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeBackendServiceConsistentHashHttpCookieTtl | undefined);
    private _nanos?;
    /**
     * @stability stable
     */
    get nanos(): number;
    /**
     * @stability stable
     */
    set nanos(value: number);
    /**
     * @stability stable
     */
    resetNanos(): void;
    /**
     * @stability stable
     */
    get nanosInput(): number | undefined;
    private _seconds?;
    /**
     * @stability stable
     */
    get seconds(): number;
    /**
     * @stability stable
     */
    set seconds(value: number);
    /**
     * @stability stable
     */
    get secondsInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface ComputeBackendServiceConsistentHashHttpCookie {
    /**
     * Name of the cookie.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#name ComputeBackendService#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Path to set for the cookie.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#path ComputeBackendService#path}
     *
     * @stability stable
     */
    readonly path?: string;
    /**
     * ttl block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#ttl ComputeBackendService#ttl}
     *
     * @stability stable
     */
    readonly ttl?: ComputeBackendServiceConsistentHashHttpCookieTtl;
}
export declare function computeBackendServiceConsistentHashHttpCookieToTerraform(struct?: ComputeBackendServiceConsistentHashHttpCookieOutputReference | ComputeBackendServiceConsistentHashHttpCookie): any;
/**
 * @stability stable
 */
export declare class ComputeBackendServiceConsistentHashHttpCookieOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeBackendServiceConsistentHashHttpCookie | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeBackendServiceConsistentHashHttpCookie | undefined);
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _path?;
    /**
     * @stability stable
     */
    get path(): string;
    /**
     * @stability stable
     */
    set path(value: string);
    /**
     * @stability stable
     */
    resetPath(): void;
    /**
     * @stability stable
     */
    get pathInput(): string | undefined;
    private _ttl;
    /**
     * @stability stable
     */
    get ttl(): ComputeBackendServiceConsistentHashHttpCookieTtlOutputReference;
    /**
     * @stability stable
     */
    putTtl(value: ComputeBackendServiceConsistentHashHttpCookieTtl): void;
    /**
     * @stability stable
     */
    resetTtl(): void;
    /**
     * @stability stable
     */
    get ttlInput(): ComputeBackendServiceConsistentHashHttpCookieTtl | undefined;
}
/**
 * @stability stable
 */
export interface ComputeBackendServiceConsistentHash {
    /**
     * The hash based on the value of the specified header field.
     *
     * This field is applicable if the sessionAffinity is set to HEADER_FIELD.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#http_header_name ComputeBackendService#http_header_name}
     *
     * @stability stable
     */
    readonly httpHeaderName?: string;
    /**
     * The minimum number of virtual nodes to use for the hash ring.
     *
     * Larger ring sizes result in more granular load
     * distributions. If the number of hosts in the load balancing pool
     * is larger than the ring size, each host will be assigned a single
     * virtual node.
     * Defaults to 1024.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#minimum_ring_size ComputeBackendService#minimum_ring_size}
     *
     * @stability stable
     */
    readonly minimumRingSize?: number;
    /**
     * http_cookie block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#http_cookie ComputeBackendService#http_cookie}
     *
     * @stability stable
     */
    readonly httpCookie?: ComputeBackendServiceConsistentHashHttpCookie;
}
export declare function computeBackendServiceConsistentHashToTerraform(struct?: ComputeBackendServiceConsistentHashOutputReference | ComputeBackendServiceConsistentHash): any;
/**
 * @stability stable
 */
export declare class ComputeBackendServiceConsistentHashOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeBackendServiceConsistentHash | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeBackendServiceConsistentHash | undefined);
    private _httpHeaderName?;
    /**
     * @stability stable
     */
    get httpHeaderName(): string;
    /**
     * @stability stable
     */
    set httpHeaderName(value: string);
    /**
     * @stability stable
     */
    resetHttpHeaderName(): void;
    /**
     * @stability stable
     */
    get httpHeaderNameInput(): string | undefined;
    private _minimumRingSize?;
    /**
     * @stability stable
     */
    get minimumRingSize(): number;
    /**
     * @stability stable
     */
    set minimumRingSize(value: number);
    /**
     * @stability stable
     */
    resetMinimumRingSize(): void;
    /**
     * @stability stable
     */
    get minimumRingSizeInput(): number | undefined;
    private _httpCookie;
    /**
     * @stability stable
     */
    get httpCookie(): ComputeBackendServiceConsistentHashHttpCookieOutputReference;
    /**
     * @stability stable
     */
    putHttpCookie(value: ComputeBackendServiceConsistentHashHttpCookie): void;
    /**
     * @stability stable
     */
    resetHttpCookie(): void;
    /**
     * @stability stable
     */
    get httpCookieInput(): ComputeBackendServiceConsistentHashHttpCookie | undefined;
}
/**
 * @stability stable
 */
export interface ComputeBackendServiceIap {
    /**
     * OAuth2 Client ID for IAP.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#oauth2_client_id ComputeBackendService#oauth2_client_id}
     *
     * @stability stable
     */
    readonly oauth2ClientId: string;
    /**
     * OAuth2 Client Secret for IAP.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#oauth2_client_secret ComputeBackendService#oauth2_client_secret}
     *
     * @stability stable
     */
    readonly oauth2ClientSecret: string;
}
export declare function computeBackendServiceIapToTerraform(struct?: ComputeBackendServiceIapOutputReference | ComputeBackendServiceIap): any;
/**
 * @stability stable
 */
export declare class ComputeBackendServiceIapOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeBackendServiceIap | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeBackendServiceIap | undefined);
    private _oauth2ClientId?;
    /**
     * @stability stable
     */
    get oauth2ClientId(): string;
    /**
     * @stability stable
     */
    set oauth2ClientId(value: string);
    /**
     * @stability stable
     */
    get oauth2ClientIdInput(): string | undefined;
    private _oauth2ClientSecret?;
    /**
     * @stability stable
     */
    get oauth2ClientSecret(): string;
    /**
     * @stability stable
     */
    set oauth2ClientSecret(value: string);
    /**
     * @stability stable
     */
    get oauth2ClientSecretInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ComputeBackendServiceLogConfig {
    /**
     * Whether to enable logging for the load balancer traffic served by this backend service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#enable ComputeBackendService#enable}
     *
     * @stability stable
     */
    readonly enable?: boolean | cdktf.IResolvable;
    /**
     * This field can only be specified if logging is enabled for this backend service.
     *
     * The value of
     * the field must be in [0, 1]. This configures the sampling rate of requests to the load balancer
     * where 1.0 means all logged requests are reported and 0.0 means no logged requests are reported.
     * The default value is 1.0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#sample_rate ComputeBackendService#sample_rate}
     *
     * @stability stable
     */
    readonly sampleRate?: number;
}
export declare function computeBackendServiceLogConfigToTerraform(struct?: ComputeBackendServiceLogConfigOutputReference | ComputeBackendServiceLogConfig): any;
/**
 * @stability stable
 */
export declare class ComputeBackendServiceLogConfigOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeBackendServiceLogConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeBackendServiceLogConfig | undefined);
    private _enable?;
    /**
     * @stability stable
     */
    get enable(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enable(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnable(): void;
    /**
     * @stability stable
     */
    get enableInput(): boolean | cdktf.IResolvable | undefined;
    private _sampleRate?;
    /**
     * @stability stable
     */
    get sampleRate(): number;
    /**
     * @stability stable
     */
    set sampleRate(value: number);
    /**
     * @stability stable
     */
    resetSampleRate(): void;
    /**
     * @stability stable
     */
    get sampleRateInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface ComputeBackendServiceOutlierDetectionBaseEjectionTime {
    /**
     * Span of time that's a fraction of a second at nanosecond resolution.
     *
     * Durations
     * less than one second are represented with a 0 'seconds' field and a positive
     * 'nanos' field. Must be from 0 to 999,999,999 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#nanos ComputeBackendService#nanos}
     *
     * @stability stable
     */
    readonly nanos?: number;
    /**
     * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#seconds ComputeBackendService#seconds}
     *
     * @stability stable
     */
    readonly seconds: number;
}
export declare function computeBackendServiceOutlierDetectionBaseEjectionTimeToTerraform(struct?: ComputeBackendServiceOutlierDetectionBaseEjectionTimeOutputReference | ComputeBackendServiceOutlierDetectionBaseEjectionTime): any;
/**
 * @stability stable
 */
export declare class ComputeBackendServiceOutlierDetectionBaseEjectionTimeOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeBackendServiceOutlierDetectionBaseEjectionTime | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeBackendServiceOutlierDetectionBaseEjectionTime | undefined);
    private _nanos?;
    /**
     * @stability stable
     */
    get nanos(): number;
    /**
     * @stability stable
     */
    set nanos(value: number);
    /**
     * @stability stable
     */
    resetNanos(): void;
    /**
     * @stability stable
     */
    get nanosInput(): number | undefined;
    private _seconds?;
    /**
     * @stability stable
     */
    get seconds(): number;
    /**
     * @stability stable
     */
    set seconds(value: number);
    /**
     * @stability stable
     */
    get secondsInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface ComputeBackendServiceOutlierDetectionInterval {
    /**
     * Span of time that's a fraction of a second at nanosecond resolution.
     *
     * Durations
     * less than one second are represented with a 0 'seconds' field and a positive
     * 'nanos' field. Must be from 0 to 999,999,999 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#nanos ComputeBackendService#nanos}
     *
     * @stability stable
     */
    readonly nanos?: number;
    /**
     * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#seconds ComputeBackendService#seconds}
     *
     * @stability stable
     */
    readonly seconds: number;
}
export declare function computeBackendServiceOutlierDetectionIntervalToTerraform(struct?: ComputeBackendServiceOutlierDetectionIntervalOutputReference | ComputeBackendServiceOutlierDetectionInterval): any;
/**
 * @stability stable
 */
export declare class ComputeBackendServiceOutlierDetectionIntervalOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeBackendServiceOutlierDetectionInterval | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeBackendServiceOutlierDetectionInterval | undefined);
    private _nanos?;
    /**
     * @stability stable
     */
    get nanos(): number;
    /**
     * @stability stable
     */
    set nanos(value: number);
    /**
     * @stability stable
     */
    resetNanos(): void;
    /**
     * @stability stable
     */
    get nanosInput(): number | undefined;
    private _seconds?;
    /**
     * @stability stable
     */
    get seconds(): number;
    /**
     * @stability stable
     */
    set seconds(value: number);
    /**
     * @stability stable
     */
    get secondsInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface ComputeBackendServiceOutlierDetection {
    /**
     * Number of errors before a host is ejected from the connection pool.
     *
     * When the
     * backend host is accessed over HTTP, a 5xx return code qualifies as an error.
     * Defaults to 5.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#consecutive_errors ComputeBackendService#consecutive_errors}
     *
     * @stability stable
     */
    readonly consecutiveErrors?: number;
    /**
     * The number of consecutive gateway failures (502, 503, 504 status or connection errors that are mapped to one of those status codes) before a consecutive gateway failure ejection occurs.
     *
     * Defaults to 5.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#consecutive_gateway_failure ComputeBackendService#consecutive_gateway_failure}
     *
     * @stability stable
     */
    readonly consecutiveGatewayFailure?: number;
    /**
     * The percentage chance that a host will be actually ejected when an outlier status is detected through consecutive 5xx.
     *
     * This setting can be used to disable
     * ejection or to ramp it up slowly. Defaults to 100.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#enforcing_consecutive_errors ComputeBackendService#enforcing_consecutive_errors}
     *
     * @stability stable
     */
    readonly enforcingConsecutiveErrors?: number;
    /**
     * The percentage chance that a host will be actually ejected when an outlier status is detected through consecutive gateway failures.
     *
     * This setting can be
     * used to disable ejection or to ramp it up slowly. Defaults to 0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#enforcing_consecutive_gateway_failure ComputeBackendService#enforcing_consecutive_gateway_failure}
     *
     * @stability stable
     */
    readonly enforcingConsecutiveGatewayFailure?: number;
    /**
     * The percentage chance that a host will be actually ejected when an outlier status is detected through success rate statistics.
     *
     * This setting can be used to
     * disable ejection or to ramp it up slowly. Defaults to 100.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#enforcing_success_rate ComputeBackendService#enforcing_success_rate}
     *
     * @stability stable
     */
    readonly enforcingSuccessRate?: number;
    /**
     * Maximum percentage of hosts in the load balancing pool for the backend service that can be ejected. Defaults to 10%.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#max_ejection_percent ComputeBackendService#max_ejection_percent}
     *
     * @stability stable
     */
    readonly maxEjectionPercent?: number;
    /**
     * The number of hosts in a cluster that must have enough request volume to detect success rate outliers.
     *
     * If the number of hosts is less than this setting, outlier
     * detection via success rate statistics is not performed for any host in the
     * cluster. Defaults to 5.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#success_rate_minimum_hosts ComputeBackendService#success_rate_minimum_hosts}
     *
     * @stability stable
     */
    readonly successRateMinimumHosts?: number;
    /**
     * The minimum number of total requests that must be collected in one interval (as defined by the interval duration above) to include this host in success rate based outlier detection.
     *
     * If the volume is lower than this setting, outlier
     * detection via success rate statistics is not performed for that host. Defaults
     * to 100.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#success_rate_request_volume ComputeBackendService#success_rate_request_volume}
     *
     * @stability stable
     */
    readonly successRateRequestVolume?: number;
    /**
     * This factor is used to determine the ejection threshold for success rate outlier ejection.
     *
     * The ejection threshold is the difference between the mean success
     * rate, and the product of this factor and the standard deviation of the mean
     * success rate: mean - (stdev * success_rate_stdev_factor). This factor is divided
     * by a thousand to get a double. That is, if the desired factor is 1.9, the
     * runtime value should be 1900. Defaults to 1900.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#success_rate_stdev_factor ComputeBackendService#success_rate_stdev_factor}
     *
     * @stability stable
     */
    readonly successRateStdevFactor?: number;
    /**
     * base_ejection_time block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#base_ejection_time ComputeBackendService#base_ejection_time}
     *
     * @stability stable
     */
    readonly baseEjectionTime?: ComputeBackendServiceOutlierDetectionBaseEjectionTime;
    /**
     * interval block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#interval ComputeBackendService#interval}
     *
     * @stability stable
     */
    readonly interval?: ComputeBackendServiceOutlierDetectionInterval;
}
export declare function computeBackendServiceOutlierDetectionToTerraform(struct?: ComputeBackendServiceOutlierDetectionOutputReference | ComputeBackendServiceOutlierDetection): any;
/**
 * @stability stable
 */
export declare class ComputeBackendServiceOutlierDetectionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeBackendServiceOutlierDetection | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeBackendServiceOutlierDetection | undefined);
    private _consecutiveErrors?;
    /**
     * @stability stable
     */
    get consecutiveErrors(): number;
    /**
     * @stability stable
     */
    set consecutiveErrors(value: number);
    /**
     * @stability stable
     */
    resetConsecutiveErrors(): void;
    /**
     * @stability stable
     */
    get consecutiveErrorsInput(): number | undefined;
    private _consecutiveGatewayFailure?;
    /**
     * @stability stable
     */
    get consecutiveGatewayFailure(): number;
    /**
     * @stability stable
     */
    set consecutiveGatewayFailure(value: number);
    /**
     * @stability stable
     */
    resetConsecutiveGatewayFailure(): void;
    /**
     * @stability stable
     */
    get consecutiveGatewayFailureInput(): number | undefined;
    private _enforcingConsecutiveErrors?;
    /**
     * @stability stable
     */
    get enforcingConsecutiveErrors(): number;
    /**
     * @stability stable
     */
    set enforcingConsecutiveErrors(value: number);
    /**
     * @stability stable
     */
    resetEnforcingConsecutiveErrors(): void;
    /**
     * @stability stable
     */
    get enforcingConsecutiveErrorsInput(): number | undefined;
    private _enforcingConsecutiveGatewayFailure?;
    /**
     * @stability stable
     */
    get enforcingConsecutiveGatewayFailure(): number;
    /**
     * @stability stable
     */
    set enforcingConsecutiveGatewayFailure(value: number);
    /**
     * @stability stable
     */
    resetEnforcingConsecutiveGatewayFailure(): void;
    /**
     * @stability stable
     */
    get enforcingConsecutiveGatewayFailureInput(): number | undefined;
    private _enforcingSuccessRate?;
    /**
     * @stability stable
     */
    get enforcingSuccessRate(): number;
    /**
     * @stability stable
     */
    set enforcingSuccessRate(value: number);
    /**
     * @stability stable
     */
    resetEnforcingSuccessRate(): void;
    /**
     * @stability stable
     */
    get enforcingSuccessRateInput(): number | undefined;
    private _maxEjectionPercent?;
    /**
     * @stability stable
     */
    get maxEjectionPercent(): number;
    /**
     * @stability stable
     */
    set maxEjectionPercent(value: number);
    /**
     * @stability stable
     */
    resetMaxEjectionPercent(): void;
    /**
     * @stability stable
     */
    get maxEjectionPercentInput(): number | undefined;
    private _successRateMinimumHosts?;
    /**
     * @stability stable
     */
    get successRateMinimumHosts(): number;
    /**
     * @stability stable
     */
    set successRateMinimumHosts(value: number);
    /**
     * @stability stable
     */
    resetSuccessRateMinimumHosts(): void;
    /**
     * @stability stable
     */
    get successRateMinimumHostsInput(): number | undefined;
    private _successRateRequestVolume?;
    /**
     * @stability stable
     */
    get successRateRequestVolume(): number;
    /**
     * @stability stable
     */
    set successRateRequestVolume(value: number);
    /**
     * @stability stable
     */
    resetSuccessRateRequestVolume(): void;
    /**
     * @stability stable
     */
    get successRateRequestVolumeInput(): number | undefined;
    private _successRateStdevFactor?;
    /**
     * @stability stable
     */
    get successRateStdevFactor(): number;
    /**
     * @stability stable
     */
    set successRateStdevFactor(value: number);
    /**
     * @stability stable
     */
    resetSuccessRateStdevFactor(): void;
    /**
     * @stability stable
     */
    get successRateStdevFactorInput(): number | undefined;
    private _baseEjectionTime;
    /**
     * @stability stable
     */
    get baseEjectionTime(): ComputeBackendServiceOutlierDetectionBaseEjectionTimeOutputReference;
    /**
     * @stability stable
     */
    putBaseEjectionTime(value: ComputeBackendServiceOutlierDetectionBaseEjectionTime): void;
    /**
     * @stability stable
     */
    resetBaseEjectionTime(): void;
    /**
     * @stability stable
     */
    get baseEjectionTimeInput(): ComputeBackendServiceOutlierDetectionBaseEjectionTime | undefined;
    private _interval;
    /**
     * @stability stable
     */
    get interval(): ComputeBackendServiceOutlierDetectionIntervalOutputReference;
    /**
     * @stability stable
     */
    putInterval(value: ComputeBackendServiceOutlierDetectionInterval): void;
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): ComputeBackendServiceOutlierDetectionInterval | undefined;
}
/**
 * @stability stable
 */
export interface ComputeBackendServiceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#create ComputeBackendService#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#delete ComputeBackendService#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#update ComputeBackendService#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function computeBackendServiceTimeoutsToTerraform(struct?: ComputeBackendServiceTimeoutsOutputReference | ComputeBackendServiceTimeouts): any;
/**
 * @stability stable
 */
export declare class ComputeBackendServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeBackendServiceTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeBackendServiceTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html google_compute_backend_service}.
 *
 * @stability stable
 */
export declare class ComputeBackendService extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html google_compute_backend_service} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeBackendServiceConfig);
    private _affinityCookieTtlSec?;
    /**
     * @stability stable
     */
    get affinityCookieTtlSec(): number;
    /**
     * @stability stable
     */
    set affinityCookieTtlSec(value: number);
    /**
     * @stability stable
     */
    resetAffinityCookieTtlSec(): void;
    /**
     * @stability stable
     */
    get affinityCookieTtlSecInput(): number | undefined;
    private _connectionDrainingTimeoutSec?;
    /**
     * @stability stable
     */
    get connectionDrainingTimeoutSec(): number;
    /**
     * @stability stable
     */
    set connectionDrainingTimeoutSec(value: number);
    /**
     * @stability stable
     */
    resetConnectionDrainingTimeoutSec(): void;
    /**
     * @stability stable
     */
    get connectionDrainingTimeoutSecInput(): number | undefined;
    /**
     * @stability stable
     */
    get creationTimestamp(): string;
    private _customRequestHeaders?;
    /**
     * @stability stable
     */
    get customRequestHeaders(): string[];
    /**
     * @stability stable
     */
    set customRequestHeaders(value: string[]);
    /**
     * @stability stable
     */
    resetCustomRequestHeaders(): void;
    /**
     * @stability stable
     */
    get customRequestHeadersInput(): string[] | undefined;
    private _customResponseHeaders?;
    /**
     * @stability stable
     */
    get customResponseHeaders(): string[];
    /**
     * @stability stable
     */
    set customResponseHeaders(value: string[]);
    /**
     * @stability stable
     */
    resetCustomResponseHeaders(): void;
    /**
     * @stability stable
     */
    get customResponseHeadersInput(): string[] | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _enableCdn?;
    /**
     * @stability stable
     */
    get enableCdn(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableCdn(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableCdn(): void;
    /**
     * @stability stable
     */
    get enableCdnInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get fingerprint(): string;
    private _healthChecks?;
    /**
     * @stability stable
     */
    get healthChecks(): string[];
    /**
     * @stability stable
     */
    set healthChecks(value: string[]);
    /**
     * @stability stable
     */
    resetHealthChecks(): void;
    /**
     * @stability stable
     */
    get healthChecksInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _loadBalancingScheme?;
    /**
     * @stability stable
     */
    get loadBalancingScheme(): string;
    /**
     * @stability stable
     */
    set loadBalancingScheme(value: string);
    /**
     * @stability stable
     */
    resetLoadBalancingScheme(): void;
    /**
     * @stability stable
     */
    get loadBalancingSchemeInput(): string | undefined;
    private _localityLbPolicy?;
    /**
     * @stability stable
     */
    get localityLbPolicy(): string;
    /**
     * @stability stable
     */
    set localityLbPolicy(value: string);
    /**
     * @stability stable
     */
    resetLocalityLbPolicy(): void;
    /**
     * @stability stable
     */
    get localityLbPolicyInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _portName?;
    /**
     * @stability stable
     */
    get portName(): string;
    /**
     * @stability stable
     */
    set portName(value: string);
    /**
     * @stability stable
     */
    resetPortName(): void;
    /**
     * @stability stable
     */
    get portNameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _protocol?;
    /**
     * @stability stable
     */
    get protocol(): string;
    /**
     * @stability stable
     */
    set protocol(value: string);
    /**
     * @stability stable
     */
    resetProtocol(): void;
    /**
     * @stability stable
     */
    get protocolInput(): string | undefined;
    private _securityPolicy?;
    /**
     * @stability stable
     */
    get securityPolicy(): string;
    /**
     * @stability stable
     */
    set securityPolicy(value: string);
    /**
     * @stability stable
     */
    resetSecurityPolicy(): void;
    /**
     * @stability stable
     */
    get securityPolicyInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _sessionAffinity?;
    /**
     * @stability stable
     */
    get sessionAffinity(): string;
    /**
     * @stability stable
     */
    set sessionAffinity(value: string);
    /**
     * @stability stable
     */
    resetSessionAffinity(): void;
    /**
     * @stability stable
     */
    get sessionAffinityInput(): string | undefined;
    private _timeoutSec?;
    /**
     * @stability stable
     */
    get timeoutSec(): number;
    /**
     * @stability stable
     */
    set timeoutSec(value: number);
    /**
     * @stability stable
     */
    resetTimeoutSec(): void;
    /**
     * @stability stable
     */
    get timeoutSecInput(): number | undefined;
    private _backend?;
    /**
     * @stability stable
     */
    get backend(): ComputeBackendServiceBackend[];
    /**
     * @stability stable
     */
    set backend(value: ComputeBackendServiceBackend[]);
    /**
     * @stability stable
     */
    resetBackend(): void;
    /**
     * @stability stable
     */
    get backendInput(): ComputeBackendServiceBackend[] | undefined;
    private _cdnPolicy;
    /**
     * @stability stable
     */
    get cdnPolicy(): ComputeBackendServiceCdnPolicyOutputReference;
    /**
     * @stability stable
     */
    putCdnPolicy(value: ComputeBackendServiceCdnPolicy): void;
    /**
     * @stability stable
     */
    resetCdnPolicy(): void;
    /**
     * @stability stable
     */
    get cdnPolicyInput(): ComputeBackendServiceCdnPolicy | undefined;
    private _circuitBreakers;
    /**
     * @stability stable
     */
    get circuitBreakers(): ComputeBackendServiceCircuitBreakersOutputReference;
    /**
     * @stability stable
     */
    putCircuitBreakers(value: ComputeBackendServiceCircuitBreakers): void;
    /**
     * @stability stable
     */
    resetCircuitBreakers(): void;
    /**
     * @stability stable
     */
    get circuitBreakersInput(): ComputeBackendServiceCircuitBreakers | undefined;
    private _consistentHash;
    /**
     * @stability stable
     */
    get consistentHash(): ComputeBackendServiceConsistentHashOutputReference;
    /**
     * @stability stable
     */
    putConsistentHash(value: ComputeBackendServiceConsistentHash): void;
    /**
     * @stability stable
     */
    resetConsistentHash(): void;
    /**
     * @stability stable
     */
    get consistentHashInput(): ComputeBackendServiceConsistentHash | undefined;
    private _iap;
    /**
     * @stability stable
     */
    get iap(): ComputeBackendServiceIapOutputReference;
    /**
     * @stability stable
     */
    putIap(value: ComputeBackendServiceIap): void;
    /**
     * @stability stable
     */
    resetIap(): void;
    /**
     * @stability stable
     */
    get iapInput(): ComputeBackendServiceIap | undefined;
    private _logConfig;
    /**
     * @stability stable
     */
    get logConfig(): ComputeBackendServiceLogConfigOutputReference;
    /**
     * @stability stable
     */
    putLogConfig(value: ComputeBackendServiceLogConfig): void;
    /**
     * @stability stable
     */
    resetLogConfig(): void;
    /**
     * @stability stable
     */
    get logConfigInput(): ComputeBackendServiceLogConfig | undefined;
    private _outlierDetection;
    /**
     * @stability stable
     */
    get outlierDetection(): ComputeBackendServiceOutlierDetectionOutputReference;
    /**
     * @stability stable
     */
    putOutlierDetection(value: ComputeBackendServiceOutlierDetection): void;
    /**
     * @stability stable
     */
    resetOutlierDetection(): void;
    /**
     * @stability stable
     */
    get outlierDetectionInput(): ComputeBackendServiceOutlierDetection | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ComputeBackendServiceTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeBackendServiceTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeBackendServiceTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
