import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeFirewallConfig extends cdktf.TerraformMetaArguments {
    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall.html#description ComputeFirewall#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * If destination ranges are specified, the firewall will apply only to traffic that has destination IP address in these ranges.
     *
     * These ranges
     * must be expressed in CIDR format. Only IPv4 is supported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall.html#destination_ranges ComputeFirewall#destination_ranges}
     *
     * @stability stable
     */
    readonly destinationRanges?: string[];
    /**
     * Direction of traffic to which this firewall applies;
     *
     * default is
     * INGRESS. Note: For INGRESS traffic, it is NOT supported to specify
     * destinationRanges; For EGRESS traffic, it is NOT supported to specify
     * sourceRanges OR sourceTags. Possible values: ["INGRESS", "EGRESS"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall.html#direction ComputeFirewall#direction}
     *
     * @stability stable
     */
    readonly direction?: string;
    /**
     * Denotes whether the firewall rule is disabled, i.e not applied to the network it is associated with. When set to true, the firewall rule is not enforced and the network behaves as if it did not exist. If this is unspecified, the firewall rule will be enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall.html#disabled ComputeFirewall#disabled}
     *
     * @stability stable
     */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
     * This field denotes whether to enable logging for a particular firewall rule.
     *
     * If logging is enabled, logs will be exported to Stackdriver.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall.html#enable_logging ComputeFirewall#enable_logging}
     *
     * @stability stable
     */
    readonly enableLogging?: boolean | cdktf.IResolvable;
    /**
     * Name of the resource.
     *
     * Provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035. Specifically, the name must be 1-63 characters long and match
     * the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
     * first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall.html#name ComputeFirewall#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The name or self_link of the network to attach this firewall to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall.html#network ComputeFirewall#network}
     *
     * @stability stable
     */
    readonly network: string;
    /**
     * Priority for this rule.
     *
     * This is an integer between 0 and 65535, both
     * inclusive. When not specified, the value assumed is 1000. Relative
     * priorities determine precedence of conflicting rules. Lower value of
     * priority implies higher precedence (eg, a rule with priority 0 has
     * higher precedence than a rule with priority 1). DENY rules take
     * precedence over ALLOW rules having equal priority.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall.html#priority ComputeFirewall#priority}
     *
     * @stability stable
     */
    readonly priority?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall.html#project ComputeFirewall#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * If source ranges are specified, the firewall will apply only to traffic that has source IP address in these ranges.
     *
     * These ranges must
     * be expressed in CIDR format. One or both of sourceRanges and
     * sourceTags may be set. If both properties are set, the firewall will
     * apply to traffic that has source IP address within sourceRanges OR the
     * source IP that belongs to a tag listed in the sourceTags property. The
     * connection does not need to match both properties for the firewall to
     * apply. Only IPv4 is supported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall.html#source_ranges ComputeFirewall#source_ranges}
     *
     * @stability stable
     */
    readonly sourceRanges?: string[];
    /**
     * If source service accounts are specified, the firewall will apply only to traffic originating from an instance with a service account in this list.
     *
     * Source service accounts cannot be used to control traffic to an
     * instance's external IP address because service accounts are associated
     * with an instance, not an IP address. sourceRanges can be set at the
     * same time as sourceServiceAccounts. If both are set, the firewall will
     * apply to traffic that has source IP address within sourceRanges OR the
     * source IP belongs to an instance with service account listed in
     * sourceServiceAccount. The connection does not need to match both
     * properties for the firewall to apply. sourceServiceAccounts cannot be
     * used at the same time as sourceTags or targetTags.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall.html#source_service_accounts ComputeFirewall#source_service_accounts}
     *
     * @stability stable
     */
    readonly sourceServiceAccounts?: string[];
    /**
     * If source tags are specified, the firewall will apply only to traffic with source IP that belongs to a tag listed in source tags.
     *
     * Source
     * tags cannot be used to control traffic to an instance's external IP
     * address. Because tags are associated with an instance, not an IP
     * address. One or both of sourceRanges and sourceTags may be set. If
     * both properties are set, the firewall will apply to traffic that has
     * source IP address within sourceRanges OR the source IP that belongs to
     * a tag listed in the sourceTags property. The connection does not need
     * to match both properties for the firewall to apply.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall.html#source_tags ComputeFirewall#source_tags}
     *
     * @stability stable
     */
    readonly sourceTags?: string[];
    /**
     * A list of service accounts indicating sets of instances located in the network that may make network connections as specified in allowed[].
     *
     * targetServiceAccounts cannot be used at the same time as targetTags or
     * sourceTags. If neither targetServiceAccounts nor targetTags are
     * specified, the firewall rule applies to all instances on the specified
     * network.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall.html#target_service_accounts ComputeFirewall#target_service_accounts}
     *
     * @stability stable
     */
    readonly targetServiceAccounts?: string[];
    /**
     * A list of instance tags indicating sets of instances located in the network that may make network connections as specified in allowed[].
     *
     * If no targetTags are specified, the firewall rule applies to all
     * instances on the specified network.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall.html#target_tags ComputeFirewall#target_tags}
     *
     * @stability stable
     */
    readonly targetTags?: string[];
    /**
     * allow block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall.html#allow ComputeFirewall#allow}
     *
     * @stability stable
     */
    readonly allow?: ComputeFirewallAllow[];
    /**
     * deny block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall.html#deny ComputeFirewall#deny}
     *
     * @stability stable
     */
    readonly deny?: ComputeFirewallDeny[];
    /**
     * log_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall.html#log_config ComputeFirewall#log_config}
     *
     * @stability stable
     */
    readonly logConfig?: ComputeFirewallLogConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall.html#timeouts ComputeFirewall#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeFirewallTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeFirewallAllow {
    /**
     * An optional list of ports to which this rule applies.
     *
     * This field
     * is only applicable for UDP or TCP protocol. Each entry must be
     * either an integer or a range. If not specified, this rule
     * applies to connections through any port.
     *
     * Example inputs include: ["22"], ["80","443"], and
     * ["12345-12349"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall.html#ports ComputeFirewall#ports}
     *
     * @stability stable
     */
    readonly ports?: string[];
    /**
     * The IP protocol to which this rule applies.
     *
     * The protocol type is
     * required when creating a firewall rule. This value can either be
     * one of the following well known protocol strings (tcp, udp,
     * icmp, esp, ah, sctp, ipip, all), or the IP protocol number.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall.html#protocol ComputeFirewall#protocol}
     *
     * @stability stable
     */
    readonly protocol: string;
}
export declare function computeFirewallAllowToTerraform(struct?: ComputeFirewallAllow): any;
/**
 * @stability stable
 */
export interface ComputeFirewallDeny {
    /**
     * An optional list of ports to which this rule applies.
     *
     * This field
     * is only applicable for UDP or TCP protocol. Each entry must be
     * either an integer or a range. If not specified, this rule
     * applies to connections through any port.
     *
     * Example inputs include: ["22"], ["80","443"], and
     * ["12345-12349"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall.html#ports ComputeFirewall#ports}
     *
     * @stability stable
     */
    readonly ports?: string[];
    /**
     * The IP protocol to which this rule applies.
     *
     * The protocol type is
     * required when creating a firewall rule. This value can either be
     * one of the following well known protocol strings (tcp, udp,
     * icmp, esp, ah, sctp, ipip, all), or the IP protocol number.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall.html#protocol ComputeFirewall#protocol}
     *
     * @stability stable
     */
    readonly protocol: string;
}
export declare function computeFirewallDenyToTerraform(struct?: ComputeFirewallDeny): any;
/**
 * @stability stable
 */
export interface ComputeFirewallLogConfig {
    /**
     * This field denotes whether to include or exclude metadata for firewall logs. Possible values: ["EXCLUDE_ALL_METADATA", "INCLUDE_ALL_METADATA"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall.html#metadata ComputeFirewall#metadata}
     *
     * @stability stable
     */
    readonly metadata: string;
}
export declare function computeFirewallLogConfigToTerraform(struct?: ComputeFirewallLogConfigOutputReference | ComputeFirewallLogConfig): any;
/**
 * @stability stable
 */
export declare class ComputeFirewallLogConfigOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeFirewallLogConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeFirewallLogConfig | undefined);
    private _metadata?;
    /**
     * @stability stable
     */
    get metadata(): string;
    /**
     * @stability stable
     */
    set metadata(value: string);
    /**
     * @stability stable
     */
    get metadataInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ComputeFirewallTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall.html#create ComputeFirewall#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall.html#delete ComputeFirewall#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall.html#update ComputeFirewall#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function computeFirewallTimeoutsToTerraform(struct?: ComputeFirewallTimeoutsOutputReference | ComputeFirewallTimeouts): any;
/**
 * @stability stable
 */
export declare class ComputeFirewallTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeFirewallTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeFirewallTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_firewall.html google_compute_firewall}.
 *
 * @stability stable
 */
export declare class ComputeFirewall extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_firewall.html google_compute_firewall} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeFirewallConfig);
    /**
     * @stability stable
     */
    get creationTimestamp(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _destinationRanges?;
    /**
     * @stability stable
     */
    get destinationRanges(): string[];
    /**
     * @stability stable
     */
    set destinationRanges(value: string[]);
    /**
     * @stability stable
     */
    resetDestinationRanges(): void;
    /**
     * @stability stable
     */
    get destinationRangesInput(): string[] | undefined;
    private _direction?;
    /**
     * @stability stable
     */
    get direction(): string;
    /**
     * @stability stable
     */
    set direction(value: string);
    /**
     * @stability stable
     */
    resetDirection(): void;
    /**
     * @stability stable
     */
    get directionInput(): string | undefined;
    private _disabled?;
    /**
     * @stability stable
     */
    get disabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set disabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDisabled(): void;
    /**
     * @stability stable
     */
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _enableLogging?;
    /**
     * @stability stable
     */
    get enableLogging(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableLogging(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableLogging(): void;
    /**
     * @stability stable
     */
    get enableLoggingInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _network?;
    /**
     * @stability stable
     */
    get network(): string;
    /**
     * @stability stable
     */
    set network(value: string);
    /**
     * @stability stable
     */
    get networkInput(): string | undefined;
    private _priority?;
    /**
     * @stability stable
     */
    get priority(): number;
    /**
     * @stability stable
     */
    set priority(value: number);
    /**
     * @stability stable
     */
    resetPriority(): void;
    /**
     * @stability stable
     */
    get priorityInput(): number | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _sourceRanges?;
    /**
     * @stability stable
     */
    get sourceRanges(): string[];
    /**
     * @stability stable
     */
    set sourceRanges(value: string[]);
    /**
     * @stability stable
     */
    resetSourceRanges(): void;
    /**
     * @stability stable
     */
    get sourceRangesInput(): string[] | undefined;
    private _sourceServiceAccounts?;
    /**
     * @stability stable
     */
    get sourceServiceAccounts(): string[];
    /**
     * @stability stable
     */
    set sourceServiceAccounts(value: string[]);
    /**
     * @stability stable
     */
    resetSourceServiceAccounts(): void;
    /**
     * @stability stable
     */
    get sourceServiceAccountsInput(): string[] | undefined;
    private _sourceTags?;
    /**
     * @stability stable
     */
    get sourceTags(): string[];
    /**
     * @stability stable
     */
    set sourceTags(value: string[]);
    /**
     * @stability stable
     */
    resetSourceTags(): void;
    /**
     * @stability stable
     */
    get sourceTagsInput(): string[] | undefined;
    private _targetServiceAccounts?;
    /**
     * @stability stable
     */
    get targetServiceAccounts(): string[];
    /**
     * @stability stable
     */
    set targetServiceAccounts(value: string[]);
    /**
     * @stability stable
     */
    resetTargetServiceAccounts(): void;
    /**
     * @stability stable
     */
    get targetServiceAccountsInput(): string[] | undefined;
    private _targetTags?;
    /**
     * @stability stable
     */
    get targetTags(): string[];
    /**
     * @stability stable
     */
    set targetTags(value: string[]);
    /**
     * @stability stable
     */
    resetTargetTags(): void;
    /**
     * @stability stable
     */
    get targetTagsInput(): string[] | undefined;
    private _allow?;
    /**
     * @stability stable
     */
    get allow(): ComputeFirewallAllow[];
    /**
     * @stability stable
     */
    set allow(value: ComputeFirewallAllow[]);
    /**
     * @stability stable
     */
    resetAllow(): void;
    /**
     * @stability stable
     */
    get allowInput(): ComputeFirewallAllow[] | undefined;
    private _deny?;
    /**
     * @stability stable
     */
    get deny(): ComputeFirewallDeny[];
    /**
     * @stability stable
     */
    set deny(value: ComputeFirewallDeny[]);
    /**
     * @stability stable
     */
    resetDeny(): void;
    /**
     * @stability stable
     */
    get denyInput(): ComputeFirewallDeny[] | undefined;
    private _logConfig;
    /**
     * @stability stable
     */
    get logConfig(): ComputeFirewallLogConfigOutputReference;
    /**
     * @stability stable
     */
    putLogConfig(value: ComputeFirewallLogConfig): void;
    /**
     * @stability stable
     */
    resetLogConfig(): void;
    /**
     * @stability stable
     */
    get logConfigInput(): ComputeFirewallLogConfig | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ComputeFirewallTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeFirewallTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeFirewallTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
