import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeHaVpnGatewayConfig extends cdktf.TerraformMetaArguments {
    /**
     * An optional description of this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ha_vpn_gateway.html#description ComputeHaVpnGateway#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Name of the resource.
     *
     * Provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035.  Specifically, the name must be 1-63 characters long and
     * match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means
     * the first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ha_vpn_gateway.html#name ComputeHaVpnGateway#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The network this VPN gateway is accepting traffic for.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ha_vpn_gateway.html#network ComputeHaVpnGateway#network}
     *
     * @stability stable
     */
    readonly network: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ha_vpn_gateway.html#project ComputeHaVpnGateway#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The region this gateway should sit in.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ha_vpn_gateway.html#region ComputeHaVpnGateway#region}
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ha_vpn_gateway.html#timeouts ComputeHaVpnGateway#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeHaVpnGatewayTimeouts;
    /**
     * vpn_interfaces block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ha_vpn_gateway.html#vpn_interfaces ComputeHaVpnGateway#vpn_interfaces}
     *
     * @stability stable
     */
    readonly vpnInterfaces?: ComputeHaVpnGatewayVpnInterfaces[];
}
/**
 * @stability stable
 */
export interface ComputeHaVpnGatewayTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ha_vpn_gateway.html#create ComputeHaVpnGateway#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ha_vpn_gateway.html#delete ComputeHaVpnGateway#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
export declare function computeHaVpnGatewayTimeoutsToTerraform(struct?: ComputeHaVpnGatewayTimeoutsOutputReference | ComputeHaVpnGatewayTimeouts): any;
/**
 * @stability stable
 */
export declare class ComputeHaVpnGatewayTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeHaVpnGatewayTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeHaVpnGatewayTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ComputeHaVpnGatewayVpnInterfaces {
    /**
     * The numeric ID of this VPN gateway interface.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ha_vpn_gateway.html#id ComputeHaVpnGateway#id}
     *
     * @stability stable
     */
    readonly id?: number;
    /**
     * URL of the interconnect attachment resource.
     *
     * When the value
     * of this field is present, the VPN Gateway will be used for
     * IPsec-encrypted Cloud Interconnect; all Egress or Ingress
     * traffic for this VPN Gateway interface will go through the
     * specified interconnect attachment resource.
     *
     * Not currently available publicly.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ha_vpn_gateway.html#interconnect_attachment ComputeHaVpnGateway#interconnect_attachment}
     *
     * @stability stable
     */
    readonly interconnectAttachment?: string;
}
export declare function computeHaVpnGatewayVpnInterfacesToTerraform(struct?: ComputeHaVpnGatewayVpnInterfaces): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_ha_vpn_gateway.html google_compute_ha_vpn_gateway}.
 *
 * @stability stable
 */
export declare class ComputeHaVpnGateway extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_ha_vpn_gateway.html google_compute_ha_vpn_gateway} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeHaVpnGatewayConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _network?;
    /**
     * @stability stable
     */
    get network(): string;
    /**
     * @stability stable
     */
    set network(value: string);
    /**
     * @stability stable
     */
    get networkInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    set region(value: string);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ComputeHaVpnGatewayTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeHaVpnGatewayTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeHaVpnGatewayTimeouts | undefined;
    private _vpnInterfaces?;
    /**
     * @stability stable
     */
    get vpnInterfaces(): ComputeHaVpnGatewayVpnInterfaces[];
    /**
     * @stability stable
     */
    set vpnInterfaces(value: ComputeHaVpnGatewayVpnInterfaces[]);
    /**
     * @stability stable
     */
    resetVpnInterfaces(): void;
    /**
     * @stability stable
     */
    get vpnInterfacesInput(): ComputeHaVpnGatewayVpnInterfaces[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
