import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
     * If true, allows Terraform to stop the instance to update its properties.
     *
     * If you try to update a property that requires stopping the instance without setting this field, the update will fail.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#allow_stopping_for_update ComputeInstance#allow_stopping_for_update}
     *
     * @stability stable
     */
    readonly allowStoppingForUpdate?: boolean | cdktf.IResolvable;
    /**
     * Whether sending and receiving of packets with non-matching source or destination IPs is allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#can_ip_forward ComputeInstance#can_ip_forward}
     *
     * @stability stable
     */
    readonly canIpForward?: boolean | cdktf.IResolvable;
    /**
     * Whether deletion protection is enabled on this instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#deletion_protection ComputeInstance#deletion_protection}
     *
     * @stability stable
     */
    readonly deletionProtection?: boolean | cdktf.IResolvable;
    /**
     * A brief description of the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#description ComputeInstance#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Desired status of the instance. Either "RUNNING" or "TERMINATED".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#desired_status ComputeInstance#desired_status}
     *
     * @stability stable
     */
    readonly desiredStatus?: string;
    /**
     * Whether the instance has virtual displays enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#enable_display ComputeInstance#enable_display}
     *
     * @stability stable
     */
    readonly enableDisplay?: boolean | cdktf.IResolvable;
    /**
     * List of the type and count of accelerator cards attached to the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#guest_accelerator ComputeInstance#guest_accelerator}
     *
     * @stability stable
     */
    readonly guestAccelerator?: ComputeInstanceGuestAccelerator[];
    /**
     * A custom hostname for the instance.
     *
     * Must be a fully qualified DNS name and RFC-1035-valid. Valid format is a series of labels 1-63 characters long matching the regular expression [a-z]([-a-z0-9]*[a-z0-9]), concatenated with periods. The entire hostname must not exceed 253 characters. Changing this forces a new resource to be created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#hostname ComputeInstance#hostname}
     *
     * @stability stable
     */
    readonly hostname?: string;
    /**
     * A set of key/value label pairs assigned to the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#labels ComputeInstance#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The machine type to create.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#machine_type ComputeInstance#machine_type}
     *
     * @stability stable
     */
    readonly machineType: string;
    /**
     * Metadata key/value pairs made available within the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#metadata ComputeInstance#metadata}
     *
     * @stability stable
     */
    readonly metadata?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Metadata startup scripts made available within the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#metadata_startup_script ComputeInstance#metadata_startup_script}
     *
     * @stability stable
     */
    readonly metadataStartupScript?: string;
    /**
     * The minimum CPU platform specified for the VM instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#min_cpu_platform ComputeInstance#min_cpu_platform}
     *
     * @stability stable
     */
    readonly minCpuPlatform?: string;
    /**
     * The name of the instance. One of name or self_link must be provided.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#name ComputeInstance#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The ID of the project in which the resource belongs.
     *
     * If self_link is provided, this value is ignored. If neither self_link nor project are provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#project ComputeInstance#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * A list of short names or self_links of resource policies to attach to the instance.
     *
     * Currently a max of 1 resource policy is supported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#resource_policies ComputeInstance#resource_policies}
     *
     * @stability stable
     */
    readonly resourcePolicies?: string[];
    /**
     * The list of tags attached to the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#tags ComputeInstance#tags}
     *
     * @stability stable
     */
    readonly tags?: string[];
    /**
     * The zone of the instance.
     *
     * If self_link is provided, this value is ignored. If neither self_link nor zone are provided, the provider zone is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#zone ComputeInstance#zone}
     *
     * @stability stable
     */
    readonly zone?: string;
    /**
     * advanced_machine_features block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#advanced_machine_features ComputeInstance#advanced_machine_features}
     *
     * @stability stable
     */
    readonly advancedMachineFeatures?: ComputeInstanceAdvancedMachineFeatures;
    /**
     * attached_disk block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#attached_disk ComputeInstance#attached_disk}
     *
     * @stability stable
     */
    readonly attachedDisk?: ComputeInstanceAttachedDisk[];
    /**
     * boot_disk block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#boot_disk ComputeInstance#boot_disk}
     *
     * @stability stable
     */
    readonly bootDisk: ComputeInstanceBootDisk;
    /**
     * confidential_instance_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#confidential_instance_config ComputeInstance#confidential_instance_config}
     *
     * @stability stable
     */
    readonly confidentialInstanceConfig?: ComputeInstanceConfidentialInstanceConfig;
    /**
     * network_interface block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#network_interface ComputeInstance#network_interface}
     *
     * @stability stable
     */
    readonly networkInterface: ComputeInstanceNetworkInterface[];
    /**
     * reservation_affinity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#reservation_affinity ComputeInstance#reservation_affinity}
     *
     * @stability stable
     */
    readonly reservationAffinity?: ComputeInstanceReservationAffinity;
    /**
     * scheduling block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#scheduling ComputeInstance#scheduling}
     *
     * @stability stable
     */
    readonly scheduling?: ComputeInstanceScheduling;
    /**
     * scratch_disk block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#scratch_disk ComputeInstance#scratch_disk}
     *
     * @stability stable
     */
    readonly scratchDisk?: ComputeInstanceScratchDisk[];
    /**
     * service_account block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#service_account ComputeInstance#service_account}
     *
     * @stability stable
     */
    readonly serviceAccount?: ComputeInstanceServiceAccount;
    /**
     * shielded_instance_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#shielded_instance_config ComputeInstance#shielded_instance_config}
     *
     * @stability stable
     */
    readonly shieldedInstanceConfig?: ComputeInstanceShieldedInstanceConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#timeouts ComputeInstance#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeInstanceTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeInstanceGuestAccelerator {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#count ComputeInstance#count}.
     *
     * @stability stable
     */
    readonly count?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#type ComputeInstance#type}.
     *
     * @stability stable
     */
    readonly type?: string;
}
export declare function computeInstanceGuestAcceleratorToTerraform(struct?: ComputeInstanceGuestAccelerator): any;
/**
 * @stability stable
 */
export interface ComputeInstanceAdvancedMachineFeatures {
    /**
     * Whether to enable nested virtualization or not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#enable_nested_virtualization ComputeInstance#enable_nested_virtualization}
     *
     * @stability stable
     */
    readonly enableNestedVirtualization?: boolean | cdktf.IResolvable;
    /**
     * The number of threads per physical core.
     *
     * To disable simultaneous multithreading (SMT) set this to 1. If unset, the maximum number of threads supported per core by the underlying processor is assumed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#threads_per_core ComputeInstance#threads_per_core}
     *
     * @stability stable
     */
    readonly threadsPerCore?: number;
}
export declare function computeInstanceAdvancedMachineFeaturesToTerraform(struct?: ComputeInstanceAdvancedMachineFeaturesOutputReference | ComputeInstanceAdvancedMachineFeatures): any;
/**
 * @stability stable
 */
export declare class ComputeInstanceAdvancedMachineFeaturesOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeInstanceAdvancedMachineFeatures | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeInstanceAdvancedMachineFeatures | undefined);
    private _enableNestedVirtualization?;
    /**
     * @stability stable
     */
    get enableNestedVirtualization(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableNestedVirtualization(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableNestedVirtualization(): void;
    /**
     * @stability stable
     */
    get enableNestedVirtualizationInput(): boolean | cdktf.IResolvable | undefined;
    private _threadsPerCore?;
    /**
     * @stability stable
     */
    get threadsPerCore(): number;
    /**
     * @stability stable
     */
    set threadsPerCore(value: number);
    /**
     * @stability stable
     */
    resetThreadsPerCore(): void;
    /**
     * @stability stable
     */
    get threadsPerCoreInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface ComputeInstanceAttachedDisk {
    /**
     * Name with which the attached disk is accessible under /dev/disk/by-id/.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#device_name ComputeInstance#device_name}
     *
     * @stability stable
     */
    readonly deviceName?: string;
    /**
     * A 256-bit customer-supplied encryption key, encoded in RFC 4648 base64 to encrypt this disk.
     *
     * Only one of kms_key_self_link and disk_encryption_key_raw may be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#disk_encryption_key_raw ComputeInstance#disk_encryption_key_raw}
     *
     * @stability stable
     */
    readonly diskEncryptionKeyRaw?: string;
    /**
     * The self_link of the encryption key that is stored in Google Cloud KMS to encrypt this disk.
     *
     * Only one of kms_key_self_link and disk_encryption_key_raw may be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#kms_key_self_link ComputeInstance#kms_key_self_link}
     *
     * @stability stable
     */
    readonly kmsKeySelfLink?: string;
    /**
     * Read/write mode for the disk. One of "READ_ONLY" or "READ_WRITE".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#mode ComputeInstance#mode}
     *
     * @stability stable
     */
    readonly mode?: string;
    /**
     * The name or self_link of the disk attached to this instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#source ComputeInstance#source}
     *
     * @stability stable
     */
    readonly source: string;
}
export declare function computeInstanceAttachedDiskToTerraform(struct?: ComputeInstanceAttachedDisk): any;
/**
 * @stability stable
 */
export interface ComputeInstanceBootDiskInitializeParams {
    /**
     * The image from which this disk was initialised.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#image ComputeInstance#image}
     *
     * @stability stable
     */
    readonly image?: string;
    /**
     * A set of key/value label pairs assigned to the disk.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#labels ComputeInstance#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The size of the image in gigabytes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#size ComputeInstance#size}
     *
     * @stability stable
     */
    readonly size?: number;
    /**
     * The Google Compute Engine disk type. One of pd-standard, pd-ssd or pd-balanced.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#type ComputeInstance#type}
     *
     * @stability stable
     */
    readonly type?: string;
}
export declare function computeInstanceBootDiskInitializeParamsToTerraform(struct?: ComputeInstanceBootDiskInitializeParamsOutputReference | ComputeInstanceBootDiskInitializeParams): any;
/**
 * @stability stable
 */
export declare class ComputeInstanceBootDiskInitializeParamsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeInstanceBootDiskInitializeParams | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeInstanceBootDiskInitializeParams | undefined);
    private _image?;
    /**
     * @stability stable
     */
    get image(): string;
    /**
     * @stability stable
     */
    set image(value: string);
    /**
     * @stability stable
     */
    resetImage(): void;
    /**
     * @stability stable
     */
    get imageInput(): string | undefined;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _size?;
    /**
     * @stability stable
     */
    get size(): number;
    /**
     * @stability stable
     */
    set size(value: number);
    /**
     * @stability stable
     */
    resetSize(): void;
    /**
     * @stability stable
     */
    get sizeInput(): number | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    resetType(): void;
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ComputeInstanceBootDisk {
    /**
     * Whether the disk will be auto-deleted when the instance is deleted.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#auto_delete ComputeInstance#auto_delete}
     *
     * @stability stable
     */
    readonly autoDelete?: boolean | cdktf.IResolvable;
    /**
     * Name with which attached disk will be accessible under /dev/disk/by-id/.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#device_name ComputeInstance#device_name}
     *
     * @stability stable
     */
    readonly deviceName?: string;
    /**
     * A 256-bit customer-supplied encryption key, encoded in RFC 4648 base64 to encrypt this disk.
     *
     * Only one of kms_key_self_link and disk_encryption_key_raw may be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#disk_encryption_key_raw ComputeInstance#disk_encryption_key_raw}
     *
     * @stability stable
     */
    readonly diskEncryptionKeyRaw?: string;
    /**
     * The self_link of the encryption key that is stored in Google Cloud KMS to encrypt this disk.
     *
     * Only one of kms_key_self_link and disk_encryption_key_raw may be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#kms_key_self_link ComputeInstance#kms_key_self_link}
     *
     * @stability stable
     */
    readonly kmsKeySelfLink?: string;
    /**
     * Read/write mode for the disk. One of "READ_ONLY" or "READ_WRITE".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#mode ComputeInstance#mode}
     *
     * @stability stable
     */
    readonly mode?: string;
    /**
     * The name or self_link of the disk attached to this instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#source ComputeInstance#source}
     *
     * @stability stable
     */
    readonly source?: string;
    /**
     * initialize_params block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#initialize_params ComputeInstance#initialize_params}
     *
     * @stability stable
     */
    readonly initializeParams?: ComputeInstanceBootDiskInitializeParams;
}
export declare function computeInstanceBootDiskToTerraform(struct?: ComputeInstanceBootDiskOutputReference | ComputeInstanceBootDisk): any;
/**
 * @stability stable
 */
export declare class ComputeInstanceBootDiskOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeInstanceBootDisk | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeInstanceBootDisk | undefined);
    private _autoDelete?;
    /**
     * @stability stable
     */
    get autoDelete(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set autoDelete(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAutoDelete(): void;
    /**
     * @stability stable
     */
    get autoDeleteInput(): boolean | cdktf.IResolvable | undefined;
    private _deviceName?;
    /**
     * @stability stable
     */
    get deviceName(): string;
    /**
     * @stability stable
     */
    set deviceName(value: string);
    /**
     * @stability stable
     */
    resetDeviceName(): void;
    /**
     * @stability stable
     */
    get deviceNameInput(): string | undefined;
    private _diskEncryptionKeyRaw?;
    /**
     * @stability stable
     */
    get diskEncryptionKeyRaw(): string;
    /**
     * @stability stable
     */
    set diskEncryptionKeyRaw(value: string);
    /**
     * @stability stable
     */
    resetDiskEncryptionKeyRaw(): void;
    /**
     * @stability stable
     */
    get diskEncryptionKeyRawInput(): string | undefined;
    private _kmsKeySelfLink?;
    /**
     * @stability stable
     */
    get kmsKeySelfLink(): string;
    /**
     * @stability stable
     */
    set kmsKeySelfLink(value: string);
    /**
     * @stability stable
     */
    resetKmsKeySelfLink(): void;
    /**
     * @stability stable
     */
    get kmsKeySelfLinkInput(): string | undefined;
    private _mode?;
    /**
     * @stability stable
     */
    get mode(): string;
    /**
     * @stability stable
     */
    set mode(value: string);
    /**
     * @stability stable
     */
    resetMode(): void;
    /**
     * @stability stable
     */
    get modeInput(): string | undefined;
    private _source?;
    /**
     * @stability stable
     */
    get source(): string;
    /**
     * @stability stable
     */
    set source(value: string);
    /**
     * @stability stable
     */
    resetSource(): void;
    /**
     * @stability stable
     */
    get sourceInput(): string | undefined;
    private _initializeParams;
    /**
     * @stability stable
     */
    get initializeParams(): ComputeInstanceBootDiskInitializeParamsOutputReference;
    /**
     * @stability stable
     */
    putInitializeParams(value: ComputeInstanceBootDiskInitializeParams): void;
    /**
     * @stability stable
     */
    resetInitializeParams(): void;
    /**
     * @stability stable
     */
    get initializeParamsInput(): ComputeInstanceBootDiskInitializeParams | undefined;
}
/**
 * @stability stable
 */
export interface ComputeInstanceConfidentialInstanceConfig {
    /**
     * Defines whether the instance should have confidential compute enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#enable_confidential_compute ComputeInstance#enable_confidential_compute}
     *
     * @stability stable
     */
    readonly enableConfidentialCompute: boolean | cdktf.IResolvable;
}
export declare function computeInstanceConfidentialInstanceConfigToTerraform(struct?: ComputeInstanceConfidentialInstanceConfigOutputReference | ComputeInstanceConfidentialInstanceConfig): any;
/**
 * @stability stable
 */
export declare class ComputeInstanceConfidentialInstanceConfigOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeInstanceConfidentialInstanceConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeInstanceConfidentialInstanceConfig | undefined);
    private _enableConfidentialCompute?;
    /**
     * @stability stable
     */
    get enableConfidentialCompute(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableConfidentialCompute(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enableConfidentialComputeInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface ComputeInstanceNetworkInterfaceAccessConfig {
    /**
     * The IP address that is be 1:1 mapped to the instance's network ip.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#nat_ip ComputeInstance#nat_ip}
     *
     * @stability stable
     */
    readonly natIp?: string;
    /**
     * The networking tier used for configuring this instance. One of PREMIUM or STANDARD.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#network_tier ComputeInstance#network_tier}
     *
     * @stability stable
     */
    readonly networkTier?: string;
    /**
     * The DNS domain name for the public PTR record.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#public_ptr_domain_name ComputeInstance#public_ptr_domain_name}
     *
     * @stability stable
     */
    readonly publicPtrDomainName?: string;
}
export declare function computeInstanceNetworkInterfaceAccessConfigToTerraform(struct?: ComputeInstanceNetworkInterfaceAccessConfig): any;
/**
 * @stability stable
 */
export interface ComputeInstanceNetworkInterfaceAliasIpRange {
    /**
     * The IP CIDR range represented by this alias IP range.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#ip_cidr_range ComputeInstance#ip_cidr_range}
     *
     * @stability stable
     */
    readonly ipCidrRange: string;
    /**
     * The subnetwork secondary range name specifying the secondary range from which to allocate the IP CIDR range for this alias IP range.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#subnetwork_range_name ComputeInstance#subnetwork_range_name}
     *
     * @stability stable
     */
    readonly subnetworkRangeName?: string;
}
export declare function computeInstanceNetworkInterfaceAliasIpRangeToTerraform(struct?: ComputeInstanceNetworkInterfaceAliasIpRange): any;
/**
 * @stability stable
 */
export interface ComputeInstanceNetworkInterfaceIpv6AccessConfig {
    /**
     * The service-level to be provided for IPv6 traffic when the subnet has an external subnet.
     *
     * Only PREMIUM tier is valid for IPv6
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#network_tier ComputeInstance#network_tier}
     *
     * @stability stable
     */
    readonly networkTier: string;
    /**
     * The domain name to be used when creating DNSv6 records for the external IPv6 ranges.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#public_ptr_domain_name ComputeInstance#public_ptr_domain_name}
     *
     * @stability stable
     */
    readonly publicPtrDomainName?: string;
}
export declare function computeInstanceNetworkInterfaceIpv6AccessConfigToTerraform(struct?: ComputeInstanceNetworkInterfaceIpv6AccessConfig): any;
/**
 * @stability stable
 */
export interface ComputeInstanceNetworkInterface {
    /**
     * The name or self_link of the network attached to this interface.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#network ComputeInstance#network}
     *
     * @stability stable
     */
    readonly network?: string;
    /**
     * The private IP address assigned to the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#network_ip ComputeInstance#network_ip}
     *
     * @stability stable
     */
    readonly networkIp?: string;
    /**
     * The type of vNIC to be used on this interface. Possible values:GVNIC, VIRTIO_NET.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#nic_type ComputeInstance#nic_type}
     *
     * @stability stable
     */
    readonly nicType?: string;
    /**
     * The stack type for this network interface to identify whether the IPv6 feature is enabled or not.
     *
     * If not specified, IPV4_ONLY will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#stack_type ComputeInstance#stack_type}
     *
     * @stability stable
     */
    readonly stackType?: string;
    /**
     * The name or self_link of the subnetwork attached to this interface.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#subnetwork ComputeInstance#subnetwork}
     *
     * @stability stable
     */
    readonly subnetwork?: string;
    /**
     * The project in which the subnetwork belongs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#subnetwork_project ComputeInstance#subnetwork_project}
     *
     * @stability stable
     */
    readonly subnetworkProject?: string;
    /**
     * access_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#access_config ComputeInstance#access_config}
     *
     * @stability stable
     */
    readonly accessConfig?: ComputeInstanceNetworkInterfaceAccessConfig[];
    /**
     * alias_ip_range block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#alias_ip_range ComputeInstance#alias_ip_range}
     *
     * @stability stable
     */
    readonly aliasIpRange?: ComputeInstanceNetworkInterfaceAliasIpRange[];
    /**
     * ipv6_access_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#ipv6_access_config ComputeInstance#ipv6_access_config}
     *
     * @stability stable
     */
    readonly ipv6AccessConfig?: ComputeInstanceNetworkInterfaceIpv6AccessConfig[];
}
export declare function computeInstanceNetworkInterfaceToTerraform(struct?: ComputeInstanceNetworkInterface): any;
/**
 * @stability stable
 */
export interface ComputeInstanceReservationAffinitySpecificReservation {
    /**
     * Corresponds to the label key of a reservation resource.
     *
     * To target a SPECIFIC_RESERVATION by name, specify compute.googleapis.com/reservation-name as the key and specify the name of your reservation as the only value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#key ComputeInstance#key}
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Corresponds to the label values of a reservation resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#values ComputeInstance#values}
     *
     * @stability stable
     */
    readonly values: string[];
}
export declare function computeInstanceReservationAffinitySpecificReservationToTerraform(struct?: ComputeInstanceReservationAffinitySpecificReservationOutputReference | ComputeInstanceReservationAffinitySpecificReservation): any;
/**
 * @stability stable
 */
export declare class ComputeInstanceReservationAffinitySpecificReservationOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeInstanceReservationAffinitySpecificReservation | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeInstanceReservationAffinitySpecificReservation | undefined);
    private _key?;
    /**
     * @stability stable
     */
    get key(): string;
    /**
     * @stability stable
     */
    set key(value: string);
    /**
     * @stability stable
     */
    get keyInput(): string | undefined;
    private _values?;
    /**
     * @stability stable
     */
    get values(): string[];
    /**
     * @stability stable
     */
    set values(value: string[]);
    /**
     * @stability stable
     */
    get valuesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface ComputeInstanceReservationAffinity {
    /**
     * The type of reservation from which this instance can consume resources.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#type ComputeInstance#type}
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * specific_reservation block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#specific_reservation ComputeInstance#specific_reservation}
     *
     * @stability stable
     */
    readonly specificReservation?: ComputeInstanceReservationAffinitySpecificReservation;
}
export declare function computeInstanceReservationAffinityToTerraform(struct?: ComputeInstanceReservationAffinityOutputReference | ComputeInstanceReservationAffinity): any;
/**
 * @stability stable
 */
export declare class ComputeInstanceReservationAffinityOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeInstanceReservationAffinity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeInstanceReservationAffinity | undefined);
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _specificReservation;
    /**
     * @stability stable
     */
    get specificReservation(): ComputeInstanceReservationAffinitySpecificReservationOutputReference;
    /**
     * @stability stable
     */
    putSpecificReservation(value: ComputeInstanceReservationAffinitySpecificReservation): void;
    /**
     * @stability stable
     */
    resetSpecificReservation(): void;
    /**
     * @stability stable
     */
    get specificReservationInput(): ComputeInstanceReservationAffinitySpecificReservation | undefined;
}
/**
 * @stability stable
 */
export interface ComputeInstanceSchedulingNodeAffinities {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#key ComputeInstance#key}.
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#operator ComputeInstance#operator}.
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#values ComputeInstance#values}.
     *
     * @stability stable
     */
    readonly values: string[];
}
export declare function computeInstanceSchedulingNodeAffinitiesToTerraform(struct?: ComputeInstanceSchedulingNodeAffinities): any;
/**
 * @stability stable
 */
export interface ComputeInstanceScheduling {
    /**
     * Specifies if the instance should be restarted if it was terminated by Compute Engine (not a user).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#automatic_restart ComputeInstance#automatic_restart}
     *
     * @stability stable
     */
    readonly automaticRestart?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#min_node_cpus ComputeInstance#min_node_cpus}.
     *
     * @stability stable
     */
    readonly minNodeCpus?: number;
    /**
     * Describes maintenance behavior for the instance. One of MIGRATE or TERMINATE,.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#on_host_maintenance ComputeInstance#on_host_maintenance}
     *
     * @stability stable
     */
    readonly onHostMaintenance?: string;
    /**
     * Whether the instance is preemptible.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#preemptible ComputeInstance#preemptible}
     *
     * @stability stable
     */
    readonly preemptible?: boolean | cdktf.IResolvable;
    /**
     * node_affinities block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#node_affinities ComputeInstance#node_affinities}
     *
     * @stability stable
     */
    readonly nodeAffinities?: ComputeInstanceSchedulingNodeAffinities[];
}
export declare function computeInstanceSchedulingToTerraform(struct?: ComputeInstanceSchedulingOutputReference | ComputeInstanceScheduling): any;
/**
 * @stability stable
 */
export declare class ComputeInstanceSchedulingOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeInstanceScheduling | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeInstanceScheduling | undefined);
    private _automaticRestart?;
    /**
     * @stability stable
     */
    get automaticRestart(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set automaticRestart(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAutomaticRestart(): void;
    /**
     * @stability stable
     */
    get automaticRestartInput(): boolean | cdktf.IResolvable | undefined;
    private _minNodeCpus?;
    /**
     * @stability stable
     */
    get minNodeCpus(): number;
    /**
     * @stability stable
     */
    set minNodeCpus(value: number);
    /**
     * @stability stable
     */
    resetMinNodeCpus(): void;
    /**
     * @stability stable
     */
    get minNodeCpusInput(): number | undefined;
    private _onHostMaintenance?;
    /**
     * @stability stable
     */
    get onHostMaintenance(): string;
    /**
     * @stability stable
     */
    set onHostMaintenance(value: string);
    /**
     * @stability stable
     */
    resetOnHostMaintenance(): void;
    /**
     * @stability stable
     */
    get onHostMaintenanceInput(): string | undefined;
    private _preemptible?;
    /**
     * @stability stable
     */
    get preemptible(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set preemptible(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPreemptible(): void;
    /**
     * @stability stable
     */
    get preemptibleInput(): boolean | cdktf.IResolvable | undefined;
    private _nodeAffinities?;
    /**
     * @stability stable
     */
    get nodeAffinities(): ComputeInstanceSchedulingNodeAffinities[];
    /**
     * @stability stable
     */
    set nodeAffinities(value: ComputeInstanceSchedulingNodeAffinities[]);
    /**
     * @stability stable
     */
    resetNodeAffinities(): void;
    /**
     * @stability stable
     */
    get nodeAffinitiesInput(): ComputeInstanceSchedulingNodeAffinities[] | undefined;
}
/**
 * @stability stable
 */
export interface ComputeInstanceScratchDisk {
    /**
     * The disk interface used for attaching this disk. One of SCSI or NVME.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#interface ComputeInstance#interface}
     *
     * @stability stable
     */
    readonly interface: string;
}
export declare function computeInstanceScratchDiskToTerraform(struct?: ComputeInstanceScratchDisk): any;
/**
 * @stability stable
 */
export interface ComputeInstanceServiceAccount {
    /**
     * The service account e-mail address.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#email ComputeInstance#email}
     *
     * @stability stable
     */
    readonly email?: string;
    /**
     * A list of service scopes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#scopes ComputeInstance#scopes}
     *
     * @stability stable
     */
    readonly scopes: string[];
}
export declare function computeInstanceServiceAccountToTerraform(struct?: ComputeInstanceServiceAccountOutputReference | ComputeInstanceServiceAccount): any;
/**
 * @stability stable
 */
export declare class ComputeInstanceServiceAccountOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeInstanceServiceAccount | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeInstanceServiceAccount | undefined);
    private _email?;
    /**
     * @stability stable
     */
    get email(): string;
    /**
     * @stability stable
     */
    set email(value: string);
    /**
     * @stability stable
     */
    resetEmail(): void;
    /**
     * @stability stable
     */
    get emailInput(): string | undefined;
    private _scopes?;
    /**
     * @stability stable
     */
    get scopes(): string[];
    /**
     * @stability stable
     */
    set scopes(value: string[]);
    /**
     * @stability stable
     */
    get scopesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface ComputeInstanceShieldedInstanceConfig {
    /**
     * Whether integrity monitoring is enabled for the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#enable_integrity_monitoring ComputeInstance#enable_integrity_monitoring}
     *
     * @stability stable
     */
    readonly enableIntegrityMonitoring?: boolean | cdktf.IResolvable;
    /**
     * Whether secure boot is enabled for the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#enable_secure_boot ComputeInstance#enable_secure_boot}
     *
     * @stability stable
     */
    readonly enableSecureBoot?: boolean | cdktf.IResolvable;
    /**
     * Whether the instance uses vTPM.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#enable_vtpm ComputeInstance#enable_vtpm}
     *
     * @stability stable
     */
    readonly enableVtpm?: boolean | cdktf.IResolvable;
}
export declare function computeInstanceShieldedInstanceConfigToTerraform(struct?: ComputeInstanceShieldedInstanceConfigOutputReference | ComputeInstanceShieldedInstanceConfig): any;
/**
 * @stability stable
 */
export declare class ComputeInstanceShieldedInstanceConfigOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeInstanceShieldedInstanceConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeInstanceShieldedInstanceConfig | undefined);
    private _enableIntegrityMonitoring?;
    /**
     * @stability stable
     */
    get enableIntegrityMonitoring(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableIntegrityMonitoring(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableIntegrityMonitoring(): void;
    /**
     * @stability stable
     */
    get enableIntegrityMonitoringInput(): boolean | cdktf.IResolvable | undefined;
    private _enableSecureBoot?;
    /**
     * @stability stable
     */
    get enableSecureBoot(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableSecureBoot(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableSecureBoot(): void;
    /**
     * @stability stable
     */
    get enableSecureBootInput(): boolean | cdktf.IResolvable | undefined;
    private _enableVtpm?;
    /**
     * @stability stable
     */
    get enableVtpm(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableVtpm(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableVtpm(): void;
    /**
     * @stability stable
     */
    get enableVtpmInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface ComputeInstanceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#create ComputeInstance#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#delete ComputeInstance#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#update ComputeInstance#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function computeInstanceTimeoutsToTerraform(struct?: ComputeInstanceTimeoutsOutputReference | ComputeInstanceTimeouts): any;
/**
 * @stability stable
 */
export declare class ComputeInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeInstanceTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeInstanceTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html google_compute_instance}.
 *
 * @stability stable
 */
export declare class ComputeInstance extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html google_compute_instance} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeInstanceConfig);
    private _allowStoppingForUpdate?;
    /**
     * @stability stable
     */
    get allowStoppingForUpdate(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set allowStoppingForUpdate(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAllowStoppingForUpdate(): void;
    /**
     * @stability stable
     */
    get allowStoppingForUpdateInput(): boolean | cdktf.IResolvable | undefined;
    private _canIpForward?;
    /**
     * @stability stable
     */
    get canIpForward(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set canIpForward(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetCanIpForward(): void;
    /**
     * @stability stable
     */
    get canIpForwardInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get cpuPlatform(): string;
    /**
     * @stability stable
     */
    get currentStatus(): string;
    private _deletionProtection?;
    /**
     * @stability stable
     */
    get deletionProtection(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set deletionProtection(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDeletionProtection(): void;
    /**
     * @stability stable
     */
    get deletionProtectionInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _desiredStatus?;
    /**
     * @stability stable
     */
    get desiredStatus(): string;
    /**
     * @stability stable
     */
    set desiredStatus(value: string);
    /**
     * @stability stable
     */
    resetDesiredStatus(): void;
    /**
     * @stability stable
     */
    get desiredStatusInput(): string | undefined;
    private _enableDisplay?;
    /**
     * @stability stable
     */
    get enableDisplay(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableDisplay(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableDisplay(): void;
    /**
     * @stability stable
     */
    get enableDisplayInput(): boolean | cdktf.IResolvable | undefined;
    private _guestAccelerator?;
    /**
     * @stability stable
     */
    get guestAccelerator(): ComputeInstanceGuestAccelerator[];
    /**
     * @stability stable
     */
    set guestAccelerator(value: ComputeInstanceGuestAccelerator[]);
    /**
     * @stability stable
     */
    resetGuestAccelerator(): void;
    /**
     * @stability stable
     */
    get guestAcceleratorInput(): ComputeInstanceGuestAccelerator[] | undefined;
    private _hostname?;
    /**
     * @stability stable
     */
    get hostname(): string;
    /**
     * @stability stable
     */
    set hostname(value: string);
    /**
     * @stability stable
     */
    resetHostname(): void;
    /**
     * @stability stable
     */
    get hostnameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get instanceId(): string;
    /**
     * @stability stable
     */
    get labelFingerprint(): string;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _machineType?;
    /**
     * @stability stable
     */
    get machineType(): string;
    /**
     * @stability stable
     */
    set machineType(value: string);
    /**
     * @stability stable
     */
    get machineTypeInput(): string | undefined;
    private _metadata?;
    /**
     * @stability stable
     */
    get metadata(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set metadata(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMetadata(): void;
    /**
     * @stability stable
     */
    get metadataInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get metadataFingerprint(): string;
    private _metadataStartupScript?;
    /**
     * @stability stable
     */
    get metadataStartupScript(): string;
    /**
     * @stability stable
     */
    set metadataStartupScript(value: string);
    /**
     * @stability stable
     */
    resetMetadataStartupScript(): void;
    /**
     * @stability stable
     */
    get metadataStartupScriptInput(): string | undefined;
    private _minCpuPlatform?;
    /**
     * @stability stable
     */
    get minCpuPlatform(): string;
    /**
     * @stability stable
     */
    set minCpuPlatform(value: string);
    /**
     * @stability stable
     */
    resetMinCpuPlatform(): void;
    /**
     * @stability stable
     */
    get minCpuPlatformInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _resourcePolicies?;
    /**
     * @stability stable
     */
    get resourcePolicies(): string[];
    /**
     * @stability stable
     */
    set resourcePolicies(value: string[]);
    /**
     * @stability stable
     */
    resetResourcePolicies(): void;
    /**
     * @stability stable
     */
    get resourcePoliciesInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): string[];
    /**
     * @stability stable
     */
    set tags(value: string[]);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get tagsFingerprint(): string;
    private _zone?;
    /**
     * @stability stable
     */
    get zone(): string;
    /**
     * @stability stable
     */
    set zone(value: string);
    /**
     * @stability stable
     */
    resetZone(): void;
    /**
     * @stability stable
     */
    get zoneInput(): string | undefined;
    private _advancedMachineFeatures;
    /**
     * @stability stable
     */
    get advancedMachineFeatures(): ComputeInstanceAdvancedMachineFeaturesOutputReference;
    /**
     * @stability stable
     */
    putAdvancedMachineFeatures(value: ComputeInstanceAdvancedMachineFeatures): void;
    /**
     * @stability stable
     */
    resetAdvancedMachineFeatures(): void;
    /**
     * @stability stable
     */
    get advancedMachineFeaturesInput(): ComputeInstanceAdvancedMachineFeatures | undefined;
    private _attachedDisk?;
    /**
     * @stability stable
     */
    get attachedDisk(): ComputeInstanceAttachedDisk[];
    /**
     * @stability stable
     */
    set attachedDisk(value: ComputeInstanceAttachedDisk[]);
    /**
     * @stability stable
     */
    resetAttachedDisk(): void;
    /**
     * @stability stable
     */
    get attachedDiskInput(): ComputeInstanceAttachedDisk[] | undefined;
    private _bootDisk;
    /**
     * @stability stable
     */
    get bootDisk(): ComputeInstanceBootDiskOutputReference;
    /**
     * @stability stable
     */
    putBootDisk(value: ComputeInstanceBootDisk): void;
    /**
     * @stability stable
     */
    get bootDiskInput(): ComputeInstanceBootDisk | undefined;
    private _confidentialInstanceConfig;
    /**
     * @stability stable
     */
    get confidentialInstanceConfig(): ComputeInstanceConfidentialInstanceConfigOutputReference;
    /**
     * @stability stable
     */
    putConfidentialInstanceConfig(value: ComputeInstanceConfidentialInstanceConfig): void;
    /**
     * @stability stable
     */
    resetConfidentialInstanceConfig(): void;
    /**
     * @stability stable
     */
    get confidentialInstanceConfigInput(): ComputeInstanceConfidentialInstanceConfig | undefined;
    private _networkInterface?;
    /**
     * @stability stable
     */
    get networkInterface(): ComputeInstanceNetworkInterface[];
    /**
     * @stability stable
     */
    set networkInterface(value: ComputeInstanceNetworkInterface[]);
    /**
     * @stability stable
     */
    get networkInterfaceInput(): ComputeInstanceNetworkInterface[] | undefined;
    private _reservationAffinity;
    /**
     * @stability stable
     */
    get reservationAffinity(): ComputeInstanceReservationAffinityOutputReference;
    /**
     * @stability stable
     */
    putReservationAffinity(value: ComputeInstanceReservationAffinity): void;
    /**
     * @stability stable
     */
    resetReservationAffinity(): void;
    /**
     * @stability stable
     */
    get reservationAffinityInput(): ComputeInstanceReservationAffinity | undefined;
    private _scheduling;
    /**
     * @stability stable
     */
    get scheduling(): ComputeInstanceSchedulingOutputReference;
    /**
     * @stability stable
     */
    putScheduling(value: ComputeInstanceScheduling): void;
    /**
     * @stability stable
     */
    resetScheduling(): void;
    /**
     * @stability stable
     */
    get schedulingInput(): ComputeInstanceScheduling | undefined;
    private _scratchDisk?;
    /**
     * @stability stable
     */
    get scratchDisk(): ComputeInstanceScratchDisk[];
    /**
     * @stability stable
     */
    set scratchDisk(value: ComputeInstanceScratchDisk[]);
    /**
     * @stability stable
     */
    resetScratchDisk(): void;
    /**
     * @stability stable
     */
    get scratchDiskInput(): ComputeInstanceScratchDisk[] | undefined;
    private _serviceAccount;
    /**
     * @stability stable
     */
    get serviceAccount(): ComputeInstanceServiceAccountOutputReference;
    /**
     * @stability stable
     */
    putServiceAccount(value: ComputeInstanceServiceAccount): void;
    /**
     * @stability stable
     */
    resetServiceAccount(): void;
    /**
     * @stability stable
     */
    get serviceAccountInput(): ComputeInstanceServiceAccount | undefined;
    private _shieldedInstanceConfig;
    /**
     * @stability stable
     */
    get shieldedInstanceConfig(): ComputeInstanceShieldedInstanceConfigOutputReference;
    /**
     * @stability stable
     */
    putShieldedInstanceConfig(value: ComputeInstanceShieldedInstanceConfig): void;
    /**
     * @stability stable
     */
    resetShieldedInstanceConfig(): void;
    /**
     * @stability stable
     */
    get shieldedInstanceConfigInput(): ComputeInstanceShieldedInstanceConfig | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ComputeInstanceTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeInstanceTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeInstanceTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
