import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeNetworkPeeringConfig extends cdktf.TerraformMetaArguments {
    /**
     * Whether to export the custom routes to the peer network. Defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering.html#export_custom_routes ComputeNetworkPeering#export_custom_routes}
     *
     * @stability stable
     */
    readonly exportCustomRoutes?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering.html#export_subnet_routes_with_public_ip ComputeNetworkPeering#export_subnet_routes_with_public_ip}.
     *
     * @stability stable
     */
    readonly exportSubnetRoutesWithPublicIp?: boolean | cdktf.IResolvable;
    /**
     * Whether to export the custom routes from the peer network. Defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering.html#import_custom_routes ComputeNetworkPeering#import_custom_routes}
     *
     * @stability stable
     */
    readonly importCustomRoutes?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering.html#import_subnet_routes_with_public_ip ComputeNetworkPeering#import_subnet_routes_with_public_ip}.
     *
     * @stability stable
     */
    readonly importSubnetRoutesWithPublicIp?: boolean | cdktf.IResolvable;
    /**
     * Name of the peering.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering.html#name ComputeNetworkPeering#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The primary network of the peering.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering.html#network ComputeNetworkPeering#network}
     *
     * @stability stable
     */
    readonly network: string;
    /**
     * The peer network in the peering. The peer network may belong to a different project.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering.html#peer_network ComputeNetworkPeering#peer_network}
     *
     * @stability stable
     */
    readonly peerNetwork: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering.html#timeouts ComputeNetworkPeering#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeNetworkPeeringTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeNetworkPeeringTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering.html#create ComputeNetworkPeering#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering.html#delete ComputeNetworkPeering#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering.html#update ComputeNetworkPeering#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function computeNetworkPeeringTimeoutsToTerraform(struct?: ComputeNetworkPeeringTimeoutsOutputReference | ComputeNetworkPeeringTimeouts): any;
/**
 * @stability stable
 */
export declare class ComputeNetworkPeeringTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeNetworkPeeringTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeNetworkPeeringTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering.html google_compute_network_peering}.
 *
 * @stability stable
 */
export declare class ComputeNetworkPeering extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering.html google_compute_network_peering} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeNetworkPeeringConfig);
    private _exportCustomRoutes?;
    /**
     * @stability stable
     */
    get exportCustomRoutes(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set exportCustomRoutes(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetExportCustomRoutes(): void;
    /**
     * @stability stable
     */
    get exportCustomRoutesInput(): boolean | cdktf.IResolvable | undefined;
    private _exportSubnetRoutesWithPublicIp?;
    /**
     * @stability stable
     */
    get exportSubnetRoutesWithPublicIp(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set exportSubnetRoutesWithPublicIp(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetExportSubnetRoutesWithPublicIp(): void;
    /**
     * @stability stable
     */
    get exportSubnetRoutesWithPublicIpInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _importCustomRoutes?;
    /**
     * @stability stable
     */
    get importCustomRoutes(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set importCustomRoutes(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetImportCustomRoutes(): void;
    /**
     * @stability stable
     */
    get importCustomRoutesInput(): boolean | cdktf.IResolvable | undefined;
    private _importSubnetRoutesWithPublicIp?;
    /**
     * @stability stable
     */
    get importSubnetRoutesWithPublicIp(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set importSubnetRoutesWithPublicIp(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetImportSubnetRoutesWithPublicIp(): void;
    /**
     * @stability stable
     */
    get importSubnetRoutesWithPublicIpInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _network?;
    /**
     * @stability stable
     */
    get network(): string;
    /**
     * @stability stable
     */
    set network(value: string);
    /**
     * @stability stable
     */
    get networkInput(): string | undefined;
    private _peerNetwork?;
    /**
     * @stability stable
     */
    get peerNetwork(): string;
    /**
     * @stability stable
     */
    set peerNetwork(value: string);
    /**
     * @stability stable
     */
    get peerNetworkInput(): string | undefined;
    /**
     * @stability stable
     */
    get state(): string;
    /**
     * @stability stable
     */
    get stateDetails(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ComputeNetworkPeeringTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeNetworkPeeringTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeNetworkPeeringTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
