import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputePacketMirroringConfig extends cdktf.TerraformMetaArguments {
    /**
     * A human-readable description of the rule.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#description ComputePacketMirroring#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The name of the packet mirroring rule.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#name ComputePacketMirroring#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Since only one rule can be active at a time, priority is used to break ties in the case of two rules that apply to the same instances.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#priority ComputePacketMirroring#priority}
     *
     * @stability stable
     */
    readonly priority?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#project ComputePacketMirroring#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The Region in which the created address should reside. If it is not provided, the provider region is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#region ComputePacketMirroring#region}
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * collector_ilb block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#collector_ilb ComputePacketMirroring#collector_ilb}
     *
     * @stability stable
     */
    readonly collectorIlb: ComputePacketMirroringCollectorIlb;
    /**
     * filter block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#filter ComputePacketMirroring#filter}
     *
     * @stability stable
     */
    readonly filter?: ComputePacketMirroringFilter;
    /**
     * mirrored_resources block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#mirrored_resources ComputePacketMirroring#mirrored_resources}
     *
     * @stability stable
     */
    readonly mirroredResources: ComputePacketMirroringMirroredResources;
    /**
     * network block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#network ComputePacketMirroring#network}
     *
     * @stability stable
     */
    readonly network: ComputePacketMirroringNetwork;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#timeouts ComputePacketMirroring#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputePacketMirroringTimeouts;
}
/**
 * @stability stable
 */
export interface ComputePacketMirroringCollectorIlb {
    /**
     * The URL of the forwarding rule.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#url ComputePacketMirroring#url}
     *
     * @stability stable
     */
    readonly url: string;
}
export declare function computePacketMirroringCollectorIlbToTerraform(struct?: ComputePacketMirroringCollectorIlbOutputReference | ComputePacketMirroringCollectorIlb): any;
/**
 * @stability stable
 */
export declare class ComputePacketMirroringCollectorIlbOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputePacketMirroringCollectorIlb | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputePacketMirroringCollectorIlb | undefined);
    private _url?;
    /**
     * @stability stable
     */
    get url(): string;
    /**
     * @stability stable
     */
    set url(value: string);
    /**
     * @stability stable
     */
    get urlInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ComputePacketMirroringFilter {
    /**
     * IP CIDR ranges that apply as a filter on the source (ingress) or destination (egress) IP in the IP header.
     *
     * Only IPv4 is supported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#cidr_ranges ComputePacketMirroring#cidr_ranges}
     *
     * @stability stable
     */
    readonly cidrRanges?: string[];
    /**
     * Direction of traffic to mirror. Default value: "BOTH" Possible values: ["INGRESS", "EGRESS", "BOTH"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#direction ComputePacketMirroring#direction}
     *
     * @stability stable
     */
    readonly direction?: string;
    /**
     * Protocols that apply as a filter on mirrored traffic. Possible values: ["tcp", "udp", "icmp"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#ip_protocols ComputePacketMirroring#ip_protocols}
     *
     * @stability stable
     */
    readonly ipProtocols?: string[];
}
export declare function computePacketMirroringFilterToTerraform(struct?: ComputePacketMirroringFilterOutputReference | ComputePacketMirroringFilter): any;
/**
 * @stability stable
 */
export declare class ComputePacketMirroringFilterOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputePacketMirroringFilter | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputePacketMirroringFilter | undefined);
    private _cidrRanges?;
    /**
     * @stability stable
     */
    get cidrRanges(): string[];
    /**
     * @stability stable
     */
    set cidrRanges(value: string[]);
    /**
     * @stability stable
     */
    resetCidrRanges(): void;
    /**
     * @stability stable
     */
    get cidrRangesInput(): string[] | undefined;
    private _direction?;
    /**
     * @stability stable
     */
    get direction(): string;
    /**
     * @stability stable
     */
    set direction(value: string);
    /**
     * @stability stable
     */
    resetDirection(): void;
    /**
     * @stability stable
     */
    get directionInput(): string | undefined;
    private _ipProtocols?;
    /**
     * @stability stable
     */
    get ipProtocols(): string[];
    /**
     * @stability stable
     */
    set ipProtocols(value: string[]);
    /**
     * @stability stable
     */
    resetIpProtocols(): void;
    /**
     * @stability stable
     */
    get ipProtocolsInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface ComputePacketMirroringMirroredResourcesInstances {
    /**
     * The URL of the instances where this rule should be active.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#url ComputePacketMirroring#url}
     *
     * @stability stable
     */
    readonly url: string;
}
export declare function computePacketMirroringMirroredResourcesInstancesToTerraform(struct?: ComputePacketMirroringMirroredResourcesInstances): any;
/**
 * @stability stable
 */
export interface ComputePacketMirroringMirroredResourcesSubnetworks {
    /**
     * The URL of the subnetwork where this rule should be active.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#url ComputePacketMirroring#url}
     *
     * @stability stable
     */
    readonly url: string;
}
export declare function computePacketMirroringMirroredResourcesSubnetworksToTerraform(struct?: ComputePacketMirroringMirroredResourcesSubnetworks): any;
/**
 * @stability stable
 */
export interface ComputePacketMirroringMirroredResources {
    /**
     * All instances with these tags will be mirrored.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#tags ComputePacketMirroring#tags}
     *
     * @stability stable
     */
    readonly tags?: string[];
    /**
     * instances block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#instances ComputePacketMirroring#instances}
     *
     * @stability stable
     */
    readonly instances?: ComputePacketMirroringMirroredResourcesInstances[];
    /**
     * subnetworks block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#subnetworks ComputePacketMirroring#subnetworks}
     *
     * @stability stable
     */
    readonly subnetworks?: ComputePacketMirroringMirroredResourcesSubnetworks[];
}
export declare function computePacketMirroringMirroredResourcesToTerraform(struct?: ComputePacketMirroringMirroredResourcesOutputReference | ComputePacketMirroringMirroredResources): any;
/**
 * @stability stable
 */
export declare class ComputePacketMirroringMirroredResourcesOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputePacketMirroringMirroredResources | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputePacketMirroringMirroredResources | undefined);
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): string[];
    /**
     * @stability stable
     */
    set tags(value: string[]);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): string[] | undefined;
    private _instances?;
    /**
     * @stability stable
     */
    get instances(): ComputePacketMirroringMirroredResourcesInstances[];
    /**
     * @stability stable
     */
    set instances(value: ComputePacketMirroringMirroredResourcesInstances[]);
    /**
     * @stability stable
     */
    resetInstances(): void;
    /**
     * @stability stable
     */
    get instancesInput(): ComputePacketMirroringMirroredResourcesInstances[] | undefined;
    private _subnetworks?;
    /**
     * @stability stable
     */
    get subnetworks(): ComputePacketMirroringMirroredResourcesSubnetworks[];
    /**
     * @stability stable
     */
    set subnetworks(value: ComputePacketMirroringMirroredResourcesSubnetworks[]);
    /**
     * @stability stable
     */
    resetSubnetworks(): void;
    /**
     * @stability stable
     */
    get subnetworksInput(): ComputePacketMirroringMirroredResourcesSubnetworks[] | undefined;
}
/**
 * @stability stable
 */
export interface ComputePacketMirroringNetwork {
    /**
     * The full self_link URL of the network where this rule is active.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#url ComputePacketMirroring#url}
     *
     * @stability stable
     */
    readonly url: string;
}
export declare function computePacketMirroringNetworkToTerraform(struct?: ComputePacketMirroringNetworkOutputReference | ComputePacketMirroringNetwork): any;
/**
 * @stability stable
 */
export declare class ComputePacketMirroringNetworkOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputePacketMirroringNetwork | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputePacketMirroringNetwork | undefined);
    private _url?;
    /**
     * @stability stable
     */
    get url(): string;
    /**
     * @stability stable
     */
    set url(value: string);
    /**
     * @stability stable
     */
    get urlInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ComputePacketMirroringTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#create ComputePacketMirroring#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#delete ComputePacketMirroring#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#update ComputePacketMirroring#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function computePacketMirroringTimeoutsToTerraform(struct?: ComputePacketMirroringTimeoutsOutputReference | ComputePacketMirroringTimeouts): any;
/**
 * @stability stable
 */
export declare class ComputePacketMirroringTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputePacketMirroringTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputePacketMirroringTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html google_compute_packet_mirroring}.
 *
 * @stability stable
 */
export declare class ComputePacketMirroring extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html google_compute_packet_mirroring} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputePacketMirroringConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _priority?;
    /**
     * @stability stable
     */
    get priority(): number;
    /**
     * @stability stable
     */
    set priority(value: number);
    /**
     * @stability stable
     */
    resetPriority(): void;
    /**
     * @stability stable
     */
    get priorityInput(): number | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    set region(value: string);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _collectorIlb;
    /**
     * @stability stable
     */
    get collectorIlb(): ComputePacketMirroringCollectorIlbOutputReference;
    /**
     * @stability stable
     */
    putCollectorIlb(value: ComputePacketMirroringCollectorIlb): void;
    /**
     * @stability stable
     */
    get collectorIlbInput(): ComputePacketMirroringCollectorIlb | undefined;
    private _filter;
    /**
     * @stability stable
     */
    get filter(): ComputePacketMirroringFilterOutputReference;
    /**
     * @stability stable
     */
    putFilter(value: ComputePacketMirroringFilter): void;
    /**
     * @stability stable
     */
    resetFilter(): void;
    /**
     * @stability stable
     */
    get filterInput(): ComputePacketMirroringFilter | undefined;
    private _mirroredResources;
    /**
     * @stability stable
     */
    get mirroredResources(): ComputePacketMirroringMirroredResourcesOutputReference;
    /**
     * @stability stable
     */
    putMirroredResources(value: ComputePacketMirroringMirroredResources): void;
    /**
     * @stability stable
     */
    get mirroredResourcesInput(): ComputePacketMirroringMirroredResources | undefined;
    private _network;
    /**
     * @stability stable
     */
    get network(): ComputePacketMirroringNetworkOutputReference;
    /**
     * @stability stable
     */
    putNetwork(value: ComputePacketMirroringNetwork): void;
    /**
     * @stability stable
     */
    get networkInput(): ComputePacketMirroringNetwork | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ComputePacketMirroringTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputePacketMirroringTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputePacketMirroringTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
