import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface EssentialContactsContactConfig extends cdktf.TerraformMetaArguments {
    /**
     * The email address to send notifications to. This does not need to be a Google account.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/essential_contacts_contact.html#email EssentialContactsContact#email}
     *
     * @stability stable
     */
    readonly email: string;
    /**
     * The preferred language for notifications, as a ISO 639-1 language code.
     *
     * See Supported languages for a list of supported languages.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/essential_contacts_contact.html#language_tag EssentialContactsContact#language_tag}
     *
     * @stability stable
     */
    readonly languageTag: string;
    /**
     * The categories of notifications that the contact will receive communications for.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/essential_contacts_contact.html#notification_category_subscriptions EssentialContactsContact#notification_category_subscriptions}
     *
     * @stability stable
     */
    readonly notificationCategorySubscriptions: string[];
    /**
     * The resource to save this contact for. Format: organizations/{organization_id}, folders/{folder_id} or projects/{project_id}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/essential_contacts_contact.html#parent EssentialContactsContact#parent}
     *
     * @stability stable
     */
    readonly parent: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/essential_contacts_contact.html#timeouts EssentialContactsContact#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: EssentialContactsContactTimeouts;
}
/**
 * @stability stable
 */
export interface EssentialContactsContactTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/essential_contacts_contact.html#create EssentialContactsContact#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/essential_contacts_contact.html#delete EssentialContactsContact#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/essential_contacts_contact.html#update EssentialContactsContact#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function essentialContactsContactTimeoutsToTerraform(struct?: EssentialContactsContactTimeoutsOutputReference | EssentialContactsContactTimeouts): any;
/**
 * @stability stable
 */
export declare class EssentialContactsContactTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): EssentialContactsContactTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: EssentialContactsContactTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/essential_contacts_contact.html google_essential_contacts_contact}.
 *
 * @stability stable
 */
export declare class EssentialContactsContact extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/essential_contacts_contact.html google_essential_contacts_contact} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: EssentialContactsContactConfig);
    private _email?;
    /**
     * @stability stable
     */
    get email(): string;
    /**
     * @stability stable
     */
    set email(value: string);
    /**
     * @stability stable
     */
    get emailInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _languageTag?;
    /**
     * @stability stable
     */
    get languageTag(): string;
    /**
     * @stability stable
     */
    set languageTag(value: string);
    /**
     * @stability stable
     */
    get languageTagInput(): string | undefined;
    /**
     * @stability stable
     */
    get name(): string;
    private _notificationCategorySubscriptions?;
    /**
     * @stability stable
     */
    get notificationCategorySubscriptions(): string[];
    /**
     * @stability stable
     */
    set notificationCategorySubscriptions(value: string[]);
    /**
     * @stability stable
     */
    get notificationCategorySubscriptionsInput(): string[] | undefined;
    private _parent?;
    /**
     * @stability stable
     */
    get parent(): string;
    /**
     * @stability stable
     */
    set parent(value: string);
    /**
     * @stability stable
     */
    get parentInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): EssentialContactsContactTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: EssentialContactsContactTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): EssentialContactsContactTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
