import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface FilestoreInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
     * A description of the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance.html#description FilestoreInstance#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Resource labels to represent user-provided metadata.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance.html#labels FilestoreInstance#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The resource name of the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance.html#name FilestoreInstance#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance.html#project FilestoreInstance#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The service tier of the instance. Possible values: ["TIER_UNSPECIFIED", "STANDARD", "PREMIUM", "BASIC_HDD", "BASIC_SSD", "HIGH_SCALE_SSD"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance.html#tier FilestoreInstance#tier}
     *
     * @stability stable
     */
    readonly tier: string;
    /**
     * The name of the Filestore zone of the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance.html#zone FilestoreInstance#zone}
     *
     * @stability stable
     */
    readonly zone: string;
    /**
     * file_shares block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance.html#file_shares FilestoreInstance#file_shares}
     *
     * @stability stable
     */
    readonly fileShares: FilestoreInstanceFileShares;
    /**
     * networks block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance.html#networks FilestoreInstance#networks}
     *
     * @stability stable
     */
    readonly networks: FilestoreInstanceNetworks[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance.html#timeouts FilestoreInstance#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: FilestoreInstanceTimeouts;
}
/**
 * @stability stable
 */
export interface FilestoreInstanceFileShares {
    /**
     * File share capacity in GiB.
     *
     * This must be at least 1024 GiB
     * for the standard tier, or 2560 GiB for the premium tier.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance.html#capacity_gb FilestoreInstance#capacity_gb}
     *
     * @stability stable
     */
    readonly capacityGb: number;
    /**
     * The name of the fileshare (16 characters or less).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance.html#name FilestoreInstance#name}
     *
     * @stability stable
     */
    readonly name: string;
}
export declare function filestoreInstanceFileSharesToTerraform(struct?: FilestoreInstanceFileSharesOutputReference | FilestoreInstanceFileShares): any;
/**
 * @stability stable
 */
export declare class FilestoreInstanceFileSharesOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): FilestoreInstanceFileShares | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: FilestoreInstanceFileShares | undefined);
    private _capacityGb?;
    /**
     * @stability stable
     */
    get capacityGb(): number;
    /**
     * @stability stable
     */
    set capacityGb(value: number);
    /**
     * @stability stable
     */
    get capacityGbInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface FilestoreInstanceNetworks {
    /**
     * IP versions for which the instance has IP addresses assigned. Possible values: ["ADDRESS_MODE_UNSPECIFIED", "MODE_IPV4", "MODE_IPV6"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance.html#modes FilestoreInstance#modes}
     *
     * @stability stable
     */
    readonly modes: string[];
    /**
     * The name of the GCE VPC network to which the instance is connected.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance.html#network FilestoreInstance#network}
     *
     * @stability stable
     */
    readonly network: string;
    /**
     * A /29 CIDR block that identifies the range of IP addresses reserved for this instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance.html#reserved_ip_range FilestoreInstance#reserved_ip_range}
     *
     * @stability stable
     */
    readonly reservedIpRange?: string;
}
export declare function filestoreInstanceNetworksToTerraform(struct?: FilestoreInstanceNetworks): any;
/**
 * @stability stable
 */
export interface FilestoreInstanceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance.html#create FilestoreInstance#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance.html#delete FilestoreInstance#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance.html#update FilestoreInstance#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function filestoreInstanceTimeoutsToTerraform(struct?: FilestoreInstanceTimeoutsOutputReference | FilestoreInstanceTimeouts): any;
/**
 * @stability stable
 */
export declare class FilestoreInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): FilestoreInstanceTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: FilestoreInstanceTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/filestore_instance.html google_filestore_instance}.
 *
 * @stability stable
 */
export declare class FilestoreInstance extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/filestore_instance.html google_filestore_instance} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: FilestoreInstanceConfig);
    /**
     * @stability stable
     */
    get createTime(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _tier?;
    /**
     * @stability stable
     */
    get tier(): string;
    /**
     * @stability stable
     */
    set tier(value: string);
    /**
     * @stability stable
     */
    get tierInput(): string | undefined;
    private _zone?;
    /**
     * @stability stable
     */
    get zone(): string;
    /**
     * @stability stable
     */
    set zone(value: string);
    /**
     * @stability stable
     */
    get zoneInput(): string | undefined;
    private _fileShares;
    /**
     * @stability stable
     */
    get fileShares(): FilestoreInstanceFileSharesOutputReference;
    /**
     * @stability stable
     */
    putFileShares(value: FilestoreInstanceFileShares): void;
    /**
     * @stability stable
     */
    get fileSharesInput(): FilestoreInstanceFileShares | undefined;
    private _networks?;
    /**
     * @stability stable
     */
    get networks(): FilestoreInstanceNetworks[];
    /**
     * @stability stable
     */
    set networks(value: FilestoreInstanceNetworks[]);
    /**
     * @stability stable
     */
    get networksInput(): FilestoreInstanceNetworks[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): FilestoreInstanceTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: FilestoreInstanceTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): FilestoreInstanceTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
