import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface IdentityPlatformTenantConfig extends cdktf.TerraformMetaArguments {
    /**
     * Whether to allow email/password user authentication.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant.html#allow_password_signup IdentityPlatformTenant#allow_password_signup}
     *
     * @stability stable
     */
    readonly allowPasswordSignup?: boolean | cdktf.IResolvable;
    /**
     * Whether authentication is disabled for the tenant.
     *
     * If true, the users under
     * the disabled tenant are not allowed to sign-in. Admins of the disabled tenant
     * are not able to manage its users.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant.html#disable_auth IdentityPlatformTenant#disable_auth}
     *
     * @stability stable
     */
    readonly disableAuth?: boolean | cdktf.IResolvable;
    /**
     * Human friendly display name of the tenant.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant.html#display_name IdentityPlatformTenant#display_name}
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * Whether to enable email link user authentication.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant.html#enable_email_link_signin IdentityPlatformTenant#enable_email_link_signin}
     *
     * @stability stable
     */
    readonly enableEmailLinkSignin?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant.html#project IdentityPlatformTenant#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant.html#timeouts IdentityPlatformTenant#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: IdentityPlatformTenantTimeouts;
}
/**
 * @stability stable
 */
export interface IdentityPlatformTenantTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant.html#create IdentityPlatformTenant#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant.html#delete IdentityPlatformTenant#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant.html#update IdentityPlatformTenant#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function identityPlatformTenantTimeoutsToTerraform(struct?: IdentityPlatformTenantTimeoutsOutputReference | IdentityPlatformTenantTimeouts): any;
/**
 * @stability stable
 */
export declare class IdentityPlatformTenantTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): IdentityPlatformTenantTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: IdentityPlatformTenantTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant.html google_identity_platform_tenant}.
 *
 * @stability stable
 */
export declare class IdentityPlatformTenant extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant.html google_identity_platform_tenant} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: IdentityPlatformTenantConfig);
    private _allowPasswordSignup?;
    /**
     * @stability stable
     */
    get allowPasswordSignup(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set allowPasswordSignup(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAllowPasswordSignup(): void;
    /**
     * @stability stable
     */
    get allowPasswordSignupInput(): boolean | cdktf.IResolvable | undefined;
    private _disableAuth?;
    /**
     * @stability stable
     */
    get disableAuth(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set disableAuth(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDisableAuth(): void;
    /**
     * @stability stable
     */
    get disableAuthInput(): boolean | cdktf.IResolvable | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    private _enableEmailLinkSignin?;
    /**
     * @stability stable
     */
    get enableEmailLinkSignin(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableEmailLinkSignin(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableEmailLinkSignin(): void;
    /**
     * @stability stable
     */
    get enableEmailLinkSigninInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): IdentityPlatformTenantTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: IdentityPlatformTenantTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): IdentityPlatformTenantTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
