import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface LoggingOrganizationSinkConfig extends cdktf.TerraformMetaArguments {
    /**
     * A description of this sink. The maximum length of the description is 8000 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_organization_sink.html#description LoggingOrganizationSink#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The destination of the sink (or, in other words, where logs are written to).
     *
     * Can be a Cloud Storage bucket, a PubSub topic, or a BigQuery dataset. Examples: "storage.googleapis.com/[GCS_BUCKET]" "bigquery.googleapis.com/projects/[PROJECT_ID]/datasets/[DATASET]" "pubsub.googleapis.com/projects/[PROJECT_ID]/topics/[TOPIC_ID]" The writer associated with the sink must have access to write to the above resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_organization_sink.html#destination LoggingOrganizationSink#destination}
     *
     * @stability stable
     */
    readonly destination: string;
    /**
     * If set to True, then this sink is disabled and it does not export any log entries.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_organization_sink.html#disabled LoggingOrganizationSink#disabled}
     *
     * @stability stable
     */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
     * The filter to apply when exporting logs. Only log entries that match the filter are exported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_organization_sink.html#filter LoggingOrganizationSink#filter}
     *
     * @stability stable
     */
    readonly filter?: string;
    /**
     * Whether or not to include children organizations in the sink export.
     *
     * If true, logs associated with child projects are also exported; otherwise only logs relating to the provided organization are included.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_organization_sink.html#include_children LoggingOrganizationSink#include_children}
     *
     * @stability stable
     */
    readonly includeChildren?: boolean | cdktf.IResolvable;
    /**
     * The name of the logging sink.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_organization_sink.html#name LoggingOrganizationSink#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The numeric ID of the organization to be exported to the sink.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_organization_sink.html#org_id LoggingOrganizationSink#org_id}
     *
     * @stability stable
     */
    readonly orgId: string;
    /**
     * bigquery_options block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_organization_sink.html#bigquery_options LoggingOrganizationSink#bigquery_options}
     *
     * @stability stable
     */
    readonly bigqueryOptions?: LoggingOrganizationSinkBigqueryOptions;
    /**
     * exclusions block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_organization_sink.html#exclusions LoggingOrganizationSink#exclusions}
     *
     * @stability stable
     */
    readonly exclusions?: LoggingOrganizationSinkExclusions[];
}
/**
 * @stability stable
 */
export interface LoggingOrganizationSinkBigqueryOptions {
    /**
     * Whether to use BigQuery's partition tables.
     *
     * By default, Logging creates dated tables based on the log entries' timestamps, e.g. syslog_20170523. With partitioned tables the date suffix is no longer present and special query syntax has to be used instead. In both cases, tables are sharded based on UTC timezone.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_organization_sink.html#use_partitioned_tables LoggingOrganizationSink#use_partitioned_tables}
     *
     * @stability stable
     */
    readonly usePartitionedTables: boolean | cdktf.IResolvable;
}
export declare function loggingOrganizationSinkBigqueryOptionsToTerraform(struct?: LoggingOrganizationSinkBigqueryOptionsOutputReference | LoggingOrganizationSinkBigqueryOptions): any;
/**
 * @stability stable
 */
export declare class LoggingOrganizationSinkBigqueryOptionsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LoggingOrganizationSinkBigqueryOptions | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LoggingOrganizationSinkBigqueryOptions | undefined);
    private _usePartitionedTables?;
    /**
     * @stability stable
     */
    get usePartitionedTables(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set usePartitionedTables(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get usePartitionedTablesInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface LoggingOrganizationSinkExclusions {
    /**
     * A description of this exclusion.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_organization_sink.html#description LoggingOrganizationSink#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * If set to True, then this exclusion is disabled and it does not exclude any log entries.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_organization_sink.html#disabled LoggingOrganizationSink#disabled}
     *
     * @stability stable
     */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
     * An advanced logs filter that matches the log entries to be excluded.
     *
     * By using the sample function, you can exclude less than 100% of the matching log entries
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_organization_sink.html#filter LoggingOrganizationSink#filter}
     *
     * @stability stable
     */
    readonly filter: string;
    /**
     * A client-assigned identifier, such as "load-balancer-exclusion".
     *
     * Identifiers are limited to 100 characters and can include only letters, digits, underscores, hyphens, and periods. First character has to be alphanumeric.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_organization_sink.html#name LoggingOrganizationSink#name}
     *
     * @stability stable
     */
    readonly name: string;
}
export declare function loggingOrganizationSinkExclusionsToTerraform(struct?: LoggingOrganizationSinkExclusions): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/logging_organization_sink.html google_logging_organization_sink}.
 *
 * @stability stable
 */
export declare class LoggingOrganizationSink extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/logging_organization_sink.html google_logging_organization_sink} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: LoggingOrganizationSinkConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _destination?;
    /**
     * @stability stable
     */
    get destination(): string;
    /**
     * @stability stable
     */
    set destination(value: string);
    /**
     * @stability stable
     */
    get destinationInput(): string | undefined;
    private _disabled?;
    /**
     * @stability stable
     */
    get disabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set disabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDisabled(): void;
    /**
     * @stability stable
     */
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _filter?;
    /**
     * @stability stable
     */
    get filter(): string;
    /**
     * @stability stable
     */
    set filter(value: string);
    /**
     * @stability stable
     */
    resetFilter(): void;
    /**
     * @stability stable
     */
    get filterInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _includeChildren?;
    /**
     * @stability stable
     */
    get includeChildren(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set includeChildren(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIncludeChildren(): void;
    /**
     * @stability stable
     */
    get includeChildrenInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _orgId?;
    /**
     * @stability stable
     */
    get orgId(): string;
    /**
     * @stability stable
     */
    set orgId(value: string);
    /**
     * @stability stable
     */
    get orgIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get writerIdentity(): string;
    private _bigqueryOptions;
    /**
     * @stability stable
     */
    get bigqueryOptions(): LoggingOrganizationSinkBigqueryOptionsOutputReference;
    /**
     * @stability stable
     */
    putBigqueryOptions(value: LoggingOrganizationSinkBigqueryOptions): void;
    /**
     * @stability stable
     */
    resetBigqueryOptions(): void;
    /**
     * @stability stable
     */
    get bigqueryOptionsInput(): LoggingOrganizationSinkBigqueryOptions | undefined;
    private _exclusions?;
    /**
     * @stability stable
     */
    get exclusions(): LoggingOrganizationSinkExclusions[];
    /**
     * @stability stable
     */
    set exclusions(value: LoggingOrganizationSinkExclusions[]);
    /**
     * @stability stable
     */
    resetExclusions(): void;
    /**
     * @stability stable
     */
    get exclusionsInput(): LoggingOrganizationSinkExclusions[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
