import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface NetworkServicesEdgeCacheServiceConfig extends cdktf.TerraformMetaArguments {
    /**
     * A human-readable description of the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#description NetworkServicesEdgeCacheService#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * HTTP/3 (IETF QUIC) and Google QUIC are enabled by default.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#disable_quic NetworkServicesEdgeCacheService#disable_quic}
     *
     * @stability stable
     */
    readonly disableQuic?: boolean | cdktf.IResolvable;
    /**
     * Resource URL that points at the Cloud Armor edge security policy that is applied on each request against the EdgeCacheService.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#edge_security_policy NetworkServicesEdgeCacheService#edge_security_policy}
     *
     * @stability stable
     */
    readonly edgeSecurityPolicy?: string;
    /**
     * URLs to sslCertificate resources that are used to authenticate connections between users and the EdgeCacheService.
     *
     * Note that only "global" certificates with a "scope" of "EDGE_CACHE" can be attached to an EdgeCacheService.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#edge_ssl_certificates NetworkServicesEdgeCacheService#edge_ssl_certificates}
     *
     * @stability stable
     */
    readonly edgeSslCertificates?: string[];
    /**
     * Set of label tags associated with the EdgeCache resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#labels NetworkServicesEdgeCacheService#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Name of the resource;
     *
     * provided by the client when the resource is created.
     * The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]* which means the first character must be a letter,
     * and all following characters must be a dash, underscore, letter or digit.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#name NetworkServicesEdgeCacheService#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#project NetworkServicesEdgeCacheService#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Require TLS (HTTPS) for all clients connecting to this service.
     *
     * Clients who connect over HTTP (port 80) will receive a HTTP 301 to the same URL over HTTPS (port 443).
     * You must have at least one (1) edgeSslCertificate specified to enable this.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#require_tls NetworkServicesEdgeCacheService#require_tls}
     *
     * @stability stable
     */
    readonly requireTls?: boolean | cdktf.IResolvable;
    /**
     * URL of the SslPolicy resource that will be associated with the EdgeCacheService.
     *
     * If not set, the EdgeCacheService has no SSL policy configured, and will default to the "COMPATIBLE" policy.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#ssl_policy NetworkServicesEdgeCacheService#ssl_policy}
     *
     * @stability stable
     */
    readonly sslPolicy?: string;
    /**
     * log_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#log_config NetworkServicesEdgeCacheService#log_config}
     *
     * @stability stable
     */
    readonly logConfig?: NetworkServicesEdgeCacheServiceLogConfig;
    /**
     * routing block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#routing NetworkServicesEdgeCacheService#routing}
     *
     * @stability stable
     */
    readonly routing: NetworkServicesEdgeCacheServiceRouting;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#timeouts NetworkServicesEdgeCacheService#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: NetworkServicesEdgeCacheServiceTimeouts;
}
/**
 * @stability stable
 */
export interface NetworkServicesEdgeCacheServiceLogConfig {
    /**
     * Specifies whether to enable logging for traffic served by this service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#enable NetworkServicesEdgeCacheService#enable}
     *
     * @stability stable
     */
    readonly enable?: boolean | cdktf.IResolvable;
    /**
     * Configures the sampling rate of requests, where 1.0 means all logged requests are reported and 0.0 means no logged requests are reported. The default value is 1.0, and the value of the field must be in [0, 1].
     *
     * This field can only be specified if logging is enabled for this service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#sample_rate NetworkServicesEdgeCacheService#sample_rate}
     *
     * @stability stable
     */
    readonly sampleRate?: number;
}
export declare function networkServicesEdgeCacheServiceLogConfigToTerraform(struct?: NetworkServicesEdgeCacheServiceLogConfigOutputReference | NetworkServicesEdgeCacheServiceLogConfig): any;
/**
 * @stability stable
 */
export declare class NetworkServicesEdgeCacheServiceLogConfigOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NetworkServicesEdgeCacheServiceLogConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NetworkServicesEdgeCacheServiceLogConfig | undefined);
    private _enable?;
    /**
     * @stability stable
     */
    get enable(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enable(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnable(): void;
    /**
     * @stability stable
     */
    get enableInput(): boolean | cdktf.IResolvable | undefined;
    private _sampleRate?;
    /**
     * @stability stable
     */
    get sampleRate(): number;
    /**
     * @stability stable
     */
    set sampleRate(value: number);
    /**
     * @stability stable
     */
    resetSampleRate(): void;
    /**
     * @stability stable
     */
    get sampleRateInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface NetworkServicesEdgeCacheServiceRoutingHostRule {
    /**
     * A human-readable description of the hostRule.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#description NetworkServicesEdgeCacheService#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The list of host patterns to match.
     *
     * Host patterns must be valid hostnames with optional port numbers in the format host:port. * matches any string of ([a-z0-9-.]*).
     * The only accepted ports are :80 and :443.
     *
     * Hosts are matched against the HTTP Host header, or for HTTP/2 and HTTP/3, the ":authority" header, from the incoming request.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#hosts NetworkServicesEdgeCacheService#hosts}
     *
     * @stability stable
     */
    readonly hosts: string[];
    /**
     * The name of the pathMatcher associated with this hostRule.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#path_matcher NetworkServicesEdgeCacheService#path_matcher}
     *
     * @stability stable
     */
    readonly pathMatcher: string;
}
export declare function networkServicesEdgeCacheServiceRoutingHostRuleToTerraform(struct?: NetworkServicesEdgeCacheServiceRoutingHostRule): any;
/**
 * @stability stable
 */
export interface NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToAdd {
    /**
     * The name of the header to add.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#header_name NetworkServicesEdgeCacheService#header_name}
     *
     * @stability stable
     */
    readonly headerName: string;
    /**
     * The value of the header to add.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#header_value NetworkServicesEdgeCacheService#header_value}
     *
     * @stability stable
     */
    readonly headerValue: string;
    /**
     * Whether to replace all existing headers with the same name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#replace NetworkServicesEdgeCacheService#replace}
     *
     * @stability stable
     */
    readonly replace?: boolean | cdktf.IResolvable;
}
export declare function networkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToAddToTerraform(struct?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToAdd): any;
/**
 * @stability stable
 */
export interface NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToRemove {
    /**
     * The name of the header to remove.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#header_name NetworkServicesEdgeCacheService#header_name}
     *
     * @stability stable
     */
    readonly headerName: string;
}
export declare function networkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToRemoveToTerraform(struct?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToRemove): any;
/**
 * @stability stable
 */
export interface NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToAdd {
    /**
     * The name of the header to add.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#header_name NetworkServicesEdgeCacheService#header_name}
     *
     * @stability stable
     */
    readonly headerName: string;
    /**
     * The value of the header to add.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#header_value NetworkServicesEdgeCacheService#header_value}
     *
     * @stability stable
     */
    readonly headerValue: string;
    /**
     * Whether to replace all existing headers with the same name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#replace NetworkServicesEdgeCacheService#replace}
     *
     * @stability stable
     */
    readonly replace?: boolean | cdktf.IResolvable;
}
export declare function networkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToAddToTerraform(struct?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToAdd): any;
/**
 * @stability stable
 */
export interface NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToRemove {
    /**
     * Headers to remove from the response prior to sending it back to the client.
     *
     * Response headers are only sent to the client, and do not have an effect on the cache serving the response.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#header_name NetworkServicesEdgeCacheService#header_name}
     *
     * @stability stable
     */
    readonly headerName: string;
}
export declare function networkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToRemoveToTerraform(struct?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToRemove): any;
/**
 * @stability stable
 */
export interface NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderAction {
    /**
     * request_header_to_add block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#request_header_to_add NetworkServicesEdgeCacheService#request_header_to_add}
     *
     * @stability stable
     */
    readonly requestHeaderToAdd?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToAdd[];
    /**
     * request_header_to_remove block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#request_header_to_remove NetworkServicesEdgeCacheService#request_header_to_remove}
     *
     * @stability stable
     */
    readonly requestHeaderToRemove?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToRemove[];
    /**
     * response_header_to_add block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#response_header_to_add NetworkServicesEdgeCacheService#response_header_to_add}
     *
     * @stability stable
     */
    readonly responseHeaderToAdd?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToAdd[];
    /**
     * response_header_to_remove block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#response_header_to_remove NetworkServicesEdgeCacheService#response_header_to_remove}
     *
     * @stability stable
     */
    readonly responseHeaderToRemove?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToRemove[];
}
export declare function networkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionToTerraform(struct?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionOutputReference | NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderAction): any;
/**
 * @stability stable
 */
export declare class NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderAction | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderAction | undefined);
    private _requestHeaderToAdd?;
    /**
     * @stability stable
     */
    get requestHeaderToAdd(): NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToAdd[];
    /**
     * @stability stable
     */
    set requestHeaderToAdd(value: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToAdd[]);
    /**
     * @stability stable
     */
    resetRequestHeaderToAdd(): void;
    /**
     * @stability stable
     */
    get requestHeaderToAddInput(): NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToAdd[] | undefined;
    private _requestHeaderToRemove?;
    /**
     * @stability stable
     */
    get requestHeaderToRemove(): NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToRemove[];
    /**
     * @stability stable
     */
    set requestHeaderToRemove(value: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToRemove[]);
    /**
     * @stability stable
     */
    resetRequestHeaderToRemove(): void;
    /**
     * @stability stable
     */
    get requestHeaderToRemoveInput(): NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToRemove[] | undefined;
    private _responseHeaderToAdd?;
    /**
     * @stability stable
     */
    get responseHeaderToAdd(): NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToAdd[];
    /**
     * @stability stable
     */
    set responseHeaderToAdd(value: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToAdd[]);
    /**
     * @stability stable
     */
    resetResponseHeaderToAdd(): void;
    /**
     * @stability stable
     */
    get responseHeaderToAddInput(): NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToAdd[] | undefined;
    private _responseHeaderToRemove?;
    /**
     * @stability stable
     */
    get responseHeaderToRemove(): NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToRemove[];
    /**
     * @stability stable
     */
    set responseHeaderToRemove(value: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToRemove[]);
    /**
     * @stability stable
     */
    resetResponseHeaderToRemove(): void;
    /**
     * @stability stable
     */
    get responseHeaderToRemoveInput(): NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToRemove[] | undefined;
}
/**
 * @stability stable
 */
export interface NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleHeaderMatch {
    /**
     * The value of the header should exactly match contents of exactMatch.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#exact_match NetworkServicesEdgeCacheService#exact_match}
     *
     * @stability stable
     */
    readonly exactMatch?: string;
    /**
     * The header name to match on.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#header_name NetworkServicesEdgeCacheService#header_name}
     *
     * @stability stable
     */
    readonly headerName: string;
    /**
     * If set to false (default), the headerMatch is considered a match if the match criteria above are met.
     *
     * If set to true, the headerMatch is considered a match if the match criteria above are NOT met.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#invert_match NetworkServicesEdgeCacheService#invert_match}
     *
     * @stability stable
     */
    readonly invertMatch?: boolean | cdktf.IResolvable;
    /**
     * The value of the header must start with the contents of prefixMatch.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#prefix_match NetworkServicesEdgeCacheService#prefix_match}
     *
     * @stability stable
     */
    readonly prefixMatch?: string;
    /**
     * A header with the contents of headerName must exist.
     *
     * The match takes place whether or not the request's header has a value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#present_match NetworkServicesEdgeCacheService#present_match}
     *
     * @stability stable
     */
    readonly presentMatch?: boolean | cdktf.IResolvable;
    /**
     * The value of the header must end with the contents of suffixMatch.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#suffix_match NetworkServicesEdgeCacheService#suffix_match}
     *
     * @stability stable
     */
    readonly suffixMatch?: string;
}
export declare function networkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleHeaderMatchToTerraform(struct?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleHeaderMatch): any;
/**
 * @stability stable
 */
export interface NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleQueryParameterMatch {
    /**
     * The queryParameterMatch matches if the value of the parameter exactly matches the contents of exactMatch.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#exact_match NetworkServicesEdgeCacheService#exact_match}
     *
     * @stability stable
     */
    readonly exactMatch?: string;
    /**
     * The name of the query parameter to match.
     *
     * The query parameter must exist in the request, in the absence of which the request match fails.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#name NetworkServicesEdgeCacheService#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Specifies that the queryParameterMatch matches if the request contains the query parameter, irrespective of whether the parameter has a value or not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#present_match NetworkServicesEdgeCacheService#present_match}
     *
     * @stability stable
     */
    readonly presentMatch?: boolean | cdktf.IResolvable;
}
export declare function networkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleQueryParameterMatchToTerraform(struct?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleQueryParameterMatch): any;
/**
 * @stability stable
 */
export interface NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleMatchRule {
    /**
     * For satisfying the matchRule condition, the path of the request must exactly match the value specified in fullPathMatch after removing any query parameters and anchor that may be part of the original URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#full_path_match NetworkServicesEdgeCacheService#full_path_match}
     *
     * @stability stable
     */
    readonly fullPathMatch?: string;
    /**
     * Specifies that prefixMatch and fullPathMatch matches are case sensitive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#ignore_case NetworkServicesEdgeCacheService#ignore_case}
     *
     * @stability stable
     */
    readonly ignoreCase?: boolean | cdktf.IResolvable;
    /**
     * For satisfying the matchRule condition, the path of the request must match the wildcard pattern specified in pathTemplateMatch after removing any query parameters and anchor that may be part of the original URL.
     *
     * pathTemplateMatch must be between 1 and 255 characters
     * (inclusive).  The pattern specified by pathTemplateMatch may
     * have at most 5 wildcard operators and at most 5 variable
     * captures in total.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#path_template_match NetworkServicesEdgeCacheService#path_template_match}
     *
     * @stability stable
     */
    readonly pathTemplateMatch?: string;
    /**
     * For satisfying the matchRule condition, the request's path must begin with the specified prefixMatch.
     *
     * prefixMatch must begin with a /.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#prefix_match NetworkServicesEdgeCacheService#prefix_match}
     *
     * @stability stable
     */
    readonly prefixMatch?: string;
    /**
     * header_match block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#header_match NetworkServicesEdgeCacheService#header_match}
     *
     * @stability stable
     */
    readonly headerMatch?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleHeaderMatch[];
    /**
     * query_parameter_match block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#query_parameter_match NetworkServicesEdgeCacheService#query_parameter_match}
     *
     * @stability stable
     */
    readonly queryParameterMatch?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleQueryParameterMatch[];
}
export declare function networkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleToTerraform(struct?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleMatchRule): any;
/**
 * @stability stable
 */
export interface NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyCacheKeyPolicy {
    /**
     * If true, requests to different hosts will be cached separately.
     *
     * Note: this should only be enabled if hosts share the same origin and content Removing the host from the cache key may inadvertently result in different objects being cached than intended, depending on which route the first user matched.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#exclude_host NetworkServicesEdgeCacheService#exclude_host}
     *
     * @stability stable
     */
    readonly excludeHost?: boolean | cdktf.IResolvable;
    /**
     * If true, exclude query string parameters from the cache key.
     *
     * If false (the default), include the query string parameters in
     * the cache key according to includeQueryParameters and
     * excludeQueryParameters. If neither includeQueryParameters nor
     * excludeQueryParameters is set, the entire query string will be
     * included.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#exclude_query_string NetworkServicesEdgeCacheService#exclude_query_string}
     *
     * @stability stable
     */
    readonly excludeQueryString?: boolean | cdktf.IResolvable;
    /**
     * Names of query string parameters to exclude from cache keys. All other parameters will be included.
     *
     * Either specify includedQueryParameters or excludedQueryParameters, not both. '&' and '=' will be percent encoded and not treated as delimiters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#excluded_query_parameters NetworkServicesEdgeCacheService#excluded_query_parameters}
     *
     * @stability stable
     */
    readonly excludedQueryParameters?: string[];
    /**
     * If true, http and https requests will be cached separately.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#include_protocol NetworkServicesEdgeCacheService#include_protocol}
     *
     * @stability stable
     */
    readonly includeProtocol?: boolean | cdktf.IResolvable;
    /**
     * Names of HTTP request headers to include in cache keys.
     *
     * The value of the header field will be used as part of the cache key.
     *
     * - Header names must be valid HTTP RFC 7230 header field values.
     * - Header field names are case insensitive
     * - To include the HTTP method, use ":method"
     *
     * Note that specifying several headers, and/or headers that have a large range of values (e.g. per-user) will dramatically impact the cache hit rate, and may result in a higher eviction rate and reduced performance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#included_header_names NetworkServicesEdgeCacheService#included_header_names}
     *
     * @stability stable
     */
    readonly includedHeaderNames?: string[];
    /**
     * Names of query string parameters to include in cache keys. All other parameters will be excluded.
     *
     * Either specify includedQueryParameters or excludedQueryParameters, not both. '&' and '=' will be percent encoded and not treated as delimiters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#included_query_parameters NetworkServicesEdgeCacheService#included_query_parameters}
     *
     * @stability stable
     */
    readonly includedQueryParameters?: string[];
}
export declare function networkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyCacheKeyPolicyToTerraform(struct?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyCacheKeyPolicyOutputReference | NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyCacheKeyPolicy): any;
/**
 * @stability stable
 */
export declare class NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyCacheKeyPolicyOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyCacheKeyPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyCacheKeyPolicy | undefined);
    private _excludeHost?;
    /**
     * @stability stable
     */
    get excludeHost(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set excludeHost(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetExcludeHost(): void;
    /**
     * @stability stable
     */
    get excludeHostInput(): boolean | cdktf.IResolvable | undefined;
    private _excludeQueryString?;
    /**
     * @stability stable
     */
    get excludeQueryString(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set excludeQueryString(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetExcludeQueryString(): void;
    /**
     * @stability stable
     */
    get excludeQueryStringInput(): boolean | cdktf.IResolvable | undefined;
    private _excludedQueryParameters?;
    /**
     * @stability stable
     */
    get excludedQueryParameters(): string[];
    /**
     * @stability stable
     */
    set excludedQueryParameters(value: string[]);
    /**
     * @stability stable
     */
    resetExcludedQueryParameters(): void;
    /**
     * @stability stable
     */
    get excludedQueryParametersInput(): string[] | undefined;
    private _includeProtocol?;
    /**
     * @stability stable
     */
    get includeProtocol(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set includeProtocol(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIncludeProtocol(): void;
    /**
     * @stability stable
     */
    get includeProtocolInput(): boolean | cdktf.IResolvable | undefined;
    private _includedHeaderNames?;
    /**
     * @stability stable
     */
    get includedHeaderNames(): string[];
    /**
     * @stability stable
     */
    set includedHeaderNames(value: string[]);
    /**
     * @stability stable
     */
    resetIncludedHeaderNames(): void;
    /**
     * @stability stable
     */
    get includedHeaderNamesInput(): string[] | undefined;
    private _includedQueryParameters?;
    /**
     * @stability stable
     */
    get includedQueryParameters(): string[];
    /**
     * @stability stable
     */
    set includedQueryParameters(value: string[]);
    /**
     * @stability stable
     */
    resetIncludedQueryParameters(): void;
    /**
     * @stability stable
     */
    get includedQueryParametersInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicy {
    /**
     * Cache modes allow users to control the behaviour of the cache, what content it should cache automatically, whether to respect origin headers, or whether to unconditionally cache all responses.
     *
     * For all cache modes, Cache-Control headers will be passed to the client. Use clientTtl to override what is sent to the client. Possible values: ["CACHE_ALL_STATIC", "USE_ORIGIN_HEADERS", "FORCE_CACHE_ALL", "BYPASS_CACHE"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#cache_mode NetworkServicesEdgeCacheService#cache_mode}
     *
     * @stability stable
     */
    readonly cacheMode?: string;
    /**
     * Specifies a separate client (e.g. browser client) TTL, separate from the TTL used by the edge caches. Leaving this empty will use the same cache TTL for both the CDN and the client-facing response.
     *
     * - The TTL must be > 0 and <= 86400s (1 day)
     * - The clientTtl cannot be larger than the defaultTtl (if set)
     * - Fractions of a second are not allowed.
     * - Omit this field to use the defaultTtl, or the max-age set by the origin, as the client-facing TTL.
     *
     * When the cache mode is set to "USE_ORIGIN_HEADERS" or "BYPASS_CACHE", you must omit this field.
     * A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#client_ttl NetworkServicesEdgeCacheService#client_ttl}
     *
     * @stability stable
     */
    readonly clientTtl?: string;
    /**
     * Specifies the default TTL for cached content served by this origin for responses that do not have an existing valid TTL (max-age or s-max-age).
     *
     * Defaults to 3600s (1 hour).
     *
     * - The TTL must be >= 0 and <= 2592000s (1 month)
     * - Setting a TTL of "0" means "always revalidate" (equivalent to must-revalidate)
     * - The value of defaultTTL cannot be set to a value greater than that of maxTTL.
     * - Fractions of a second are not allowed.
     * - When the cacheMode is set to FORCE_CACHE_ALL, the defaultTTL will overwrite the TTL set in all responses.
     *
     * Note that infrequently accessed objects may be evicted from the cache before the defined TTL. Objects that expire will be revalidated with the origin.
     *
     * When the cache mode is set to "USE_ORIGIN_HEADERS" or "BYPASS_CACHE", you must omit this field.
     *
     * A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#default_ttl NetworkServicesEdgeCacheService#default_ttl}
     *
     * @stability stable
     */
    readonly defaultTtl?: string;
    /**
     * Specifies the maximum allowed TTL for cached content served by this origin.
     *
     * Defaults to 86400s (1 day).
     *
     * Cache directives that attempt to set a max-age or s-maxage higher than this, or an Expires header more than maxTtl seconds in the future will be capped at the value of maxTTL, as if it were the value of an s-maxage Cache-Control directive.
     *
     * - The TTL must be >= 0 and <= 2592000s (1 month)
     * - Setting a TTL of "0" means "always revalidate"
     * - The value of maxTtl must be equal to or greater than defaultTtl.
     * - Fractions of a second are not allowed.
     * - When the cache mode is set to "USE_ORIGIN_HEADERS", "FORCE_CACHE_ALL", or "BYPASS_CACHE", you must omit this field.
     *
     * A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#max_ttl NetworkServicesEdgeCacheService#max_ttl}
     *
     * @stability stable
     */
    readonly maxTtl?: string;
    /**
     * Negative caching allows per-status code TTLs to be set, in order to apply fine-grained caching for common errors or redirects.
     *
     * This can reduce the load on your origin and improve end-user experience by reducing response latency.
     *
     * By default, the CDNPolicy will apply the following default TTLs to these status codes:
     *
     * - HTTP 300 (Multiple Choice), 301, 308 (Permanent Redirects): 10m
     * - HTTP 404 (Not Found), 410 (Gone), 451 (Unavailable For Legal Reasons): 120s
     * - HTTP 405 (Method Not Found), 414 (URI Too Long), 501 (Not Implemented): 60s
     *
     * These defaults can be overridden in negativeCachingPolicy
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#negative_caching NetworkServicesEdgeCacheService#negative_caching}
     *
     * @stability stable
     */
    readonly negativeCaching?: boolean | cdktf.IResolvable;
    /**
     * Sets a cache TTL for the specified HTTP status code. negativeCaching must be enabled to configure negativeCachingPolicy.
     *
     * - Omitting the policy and leaving negativeCaching enabled will use the default TTLs for each status code, defined in negativeCaching.
     * - TTLs must be >= 0 (where 0 is "always revalidate") and <= 86400s (1 day)
     *
     * Note that when specifying an explicit negativeCachingPolicy, you should take care to specify a cache TTL for all response codes that you wish to cache. The CDNPolicy will not apply any default negative caching when a policy exists.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#negative_caching_policy NetworkServicesEdgeCacheService#negative_caching_policy}
     *
     * @stability stable
     */
    readonly negativeCachingPolicy?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The EdgeCacheKeyset containing the set of public keys used to validate signed requests at the edge.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#signed_request_keyset NetworkServicesEdgeCacheService#signed_request_keyset}
     *
     * @stability stable
     */
    readonly signedRequestKeyset?: string;
    /**
     * Whether to enforce signed requests.
     *
     * The default value is DISABLED, which means all content is public, and does not authorize access.
     *
     * You must also set a signedRequestKeyset to enable signed requests.
     *
     * When set to REQUIRE_SIGNATURES, all matching requests will have their signature validated. Requests that were not signed with the corresponding private key, or that are otherwise invalid (expired, do not match the signature, IP address, or header) will be rejected with a HTTP 403 and (if enabled) logged. Possible values: ["DISABLED", "REQUIRE_SIGNATURES"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#signed_request_mode NetworkServicesEdgeCacheService#signed_request_mode}
     *
     * @stability stable
     */
    readonly signedRequestMode?: string;
    /**
     * cache_key_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#cache_key_policy NetworkServicesEdgeCacheService#cache_key_policy}
     *
     * @stability stable
     */
    readonly cacheKeyPolicy?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyCacheKeyPolicy;
}
export declare function networkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyToTerraform(struct?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyOutputReference | NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicy): any;
/**
 * @stability stable
 */
export declare class NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicy | undefined);
    private _cacheMode?;
    /**
     * @stability stable
     */
    get cacheMode(): string;
    /**
     * @stability stable
     */
    set cacheMode(value: string);
    /**
     * @stability stable
     */
    resetCacheMode(): void;
    /**
     * @stability stable
     */
    get cacheModeInput(): string | undefined;
    private _clientTtl?;
    /**
     * @stability stable
     */
    get clientTtl(): string;
    /**
     * @stability stable
     */
    set clientTtl(value: string);
    /**
     * @stability stable
     */
    resetClientTtl(): void;
    /**
     * @stability stable
     */
    get clientTtlInput(): string | undefined;
    private _defaultTtl?;
    /**
     * @stability stable
     */
    get defaultTtl(): string;
    /**
     * @stability stable
     */
    set defaultTtl(value: string);
    /**
     * @stability stable
     */
    resetDefaultTtl(): void;
    /**
     * @stability stable
     */
    get defaultTtlInput(): string | undefined;
    private _maxTtl?;
    /**
     * @stability stable
     */
    get maxTtl(): string;
    /**
     * @stability stable
     */
    set maxTtl(value: string);
    /**
     * @stability stable
     */
    resetMaxTtl(): void;
    /**
     * @stability stable
     */
    get maxTtlInput(): string | undefined;
    private _negativeCaching?;
    /**
     * @stability stable
     */
    get negativeCaching(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set negativeCaching(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetNegativeCaching(): void;
    /**
     * @stability stable
     */
    get negativeCachingInput(): boolean | cdktf.IResolvable | undefined;
    private _negativeCachingPolicy?;
    /**
     * @stability stable
     */
    get negativeCachingPolicy(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set negativeCachingPolicy(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetNegativeCachingPolicy(): void;
    /**
     * @stability stable
     */
    get negativeCachingPolicyInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _signedRequestKeyset?;
    /**
     * @stability stable
     */
    get signedRequestKeyset(): string;
    /**
     * @stability stable
     */
    set signedRequestKeyset(value: string);
    /**
     * @stability stable
     */
    resetSignedRequestKeyset(): void;
    /**
     * @stability stable
     */
    get signedRequestKeysetInput(): string | undefined;
    private _signedRequestMode?;
    /**
     * @stability stable
     */
    get signedRequestMode(): string;
    /**
     * @stability stable
     */
    set signedRequestMode(value: string);
    /**
     * @stability stable
     */
    resetSignedRequestMode(): void;
    /**
     * @stability stable
     */
    get signedRequestModeInput(): string | undefined;
    private _cacheKeyPolicy;
    /**
     * @stability stable
     */
    get cacheKeyPolicy(): NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyCacheKeyPolicyOutputReference;
    /**
     * @stability stable
     */
    putCacheKeyPolicy(value: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyCacheKeyPolicy): void;
    /**
     * @stability stable
     */
    resetCacheKeyPolicy(): void;
    /**
     * @stability stable
     */
    get cacheKeyPolicyInput(): NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyCacheKeyPolicy | undefined;
}
/**
 * @stability stable
 */
export interface NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCorsPolicy {
    /**
     * In response to a preflight request, setting this to true indicates that the actual request can include user credentials.
     *
     * This translates to the Access-Control-Allow-Credentials response header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#allow_credentials NetworkServicesEdgeCacheService#allow_credentials}
     *
     * @stability stable
     */
    readonly allowCredentials?: boolean | cdktf.IResolvable;
    /**
     * Specifies the content for the Access-Control-Allow-Headers response header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#allow_headers NetworkServicesEdgeCacheService#allow_headers}
     *
     * @stability stable
     */
    readonly allowHeaders?: string[];
    /**
     * Specifies the content for the Access-Control-Allow-Methods response header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#allow_methods NetworkServicesEdgeCacheService#allow_methods}
     *
     * @stability stable
     */
    readonly allowMethods?: string[];
    /**
     * Specifies the list of origins that will be allowed to do CORS requests.
     *
     * This translates to the Access-Control-Allow-Origin response header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#allow_origins NetworkServicesEdgeCacheService#allow_origins}
     *
     * @stability stable
     */
    readonly allowOrigins?: string[];
    /**
     * If true, specifies the CORS policy is disabled.
     *
     * The default value is false, which indicates that the CORS policy is in effect.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#disabled NetworkServicesEdgeCacheService#disabled}
     *
     * @stability stable
     */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
     * Specifies the content for the Access-Control-Allow-Headers response header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#expose_headers NetworkServicesEdgeCacheService#expose_headers}
     *
     * @stability stable
     */
    readonly exposeHeaders?: string[];
    /**
     * Specifies how long results of a preflight request can be cached by a client in seconds.
     *
     * Note that many browser clients enforce a maximum TTL of 600s (10 minutes).
     *
     * - Setting the value to -1 forces a pre-flight check for all requests (not recommended)
     * - A maximum TTL of 86400s can be set, but note that (as above) some clients may force pre-flight checks at a more regular interval.
     * - This translates to the Access-Control-Max-Age header.
     *
     * A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#max_age NetworkServicesEdgeCacheService#max_age}
     *
     * @stability stable
     */
    readonly maxAge: string;
}
export declare function networkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCorsPolicyToTerraform(struct?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCorsPolicyOutputReference | NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCorsPolicy): any;
/**
 * @stability stable
 */
export declare class NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCorsPolicyOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCorsPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCorsPolicy | undefined);
    private _allowCredentials?;
    /**
     * @stability stable
     */
    get allowCredentials(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set allowCredentials(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAllowCredentials(): void;
    /**
     * @stability stable
     */
    get allowCredentialsInput(): boolean | cdktf.IResolvable | undefined;
    private _allowHeaders?;
    /**
     * @stability stable
     */
    get allowHeaders(): string[];
    /**
     * @stability stable
     */
    set allowHeaders(value: string[]);
    /**
     * @stability stable
     */
    resetAllowHeaders(): void;
    /**
     * @stability stable
     */
    get allowHeadersInput(): string[] | undefined;
    private _allowMethods?;
    /**
     * @stability stable
     */
    get allowMethods(): string[];
    /**
     * @stability stable
     */
    set allowMethods(value: string[]);
    /**
     * @stability stable
     */
    resetAllowMethods(): void;
    /**
     * @stability stable
     */
    get allowMethodsInput(): string[] | undefined;
    private _allowOrigins?;
    /**
     * @stability stable
     */
    get allowOrigins(): string[];
    /**
     * @stability stable
     */
    set allowOrigins(value: string[]);
    /**
     * @stability stable
     */
    resetAllowOrigins(): void;
    /**
     * @stability stable
     */
    get allowOriginsInput(): string[] | undefined;
    private _disabled?;
    /**
     * @stability stable
     */
    get disabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set disabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDisabled(): void;
    /**
     * @stability stable
     */
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _exposeHeaders?;
    /**
     * @stability stable
     */
    get exposeHeaders(): string[];
    /**
     * @stability stable
     */
    set exposeHeaders(value: string[]);
    /**
     * @stability stable
     */
    resetExposeHeaders(): void;
    /**
     * @stability stable
     */
    get exposeHeadersInput(): string[] | undefined;
    private _maxAge?;
    /**
     * @stability stable
     */
    get maxAge(): string;
    /**
     * @stability stable
     */
    set maxAge(value: string);
    /**
     * @stability stable
     */
    get maxAgeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionUrlRewrite {
    /**
     * Prior to forwarding the request to the selected origin, the request's host header is replaced with contents of hostRewrite.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#host_rewrite NetworkServicesEdgeCacheService#host_rewrite}
     *
     * @stability stable
     */
    readonly hostRewrite?: string;
    /**
     * Prior to forwarding the request to the selected origin, the matching portion of the request's path is replaced by pathPrefixRewrite.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#path_prefix_rewrite NetworkServicesEdgeCacheService#path_prefix_rewrite}
     *
     * @stability stable
     */
    readonly pathPrefixRewrite?: string;
    /**
     * Prior to forwarding the request to the selected origin, if the request matched a pathTemplateMatch, the matching portion of the request's path is replaced re-written using the pattern specified by pathTemplateRewrite.
     *
     * pathTemplateRewrite must be between 1 and 255 characters
     * (inclusive), must start with a '/', and must only use variables
     * captured by the route's pathTemplate matchers.
     *
     * pathTemplateRewrite may only be used when all of a route's
     * MatchRules specify pathTemplate.
     *
     * Only one of pathPrefixRewrite and pathTemplateRewrite may be
     * specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#path_template_rewrite NetworkServicesEdgeCacheService#path_template_rewrite}
     *
     * @stability stable
     */
    readonly pathTemplateRewrite?: string;
}
export declare function networkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionUrlRewriteToTerraform(struct?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionUrlRewriteOutputReference | NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionUrlRewrite): any;
/**
 * @stability stable
 */
export declare class NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionUrlRewriteOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionUrlRewrite | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionUrlRewrite | undefined);
    private _hostRewrite?;
    /**
     * @stability stable
     */
    get hostRewrite(): string;
    /**
     * @stability stable
     */
    set hostRewrite(value: string);
    /**
     * @stability stable
     */
    resetHostRewrite(): void;
    /**
     * @stability stable
     */
    get hostRewriteInput(): string | undefined;
    private _pathPrefixRewrite?;
    /**
     * @stability stable
     */
    get pathPrefixRewrite(): string;
    /**
     * @stability stable
     */
    set pathPrefixRewrite(value: string);
    /**
     * @stability stable
     */
    resetPathPrefixRewrite(): void;
    /**
     * @stability stable
     */
    get pathPrefixRewriteInput(): string | undefined;
    private _pathTemplateRewrite?;
    /**
     * @stability stable
     */
    get pathTemplateRewrite(): string;
    /**
     * @stability stable
     */
    set pathTemplateRewrite(value: string);
    /**
     * @stability stable
     */
    resetPathTemplateRewrite(): void;
    /**
     * @stability stable
     */
    get pathTemplateRewriteInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteAction {
    /**
     * cdn_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#cdn_policy NetworkServicesEdgeCacheService#cdn_policy}
     *
     * @stability stable
     */
    readonly cdnPolicy?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicy;
    /**
     * cors_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#cors_policy NetworkServicesEdgeCacheService#cors_policy}
     *
     * @stability stable
     */
    readonly corsPolicy?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCorsPolicy;
    /**
     * url_rewrite block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#url_rewrite NetworkServicesEdgeCacheService#url_rewrite}
     *
     * @stability stable
     */
    readonly urlRewrite?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionUrlRewrite;
}
export declare function networkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionToTerraform(struct?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionOutputReference | NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteAction): any;
/**
 * @stability stable
 */
export declare class NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteAction | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteAction | undefined);
    private _cdnPolicy;
    /**
     * @stability stable
     */
    get cdnPolicy(): NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyOutputReference;
    /**
     * @stability stable
     */
    putCdnPolicy(value: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicy): void;
    /**
     * @stability stable
     */
    resetCdnPolicy(): void;
    /**
     * @stability stable
     */
    get cdnPolicyInput(): NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicy | undefined;
    private _corsPolicy;
    /**
     * @stability stable
     */
    get corsPolicy(): NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCorsPolicyOutputReference;
    /**
     * @stability stable
     */
    putCorsPolicy(value: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCorsPolicy): void;
    /**
     * @stability stable
     */
    resetCorsPolicy(): void;
    /**
     * @stability stable
     */
    get corsPolicyInput(): NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCorsPolicy | undefined;
    private _urlRewrite;
    /**
     * @stability stable
     */
    get urlRewrite(): NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionUrlRewriteOutputReference;
    /**
     * @stability stable
     */
    putUrlRewrite(value: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionUrlRewrite): void;
    /**
     * @stability stable
     */
    resetUrlRewrite(): void;
    /**
     * @stability stable
     */
    get urlRewriteInput(): NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionUrlRewrite | undefined;
}
/**
 * @stability stable
 */
export interface NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleUrlRedirect {
    /**
     * The host that will be used in the redirect response instead of the one that was supplied in the request.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#host_redirect NetworkServicesEdgeCacheService#host_redirect}
     *
     * @stability stable
     */
    readonly hostRedirect?: string;
    /**
     * If set to true, the URL scheme in the redirected request is set to https.
     *
     * If set to false, the URL scheme of the redirected request will remain the same as that of the request.
     *
     * This can only be set if there is at least one (1) edgeSslCertificate set on the service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#https_redirect NetworkServicesEdgeCacheService#https_redirect}
     *
     * @stability stable
     */
    readonly httpsRedirect?: boolean | cdktf.IResolvable;
    /**
     * The path that will be used in the redirect response instead of the one that was supplied in the request.
     *
     * pathRedirect cannot be supplied together with prefixRedirect. Supply one alone or neither. If neither is supplied, the path of the original request will be used for the redirect.
     *
     * The path value must be between 1 and 1024 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#path_redirect NetworkServicesEdgeCacheService#path_redirect}
     *
     * @stability stable
     */
    readonly pathRedirect?: string;
    /**
     * The prefix that replaces the prefixMatch specified in the routeRule, retaining the remaining portion of the URL before redirecting the request.
     *
     * prefixRedirect cannot be supplied together with pathRedirect. Supply one alone or neither. If neither is supplied, the path of the original request will be used for the redirect.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#prefix_redirect NetworkServicesEdgeCacheService#prefix_redirect}
     *
     * @stability stable
     */
    readonly prefixRedirect?: string;
    /**
     * The HTTP Status code to use for this RedirectAction.
     *
     * The supported values are:
     *
     * - 'MOVED_PERMANENTLY_DEFAULT', which is the default value and corresponds to 301.
     * - 'FOUND', which corresponds to 302.
     * - 'SEE_OTHER' which corresponds to 303.
     * - 'TEMPORARY_REDIRECT', which corresponds to 307. in this case, the request method will be retained.
     * - 'PERMANENT_REDIRECT', which corresponds to 308. in this case, the request method will be retained. Possible values: ["MOVED_PERMANENTLY_DEFAULT", "FOUND", "SEE_OTHER", "TEMPORARY_REDIRECT", "PERMANENT_REDIRECT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#redirect_response_code NetworkServicesEdgeCacheService#redirect_response_code}
     *
     * @stability stable
     */
    readonly redirectResponseCode?: string;
    /**
     * If set to true, any accompanying query portion of the original URL is removed prior to redirecting the request.
     *
     * If set to false, the query portion of the original URL is retained.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#strip_query NetworkServicesEdgeCacheService#strip_query}
     *
     * @stability stable
     */
    readonly stripQuery?: boolean | cdktf.IResolvable;
}
export declare function networkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleUrlRedirectToTerraform(struct?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleUrlRedirectOutputReference | NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleUrlRedirect): any;
/**
 * @stability stable
 */
export declare class NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleUrlRedirectOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleUrlRedirect | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleUrlRedirect | undefined);
    private _hostRedirect?;
    /**
     * @stability stable
     */
    get hostRedirect(): string;
    /**
     * @stability stable
     */
    set hostRedirect(value: string);
    /**
     * @stability stable
     */
    resetHostRedirect(): void;
    /**
     * @stability stable
     */
    get hostRedirectInput(): string | undefined;
    private _httpsRedirect?;
    /**
     * @stability stable
     */
    get httpsRedirect(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set httpsRedirect(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetHttpsRedirect(): void;
    /**
     * @stability stable
     */
    get httpsRedirectInput(): boolean | cdktf.IResolvable | undefined;
    private _pathRedirect?;
    /**
     * @stability stable
     */
    get pathRedirect(): string;
    /**
     * @stability stable
     */
    set pathRedirect(value: string);
    /**
     * @stability stable
     */
    resetPathRedirect(): void;
    /**
     * @stability stable
     */
    get pathRedirectInput(): string | undefined;
    private _prefixRedirect?;
    /**
     * @stability stable
     */
    get prefixRedirect(): string;
    /**
     * @stability stable
     */
    set prefixRedirect(value: string);
    /**
     * @stability stable
     */
    resetPrefixRedirect(): void;
    /**
     * @stability stable
     */
    get prefixRedirectInput(): string | undefined;
    private _redirectResponseCode?;
    /**
     * @stability stable
     */
    get redirectResponseCode(): string;
    /**
     * @stability stable
     */
    set redirectResponseCode(value: string);
    /**
     * @stability stable
     */
    resetRedirectResponseCode(): void;
    /**
     * @stability stable
     */
    get redirectResponseCodeInput(): string | undefined;
    private _stripQuery?;
    /**
     * @stability stable
     */
    get stripQuery(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set stripQuery(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetStripQuery(): void;
    /**
     * @stability stable
     */
    get stripQueryInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRule {
    /**
     * A human-readable description of the routeRule.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#description NetworkServicesEdgeCacheService#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The Origin resource that requests to this route should fetch from when a matching response is not in cache.
     *
     * Origins can be defined as short names ("my-origin") or fully-qualified resource URLs - e.g. "networkservices.googleapis.com/projects/my-project/global/edgecacheorigins/my-origin"
     *
     * Only one of origin or urlRedirect can be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#origin NetworkServicesEdgeCacheService#origin}
     *
     * @stability stable
     */
    readonly origin?: string;
    /**
     * The priority of this route rule, where 1 is the highest priority.
     *
     * You cannot configure two or more routeRules with the same priority. Priority for each rule must be set to a number between 1 and 999 inclusive.
     *
     * Priority numbers can have gaps, which enable you to add or remove rules in the future without affecting the rest of the rules. For example, 1, 2, 3, 4, 5, 9, 12, 16 is a valid series of priority numbers
     * to which you could add rules numbered from 6 to 8, 10 to 11, and 13 to 15 in the future without any impact on existing rules.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#priority NetworkServicesEdgeCacheService#priority}
     *
     * @stability stable
     */
    readonly priority: string;
    /**
     * header_action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#header_action NetworkServicesEdgeCacheService#header_action}
     *
     * @stability stable
     */
    readonly headerAction?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderAction;
    /**
     * match_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#match_rule NetworkServicesEdgeCacheService#match_rule}
     *
     * @stability stable
     */
    readonly matchRule: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleMatchRule[];
    /**
     * route_action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#route_action NetworkServicesEdgeCacheService#route_action}
     *
     * @stability stable
     */
    readonly routeAction?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteAction;
    /**
     * url_redirect block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#url_redirect NetworkServicesEdgeCacheService#url_redirect}
     *
     * @stability stable
     */
    readonly urlRedirect?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleUrlRedirect;
}
export declare function networkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleToTerraform(struct?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRule): any;
/**
 * @stability stable
 */
export interface NetworkServicesEdgeCacheServiceRoutingPathMatcher {
    /**
     * A human-readable description of the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#description NetworkServicesEdgeCacheService#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The name to which this PathMatcher is referred by the HostRule.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#name NetworkServicesEdgeCacheService#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * route_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#route_rule NetworkServicesEdgeCacheService#route_rule}
     *
     * @stability stable
     */
    readonly routeRule: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRule[];
}
export declare function networkServicesEdgeCacheServiceRoutingPathMatcherToTerraform(struct?: NetworkServicesEdgeCacheServiceRoutingPathMatcher): any;
/**
 * @stability stable
 */
export interface NetworkServicesEdgeCacheServiceRouting {
    /**
     * host_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#host_rule NetworkServicesEdgeCacheService#host_rule}
     *
     * @stability stable
     */
    readonly hostRule: NetworkServicesEdgeCacheServiceRoutingHostRule[];
    /**
     * path_matcher block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#path_matcher NetworkServicesEdgeCacheService#path_matcher}
     *
     * @stability stable
     */
    readonly pathMatcher: NetworkServicesEdgeCacheServiceRoutingPathMatcher[];
}
export declare function networkServicesEdgeCacheServiceRoutingToTerraform(struct?: NetworkServicesEdgeCacheServiceRoutingOutputReference | NetworkServicesEdgeCacheServiceRouting): any;
/**
 * @stability stable
 */
export declare class NetworkServicesEdgeCacheServiceRoutingOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NetworkServicesEdgeCacheServiceRouting | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NetworkServicesEdgeCacheServiceRouting | undefined);
    private _hostRule?;
    /**
     * @stability stable
     */
    get hostRule(): NetworkServicesEdgeCacheServiceRoutingHostRule[];
    /**
     * @stability stable
     */
    set hostRule(value: NetworkServicesEdgeCacheServiceRoutingHostRule[]);
    /**
     * @stability stable
     */
    get hostRuleInput(): NetworkServicesEdgeCacheServiceRoutingHostRule[] | undefined;
    private _pathMatcher?;
    /**
     * @stability stable
     */
    get pathMatcher(): NetworkServicesEdgeCacheServiceRoutingPathMatcher[];
    /**
     * @stability stable
     */
    set pathMatcher(value: NetworkServicesEdgeCacheServiceRoutingPathMatcher[]);
    /**
     * @stability stable
     */
    get pathMatcherInput(): NetworkServicesEdgeCacheServiceRoutingPathMatcher[] | undefined;
}
/**
 * @stability stable
 */
export interface NetworkServicesEdgeCacheServiceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#create NetworkServicesEdgeCacheService#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#delete NetworkServicesEdgeCacheService#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html#update NetworkServicesEdgeCacheService#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function networkServicesEdgeCacheServiceTimeoutsToTerraform(struct?: NetworkServicesEdgeCacheServiceTimeoutsOutputReference | NetworkServicesEdgeCacheServiceTimeouts): any;
/**
 * @stability stable
 */
export declare class NetworkServicesEdgeCacheServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NetworkServicesEdgeCacheServiceTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NetworkServicesEdgeCacheServiceTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html google_network_services_edge_cache_service}.
 *
 * @stability stable
 */
export declare class NetworkServicesEdgeCacheService extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service.html google_network_services_edge_cache_service} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: NetworkServicesEdgeCacheServiceConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _disableQuic?;
    /**
     * @stability stable
     */
    get disableQuic(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set disableQuic(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDisableQuic(): void;
    /**
     * @stability stable
     */
    get disableQuicInput(): boolean | cdktf.IResolvable | undefined;
    private _edgeSecurityPolicy?;
    /**
     * @stability stable
     */
    get edgeSecurityPolicy(): string;
    /**
     * @stability stable
     */
    set edgeSecurityPolicy(value: string);
    /**
     * @stability stable
     */
    resetEdgeSecurityPolicy(): void;
    /**
     * @stability stable
     */
    get edgeSecurityPolicyInput(): string | undefined;
    private _edgeSslCertificates?;
    /**
     * @stability stable
     */
    get edgeSslCertificates(): string[];
    /**
     * @stability stable
     */
    set edgeSslCertificates(value: string[]);
    /**
     * @stability stable
     */
    resetEdgeSslCertificates(): void;
    /**
     * @stability stable
     */
    get edgeSslCertificatesInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get ipv4Addresses(): string[];
    /**
     * @stability stable
     */
    get ipv6Addresses(): string[];
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _requireTls?;
    /**
     * @stability stable
     */
    get requireTls(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set requireTls(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRequireTls(): void;
    /**
     * @stability stable
     */
    get requireTlsInput(): boolean | cdktf.IResolvable | undefined;
    private _sslPolicy?;
    /**
     * @stability stable
     */
    get sslPolicy(): string;
    /**
     * @stability stable
     */
    set sslPolicy(value: string);
    /**
     * @stability stable
     */
    resetSslPolicy(): void;
    /**
     * @stability stable
     */
    get sslPolicyInput(): string | undefined;
    private _logConfig;
    /**
     * @stability stable
     */
    get logConfig(): NetworkServicesEdgeCacheServiceLogConfigOutputReference;
    /**
     * @stability stable
     */
    putLogConfig(value: NetworkServicesEdgeCacheServiceLogConfig): void;
    /**
     * @stability stable
     */
    resetLogConfig(): void;
    /**
     * @stability stable
     */
    get logConfigInput(): NetworkServicesEdgeCacheServiceLogConfig | undefined;
    private _routing;
    /**
     * @stability stable
     */
    get routing(): NetworkServicesEdgeCacheServiceRoutingOutputReference;
    /**
     * @stability stable
     */
    putRouting(value: NetworkServicesEdgeCacheServiceRouting): void;
    /**
     * @stability stable
     */
    get routingInput(): NetworkServicesEdgeCacheServiceRouting | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): NetworkServicesEdgeCacheServiceTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: NetworkServicesEdgeCacheServiceTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): NetworkServicesEdgeCacheServiceTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
