import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface NotebooksInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
     * The size of the boot disk in GB attached to this instance, up to a maximum of 64000 GB (64 TB).
     *
     * The minimum recommended value is 100 GB.
     * If not specified, this defaults to 100.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#boot_disk_size_gb NotebooksInstance#boot_disk_size_gb}
     *
     * @stability stable
     */
    readonly bootDiskSizeGb?: number;
    /**
     * Possible disk types for notebook instances. Possible values: ["DISK_TYPE_UNSPECIFIED", "PD_STANDARD", "PD_SSD", "PD_BALANCED"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#boot_disk_type NotebooksInstance#boot_disk_type}
     *
     * @stability stable
     */
    readonly bootDiskType?: string;
    /**
     * Instance creation time.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#create_time NotebooksInstance#create_time}
     *
     * @stability stable
     */
    readonly createTime?: string;
    /**
     * Specify a custom Cloud Storage path where the GPU driver is stored.
     *
     * If not specified, we'll automatically choose from official GPU drivers.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#custom_gpu_driver_path NotebooksInstance#custom_gpu_driver_path}
     *
     * @stability stable
     */
    readonly customGpuDriverPath?: string;
    /**
     * The size of the data disk in GB attached to this instance, up to a maximum of 64000 GB (64 TB).
     *
     * You can choose the size of the data disk based on how big your notebooks and data are.
     * If not specified, this defaults to 100.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#data_disk_size_gb NotebooksInstance#data_disk_size_gb}
     *
     * @stability stable
     */
    readonly dataDiskSizeGb?: number;
    /**
     * Possible disk types for notebook instances. Possible values: ["DISK_TYPE_UNSPECIFIED", "PD_STANDARD", "PD_SSD", "PD_BALANCED"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#data_disk_type NotebooksInstance#data_disk_type}
     *
     * @stability stable
     */
    readonly dataDiskType?: string;
    /**
     * Disk encryption method used on the boot and data disks, defaults to GMEK. Possible values: ["DISK_ENCRYPTION_UNSPECIFIED", "GMEK", "CMEK"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#disk_encryption NotebooksInstance#disk_encryption}
     *
     * @stability stable
     */
    readonly diskEncryption?: string;
    /**
     * Whether the end user authorizes Google Cloud to install GPU driver on this instance.
     *
     * If this field is empty or set to false, the GPU driver
     * won't be installed. Only applicable to instances with GPUs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#install_gpu_driver NotebooksInstance#install_gpu_driver}
     *
     * @stability stable
     */
    readonly installGpuDriver?: boolean | cdktf.IResolvable;
    /**
     * The list of owners of this instance after creation.
     *
     * Format: alias@example.com.
     * Currently supports one owner only.
     * If not specified, all of the service account users of
     * your VM instance's service account can use the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#instance_owners NotebooksInstance#instance_owners}
     *
     * @stability stable
     */
    readonly instanceOwners?: string[];
    /**
     * The KMS key used to encrypt the disks, only applicable if diskEncryption is CMEK. Format: projects/{project_id}/locations/{location}/keyRings/{key_ring_id}/cryptoKeys/{key_id}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#kms_key NotebooksInstance#kms_key}
     *
     * @stability stable
     */
    readonly kmsKey?: string;
    /**
     * Labels to apply to this instance.
     *
     * These can be later modified by the setLabels method.
     * An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#labels NotebooksInstance#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * A reference to the zone where the machine resides.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#location NotebooksInstance#location}
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * A reference to a machine type which defines VM kind.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#machine_type NotebooksInstance#machine_type}
     *
     * @stability stable
     */
    readonly machineType: string;
    /**
     * Custom metadata to apply to this instance.
     *
     * An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#metadata NotebooksInstance#metadata}
     *
     * @stability stable
     */
    readonly metadata?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The name specified for the Notebook instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#name NotebooksInstance#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The name of the VPC that this instance is in. Format: projects/{project_id}/global/networks/{network_id}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#network NotebooksInstance#network}
     *
     * @stability stable
     */
    readonly network?: string;
    /**
     * The notebook instance will not register with the proxy..
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#no_proxy_access NotebooksInstance#no_proxy_access}
     *
     * @stability stable
     */
    readonly noProxyAccess?: boolean | cdktf.IResolvable;
    /**
     * No public IP will be assigned to this instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#no_public_ip NotebooksInstance#no_public_ip}
     *
     * @stability stable
     */
    readonly noPublicIp?: boolean | cdktf.IResolvable;
    /**
     * If true, the data disk will not be auto deleted when deleting the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#no_remove_data_disk NotebooksInstance#no_remove_data_disk}
     *
     * @stability stable
     */
    readonly noRemoveDataDisk?: boolean | cdktf.IResolvable;
    /**
     * Path to a Bash script that automatically runs after a notebook instance fully boots up.
     *
     * The path must be a URL
     * or Cloud Storage path (gs://path-to-file/file-name).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#post_startup_script NotebooksInstance#post_startup_script}
     *
     * @stability stable
     */
    readonly postStartupScript?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#project NotebooksInstance#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The service account on this instance, giving access to other Google Cloud services.
     *
     * You can use any service account within
     * the same project, but you must have the service account user
     * permission to use the instance. If not specified,
     * the Compute Engine default service account is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#service_account NotebooksInstance#service_account}
     *
     * @stability stable
     */
    readonly serviceAccount?: string;
    /**
     * Optional.
     *
     * The URIs of service account scopes to be included in Compute Engine instances.
     * If not specified, the following scopes are defined:
     * - https://www.googleapis.com/auth/cloud-platform
     * - https://www.googleapis.com/auth/userinfo.email
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#service_account_scopes NotebooksInstance#service_account_scopes}
     *
     * @stability stable
     */
    readonly serviceAccountScopes?: string[];
    /**
     * The name of the subnet that this instance is in. Format: projects/{project_id}/regions/{region}/subnetworks/{subnetwork_id}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#subnet NotebooksInstance#subnet}
     *
     * @stability stable
     */
    readonly subnet?: string;
    /**
     * The Compute Engine tags to add to runtime.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#tags NotebooksInstance#tags}
     *
     * @stability stable
     */
    readonly tags?: string[];
    /**
     * Instance update time.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#update_time NotebooksInstance#update_time}
     *
     * @stability stable
     */
    readonly updateTime?: string;
    /**
     * accelerator_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#accelerator_config NotebooksInstance#accelerator_config}
     *
     * @stability stable
     */
    readonly acceleratorConfig?: NotebooksInstanceAcceleratorConfig;
    /**
     * container_image block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#container_image NotebooksInstance#container_image}
     *
     * @stability stable
     */
    readonly containerImage?: NotebooksInstanceContainerImage;
    /**
     * shielded_instance_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#shielded_instance_config NotebooksInstance#shielded_instance_config}
     *
     * @stability stable
     */
    readonly shieldedInstanceConfig?: NotebooksInstanceShieldedInstanceConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#timeouts NotebooksInstance#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: NotebooksInstanceTimeouts;
    /**
     * vm_image block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#vm_image NotebooksInstance#vm_image}
     *
     * @stability stable
     */
    readonly vmImage?: NotebooksInstanceVmImage;
}
/**
 * @stability stable
 */
export interface NotebooksInstanceAcceleratorConfig {
    /**
     * Count of cores of this accelerator.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#core_count NotebooksInstance#core_count}
     *
     * @stability stable
     */
    readonly coreCount: number;
    /**
     * Type of this accelerator. Possible values: ["ACCELERATOR_TYPE_UNSPECIFIED", "NVIDIA_TESLA_K80", "NVIDIA_TESLA_P100", "NVIDIA_TESLA_V100", "NVIDIA_TESLA_P4", "NVIDIA_TESLA_T4", "NVIDIA_TESLA_T4_VWS", "NVIDIA_TESLA_P100_VWS", "NVIDIA_TESLA_P4_VWS", "NVIDIA_TESLA_A100", "TPU_V2", "TPU_V3"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#type NotebooksInstance#type}
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function notebooksInstanceAcceleratorConfigToTerraform(struct?: NotebooksInstanceAcceleratorConfigOutputReference | NotebooksInstanceAcceleratorConfig): any;
/**
 * @stability stable
 */
export declare class NotebooksInstanceAcceleratorConfigOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NotebooksInstanceAcceleratorConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NotebooksInstanceAcceleratorConfig | undefined);
    private _coreCount?;
    /**
     * @stability stable
     */
    get coreCount(): number;
    /**
     * @stability stable
     */
    set coreCount(value: number);
    /**
     * @stability stable
     */
    get coreCountInput(): number | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface NotebooksInstanceContainerImage {
    /**
     * The path to the container image repository. For example: gcr.io/{project_id}/{imageName}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#repository NotebooksInstance#repository}
     *
     * @stability stable
     */
    readonly repository: string;
    /**
     * The tag of the container image. If not specified, this defaults to the latest tag.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#tag NotebooksInstance#tag}
     *
     * @stability stable
     */
    readonly tag?: string;
}
export declare function notebooksInstanceContainerImageToTerraform(struct?: NotebooksInstanceContainerImageOutputReference | NotebooksInstanceContainerImage): any;
/**
 * @stability stable
 */
export declare class NotebooksInstanceContainerImageOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NotebooksInstanceContainerImage | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NotebooksInstanceContainerImage | undefined);
    private _repository?;
    /**
     * @stability stable
     */
    get repository(): string;
    /**
     * @stability stable
     */
    set repository(value: string);
    /**
     * @stability stable
     */
    get repositoryInput(): string | undefined;
    private _tag?;
    /**
     * @stability stable
     */
    get tag(): string;
    /**
     * @stability stable
     */
    set tag(value: string);
    /**
     * @stability stable
     */
    resetTag(): void;
    /**
     * @stability stable
     */
    get tagInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface NotebooksInstanceShieldedInstanceConfig {
    /**
     * Defines whether the instance has integrity monitoring enabled.
     *
     * Enables monitoring and attestation of the
     * boot integrity of the instance. The attestation is performed against the integrity policy baseline.
     * This baseline is initially derived from the implicitly trusted boot image when the instance is created.
     * Enabled by default.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#enable_integrity_monitoring NotebooksInstance#enable_integrity_monitoring}
     *
     * @stability stable
     */
    readonly enableIntegrityMonitoring?: boolean | cdktf.IResolvable;
    /**
     * Defines whether the instance has Secure Boot enabled.
     *
     * Secure Boot helps ensure that the system only runs
     * authentic software by verifying the digital signature of all boot components, and halting the boot process
     * if signature verification fails.
     * Disabled by default.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#enable_secure_boot NotebooksInstance#enable_secure_boot}
     *
     * @stability stable
     */
    readonly enableSecureBoot?: boolean | cdktf.IResolvable;
    /**
     * Defines whether the instance has the vTPM enabled. Enabled by default.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#enable_vtpm NotebooksInstance#enable_vtpm}
     *
     * @stability stable
     */
    readonly enableVtpm?: boolean | cdktf.IResolvable;
}
export declare function notebooksInstanceShieldedInstanceConfigToTerraform(struct?: NotebooksInstanceShieldedInstanceConfigOutputReference | NotebooksInstanceShieldedInstanceConfig): any;
/**
 * @stability stable
 */
export declare class NotebooksInstanceShieldedInstanceConfigOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NotebooksInstanceShieldedInstanceConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NotebooksInstanceShieldedInstanceConfig | undefined);
    private _enableIntegrityMonitoring?;
    /**
     * @stability stable
     */
    get enableIntegrityMonitoring(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableIntegrityMonitoring(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableIntegrityMonitoring(): void;
    /**
     * @stability stable
     */
    get enableIntegrityMonitoringInput(): boolean | cdktf.IResolvable | undefined;
    private _enableSecureBoot?;
    /**
     * @stability stable
     */
    get enableSecureBoot(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableSecureBoot(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableSecureBoot(): void;
    /**
     * @stability stable
     */
    get enableSecureBootInput(): boolean | cdktf.IResolvable | undefined;
    private _enableVtpm?;
    /**
     * @stability stable
     */
    get enableVtpm(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableVtpm(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableVtpm(): void;
    /**
     * @stability stable
     */
    get enableVtpmInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface NotebooksInstanceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#create NotebooksInstance#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#delete NotebooksInstance#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#update NotebooksInstance#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function notebooksInstanceTimeoutsToTerraform(struct?: NotebooksInstanceTimeoutsOutputReference | NotebooksInstanceTimeouts): any;
/**
 * @stability stable
 */
export declare class NotebooksInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NotebooksInstanceTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NotebooksInstanceTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface NotebooksInstanceVmImage {
    /**
     * Use this VM image family to find the image; the newest image in this family will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#image_family NotebooksInstance#image_family}
     *
     * @stability stable
     */
    readonly imageFamily?: string;
    /**
     * Use VM image name to find the image.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#image_name NotebooksInstance#image_name}
     *
     * @stability stable
     */
    readonly imageName?: string;
    /**
     * The name of the Google Cloud project that this VM image belongs to. Format: projects/{project_id}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#project NotebooksInstance#project}
     *
     * @stability stable
     */
    readonly project: string;
}
export declare function notebooksInstanceVmImageToTerraform(struct?: NotebooksInstanceVmImageOutputReference | NotebooksInstanceVmImage): any;
/**
 * @stability stable
 */
export declare class NotebooksInstanceVmImageOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NotebooksInstanceVmImage | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NotebooksInstanceVmImage | undefined);
    private _imageFamily?;
    /**
     * @stability stable
     */
    get imageFamily(): string;
    /**
     * @stability stable
     */
    set imageFamily(value: string);
    /**
     * @stability stable
     */
    resetImageFamily(): void;
    /**
     * @stability stable
     */
    get imageFamilyInput(): string | undefined;
    private _imageName?;
    /**
     * @stability stable
     */
    get imageName(): string;
    /**
     * @stability stable
     */
    set imageName(value: string);
    /**
     * @stability stable
     */
    resetImageName(): void;
    /**
     * @stability stable
     */
    get imageNameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html google_notebooks_instance}.
 *
 * @stability stable
 */
export declare class NotebooksInstance extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html google_notebooks_instance} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: NotebooksInstanceConfig);
    private _bootDiskSizeGb?;
    /**
     * @stability stable
     */
    get bootDiskSizeGb(): number;
    /**
     * @stability stable
     */
    set bootDiskSizeGb(value: number);
    /**
     * @stability stable
     */
    resetBootDiskSizeGb(): void;
    /**
     * @stability stable
     */
    get bootDiskSizeGbInput(): number | undefined;
    private _bootDiskType?;
    /**
     * @stability stable
     */
    get bootDiskType(): string;
    /**
     * @stability stable
     */
    set bootDiskType(value: string);
    /**
     * @stability stable
     */
    resetBootDiskType(): void;
    /**
     * @stability stable
     */
    get bootDiskTypeInput(): string | undefined;
    private _createTime?;
    /**
     * @stability stable
     */
    get createTime(): string;
    /**
     * @stability stable
     */
    set createTime(value: string);
    /**
     * @stability stable
     */
    resetCreateTime(): void;
    /**
     * @stability stable
     */
    get createTimeInput(): string | undefined;
    private _customGpuDriverPath?;
    /**
     * @stability stable
     */
    get customGpuDriverPath(): string;
    /**
     * @stability stable
     */
    set customGpuDriverPath(value: string);
    /**
     * @stability stable
     */
    resetCustomGpuDriverPath(): void;
    /**
     * @stability stable
     */
    get customGpuDriverPathInput(): string | undefined;
    private _dataDiskSizeGb?;
    /**
     * @stability stable
     */
    get dataDiskSizeGb(): number;
    /**
     * @stability stable
     */
    set dataDiskSizeGb(value: number);
    /**
     * @stability stable
     */
    resetDataDiskSizeGb(): void;
    /**
     * @stability stable
     */
    get dataDiskSizeGbInput(): number | undefined;
    private _dataDiskType?;
    /**
     * @stability stable
     */
    get dataDiskType(): string;
    /**
     * @stability stable
     */
    set dataDiskType(value: string);
    /**
     * @stability stable
     */
    resetDataDiskType(): void;
    /**
     * @stability stable
     */
    get dataDiskTypeInput(): string | undefined;
    private _diskEncryption?;
    /**
     * @stability stable
     */
    get diskEncryption(): string;
    /**
     * @stability stable
     */
    set diskEncryption(value: string);
    /**
     * @stability stable
     */
    resetDiskEncryption(): void;
    /**
     * @stability stable
     */
    get diskEncryptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _installGpuDriver?;
    /**
     * @stability stable
     */
    get installGpuDriver(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set installGpuDriver(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetInstallGpuDriver(): void;
    /**
     * @stability stable
     */
    get installGpuDriverInput(): boolean | cdktf.IResolvable | undefined;
    private _instanceOwners?;
    /**
     * @stability stable
     */
    get instanceOwners(): string[];
    /**
     * @stability stable
     */
    set instanceOwners(value: string[]);
    /**
     * @stability stable
     */
    resetInstanceOwners(): void;
    /**
     * @stability stable
     */
    get instanceOwnersInput(): string[] | undefined;
    private _kmsKey?;
    /**
     * @stability stable
     */
    get kmsKey(): string;
    /**
     * @stability stable
     */
    set kmsKey(value: string);
    /**
     * @stability stable
     */
    resetKmsKey(): void;
    /**
     * @stability stable
     */
    get kmsKeyInput(): string | undefined;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _machineType?;
    /**
     * @stability stable
     */
    get machineType(): string;
    /**
     * @stability stable
     */
    set machineType(value: string);
    /**
     * @stability stable
     */
    get machineTypeInput(): string | undefined;
    private _metadata?;
    /**
     * @stability stable
     */
    get metadata(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set metadata(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMetadata(): void;
    /**
     * @stability stable
     */
    get metadataInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _network?;
    /**
     * @stability stable
     */
    get network(): string;
    /**
     * @stability stable
     */
    set network(value: string);
    /**
     * @stability stable
     */
    resetNetwork(): void;
    /**
     * @stability stable
     */
    get networkInput(): string | undefined;
    private _noProxyAccess?;
    /**
     * @stability stable
     */
    get noProxyAccess(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set noProxyAccess(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetNoProxyAccess(): void;
    /**
     * @stability stable
     */
    get noProxyAccessInput(): boolean | cdktf.IResolvable | undefined;
    private _noPublicIp?;
    /**
     * @stability stable
     */
    get noPublicIp(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set noPublicIp(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetNoPublicIp(): void;
    /**
     * @stability stable
     */
    get noPublicIpInput(): boolean | cdktf.IResolvable | undefined;
    private _noRemoveDataDisk?;
    /**
     * @stability stable
     */
    get noRemoveDataDisk(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set noRemoveDataDisk(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetNoRemoveDataDisk(): void;
    /**
     * @stability stable
     */
    get noRemoveDataDiskInput(): boolean | cdktf.IResolvable | undefined;
    private _postStartupScript?;
    /**
     * @stability stable
     */
    get postStartupScript(): string;
    /**
     * @stability stable
     */
    set postStartupScript(value: string);
    /**
     * @stability stable
     */
    resetPostStartupScript(): void;
    /**
     * @stability stable
     */
    get postStartupScriptInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get proxyUri(): string;
    private _serviceAccount?;
    /**
     * @stability stable
     */
    get serviceAccount(): string;
    /**
     * @stability stable
     */
    set serviceAccount(value: string);
    /**
     * @stability stable
     */
    resetServiceAccount(): void;
    /**
     * @stability stable
     */
    get serviceAccountInput(): string | undefined;
    private _serviceAccountScopes?;
    /**
     * @stability stable
     */
    get serviceAccountScopes(): string[];
    /**
     * @stability stable
     */
    set serviceAccountScopes(value: string[]);
    /**
     * @stability stable
     */
    resetServiceAccountScopes(): void;
    /**
     * @stability stable
     */
    get serviceAccountScopesInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get state(): string;
    private _subnet?;
    /**
     * @stability stable
     */
    get subnet(): string;
    /**
     * @stability stable
     */
    set subnet(value: string);
    /**
     * @stability stable
     */
    resetSubnet(): void;
    /**
     * @stability stable
     */
    get subnetInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): string[];
    /**
     * @stability stable
     */
    set tags(value: string[]);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): string[] | undefined;
    private _updateTime?;
    /**
     * @stability stable
     */
    get updateTime(): string;
    /**
     * @stability stable
     */
    set updateTime(value: string);
    /**
     * @stability stable
     */
    resetUpdateTime(): void;
    /**
     * @stability stable
     */
    get updateTimeInput(): string | undefined;
    private _acceleratorConfig;
    /**
     * @stability stable
     */
    get acceleratorConfig(): NotebooksInstanceAcceleratorConfigOutputReference;
    /**
     * @stability stable
     */
    putAcceleratorConfig(value: NotebooksInstanceAcceleratorConfig): void;
    /**
     * @stability stable
     */
    resetAcceleratorConfig(): void;
    /**
     * @stability stable
     */
    get acceleratorConfigInput(): NotebooksInstanceAcceleratorConfig | undefined;
    private _containerImage;
    /**
     * @stability stable
     */
    get containerImage(): NotebooksInstanceContainerImageOutputReference;
    /**
     * @stability stable
     */
    putContainerImage(value: NotebooksInstanceContainerImage): void;
    /**
     * @stability stable
     */
    resetContainerImage(): void;
    /**
     * @stability stable
     */
    get containerImageInput(): NotebooksInstanceContainerImage | undefined;
    private _shieldedInstanceConfig;
    /**
     * @stability stable
     */
    get shieldedInstanceConfig(): NotebooksInstanceShieldedInstanceConfigOutputReference;
    /**
     * @stability stable
     */
    putShieldedInstanceConfig(value: NotebooksInstanceShieldedInstanceConfig): void;
    /**
     * @stability stable
     */
    resetShieldedInstanceConfig(): void;
    /**
     * @stability stable
     */
    get shieldedInstanceConfigInput(): NotebooksInstanceShieldedInstanceConfig | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): NotebooksInstanceTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: NotebooksInstanceTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): NotebooksInstanceTimeouts | undefined;
    private _vmImage;
    /**
     * @stability stable
     */
    get vmImage(): NotebooksInstanceVmImageOutputReference;
    /**
     * @stability stable
     */
    putVmImage(value: NotebooksInstanceVmImage): void;
    /**
     * @stability stable
     */
    resetVmImage(): void;
    /**
     * @stability stable
     */
    get vmImageInput(): NotebooksInstanceVmImage | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
