import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ProjectConfig extends cdktf.TerraformMetaArguments {
    /**
     * Create the 'default' network automatically.
     *
     * Default true. If set to false, the default network will be deleted.  Note that, for quota purposes, you will still need to have 1 network slot available to create the project successfully, even if you set auto_create_network to false, since the network will exist momentarily.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project.html#auto_create_network Project#auto_create_network}
     *
     * @stability stable
     */
    readonly autoCreateNetwork?: boolean | cdktf.IResolvable;
    /**
     * The alphanumeric ID of the billing account this project belongs to.
     *
     * The user or service account performing this operation with Terraform must have Billing Account Administrator privileges (roles/billing.admin) in the organization. See Google Cloud Billing API Access Control for more details.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project.html#billing_account Project#billing_account}
     *
     * @stability stable
     */
    readonly billingAccount?: string;
    /**
     * The numeric ID of the folder this project should be created under.
     *
     * Only one of org_id or folder_id may be specified. If the folder_id is specified, then the project is created under the specified folder. Changing this forces the project to be migrated to the newly specified folder.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project.html#folder_id Project#folder_id}
     *
     * @stability stable
     */
    readonly folderId?: string;
    /**
     * A set of key/value label pairs to assign to the project.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project.html#labels Project#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The display name of the project.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project.html#name Project#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The numeric ID of the organization this project belongs to.
     *
     * Changing this forces a new project to be created.  Only one of org_id or folder_id may be specified. If the org_id is specified then the project is created at the top level. Changing this forces the project to be migrated to the newly specified organization.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project.html#org_id Project#org_id}
     *
     * @stability stable
     */
    readonly orgId?: string;
    /**
     * The project ID. Changing this forces a new project to be created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project.html#project_id Project#project_id}
     *
     * @stability stable
     */
    readonly projectId: string;
    /**
     * If true, the Terraform resource can be deleted without deleting the Project via the Google API.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project.html#skip_delete Project#skip_delete}
     *
     * @stability stable
     */
    readonly skipDelete?: boolean | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project.html#timeouts Project#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ProjectTimeouts;
}
/**
 * @stability stable
 */
export interface ProjectTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project.html#create Project#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project.html#delete Project#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project.html#read Project#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project.html#update Project#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function projectTimeoutsToTerraform(struct?: ProjectTimeoutsOutputReference | ProjectTimeouts): any;
/**
 * @stability stable
 */
export declare class ProjectTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ProjectTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ProjectTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/project.html google_project}.
 *
 * @stability stable
 */
export declare class Project extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/project.html google_project} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ProjectConfig);
    private _autoCreateNetwork?;
    /**
     * @stability stable
     */
    get autoCreateNetwork(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set autoCreateNetwork(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAutoCreateNetwork(): void;
    /**
     * @stability stable
     */
    get autoCreateNetworkInput(): boolean | cdktf.IResolvable | undefined;
    private _billingAccount?;
    /**
     * @stability stable
     */
    get billingAccount(): string;
    /**
     * @stability stable
     */
    set billingAccount(value: string);
    /**
     * @stability stable
     */
    resetBillingAccount(): void;
    /**
     * @stability stable
     */
    get billingAccountInput(): string | undefined;
    private _folderId?;
    /**
     * @stability stable
     */
    get folderId(): string;
    /**
     * @stability stable
     */
    set folderId(value: string);
    /**
     * @stability stable
     */
    resetFolderId(): void;
    /**
     * @stability stable
     */
    get folderIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get number(): string;
    private _orgId?;
    /**
     * @stability stable
     */
    get orgId(): string;
    /**
     * @stability stable
     */
    set orgId(value: string);
    /**
     * @stability stable
     */
    resetOrgId(): void;
    /**
     * @stability stable
     */
    get orgIdInput(): string | undefined;
    private _projectId?;
    /**
     * @stability stable
     */
    get projectId(): string;
    /**
     * @stability stable
     */
    set projectId(value: string);
    /**
     * @stability stable
     */
    get projectIdInput(): string | undefined;
    private _skipDelete?;
    /**
     * @stability stable
     */
    get skipDelete(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set skipDelete(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSkipDelete(): void;
    /**
     * @stability stable
     */
    get skipDeleteInput(): boolean | cdktf.IResolvable | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ProjectTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ProjectTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ProjectTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
