import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface PubsubTopicConfig extends cdktf.TerraformMetaArguments {
    /**
     * The resource name of the Cloud KMS CryptoKey to be used to protect access to messages published on this topic.
     *
     * Your project's PubSub service account
     * ('service-{{PROJECT_NUMBER}}@gcp-sa-pubsub.iam.gserviceaccount.com') must have
     * 'roles/cloudkms.cryptoKeyEncrypterDecrypter' to use this feature.
     * The expected format is 'projects/*\/locations/*\/keyRings/*\/cryptoKeys/*'
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_topic.html#kms_key_name PubsubTopic#kms_key_name}
     *
     * @stability stable
     */
    readonly kmsKeyName?: string;
    /**
     * A set of key/value label pairs to assign to this Topic.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_topic.html#labels PubsubTopic#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Name of the topic.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_topic.html#name PubsubTopic#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_topic.html#project PubsubTopic#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * message_storage_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_topic.html#message_storage_policy PubsubTopic#message_storage_policy}
     *
     * @stability stable
     */
    readonly messageStoragePolicy?: PubsubTopicMessageStoragePolicy;
    /**
     * schema_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_topic.html#schema_settings PubsubTopic#schema_settings}
     *
     * @stability stable
     */
    readonly schemaSettings?: PubsubTopicSchemaSettings;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_topic.html#timeouts PubsubTopic#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: PubsubTopicTimeouts;
}
/**
 * @stability stable
 */
export interface PubsubTopicMessageStoragePolicy {
    /**
     * A list of IDs of GCP regions where messages that are published to the topic may be persisted in storage.
     *
     * Messages published by
     * publishers running in non-allowed GCP regions (or running outside
     * of GCP altogether) will be routed for storage in one of the
     * allowed regions. An empty list means that no regions are allowed,
     * and is not a valid configuration.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_topic.html#allowed_persistence_regions PubsubTopic#allowed_persistence_regions}
     *
     * @stability stable
     */
    readonly allowedPersistenceRegions: string[];
}
export declare function pubsubTopicMessageStoragePolicyToTerraform(struct?: PubsubTopicMessageStoragePolicyOutputReference | PubsubTopicMessageStoragePolicy): any;
/**
 * @stability stable
 */
export declare class PubsubTopicMessageStoragePolicyOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PubsubTopicMessageStoragePolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PubsubTopicMessageStoragePolicy | undefined);
    private _allowedPersistenceRegions?;
    /**
     * @stability stable
     */
    get allowedPersistenceRegions(): string[];
    /**
     * @stability stable
     */
    set allowedPersistenceRegions(value: string[]);
    /**
     * @stability stable
     */
    get allowedPersistenceRegionsInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface PubsubTopicSchemaSettings {
    /**
     * The encoding of messages validated against schema. Default value: "ENCODING_UNSPECIFIED" Possible values: ["ENCODING_UNSPECIFIED", "JSON", "BINARY"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_topic.html#encoding PubsubTopic#encoding}
     *
     * @stability stable
     */
    readonly encoding?: string;
    /**
     * The name of the schema that messages published should be validated against.
     *
     * Format is projects/{project}/schemas/{schema}.
     * The value of this field will be _deleted-schema_
     * if the schema has been deleted.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_topic.html#schema PubsubTopic#schema}
     *
     * @stability stable
     */
    readonly schema: string;
}
export declare function pubsubTopicSchemaSettingsToTerraform(struct?: PubsubTopicSchemaSettingsOutputReference | PubsubTopicSchemaSettings): any;
/**
 * @stability stable
 */
export declare class PubsubTopicSchemaSettingsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PubsubTopicSchemaSettings | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PubsubTopicSchemaSettings | undefined);
    private _encoding?;
    /**
     * @stability stable
     */
    get encoding(): string;
    /**
     * @stability stable
     */
    set encoding(value: string);
    /**
     * @stability stable
     */
    resetEncoding(): void;
    /**
     * @stability stable
     */
    get encodingInput(): string | undefined;
    private _schema?;
    /**
     * @stability stable
     */
    get schema(): string;
    /**
     * @stability stable
     */
    set schema(value: string);
    /**
     * @stability stable
     */
    get schemaInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface PubsubTopicTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_topic.html#create PubsubTopic#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_topic.html#delete PubsubTopic#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_topic.html#update PubsubTopic#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function pubsubTopicTimeoutsToTerraform(struct?: PubsubTopicTimeoutsOutputReference | PubsubTopicTimeouts): any;
/**
 * @stability stable
 */
export declare class PubsubTopicTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PubsubTopicTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PubsubTopicTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/pubsub_topic.html google_pubsub_topic}.
 *
 * @stability stable
 */
export declare class PubsubTopic extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/pubsub_topic.html google_pubsub_topic} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: PubsubTopicConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _kmsKeyName?;
    /**
     * @stability stable
     */
    get kmsKeyName(): string;
    /**
     * @stability stable
     */
    set kmsKeyName(value: string);
    /**
     * @stability stable
     */
    resetKmsKeyName(): void;
    /**
     * @stability stable
     */
    get kmsKeyNameInput(): string | undefined;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _messageStoragePolicy;
    /**
     * @stability stable
     */
    get messageStoragePolicy(): PubsubTopicMessageStoragePolicyOutputReference;
    /**
     * @stability stable
     */
    putMessageStoragePolicy(value: PubsubTopicMessageStoragePolicy): void;
    /**
     * @stability stable
     */
    resetMessageStoragePolicy(): void;
    /**
     * @stability stable
     */
    get messageStoragePolicyInput(): PubsubTopicMessageStoragePolicy | undefined;
    private _schemaSettings;
    /**
     * @stability stable
     */
    get schemaSettings(): PubsubTopicSchemaSettingsOutputReference;
    /**
     * @stability stable
     */
    putSchemaSettings(value: PubsubTopicSchemaSettings): void;
    /**
     * @stability stable
     */
    resetSchemaSettings(): void;
    /**
     * @stability stable
     */
    get schemaSettingsInput(): PubsubTopicSchemaSettings | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): PubsubTopicTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: PubsubTopicTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): PubsubTopicTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
