import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ServiceNetworkingPeeredDnsDomainConfig extends cdktf.TerraformMetaArguments {
    /**
     * The DNS domain name suffix of the peered DNS domain.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_networking_peered_dns_domain.html#dns_suffix ServiceNetworkingPeeredDnsDomain#dns_suffix}
     *
     * @stability stable
     */
    readonly dnsSuffix: string;
    /**
     * Name of the peered DNS domain.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_networking_peered_dns_domain.html#name ServiceNetworkingPeeredDnsDomain#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Network in the consumer project to peer with.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_networking_peered_dns_domain.html#network ServiceNetworkingPeeredDnsDomain#network}
     *
     * @stability stable
     */
    readonly network: string;
    /**
     * The ID of the project that the service account will be created in. Defaults to the provider project configuration.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_networking_peered_dns_domain.html#project ServiceNetworkingPeeredDnsDomain#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The name of the service to create a peered DNS domain for, e.g. servicenetworking.googleapis.com.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_networking_peered_dns_domain.html#service ServiceNetworkingPeeredDnsDomain#service}
     *
     * @stability stable
     */
    readonly service?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_networking_peered_dns_domain.html#timeouts ServiceNetworkingPeeredDnsDomain#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ServiceNetworkingPeeredDnsDomainTimeouts;
}
/**
 * @stability stable
 */
export interface ServiceNetworkingPeeredDnsDomainTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_networking_peered_dns_domain.html#create ServiceNetworkingPeeredDnsDomain#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_networking_peered_dns_domain.html#delete ServiceNetworkingPeeredDnsDomain#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_networking_peered_dns_domain.html#read ServiceNetworkingPeeredDnsDomain#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function serviceNetworkingPeeredDnsDomainTimeoutsToTerraform(struct?: ServiceNetworkingPeeredDnsDomainTimeoutsOutputReference | ServiceNetworkingPeeredDnsDomainTimeouts): any;
/**
 * @stability stable
 */
export declare class ServiceNetworkingPeeredDnsDomainTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ServiceNetworkingPeeredDnsDomainTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ServiceNetworkingPeeredDnsDomainTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/service_networking_peered_dns_domain.html google_service_networking_peered_dns_domain}.
 *
 * @stability stable
 */
export declare class ServiceNetworkingPeeredDnsDomain extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/service_networking_peered_dns_domain.html google_service_networking_peered_dns_domain} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ServiceNetworkingPeeredDnsDomainConfig);
    private _dnsSuffix?;
    /**
     * @stability stable
     */
    get dnsSuffix(): string;
    /**
     * @stability stable
     */
    set dnsSuffix(value: string);
    /**
     * @stability stable
     */
    get dnsSuffixInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _network?;
    /**
     * @stability stable
     */
    get network(): string;
    /**
     * @stability stable
     */
    set network(value: string);
    /**
     * @stability stable
     */
    get networkInput(): string | undefined;
    /**
     * @stability stable
     */
    get parent(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _service?;
    /**
     * @stability stable
     */
    get service(): string;
    /**
     * @stability stable
     */
    set service(value: string);
    /**
     * @stability stable
     */
    resetService(): void;
    /**
     * @stability stable
     */
    get serviceInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ServiceNetworkingPeeredDnsDomainTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ServiceNetworkingPeeredDnsDomainTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ServiceNetworkingPeeredDnsDomainTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
