# -*- coding: utf-8 -*-
# Generated by Django 1.11.16 on 2019-04-01 09:45
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
        ('pymess', '0006_auto_20190322_1712'),
    ]

    operations = [
        migrations.CreateModel(
            name='DialerTemplateDisallowedObject',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created at')),
                ('changed_at', models.DateTimeField(auto_now=True, db_index=True, verbose_name='changed at')),
                ('object_id', models.TextField(verbose_name='ID of the related object')),
                ('object_id_int', models.PositiveIntegerField(blank=True, db_index=True, null=True, verbose_name='ID of the related object in int format')),
                ('content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType', verbose_name='content type of the related object')),
            ],
            options={
                'verbose_name': 'disallowed object of a dialer template',
                'verbose_name_plural': 'disallowed objects of dialer templates',
                'ordering': ('-created_at',),
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='EmailTemplateDisallowedObject',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created at')),
                ('changed_at', models.DateTimeField(auto_now=True, db_index=True, verbose_name='changed at')),
                ('object_id', models.TextField(verbose_name='ID of the related object')),
                ('object_id_int', models.PositiveIntegerField(blank=True, db_index=True, null=True, verbose_name='ID of the related object in int format')),
                ('content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType', verbose_name='content type of the related object')),
            ],
            options={
                'verbose_name': 'disallowed object of an e-mail template',
                'verbose_name_plural': 'disallowed objects of e-mail templates',
                'ordering': ('-created_at',),
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='SMSTemplateDisallowedObject',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created at')),
                ('changed_at', models.DateTimeField(auto_now=True, db_index=True, verbose_name='changed at')),
                ('object_id', models.TextField(verbose_name='ID of the related object')),
                ('object_id_int', models.PositiveIntegerField(blank=True, db_index=True, null=True, verbose_name='ID of the related object in int format')),
                ('content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType', verbose_name='content type of the related object')),
            ],
            options={
                'verbose_name': 'disallowed object of an SMS template',
                'verbose_name_plural': 'disallowed objects of SMS templates',
                'ordering': ('-created_at',),
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='smstemplatedisallowedobject',
            name='template',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='disallowed_objects', to='pymess.SMSTemplate', verbose_name='template', null=True, blank=True),
        ),
        migrations.AddField(
            model_name='emailtemplatedisallowedobject',
            name='template',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='disallowed_objects', to='pymess.EmailTemplate', verbose_name='template', null=True, blank=True),
        ),
        migrations.AddField(
            model_name='dialertemplatedisallowedobject',
            name='template',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='disallowed_objects', to='pymess.DialerTemplate', verbose_name='template', null=True, blank=True),
        ),
    ]
