import datetime
from typing import Any, List, Optional, Union, overload

from .colour import Colour
from .enums import ActivityType
from .http import (
    _ActivityAssetsDict,
    _ActivityDict,
    _ActivityPartyDict,
    _CustomActivityDict,
    _PartialEmojiDict,
    _SpotifyActivityDict,
    _TimestampsDict,
)
from .partial_emoji import PartialEmoji

class BaseActivity:
    @property
    def created_at(self) -> datetime.datetime: ...

class Activity(BaseActivity):
    application_id: int
    name: str
    url: str
    type: ActivityType
    state: str
    details: str
    timestamps: _TimestampsDict
    assets: _ActivityAssetsDict
    party: _ActivityPartyDict
    emoji: Optional[PartialEmoji]
    flags: int
    sync_id: Optional[str]
    session_id: Optional[str]
    def __init__(
        self,
        *,
        state: Optional[str] = ...,
        details: Optional[str] = ...,
        timestamps: _TimestampsDict = ...,
        assets: _ActivityAssetsDict = ...,
        party: _ActivityPartyDict = ...,
        application_id: Optional[Union[str, int]] = ...,
        name: Optional[str] = ...,
        url: Optional[str] = ...,
        flags: int = ...,
        sync_id: Optional[str] = ...,
        session_id: Optional[str] = ...,
        type: ActivityType = ...,
    ) -> None: ...
    def to_dict(self) -> _ActivityDict: ...
    @property
    def start(self) -> Optional[datetime.datetime]: ...
    @property
    def end(self) -> Optional[datetime.datetime]: ...
    @property
    def large_image_url(self) -> Optional[str]: ...
    @property
    def small_image_url(self) -> Optional[str]: ...
    @property
    def large_image_text(self) -> Optional[str]: ...
    @property
    def small_image_text(self) -> Optional[str]: ...

class Game(BaseActivity):
    name: str
    @overload
    def __init__(self, name: str, *, timestamps: _TimestampsDict) -> None: ...
    @overload
    def __init__(
        self,
        name: str,
        *,
        start: Optional[datetime.datetime] = ...,
        end: Optional[datetime.datetime] = ...,
    ) -> None: ...
    @property
    def type(self) -> ActivityType: ...
    @property
    def start(self) -> Optional[datetime.datetime]: ...
    @property
    def end(self) -> Optional[datetime.datetime]: ...
    def to_dict(self) -> _ActivityDict: ...
    def __eq__(self, other: Any) -> bool: ...
    def __ne__(self, other: Any) -> bool: ...
    def __hash__(self) -> int: ...

class Streaming(BaseActivity):
    platform: str
    name: str
    details: str
    game: Optional[str]
    url: str
    assets: _ActivityAssetsDict
    def __init__(
        self,
        *,
        name: str,
        url: str,
        details: Optional[str] = ...,
        assets: _ActivityAssetsDict = ...,
    ) -> None: ...
    @property
    def type(self) -> ActivityType: ...
    @property
    def twitch_name(self) -> Optional[str]: ...
    def to_dict(self) -> _ActivityDict: ...
    def __eq__(self, other: Any) -> bool: ...
    def __ne__(self, other: Any) -> bool: ...
    def __hash__(self) -> int: ...

class Spotify:
    @property
    def type(self) -> ActivityType: ...
    @property
    def created_at(self) -> datetime.datetime: ...
    @property
    def colour(self) -> Colour: ...
    @property
    def color(self) -> Colour: ...
    def to_dict(self) -> _SpotifyActivityDict: ...
    @property
    def name(self) -> str: ...
    def __eq__(self, other: Any) -> bool: ...
    def __ne__(self, other: Any) -> bool: ...
    def __hash__(self) -> int: ...
    @property
    def title(self) -> Optional[str]: ...
    @property
    def artists(self) -> List[str]: ...
    @property
    def artist(self) -> str: ...
    @property
    def album(self) -> str: ...
    @property
    def album_cover_url(self) -> str: ...
    @property
    def track_id(self) -> str: ...
    @property
    def start(self) -> datetime.datetime: ...
    @property
    def end(self) -> datetime.datetime: ...
    @property
    def duration(self) -> datetime.timedelta: ...
    @property
    def party_id(self) -> str: ...

class CustomActivity(BaseActivity):
    name: Optional[str]
    emoji: Optional[PartialEmoji]
    def __init__(
        self,
        name: Optional[str],
        *,
        emoji: Optional[Union[PartialEmoji, str, _PartialEmojiDict]] = ...,
        **extra: Any,
    ) -> None: ...
    @property
    def type(self) -> ActivityType: ...
    def to_dict(self) -> _CustomActivityDict: ...
    def __eq__(self, other: Any) -> bool: ...
    def __ne__(self, other: Any) -> bool: ...
    def __hash__(self) -> int: ...
