# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 9
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from isi_sdk_8_2_2.api_client import ApiClient


class NetworkApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_dnscache_flush_item(self, dnscache_flush_item, **kwargs):  # noqa: E501
        """create_dnscache_flush_item  # noqa: E501

        Flush the DNSCache.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_dnscache_flush_item(dnscache_flush_item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Empty dnscache_flush_item: (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_dnscache_flush_item_with_http_info(dnscache_flush_item, **kwargs)  # noqa: E501
        else:
            (data) = self.create_dnscache_flush_item_with_http_info(dnscache_flush_item, **kwargs)  # noqa: E501
            return data

    def create_dnscache_flush_item_with_http_info(self, dnscache_flush_item, **kwargs):  # noqa: E501
        """create_dnscache_flush_item  # noqa: E501

        Flush the DNSCache.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_dnscache_flush_item_with_http_info(dnscache_flush_item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Empty dnscache_flush_item: (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dnscache_flush_item']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_dnscache_flush_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'dnscache_flush_item' is set
        if ('dnscache_flush_item' not in params or
                params['dnscache_flush_item'] is None):
            raise ValueError("Missing the required parameter `dnscache_flush_item` when calling `create_dnscache_flush_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'dnscache_flush_item' in params:
            body_params = params['dnscache_flush_item']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/network/dnscache/flush', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_network_groupnet(self, network_groupnet, **kwargs):  # noqa: E501
        """create_network_groupnet  # noqa: E501

        Create a new groupnet.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_network_groupnet(network_groupnet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NetworkGroupnetCreateParams network_groupnet: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_network_groupnet_with_http_info(network_groupnet, **kwargs)  # noqa: E501
        else:
            (data) = self.create_network_groupnet_with_http_info(network_groupnet, **kwargs)  # noqa: E501
            return data

    def create_network_groupnet_with_http_info(self, network_groupnet, **kwargs):  # noqa: E501
        """create_network_groupnet  # noqa: E501

        Create a new groupnet.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_network_groupnet_with_http_info(network_groupnet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NetworkGroupnetCreateParams network_groupnet: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['network_groupnet']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_network_groupnet" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'network_groupnet' is set
        if ('network_groupnet' not in params or
                params['network_groupnet'] is None):
            raise ValueError("Missing the required parameter `network_groupnet` when calling `create_network_groupnet`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'network_groupnet' in params:
            body_params = params['network_groupnet']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/network/groupnets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_network_sc_rebalance_all_item(self, network_sc_rebalance_all_item, **kwargs):  # noqa: E501
        """create_network_sc_rebalance_all_item  # noqa: E501

        Rebalance IP addresses in all pools.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_network_sc_rebalance_all_item(network_sc_rebalance_all_item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Empty network_sc_rebalance_all_item: (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_network_sc_rebalance_all_item_with_http_info(network_sc_rebalance_all_item, **kwargs)  # noqa: E501
        else:
            (data) = self.create_network_sc_rebalance_all_item_with_http_info(network_sc_rebalance_all_item, **kwargs)  # noqa: E501
            return data

    def create_network_sc_rebalance_all_item_with_http_info(self, network_sc_rebalance_all_item, **kwargs):  # noqa: E501
        """create_network_sc_rebalance_all_item  # noqa: E501

        Rebalance IP addresses in all pools.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_network_sc_rebalance_all_item_with_http_info(network_sc_rebalance_all_item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Empty network_sc_rebalance_all_item: (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['network_sc_rebalance_all_item']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_network_sc_rebalance_all_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'network_sc_rebalance_all_item' is set
        if ('network_sc_rebalance_all_item' not in params or
                params['network_sc_rebalance_all_item'] is None):
            raise ValueError("Missing the required parameter `network_sc_rebalance_all_item` when calling `create_network_sc_rebalance_all_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'network_sc_rebalance_all_item' in params:
            body_params = params['network_sc_rebalance_all_item']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/network/sc-rebalance-all', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_network_groupnet(self, network_groupnet_id, **kwargs):  # noqa: E501
        """delete_network_groupnet  # noqa: E501

        Delete a network groupnet.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_network_groupnet(network_groupnet_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str network_groupnet_id: Delete a network groupnet. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_network_groupnet_with_http_info(network_groupnet_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_network_groupnet_with_http_info(network_groupnet_id, **kwargs)  # noqa: E501
            return data

    def delete_network_groupnet_with_http_info(self, network_groupnet_id, **kwargs):  # noqa: E501
        """delete_network_groupnet  # noqa: E501

        Delete a network groupnet.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_network_groupnet_with_http_info(network_groupnet_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str network_groupnet_id: Delete a network groupnet. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['network_groupnet_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_network_groupnet" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'network_groupnet_id' is set
        if ('network_groupnet_id' not in params or
                params['network_groupnet_id'] is None):
            raise ValueError("Missing the required parameter `network_groupnet_id` when calling `delete_network_groupnet`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'network_groupnet_id' in params:
            path_params['NetworkGroupnetId'] = params['network_groupnet_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/network/groupnets/{NetworkGroupnetId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_network_dnscache(self, **kwargs):  # noqa: E501
        """get_network_dnscache  # noqa: E501

        View network dns cache settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_network_dnscache(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: NetworkDnscache
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_network_dnscache_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_network_dnscache_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_network_dnscache_with_http_info(self, **kwargs):  # noqa: E501
        """get_network_dnscache  # noqa: E501

        View network dns cache settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_network_dnscache_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: NetworkDnscache
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_network_dnscache" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/network/dnscache', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NetworkDnscache',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_network_external(self, **kwargs):  # noqa: E501
        """get_network_external  # noqa: E501

        View external network settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_network_external(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: NetworkExternal
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_network_external_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_network_external_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_network_external_with_http_info(self, **kwargs):  # noqa: E501
        """get_network_external  # noqa: E501

        View external network settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_network_external_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: NetworkExternal
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_network_external" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/network/external', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NetworkExternal',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_network_groupnet(self, network_groupnet_id, **kwargs):  # noqa: E501
        """get_network_groupnet  # noqa: E501

        View a network groupnet.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_network_groupnet(network_groupnet_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str network_groupnet_id: View a network groupnet. (required)
        :return: NetworkGroupnets
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_network_groupnet_with_http_info(network_groupnet_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_network_groupnet_with_http_info(network_groupnet_id, **kwargs)  # noqa: E501
            return data

    def get_network_groupnet_with_http_info(self, network_groupnet_id, **kwargs):  # noqa: E501
        """get_network_groupnet  # noqa: E501

        View a network groupnet.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_network_groupnet_with_http_info(network_groupnet_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str network_groupnet_id: View a network groupnet. (required)
        :return: NetworkGroupnets
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['network_groupnet_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_network_groupnet" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'network_groupnet_id' is set
        if ('network_groupnet_id' not in params or
                params['network_groupnet_id'] is None):
            raise ValueError("Missing the required parameter `network_groupnet_id` when calling `get_network_groupnet`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'network_groupnet_id' in params:
            path_params['NetworkGroupnetId'] = params['network_groupnet_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/network/groupnets/{NetworkGroupnetId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NetworkGroupnets',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_network_interfaces(self, **kwargs):  # noqa: E501
        """get_network_interfaces  # noqa: E501

        Get a list of interfaces.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_network_interfaces(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param str network: Show interfaces associated with external and/or internal networks. Default is 'external'
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str lnns: Get a list of interfaces for the specified lnn.
        :param str alloc_method: Filter addresses and owners by pool address allocation method.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :return: PoolsPoolInterfaces
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_network_interfaces_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_network_interfaces_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_network_interfaces_with_http_info(self, **kwargs):  # noqa: E501
        """get_network_interfaces  # noqa: E501

        Get a list of interfaces.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_network_interfaces_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param str network: Show interfaces associated with external and/or internal networks. Default is 'external'
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str lnns: Get a list of interfaces for the specified lnn.
        :param str alloc_method: Filter addresses and owners by pool address allocation method.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :return: PoolsPoolInterfaces
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'network', 'resume', 'lnns', 'alloc_method', 'limit', 'dir']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_network_interfaces" % key
                )
            params[key] = val
        del params['kwargs']

        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `get_network_interfaces`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `get_network_interfaces`, length must be greater than or equal to `0`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `get_network_interfaces`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `get_network_interfaces`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_network_interfaces`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_network_interfaces`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `get_network_interfaces`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'network' in params:
            query_params.append(('network', params['network']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'lnns' in params:
            query_params.append(('lnns', params['lnns']))  # noqa: E501
        if 'alloc_method' in params:
            query_params.append(('alloc_method', params['alloc_method']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/network/interfaces', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PoolsPoolInterfaces',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_network_pools(self, **kwargs):  # noqa: E501
        """get_network_pools  # noqa: E501

        Get a list of flexnet pools.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_network_pools(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param str subnet: If specified, only pools for this subnet will be returned.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str access_zone: If specified, only pools with this zone name will be returned.
        :param str alloc_method: If specified, only pools with this allocation type will be returned.
        :param int limit: Return no more than this many results at once (see resume).
        :param str groupnet: If specified, only pools for this groupnet will be returned.
        :param str dir: The direction of the sort.
        :return: NetworkPools
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_network_pools_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_network_pools_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_network_pools_with_http_info(self, **kwargs):  # noqa: E501
        """get_network_pools  # noqa: E501

        Get a list of flexnet pools.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_network_pools_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param str subnet: If specified, only pools for this subnet will be returned.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str access_zone: If specified, only pools with this zone name will be returned.
        :param str alloc_method: If specified, only pools with this allocation type will be returned.
        :param int limit: Return no more than this many results at once (see resume).
        :param str groupnet: If specified, only pools for this groupnet will be returned.
        :param str dir: The direction of the sort.
        :return: NetworkPools
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'subnet', 'resume', 'access_zone', 'alloc_method', 'limit', 'groupnet', 'dir']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_network_pools" % key
                )
            params[key] = val
        del params['kwargs']

        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `get_network_pools`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `get_network_pools`, length must be greater than or equal to `0`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `get_network_pools`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `get_network_pools`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_network_pools`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_network_pools`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `get_network_pools`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'subnet' in params:
            query_params.append(('subnet', params['subnet']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'access_zone' in params:
            query_params.append(('access_zone', params['access_zone']))  # noqa: E501
        if 'alloc_method' in params:
            query_params.append(('alloc_method', params['alloc_method']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'groupnet' in params:
            query_params.append(('groupnet', params['groupnet']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/network/pools', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NetworkPools',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_network_rules(self, **kwargs):  # noqa: E501
        """get_network_rules  # noqa: E501

        Get a list of network rules.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_network_rules(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param str subnet: Name of the subnet to list rules from.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :param str groupnet: Name of the groupnet to list rules from.
        :param str pool: Name of the pool to list rules from.
        :return: PoolsPoolRulesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_network_rules_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_network_rules_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_network_rules_with_http_info(self, **kwargs):  # noqa: E501
        """get_network_rules  # noqa: E501

        Get a list of network rules.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_network_rules_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param str subnet: Name of the subnet to list rules from.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :param str groupnet: Name of the groupnet to list rules from.
        :param str pool: Name of the pool to list rules from.
        :return: PoolsPoolRulesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'subnet', 'resume', 'limit', 'dir', 'groupnet', 'pool']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_network_rules" % key
                )
            params[key] = val
        del params['kwargs']

        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `get_network_rules`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `get_network_rules`, length must be greater than or equal to `0`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `get_network_rules`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `get_network_rules`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_network_rules`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_network_rules`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `get_network_rules`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'subnet' in params:
            query_params.append(('subnet', params['subnet']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'groupnet' in params:
            query_params.append(('groupnet', params['groupnet']))  # noqa: E501
        if 'pool' in params:
            query_params.append(('pool', params['pool']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/network/rules', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PoolsPoolRulesExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_network_subnets(self, **kwargs):  # noqa: E501
        """get_network_subnets  # noqa: E501

        Get a list of subnets.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_network_subnets(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param str groupnet: If specified, only subnets for this groupnet will be returned.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: GroupnetSubnetsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_network_subnets_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_network_subnets_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_network_subnets_with_http_info(self, **kwargs):  # noqa: E501
        """get_network_subnets  # noqa: E501

        Get a list of subnets.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_network_subnets_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param str groupnet: If specified, only subnets for this groupnet will be returned.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: GroupnetSubnetsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'groupnet', 'limit', 'dir', 'resume']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_network_subnets" % key
                )
            params[key] = val
        del params['kwargs']

        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `get_network_subnets`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `get_network_subnets`, length must be greater than or equal to `0`")  # noqa: E501
        if ('groupnet' in params and
                len(params['groupnet']) > 32):
            raise ValueError("Invalid value for parameter `groupnet` when calling `get_network_subnets`, length must be less than or equal to `32`")  # noqa: E501
        if ('groupnet' in params and
                len(params['groupnet']) < 0):
            raise ValueError("Invalid value for parameter `groupnet` when calling `get_network_subnets`, length must be greater than or equal to `0`")  # noqa: E501
        if 'groupnet' in params and not re.search('(^[0-9a-zA-Z_-]*$|^~DEFAULT$)', params['groupnet']):  # noqa: E501
            raise ValueError("Invalid value for parameter `groupnet` when calling `get_network_subnets`, must conform to the pattern `/(^[0-9a-zA-Z_-]*$|^~DEFAULT$)/`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_network_subnets`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_network_subnets`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `get_network_subnets`, length must be greater than or equal to `0`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `get_network_subnets`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `get_network_subnets`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'groupnet' in params:
            query_params.append(('groupnet', params['groupnet']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/network/subnets', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GroupnetSubnetsExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_network_groupnets(self, **kwargs):  # noqa: E501
        """list_network_groupnets  # noqa: E501

        Get a list of groupnets.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_network_groupnets(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: NetworkGroupnetsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_network_groupnets_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_network_groupnets_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_network_groupnets_with_http_info(self, **kwargs):  # noqa: E501
        """list_network_groupnets  # noqa: E501

        Get a list of groupnets.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_network_groupnets_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: NetworkGroupnetsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'limit', 'dir', 'resume']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_network_groupnets" % key
                )
            params[key] = val
        del params['kwargs']

        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `list_network_groupnets`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `list_network_groupnets`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_network_groupnets`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_network_groupnets`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `list_network_groupnets`, length must be greater than or equal to `0`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_network_groupnets`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_network_groupnets`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/network/groupnets', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NetworkGroupnetsExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_network_dnscache(self, network_dnscache, **kwargs):  # noqa: E501
        """update_network_dnscache  # noqa: E501

        Modify network dns cache settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_network_dnscache(network_dnscache, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NetworkDnscacheExtended network_dnscache: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_network_dnscache_with_http_info(network_dnscache, **kwargs)  # noqa: E501
        else:
            (data) = self.update_network_dnscache_with_http_info(network_dnscache, **kwargs)  # noqa: E501
            return data

    def update_network_dnscache_with_http_info(self, network_dnscache, **kwargs):  # noqa: E501
        """update_network_dnscache  # noqa: E501

        Modify network dns cache settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_network_dnscache_with_http_info(network_dnscache, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NetworkDnscacheExtended network_dnscache: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['network_dnscache']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_network_dnscache" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'network_dnscache' is set
        if ('network_dnscache' not in params or
                params['network_dnscache'] is None):
            raise ValueError("Missing the required parameter `network_dnscache` when calling `update_network_dnscache`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'network_dnscache' in params:
            body_params = params['network_dnscache']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/network/dnscache', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_network_external(self, network_external, **kwargs):  # noqa: E501
        """update_network_external  # noqa: E501

        Modify external network settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_network_external(network_external, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NetworkExternalExtended network_external: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_network_external_with_http_info(network_external, **kwargs)  # noqa: E501
        else:
            (data) = self.update_network_external_with_http_info(network_external, **kwargs)  # noqa: E501
            return data

    def update_network_external_with_http_info(self, network_external, **kwargs):  # noqa: E501
        """update_network_external  # noqa: E501

        Modify external network settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_network_external_with_http_info(network_external, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NetworkExternalExtended network_external: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['network_external']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_network_external" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'network_external' is set
        if ('network_external' not in params or
                params['network_external'] is None):
            raise ValueError("Missing the required parameter `network_external` when calling `update_network_external`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'network_external' in params:
            body_params = params['network_external']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/network/external', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_network_groupnet(self, network_groupnet, network_groupnet_id, **kwargs):  # noqa: E501
        """update_network_groupnet  # noqa: E501

        Modify a network groupnet.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_network_groupnet(network_groupnet, network_groupnet_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NetworkGroupnet network_groupnet: (required)
        :param str network_groupnet_id: Modify a network groupnet. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_network_groupnet_with_http_info(network_groupnet, network_groupnet_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_network_groupnet_with_http_info(network_groupnet, network_groupnet_id, **kwargs)  # noqa: E501
            return data

    def update_network_groupnet_with_http_info(self, network_groupnet, network_groupnet_id, **kwargs):  # noqa: E501
        """update_network_groupnet  # noqa: E501

        Modify a network groupnet.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_network_groupnet_with_http_info(network_groupnet, network_groupnet_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NetworkGroupnet network_groupnet: (required)
        :param str network_groupnet_id: Modify a network groupnet. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['network_groupnet', 'network_groupnet_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_network_groupnet" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'network_groupnet' is set
        if ('network_groupnet' not in params or
                params['network_groupnet'] is None):
            raise ValueError("Missing the required parameter `network_groupnet` when calling `update_network_groupnet`")  # noqa: E501
        # verify the required parameter 'network_groupnet_id' is set
        if ('network_groupnet_id' not in params or
                params['network_groupnet_id'] is None):
            raise ValueError("Missing the required parameter `network_groupnet_id` when calling `update_network_groupnet`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'network_groupnet_id' in params:
            path_params['NetworkGroupnetId'] = params['network_groupnet_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'network_groupnet' in params:
            body_params = params['network_groupnet']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/network/groupnets/{NetworkGroupnetId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
