from typing import Any, Dict, List, Type, TypeVar, Union

import attr

from ..types import UNSET, Unset

T = TypeVar("T", bound="EndpointTransformationIn")


@attr.s(auto_attribs=True)
class EndpointTransformationIn:
    """
    Attributes:
        code (Union[Unset, None, str]):
        enabled (Union[Unset, bool]):
    """

    code: Union[Unset, None, str] = UNSET
    enabled: Union[Unset, bool] = False
    additional_properties: Dict[str, Any] = attr.ib(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        code = self.code
        enabled = self.enabled

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if code is not UNSET:
            field_dict["code"] = code
        if enabled is not UNSET:
            field_dict["enabled"] = enabled

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        dict_copy = src_dict.copy()
        code = dict_copy.pop("code", UNSET)

        enabled = dict_copy.pop("enabled", UNSET)

        endpoint_transformation_in = cls(
            code=code,
            enabled=enabled,
        )

        endpoint_transformation_in.additional_properties = dict_copy
        return endpoint_transformation_in

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
