# Supported Ops

This file was automatically generated by Vela using the `--supported-ops-report` parameter.  
Vela version: `2.0.0`

This file complies with
[**Gitiles Markdown syntax**](https://github.com/google/gitiles/blob/master/Documentation/markdown.md)

## Summary Table

The table below contains TFLite operators that can be placed on the Ethos-U NPU.  
If the constraints are not met, then that operator will be scheduled on the CPU instead.  
For any other TFLite operator not listed, will be left untouched and scheduled on the CPU.  
Please check the supported operator list for your chosen runtime for further information.

| Operator | Constraints |
| --- | --- |
| ABS | [Generic](#generic-constraints), [Specific](#abs-constraints) |
| ADD | [Generic](#generic-constraints), [Specific](#add-constraints) |
| AVERAGE_POOL_2D | [Generic](#generic-constraints), [Specific](#average_pool_2d-constraints) |
| CONCATENATION | [Generic](#generic-constraints), [Specific](#concatenation-constraints) |
| CONV_2D | [Generic](#generic-constraints), [Specific](#conv_2d-constraints) |
| DEPTHWISE_CONV_2D | [Generic](#generic-constraints), [Specific](#depthwise_conv_2d-constraints) |
| FULLY_CONNECTED | [Generic](#generic-constraints), [Specific](#fully_connected-constraints) |
| LEAKY_RELU | [Generic](#generic-constraints), [Specific](#leaky_relu-constraints) |
| LOGISTIC | [Generic](#generic-constraints) |
| MAXIMUM | [Generic](#generic-constraints), [Specific](#maximum-constraints) |
| MAX_POOL_2D | [Generic](#generic-constraints), [Specific](#max_pool_2d-constraints) |
| MINIMUM | [Generic](#generic-constraints), [Specific](#minimum-constraints) |
| MUL | [Generic](#generic-constraints), [Specific](#mul-constraints) |
| PACK | [Generic](#generic-constraints) |
| QUANTIZE | [Generic](#generic-constraints) |
| RELU | [Generic](#generic-constraints), [Specific](#relu-constraints) |
| RELU6 | [Generic](#generic-constraints), [Specific](#relu6-constraints) |
| RELU_N1_TO_1 | [Generic](#generic-constraints), [Specific](#relu_n1_to_1-constraints) |
| RESHAPE | [Generic](#generic-constraints) |
| RESIZE_BILINEAR | [Generic](#generic-constraints), [Specific](#resize_bilinear-constraints) |
| SLICE | [Generic](#generic-constraints) |
| SOFTMAX | [Generic](#generic-constraints), [Specific](#softmax-constraints) |
| SPLIT | [Generic](#generic-constraints) |
| SPLIT_V | [Generic](#generic-constraints), [Specific](#split_v-constraints) |
| SQUEEZE | [Generic](#generic-constraints) |
| STRIDED_SLICE | [Generic](#generic-constraints), [Specific](#strided_slice-constraints) |
| SUB | [Generic](#generic-constraints), [Specific](#sub-constraints) |
| TANH | [Generic](#generic-constraints) |
| TRANSPOSE_CONV | [Generic](#generic-constraints), [Specific](#transpose_conv-constraints) |
| UNPACK | [Generic](#generic-constraints) |

## Generic Constraints

This is a list of constraints that all NPU operators must satisfy in order to be scheduled on the NPU.

- Input(s) and Output tensors must not be dynamic
- Input(s) and Output tensors must have a defined shape
- Output tensors cannot be scalar
- Scalar Input tensors are only valid for op type: ADD, MAXIMUM, MINIMUM, MUL, SPLIT, SPLIT_V, SUB
- Input(s) and Output tensors must not be greater than 4D
- Tensors must be of type: int16, int32, int8, uint8
- Tensors which are int32 are only valid when op type is: ADD, MUL, SUB
- Tensor dimensions must be in the range [1, 65535]
- Input(s), Output and Weight tensors must have quantization parameters
- Input(s), Output and Weight tensors with quantization scales must be finite
- Per-axis quantization is only supported for the following op types: CONV_2D, DEPTHWISE_CONV_2D, TRANSPOSE_CONV
- The fused activation function (if present) must be one of type: LOGISTIC, RELU, RELU6, RELU_N1_TO_1, TANH

## ABS Constraints

This is a list of constraints that the ABS operator must satisfy in order to be scheduled on the NPU.

- Batch size must be 1 for Input tensors with more than 2 dimensions
- At least one Input's shape must match the OFM's shape
- IFM and OFM data types must match

## ADD Constraints

This is a list of constraints that the ADD operator must satisfy in order to be scheduled on the NPU.

- Batch size must be 1 for Input tensors with more than 2 dimensions
- At least one Input's shape must match the OFM's shape
- Both Input data types must match
- For IFM that are signed, OFM must also be signed
- For IFM that are unsigned, OFM must either be the same type or int32
- Broadcasting is only allowed for rank indices with dimension 1, from either IFM1 or IFM2

## AVERAGE_POOL_2D Constraints

This is a list of constraints that the AVERAGE_POOL_2D operator must satisfy in order to be scheduled on the NPU.

- IFM Tensor batch size must be 1
- Stride values for both width and height must be integer types
- Stride values for both width and height must be in the range [1, 3]
- IFM and OFM data types must match
- Kernel filter values for both width and height must be integer types
- Kernel filter values for both width and height must be in the range [1, 8]
- VALID padding: Kernel filter height must be in the range [1, 256]
- VALID padding: Product of kernel filter width and height must be in the range [1, 65536]

## CONCATENATION Constraints

This is a list of constraints that the CONCATENATION operator must satisfy in order to be scheduled on the NPU.

- Axis attribute must exist
- Axis attribute must be in the range [0, <ofm_dimensions>)
- All Input dimensionalities must match OFM dimensionality
- All Input dimensions must match OFM dimension in all axes except the one defined by the axis attribute

## CONV_2D Constraints

This is a list of constraints that the CONV_2D operator must satisfy in order to be scheduled on the NPU.

- Stride values for both width and height must be integer types
- Stride values for both width and height must be in the range [1, 3]
- Dilation factor values for both width and height must be integer types
- Dilation factor values for both width and height must be in the range [1, 2]
- Dilated kernel height must be in the range [1, 64]
- Product of dilated kernel width and height must be in the range [1, 4096]
- Weight tensor must be 8-bit
- Weight tensor must be constant
- The sum of the weights cannot exceed 8323072
- Optional Bias tensor must be of type: int32, int64
- Optional Bias tensor values must fit within 40-bits
- IFM Tensor batch size must be 1

## DEPTHWISE_CONV_2D Constraints

This is a list of constraints that the DEPTHWISE_CONV_2D operator must satisfy in order to be scheduled on the NPU.

- Stride values for both width and height must be integer types
- Stride values for both width and height must be in the range [1, 3]
- Dilation factor values for both width and height must be integer types
- Dilation factor values for both width and height must be in the range [1, 2]
- Dilated kernel height must be in the range [1, 64]
- Product of dilated kernel width and height must be in the range [1, 4096]
- Weight tensor must be 8-bit
- Weight tensor must be constant
- The sum of the weights cannot exceed 8323072
- Optional Bias tensor must be of type: int32, int64
- Optional Bias tensor values must fit within 40-bits
- IFM Tensor batch size must be 1
- For depth multipliers > 1, IFM channels must be 1 and OFM channels must be equal to the depth multiplier

## FULLY_CONNECTED Constraints

This is a list of constraints that the FULLY_CONNECTED operator must satisfy in order to be scheduled on the NPU.

- Weight tensor must be 8-bit
- Weight tensor must be constant
- Optional Bias tensor must be of type: int32, int64
- Optional Bias tensor values must fit within 40-bits
- The output tensor(s) must have 2D shape

## LEAKY_RELU Constraints

This is a list of constraints that the LEAKY_RELU operator must satisfy in order to be scheduled on the NPU.

- Batch size must be 1 for Input tensors with more than 2 dimensions
- At least one Input's shape must match the OFM's shape
- IFM and OFM data types must match
- Alpha must not be negative

## MAXIMUM Constraints

This is a list of constraints that the MAXIMUM operator must satisfy in order to be scheduled on the NPU.

- Batch size must be 1 for Input tensors with more than 2 dimensions
- At least one Input's shape must match the OFM's shape
- IFM and OFM data types must match
- Both Input quantization parameters must match OFM quantization parameters
- Broadcasting is only allowed for rank indices with dimension 1, from either IFM1 or IFM2

## MAX_POOL_2D Constraints

This is a list of constraints that the MAX_POOL_2D operator must satisfy in order to be scheduled on the NPU.

- IFM Tensor batch size must be 1
- Stride values for both width and height must be integer types
- Stride values for both width and height must be in the range [1, 3]
- IFM and OFM data types must match
- Kernel filter values for both width and height must be integer types
- Kernel filter height must be in the range [1, 256]
- Product of kernel filter width and height must be in the range [1, 65536]

## MINIMUM Constraints

This is a list of constraints that the MINIMUM operator must satisfy in order to be scheduled on the NPU.

- Batch size must be 1 for Input tensors with more than 2 dimensions
- At least one Input's shape must match the OFM's shape
- IFM and OFM data types must match
- Both Input quantization parameters must match OFM quantization parameters
- Broadcasting is only allowed for rank indices with dimension 1, from either IFM1 or IFM2

## MUL Constraints

This is a list of constraints that the MUL operator must satisfy in order to be scheduled on the NPU.

- Batch size must be 1 for Input tensors with more than 2 dimensions
- At least one Input's shape must match the OFM's shape
- Both Input data types must match
- For IFM that are signed, OFM must also be signed
- For IFM that are unsigned, OFM must either be the same type or int32
- Broadcasting is only allowed for rank indices with dimension 1, from either IFM1 or IFM2

## RELU Constraints

This is a list of constraints that the RELU operator must satisfy in order to be scheduled on the NPU.

- The IFM quantization scale divided by the OFM quantization scale must not be infinite

## RELU6 Constraints

This is a list of constraints that the RELU6 operator must satisfy in order to be scheduled on the NPU.

- The IFM quantization scale divided by the OFM quantization scale must not be infinite

## RELU_N1_TO_1 Constraints

This is a list of constraints that the RELU_N1_TO_1 operator must satisfy in order to be scheduled on the NPU.

- The IFM quantization scale divided by the OFM quantization scale must not be infinite

## RESIZE_BILINEAR Constraints

This is a list of constraints that the RESIZE_BILINEAR operator must satisfy in order to be scheduled on the NPU.

- The width and height of the IFM and OFM must match one of the following criteria:  
        IFM W and H must both be 1  
        IFM must match OFM  
        OFM W and H must be 2x IFM -1, if align_corners is True  
        OFM W and H must be 2x IFM, if align_corners is False

## SOFTMAX Constraints

This is a list of constraints that the SOFTMAX operator must satisfy in order to be scheduled on the NPU.

- IFM and OFM shapes must match
- IFM and OFM data types must match
- Beta value needs to be positive

## SPLIT_V Constraints

This is a list of constraints that the SPLIT_V operator must satisfy in order to be scheduled on the NPU.

- Only one size is allowed to be inferred

## STRIDED_SLICE Constraints

This is a list of constraints that the STRIDED_SLICE operator must satisfy in order to be scheduled on the NPU.

- Exactly 4 Input tensors are required
- Begin, End and Stride Input tensors must be constant
- All Strides values must be 1
- ellipsis_mask must be 0
- new_axis_mask and shrink_axis_mask cannot both be set
- Slice 'end' values must be greater than 'begin' values

## SUB Constraints

This is a list of constraints that the SUB operator must satisfy in order to be scheduled on the NPU.

- Batch size must be 1 for Input tensors with more than 2 dimensions
- At least one Input's shape must match the OFM's shape
- Both Input data types must match
- For IFM that are signed, OFM must also be signed
- For IFM that are unsigned, OFM must either be the same type or int32
- Broadcasting is only allowed for rank indices with dimension 1, from either IFM1 or IFM2

## TRANSPOSE_CONV Constraints

This is a list of constraints that the TRANSPOSE_CONV operator must satisfy in order to be scheduled on the NPU.

- Stride values for both width and height must be integer types
- Stride values for both width and height must be in the range [1, 3]
- Dilation factor values for both width and height must be integer types
- Dilation factor values for both width and height must be in the range [1, 2]
- Dilated kernel height must be in the range [1, 64]
- Product of dilated kernel width and height must be in the range [1, 4096]
- Weight tensor must be 8-bit
- Weight tensor must be constant
- The sum of the weights cannot exceed 8323072
- Optional Bias tensor must be of type: int32, int64
- Optional Bias tensor values must fit within 40-bits
- IFM Tensor batch size must be 1
- Stride values for both width and height must be 2
- SAME padding: OFM dimensions must equal IFM dimensions multiplied by stride
- VALID padding: OFM dimensions must equal IFM dimensions multiplied by stride,  
                  minus difference between kernel size and stride
