import numpy as np
import cv2

# To convert to bytes
# cv2.imencode('.jpg', cv2.imread("[FILENAME]", cv2.IMREAD_GRAYSCALE))[1].tostring()

LEVEL_HATCHED = cv2.imdecode(np.frombuffer(
    b'\xff\xd8\xff\xe0\x00\x10JFIF\x00\x01\x01\x00\x00\x01\x00\x01\x00\x00\xff\xdb\x00C\x00\x02\x01\x01\x01\x01\x01'
    b'\x02\x01\x01\x01\x02\x02\x02\x02\x02\x04\x03\x02\x02\x02\x02\x05\x04\x04\x03\x04\x06\x05\x06\x06\x06\x05\x06'
    b'\x06\x06\x07\t\x08\x06\x07\t\x07\x06\x06\x08\x0b\x08\t\n\n\n\n\n\x06\x08\x0b\x0c\x0b\n\x0c\t\n\n\n\xff\xc0\x00'
    b'\x0b\x08\x00!\x00$\x01\x01\x11\x00\xff\xc4\x00\x1f\x00\x00\x01\x05\x01\x01\x01\x01\x01\x01\x00\x00\x00\x00\x00'
    b'\x00\x00\x00\x01\x02\x03\x04\x05\x06\x07\x08\t\n\x0b\xff\xc4\x00\xb5\x10\x00\x02\x01\x03\x03\x02\x04\x03\x05'
    b'\x05\x04\x04\x00\x00\x01}\x01\x02\x03\x00\x04\x11\x05\x12!1A\x06\x13Qa\x07"q\x142\x81\x91\xa1\x08#B\xb1\xc1'
    b'\x15R\xd1\xf0$3br\x82\t\n\x16\x17\x18\x19\x1a%&\'('
    b')*456789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz\x83\x84\x85\x86\x87\x88\x89\x8a\x92\x93\x94\x95\x96\x97\x98\x99\x9a'
    b'\xa2\xa3\xa4\xa5\xa6\xa7\xa8\xa9\xaa\xb2\xb3\xb4\xb5\xb6\xb7\xb8\xb9\xba\xc2\xc3\xc4\xc5\xc6\xc7\xc8\xc9\xca'
    b'\xd2\xd3\xd4\xd5\xd6\xd7\xd8\xd9\xda\xe1\xe2\xe3\xe4\xe5\xe6\xe7\xe8\xe9\xea\xf1\xf2\xf3\xf4\xf5\xf6\xf7\xf8'
    b'\xf9\xfa\xff\xda\x00\x08\x01\x01\x00\x00?\x00\xf9?\xe0\xff\x00\x894_\x06|M\xf0\xc7\xc5O\x11\xf8\x0b\xfbw\xc3'
    b'\x9a\x17\x8a,\xce\xb9\xa6Ok\xe6\xdb\xb4or\xd8\x8eB\xc3i\x0c\x19@S\xc7\x00W\xe8\xe7\xfc\x14{'
    b'\xfe\t=\xe0\xbf\x8a\x1f\x0f\xc7\xc6\x0f\xd8\xdf\xe1\xe5\xbe\x99\xe2\xcf\xb4G!\xd1\xb4\x1bP\x96\x9a\xa5\xbb\xb2'
    b'\xa1\x0b\x17\x11\xc6x.\x0e:;\x9e\xe7<\x1f\xc4\x0f\xf8#N\xbf\xe2\xaf\xda\x7f\xe1\x96\x8d\xa3iwp|>\xb5\xf0u\xb7'
    b'\xfc&\xba\xea\xcd\x10\x92K\xd8%\x904A\x14\x02\xd3\xc8\xad\x18\xdd\xdd\xd6Np\xabY?\xf0W\xdf\x84\xdf\x02~\x00xw'
    b'\xe1\x7f\xec\xbd\xf0\x17\xe0%\xa5\xb6\xb1\xa84\xba\x98\xbc\xb0\xd3\x9aY\xe6\xb1\x8dDl\xaf(\x1ed\xb2\x17Ff,'
    b'N\xdc\x92+\xe1\x8d/T\xd0u\x18\r\xcd\xd6I\xc2\x05h\xee\x19A\x024\xec{'
    b'\xe79\xf7\xaf\xd6\x9f\xd8\x1f\xf6E\xfd\x9c\xfe>\xff\x00\xc194\xef\x0ex\xb3\xe1\xe5\xb5\x95\xa7\x8d4\xdbI\xbcD'
    b'\xb6Z\xca\\5\xc4\xf6\xeb\x1aEtv\x0f2)\x8c\xab\x92\x84\xfc\xb9\xdcj_\x81_\xf0U\x0f\x87\xbe)\xfd\xba\xbca\xfb\x13'
    b'?\x82!\xd0\xf4/\t\xdb5\x87\x85uW\x95\xd5\xe7\xba\xb3\x8d~\xd1\x0c\xc1\xb1\xb65\x8c\xb1\x86e\xc6\xf8c\x0cNgP'
    b';\x0f\x8d\xff\x00\xf0S\xcf\x84_\t\x7fg\xef\x1a\xfc`\xba\xd3\xae '
    b'\xd54KH\x9b@\xf0\xee\xa4\xe2\x1b\x8dV+\x8f6+IT\x98\x91\x84r\xbc2\x93\x10\xc6\xd1m '
    b'\xde\xa3k\x08?b\x7f\x13|7\xff\x00\x82\x87\xf8W\xc0\xff\x00\xf0P\x8f\x18\xf8\x15\xf4\xff\x00\x1b\xe8\xfa6\xa3'
    b'\xa1\xc3\x0c\x12\xb4v\xf0\\I#\x0b\xa3\x0cr,'
    b'\x9b\xd7;\x82\xb1a\xb5Xm"\xbf-?\xe0\xa5\xfaw\xc2\x8f\t\xfe\xd7\xfe$\xf8w\xf0\xc7\xc0Zo\x874\xef\x0c\x88t\xf7'
    b'\xb7\xd2\xf5\x9f:;\xa9v\xf9\xe6\xe1\x88\x18\x122\xcc\xa1\x97\xf8YJ\xf6\xaf\xa4\x7f\xe0\x8d_\x1b~2\xf8?\xf6\xa0'
    b'\xd1\xff\x00g\x93\xf1\x00\xb7\x82\xaf\xf4\xddJ\xf3\xfb\x16['
    b'fq\xf6\xbd\x86O1v\xff\x00\xaam\xa0\x82X6\xe1\xc1\x0c8>\xcb\xe3?\x8a_\xf0O\xef\x12~\xd0~!\xd6?l\x1b=\x1f\xe1\xe7'
    b'\xc4\xbb\x1f\x18j^\x1d\xd2%h\x1e\x0b\xe4\xd2\xd6\xd9\x11$\xbf$\xb2\xc7\x1d\xc9\xbc{'
    b'\xb4\x96`\x80\xa1\x85VI:H\xdf\x89z\xb7\xfc\x12j\x0f\x00\xe9\xdf\x0f\xbfh\xff\x00\xda\x8b\xc2\xde6\xd2\xae|Mg'
    b'\xf6+\x1d\x1a\xf6\x12\xb8O9!\x17i\x04\x8e\xe5\x02\xcd!iddE)\x1b3('
    b'PGa\xf1\x87\xf6\x93\xd7\xbc\x13\xff\x00\x04\xd9\xf1\xf7\xc4\x7f\x81\xfe+\xf0\xbf\x86a\xd2u\xbb\xcd/\xc0\xbe'
    b'!\xf0\xe1\x85,\xaf\xad\x96\xe5\xa2\xb6\x9a\xd0e\xa3\x95\xa7E\x8c!\x8d\xda-\xdfq\x8b\xf1_\x93\xb73\xc1\xe2\xed_Q'
    b'\xf1\x8f\x8e<O=\xc6\xa7\xac\xea\x12\xea7\x97\t\xa8\xf9&I\'o9\xd9\x95x\xc9w~}1]\x84\xd2\xf8\xaf\xc2>)\xd3~ '
    b'\xf87Q\x92\xcf^\xd1.\xe3\xbb\xb3\xb9\x89~tt '
    b'\xa9V\xea\x1b\x80\x05}W\xe3\xdf\x01|\x0c\xff\x00\x82\xc2\xf8\x13D\xf1O\x86\xfcI\xe1\xef\x08|x\xd1\xecc\xb5\xd5'
    b'\xacu\xc6\x10X\xeb\xfe[K\xf3\xa8\xe3n7\xbe\x0f\xdebB\x1f\x96\x14\xc7\x19\xf0\xcf\xfe\x08\xd7\xe3\xbf\r\xea\x8b'
    b'\xe3\xff\x00\xdb\xab\xc6\x9e\x15\xf0o\x80\xb49U\xef\x02\xea,'
    b'\x977\xec\x89\xbc\xaa4h\x18n\x03n\xf3\x86\x06\x06m\xa9\xbb}r\x1f\xb7\x87\xed{'
    b'\xa4~\xd4\xbe!\xd1\xfe\x11|\x1c\xd0b\xf0\xe7\xc2\xdf\x03\x17\x83\xc3\x16P\xdb\xac^j\x01\xf6qvv\x01\xb3z\x92\x88'
    b'\x83\xfb\xdc\xf0Mx\x92\xe9v\xb7(\xaeexv\xa2\xa0\x8e3\xb4\x00\xa0(\xe0{'
    b'\x01^\x8f\xab\xff\x00\xc7\xad\xcf\xd1\x7f\x95r~\x01\xff\x00\x93\x8d\x83\xfe\xc6\xbb\xef\xfd%\xafF\xfd\xb1\x7f'
    b'\xe4\x8b\\\x7f\xd8sM\xff\x00\xd0\xe5\xaf\x14\xf0\xa7\xfcx\xc7\xff\x00]/\xff\x00\x95j\\\x7f\xac\xff\x00\x80\x8f'
    b'\xe5_\xff\xd9', np.uint8), cv2.IMREAD_GRAYSCALE)

LEVEL_MASK_HATCHED = cv2.imdecode(np.frombuffer(
    b'\xff\xd8\xff\xe0\x00\x10JFIF\x00\x01\x01\x00\x00\x01\x00\x01\x00\x00\xff\xdb\x00C\x00\x02\x01\x01\x01\x01\x01'
    b'\x02\x01\x01\x01\x02\x02\x02\x02\x02\x04\x03\x02\x02\x02\x02\x05\x04\x04\x03\x04\x06\x05\x06\x06\x06\x05\x06'
    b'\x06\x06\x07\t\x08\x06\x07\t\x07\x06\x06\x08\x0b\x08\t\n\n\n\n\n\x06\x08\x0b\x0c\x0b\n\x0c\t\n\n\n\xff\xc0\x00'
    b'\x0b\x08\x00!\x00$\x01\x01\x11\x00\xff\xc4\x00\x1f\x00\x00\x01\x05\x01\x01\x01\x01\x01\x01\x00\x00\x00\x00\x00'
    b'\x00\x00\x00\x01\x02\x03\x04\x05\x06\x07\x08\t\n\x0b\xff\xc4\x00\xb5\x10\x00\x02\x01\x03\x03\x02\x04\x03\x05'
    b'\x05\x04\x04\x00\x00\x01}\x01\x02\x03\x00\x04\x11\x05\x12!1A\x06\x13Qa\x07"q\x142\x81\x91\xa1\x08#B\xb1\xc1'
    b'\x15R\xd1\xf0$3br\x82\t\n\x16\x17\x18\x19\x1a%&\'('
    b')*456789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz\x83\x84\x85\x86\x87\x88\x89\x8a\x92\x93\x94\x95\x96\x97\x98\x99\x9a'
    b'\xa2\xa3\xa4\xa5\xa6\xa7\xa8\xa9\xaa\xb2\xb3\xb4\xb5\xb6\xb7\xb8\xb9\xba\xc2\xc3\xc4\xc5\xc6\xc7\xc8\xc9\xca'
    b'\xd2\xd3\xd4\xd5\xd6\xd7\xd8\xd9\xda\xe1\xe2\xe3\xe4\xe5\xe6\xe7\xe8\xe9\xea\xf1\xf2\xf3\xf4\xf5\xf6\xf7\xf8'
    b'\xf9\xfa\xff\xda\x00\x08\x01\x01\x00\x00?\x00\xf9;\xfe\re\xfd\x8b\xff\x00i\xfdS\xf6\xfd\xf8i\xff\x00\x05\x16'
    b'\xd1~\x10j\x1a\x87\xc1\xdf\x05\xf8\xc3W\xf0\xbf\x89\xbcW\xa6O\r\xcc\x96:\x9d\xe6\x87-\xa4\x11\x9b\x18\x9d\xaf'
    b'\x1a/7U\xb12\\,-\x04\x11\xc8\xf3K$qC4\x91\xff\x00A\xdf\xf0R\x7f\xf8#\xff\x00\xec;\xff\x00\x05R\xf0 '
    b'\xf0\xcf\xed3\xf0\xdb\xec\xde \xb6\xfb*\xe9?\x11\xfc-\x15\xb5\xaf\x894\xd8`\x96I\x05\xb4W\x92C.\xfbf\xf3\xee'
    b'\x03[J\x92C\x99\xda@\x8b*\xc7*y\xff\x00\xc7/\xf87\xcb\xfe\t\x95\xf1\xc7\xf6\x8e\xf8S\xf1\xae\xe7\xf6_\xf8\x7f'
    b'\xe1\xaf\x0f\xfc2\xfe\xd5\xba\xbe\xf0\x07\x83\xfc\x05\xa7\xe9v\x1e.\xbf\xb8k\x13f\xfa\xa1\xb6\x8d>\xd5mk\xf6i'
    b'\xd8Z\xba\x95\x95\xae@v\xf2\x84\xd0\\s\xff\x00\xf0sv\x8b\xf1O\xe2\x07\xfc\x12\x17\xc7\x1f\x02\xfe\n~\xcf\xff'
    b'\x00\x10>"\xf8\x9f\xc7\xfe \xd0\xb4\xad3K\xf8{'
    b'\xe1I\xf5y\xac\xbc\x8dJ\x1dNK\xbb\xa8\xa0\x06H\xed\x84Z|\x91y\x8a\xaf\x89\xa7\x81H\x01\xcb/\xf2%\xe2\xcf\t\xf8'
    b'\xab\xc0^*\xd4\xfc\x0b\xe3\xaf\x0c\xea\x1a.\xb7\xa2\xea\x13Xk:6\xadd\xf6\xd7V\x17P\xb9\x8e['
    b'y\xa2\x90\x07\x8aTudd`\x19YH \x11_\xdeg\xc2\xdf\x84\xff\x00\x0b>\x07x\x12\xc7\xe1o\xc1O\x86\x9e\x1f\xf0\x7f'
    b'\x864\xbf7\xfb3\xc3\x9e\x16\xd1\xa0\xd3\xec-<\xc9^i<\xabx\x11#\x8f|\xb2I#mQ\xb9\x9d\x98\xe4\x92k\xa0\xa2\x8a'
    b'\xfc\xb0\xff\x00\x82\xc9\x7f\xc1C?\xe0\x86\xbf\xb0_\xedqm\xe0_\xdb\xdb\xfe\t\xa1\xa7\xfcJ\xf8\x85\xe2\xef\x07'
    b'\xd9x\x92\xe7\xc5\xb6_\x06\xbc3\xac\xc9sje\xb8\xb0\x85\'\xba\xd4n"\x9d\xe5A\xa7\x94\x00\x86U\x8cD\x03q\xb5x\x0f'
    b'\xf84s\xfe\n\xa7\xf1\x97\xf6\xc5\xf85\xe2_\xd8\xb3\xe3\xef\x88\xfc\x1e\xf2\xfc\x11\xf0\x7f\x87\xec\xbe\x1c\xad'
    b'\x94\x02\xd7Y\xd4\xb4e7\x96\xf2\xb4\xf1\x89v\\Ef\x91\xe9\x96\xc2h\xa1B\xa2X\xbc\xf6\x92Y\x83\xb7\xecu\x15\x9f'
    b'\xe2\xcbo\x15^xWS\xb3\xf0.\xb3\xa7\xe9\xda\xdc\xba|\xc9\xa3j\x1a\xb6\x98\xf7\xb6\xb6\xb7E\x08\x8aY\xad\xe3\x9a'
    b'\x07\x9e%}\xac\xd1,\xd13\xa8*$Bw\x0f\xe2\x0f\xfe\n\x1d\xff\x00\x05\x02\xf8\xfb\xff\x00\x054\xfd\xa85_\xda\xb7'
    b'\xf6\x8c\x9fO\x8b[\xd4t\xfb;\x0b]\x1bCk\xa5\xd34\x9b['
    b'hV5\xb7\xb3\x8a\xeay\xde\x08\x99\xfc\xdb\x87@\xe5L\xf73\xc9\x80d5\x7f\xfe\t\x8b\xff\x00\x05\x0b\xf8\xa7\xff\x00'
    b'\x04\xbe\xfd\xb2|/\xfb\\\xfc-\xd3?\xb5\xff\x00\xb2<\xeb?\x11\xf8ZmV{'
    b'Ko\x10iW\t\xb2\xe2\xcag\x84\xff\x00\xb94L\xeb*Gqoo3E/\x94\x10\xff\x00O\xdf\x1d>\x05\xff\x00\xc18\xff\x00\xe0'
    b'\xe8\x1f\xf8\'\x1e\x97\xe3_\x05x\xa7\xfe{'
    b'\xbf\x83|e\x15\x8c\x7f\xdb\xbf\x0f\xf5\xdf.?\xb4Y]\xdb\x87\xff\x00\xae+sfd\xf2\xaeb\xf2f\x8aO\xf8\xf4\xbbO\x1f'
    b'\xff\x00\x82Q\xff\x00\xc1\xa9\x1f\xb3\x8f\xfc\x13\xbb\xf6\x8e\x8b\xf6\xa0\xf8\xd7\xf1\xc3\xfe\x17O\x884\x0f&o'
    b'\x00Y_x-t\x9b\r\x06\xfdY\x89\xd4\x1e\x13wu\xf6\xab\x94\xc4~C1E\xb7`\xd2\x84yD\x12A\xf3\x87\xfc\x1da\xff\x00\x05'
    b'\xda\xf0\xaa\xf8WW\xff\x00\x82Z~\xc6\xbf\x135\x07\xd6\xdfPk_\x8d\xde)\xf0\xf5\xf2%\xac\x16\xaa\x92G7\x86D\x81K'
    b'\xcb+\xbb!\xbb1:,k\t\xb4s)\x9a\xee\x18\x7f\x9f\x1a+\xf5\xfb\xfe\x0c\xa9\xff\x00\x94\xa6\xf8\xfb\xfe\xcd\xff'
    b'\x00U\xff\x00\xd3\xe6\x87_\xbf\xff\x00\xf0V/\xf9E\x97\xed-\xff\x00f\xff\x00\xe3/\xfd1\xdeW\xf1\x05E\x7f\xff\xd9 '
    , np.uint8), cv2.IMREAD_GRAYSCALE)

LEVEL_EGG = cv2.imdecode(np.frombuffer(
    b'\xff\xd8\xff\xe0\x00\x10JFIF\x00\x01\x01\x00\x00\x01\x00\x01\x00\x00\xff\xdb\x00C\x00\x02\x01\x01\x01\x01\x01'
    b'\x02\x01\x01\x01\x02\x02\x02\x02\x02\x04\x03\x02\x02\x02\x02\x05\x04\x04\x03\x04\x06\x05\x06\x06\x06\x05\x06'
    b'\x06\x06\x07\t\x08\x06\x07\t\x07\x06\x06\x08\x0b\x08\t\n\n\n\n\n\x06\x08\x0b\x0c\x0b\n\x0c\t\n\n\n\xff\xc0\x00'
    b'\x0b\x08\x003\x007\x01\x01\x11\x00\xff\xc4\x00\x1f\x00\x00\x01\x05\x01\x01\x01\x01\x01\x01\x00\x00\x00\x00\x00'
    b'\x00\x00\x00\x01\x02\x03\x04\x05\x06\x07\x08\t\n\x0b\xff\xc4\x00\xb5\x10\x00\x02\x01\x03\x03\x02\x04\x03\x05'
    b'\x05\x04\x04\x00\x00\x01}\x01\x02\x03\x00\x04\x11\x05\x12!1A\x06\x13Qa\x07"q\x142\x81\x91\xa1\x08#B\xb1\xc1'
    b'\x15R\xd1\xf0$3br\x82\t\n\x16\x17\x18\x19\x1a%&\'('
    b')*456789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz\x83\x84\x85\x86\x87\x88\x89\x8a\x92\x93\x94\x95\x96\x97\x98\x99\x9a'
    b'\xa2\xa3\xa4\xa5\xa6\xa7\xa8\xa9\xaa\xb2\xb3\xb4\xb5\xb6\xb7\xb8\xb9\xba\xc2\xc3\xc4\xc5\xc6\xc7\xc8\xc9\xca'
    b'\xd2\xd3\xd4\xd5\xd6\xd7\xd8\xd9\xda\xe1\xe2\xe3\xe4\xe5\xe6\xe7\xe8\xe9\xea\xf1\xf2\xf3\xf4\xf5\xf6\xf7\xf8'
    b'\xf9\xfa\xff\xda\x00\x08\x01\x01\x00\x00?\x00\xf9\x03\xe1U\xcc\x9f\xdb\xd7\xa1"\x0e\xcd\xa2\\67m-\xb9#\xf9s\xd0'
    b'\x0fC\xdb5\xfa\xad\xff\x00\x04\xd9\xff\x00\x82c\xff\x00\xc1=\xff\x00n\xbf\xf8\'\xaf\x84\xbc['
    b's\xa7jW\x1e"\x11O\x0f\x88<Aitb\xbaML`H\x9e[\x06\x06$,'
    b'\n\xe7\x92\x07$\xd7\xc3?\xf0So\xf8&\x97\xc4\x9f\xf8\'g\x8d\xac\xa3\x97Z\x93]\xf0n\xac\xf2\x1d\x03^kP\xa1\x1b'
    b'\xb43\x92x~\x80p3[\xdf\xb4\xbf\xfc\x132\xfb\xf6}\xff\x00\x82z|6\xfd\xb3\xed\xaf\xef\'\xbf\xf14\x91\xbf\x88\xac'
    b'\xde_6\x0b{{\xa8\xe4\x9a\xcaQ\x85\x18W\x8d\x00f\'\xe4i\x14W_\xff\x00\x04\xae\xff\x00\x82<x\xbf\xf6\xe4\xd2'
    b'?\xe1s\xfcd\xbe\xd4\xb4/\x00\xc7/\x95\xa4\x9bx\xd5&\xd6YO\xcc\xd13n\xd9\x19\xfb\xa1\x88<\xf3\xcfJ\xf6\x7f\xf8'
    b'-\x0f\xecW\xfb\x13~\xc7_\x00\xfc\x0b\xa2|\x1e\xd0\x9bL\xf1m\xd6\xb92X\x83zZ}F\xc9a\xc4\xf2K\xd8\x88\xdf\xc8\x03'
    b'\x00\x02d<r1\xf9\xd5gq<1bT\x00v\xaf\xa7\x7f\xe0\x9b\x1f\xf0J\x0f\x89\x1f\xb4\xff\x00\xc4\x8d['
    b'O\xf8\x91s\xabx3F>\x11y\xf4\xfb\xe9\xf4\xb2\xd2_\xac\xc4$O\x119B\x80\x00X\x93\x9cg\x81_V\xff\x00\xc1\xba\xfe'
    b'\x15\xf8\xd5\xf0?\xe2\x97\xc6\xbf\xd9\xab\xc7\xfe\x06\xd5\xedt\xed\x0fR\x82i\xf5+\xdbS\x1c"\xf47\x95\xe4\xa1'
    b'-\x8c\xbcj\x1c\x80:\x9ex\xe2\xbfJ\xbe1\xfc\x0e\xf8I\xfb@\xf8@\xf8\x03\xe3g\xc3\xdb\x0f\x11h\xf2M\x1d\xc3\xd8'
    b'\xeaV\xe1\xd0\xca\xad\xf2\xb7\xcar\x18\x11\xc1\x04~4\xef\x1f|\x02\xf8K\xf1;\xe1<\xdf\x03\xfcq\xe0K\rC\xc2'
    b'\x976qZI\xa1\xcd\x0e \xf2c*c\x8fj\xe3\n\xac\x88@\x18\xfb\xa3\xb7\x15\xa3\xe0\x8f\x02x+\xe1\xcf\x84\xec\xbc\x1f'
    b'\xe0\x8f\x0f\xda\xe9:6\x9bl \xb2\xb1\xb5\x8dR+hG\x020\x00\xe0g\x9f_z\xfc\x91\xff\x00\x82\x97\xfe\xce\xdf\x14'
    b'\xbfn\xef\xf8,~\x85\xf0\x19\xec5\x9d\'J\xb3\xf0M\x9c0\xea\x13Z\x13\x12['
    b'\xf9\xb3Ouu\x11?+\x16\xcck\x8e2m@\xeb\xb8/\xcb\x7f\xb5\xc7\xfc\x13\xff\x00\xe3w\xec\xbb\xf1\x13\xc4\xba"xC]\xd6'
    b'|\x1b\xa0jQ\xc0\xbe6M._\xb2\xb2J\xbf\xbb\xdc\xd1\xa3\x8d\xdb\xf1\x19\xc7\x1b\x88\xaf\xd8\x9f\xf8$\x17\x8a\xfc'
    b']\xe3\x8f\xd83\xc1z\x97\x8c\xbcU\xa3\xeak\x1d\xabAe\x0e\x91b\xf0\xbd\xb4\x111\x88E>\xe9\x9f|\x81\x95\x9c\xb0'
    b'\xda6\xb2ax\xe5\xdf\xf0V\x0f\xda\x8f\xc4\x9f\xb0\x9f\xecE\xe3\x0f\x8f\xbf\x0b<?h\xde)\x91\xad\xec4\xfb\x9f\xb2'
    b'\xa6\xd8\xef\xae\x9b\xc9[\xa9\x97\x1f:\xa6A$\xf4\x00\xf3_"\x7f\xc1\xbf\xff\x00\xf0VO\x8a\xff\x00\x1d\xa3\xf1'
    b'\x17\xec\xcb\xfb_x\xecj\xfe#\xf0\xf6\x9f/\x884\xaf\x17_\xb2['
    b'\xb5\xcd\x89`e\x82p\x88\x91\xa1\x8b\xcc\x8d\x81\xfe\xe3r\tRk\xeao\x86\x1f\xf0S\xdf\x07\xf8\xcb\xe3f\x9b\xa0\xea'
    b'\x9e"\xd1"\xf0\x87\x8b\xef\xee\xf4\xbf\n\xdd\x84\x9e+\xe8.\xed\xe4\x08%\xbcW;b\x82\xe0\x9d\xb0\x92\x10\xee1\x8c'
    b'\xbf\x9a1\xf0?\xfc\x15\xe3\xfe\x0b\x87\xfbH\xf8\x07\xf6\xdc\xb6\xf8G\xfb%x\xae=\x1bE\xf8Y\xab\x04\xf10\xe1\xc7'
    b'\x88o\xd1\xb1ui*\xb2aa\x8d\x83C\xc1\xce\xf5g\xc9R\x05~\xb7|\x02\xf1\xcf\x85\xbe6\xfc$\xf0\x8f\xc7m+\xc3\xd0\xd9'
    b'\xcd\xe2o\x0e\xdb^\xa9\x9e &\x83\xcf\x89]\xad\x8b\x91\xb8l('
    b'\xa0\x81\x80Lc\xa6+\xe2_\xf88\x9f\xc7\x1f\x14\xfc\x1d\xfb-i\xfa\x7f\x84\xfe$\xe8Z~\x93\xab\xf8\xa6\xd6\x1dWB'
    b'\xbb\xd1Q\xef\xae\x17d\x93#\xa4\xac\xec\x82%\x92!\xb84%\x8bc\x0e\x07\x15\xf9\x93\xff\x00\x04\xe8\xff\x00\x82'
    b'\xaf~\xd4\x1f\xb0\x9e\xa5i\xf0\x83\xe0\xcf\xc3\x0f\x0c\xf8\xbbK\xf1o\x8a\xac\xa6\xb9\xb0\xd6n\xee#\x9e)\xa5d'
    b'\xb7h\xe0up\x8a\xd2)\x18\x18\xc6\xfd\xa7\xa7\x15\xfb\xa7\xfb~\xfcq\xf8_\xf0\x87\xf6A\xd5<\x7f\xf1\xf7\xe1L'
    b'~%\xd3\xafE\xa5\x9c\xde\x0e\x95\x16Suwr\xc9\x1cv\xe4\x91\x8f\xbc\xe1w\xf6\xceq_?i?\xf0AO\xd9\x97\xe1\xf7\xc6'
    b'\x9b\xbf\x8b\x1f\x04|O\xa9\xf8r\xcfR\xd0/l\xef<2\xec\xf3\xdb4\xb7\x10\xba\x19\x94;o\nZI\x1bi\xdc0\xa0\x01\xd3'
    b'\x1a6\xff\x00\xb0W\xc6\x8f\x13\xe9\xfaO\xc0\xdds\xe1\xe7\x86\xec|\x1d\xa3j\x16\x0b\x1e\xae|T/H\x86\xceA"f\x1f'
    b'\xb2G<\xe4\xae\xe5\x8f\xcd\x9d\xfc\xb7`N\xed\x8b\xb7\x89\xf8\xb7\xff\x00\x04\x9f\xfd\x8f\x7fc}\x13\xe2\x97\xed'
    b'\xfb\xf1\xa3\xc1\xda\x97\xc5\x8dSG7\x9e#\x8b\xc3wW_g\x84\xf9{'
    b'\xe5H\x95\x01"G\xda\xc3$\xf0q\x92\xa7\x9c\xfdg\xe3\xef\xdaN?\t\xfe\xc2w\xbf\xb5\'\xc1\xbf\tY_-\xb7\x80c\xd7'
    b'\xb4M"yV(H{q"#4c\x03fX6\xdc\x1f\x95\xb1\x8e+\xf0\x1f\xf6\x89\xfd\xb5~4\x7f\xc1B\xbe\'\xc3\xf1\xbb\xe3\xc7\x83t'
    b'}\x1fS\xd34u\xd3\xact\xbf\x0c\xcf+Bc2\xb3\x99X;\x90\\\x93\x8c\x9e\xdd\xbb\xd7\xceZ?\x8a<A\xe1}oO\xf1\x17\x84'
    b'\xb5\x06\xb6\xd4t\xcb\xe8/4\xfb\x822\x12\xe6\x19\x04\x91HW!N\xd7U8\xe0q_\xbd_\x07~9\xfc9\xff\x00\x82\xed\x7f'
    b'\xc19\xaf|\x15\x06\xa1\xa6\xe9>?\xd2\xe3\xb6\x9fV\xd1\x1ea0\xd3u\x9bW\x12Ap\xeaFd\x82I\x11>S\x8c\x02A\xdc\x07'
    b'?\x94\x7f\xb4g\xfc\x14?\xfe\n\xd9\xe0\x1f\xdb\x1fW\xf1\xcf\xc5\x1f\x8c\xda\x9f\x83<y\xe1\xc8\x97D\xd4<=\xa6'
    b'\'\x95\xa6\x8bx\xa4\xf3\x15<\x95\xf9\'\x8eC\x99L\x8a0\xc8\xc0\x8c\x05en\xbb]\xff\x00\x83\x8c\xbf\xe0\xabZ\xbf'
    b'\x86\x07\x87\xac\xbcI\xe0\xbb\x19e\xb70\xcd\xac.\x88\xb1\xb9P1\xb9I8\x8c\xf7\xdd\x8a\x87\xfe\t\xe7\xf1K\xfe\ny'
    b'\xfb]\xfcQ\xf1\x7f\xec\xd5\xe1\xbf\x8b\x9a\x87\x89\xf4\xcf\x8b6\xc5>$j~*\x8ft:u\xa8\x0c\xadz\xb8\xe2\xdc\x94b'
    b'\x15\x10|\xdb\x17*{\xfe\x81\x7f\xc1Z\x7fm\xef\x85\x7f\xf0N\x7f\xd9\x0bK\xff\x00\x82z|\x05\xd5!\xbb\xf1\xa6\xad'
    b'\xe1\xa4\xd3#\xb2g\x0e\xdav\x96F\xc9\xef\'@\xd9\x88\xc9\xf3\x88\xd7<\xeev\x00\xa8\x0c\x7f&\xbe\x14\xe9-}\xa5'
    b'\xde\x9f\xbeb\xc0s)\xdc\xaeC\xe3\'\xbey=\ry\r\xda#\x83\xb5pq\xc0\xc0\xc7\xea1^\xaf\xfb\x11\xfco\xf8\xd9\xfb.|r'
    b'\x1f\x1d\xbfg\xaf\x15\x9d;Y\xd3a\x0b{m";Y\xeb\x16\xc3\x93kv\x14\x8f1x '
    b'1\xf9\x939\x04b\xbfS!\xf1\x8f\xfc\x13\x1b\xfe\x0e\x00\xf0-\x8d\xa7\x8d\xb54\xf8o\xf1\xafE&\xdb\xc8\x96h\xa3\xd4'
    b'\xe2q\x90\xd1\xc6$\xc2\xdd\xdb\xee\x04\x85\xf9eQ\x16\x0e\x14\xb6|\xf3F\xff\x00\x83\\o\xa2\xf1"\\\xf8\xa3\xf6'
    b'\xc0\xb2m\x061\xbc\xdc[he\xa5\x99Kt\xdb$\xdb\x10\xe3\xaew\x03\xe9]\'\xed\x0b\xff\x00\x05\x03\xfd\x85?\xe0\x8c'
    b'\xbf\x05o\xff\x00eo\xf8\'~\x97e\xe2\xff\x00\x8aW0\x84\xbc\xd6\x0c\xebt\xa2\xe1\xb9\xfbU\xed\xc4d\x03 '
    b'M\xc7\xcbM\x8a00\x05~F\xf8\x83\xc4\x9e9\xf8\x85\xe3\x8dW\xe2O\xc5o\x19\\\xf8\x8f\xc5~!\x9d\xef<A\xac\xdf\x9f'
    b'\xf4\x8b\x87\' \x0fDA\x85U\\*"\x84UT\x1bk\xdd\x7ff\xad)\xf5\x0f\x02\xeb\x97\x93,'
    b'M\xe5H\xa4\x02\x0e9\x99G\xadx-\xccQ\x84\'`\xe9\xfd+\xd4?eK\x1b{'
    b'\x8f\x14]\xdb:\xb0Ce#b9\x19\x08`\xbc\x10T\x82\x0f\xb8\xaf\x13\xf8\x87m\r\xb6\xbby\xac\xd9\xa9\xb7\xbb\x8a'
    b'\xebtW6\xccc\x91\x08\xfb;\r\xac\xb8#\xe6\x96F\xe3\xbb\x13\xd6\xb3u?\xda\xb3\xf6\x97\xf1\x05\x85\xbf\x825\xaf'
    b'\x8f>,\xb8\xd2e\xb7]\xf62k\xb3\xec;[\xe5\xfe.1\xedZ\x1e\x1f\xd34\xfd\x17K\xbf\xbc\xd2\xac\xe3\x82['
    b'i#\xf2\xa4\x8dpN\xe1\x86,\x7f\x8c\x90O-\x93\xcdn\xcf\x0cQ\xc9{'
    b'd\x89\x88\xe2H\xde1\x9eT\x9e\xb8=p}:W\xd1_\xb3b\xaa|2\xf1F\xc1\x8cI\x061\xff\x00]\x96\xbf\xff\xd9'
    , np.uint8), cv2.IMREAD_GRAYSCALE)

LEVEL_MASK_EGG = cv2.imdecode(np.frombuffer(
    b'\xff\xd8\xff\xe0\x00\x10JFIF\x00\x01\x01\x00\x00\x01\x00\x01\x00\x00\xff\xdb\x00C\x00\x02\x01\x01\x01\x01\x01'
    b'\x02\x01\x01\x01\x02\x02\x02\x02\x02\x04\x03\x02\x02\x02\x02\x05\x04\x04\x03\x04\x06\x05\x06\x06\x06\x05\x06'
    b'\x06\x06\x07\t\x08\x06\x07\t\x07\x06\x06\x08\x0b\x08\t\n\n\n\n\n\x06\x08\x0b\x0c\x0b\n\x0c\t\n\n\n\xff\xc0\x00'
    b'\x0b\x08\x003\x007\x01\x01\x11\x00\xff\xc4\x00\x1f\x00\x00\x01\x05\x01\x01\x01\x01\x01\x01\x00\x00\x00\x00\x00'
    b'\x00\x00\x00\x01\x02\x03\x04\x05\x06\x07\x08\t\n\x0b\xff\xc4\x00\xb5\x10\x00\x02\x01\x03\x03\x02\x04\x03\x05'
    b'\x05\x04\x04\x00\x00\x01}\x01\x02\x03\x00\x04\x11\x05\x12!1A\x06\x13Qa\x07"q\x142\x81\x91\xa1\x08#B\xb1\xc1'
    b'\x15R\xd1\xf0$3br\x82\t\n\x16\x17\x18\x19\x1a%&\'('
    b')*456789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz\x83\x84\x85\x86\x87\x88\x89\x8a\x92\x93\x94\x95\x96\x97\x98\x99\x9a'
    b'\xa2\xa3\xa4\xa5\xa6\xa7\xa8\xa9\xaa\xb2\xb3\xb4\xb5\xb6\xb7\xb8\xb9\xba\xc2\xc3\xc4\xc5\xc6\xc7\xc8\xc9\xca'
    b'\xd2\xd3\xd4\xd5\xd6\xd7\xd8\xd9\xda\xe1\xe2\xe3\xe4\xe5\xe6\xe7\xe8\xe9\xea\xf1\xf2\xf3\xf4\xf5\xf6\xf7\xf8'
    b'\xf9\xfa\xff\xda\x00\x08\x01\x01\x00\x00?\x00\xfe\x7f\xeb\xfb\x8c\xf0\x07\xecS\xff\x00\x04\xf4\xf1g\xec\x8f\xe0'
    b'?\xd9\xf3\xc1\xdf\xb3\x97\xc2\xff\x00\x17\xfc\x17\xd14\xfb]G\xe1\xfe\x85{'
    b'\xa1\xd9\xeb\xba1\x8d\xe2v\x87Q\x81\xae\x04\xc9q,\xa9s,'
    b'\x86\xf0\xb3\xc91\xb9\x96F\x91\xcc\xae\xcd\xf8\xa3\xff\x00\x05\xec\xff\x00\x83Z<\t\xf0;\xe1d\x1f\xb5\x07\xfc'
    b'\x12\x8f\xe1/\xc4\rft\xf1\x05\xbd\xa7\x8a~\x10\xe8\xe6]w\xec\x96\x12@\xb1%\xf6\x9e\x1d\x9e\xfeM\x97\x11\xaf\x9d'
    b'\t7l\xdfn2\xa9\xb7\x86\xd9\xc5z\x87\xfc\x15\x83\xfe\r\x88\xfd\x89\x7fg/\xf8#\xf7\x88\xfe&~\xcc\xff\x00\n5\x0b'
    b'\xbf\x8d\x1f\n\xbc\x1f\xa7k\x1a\xe7\x8d,\xbcQwo\x1f\x89#\xb1H\x86\xb5w=\x95\xfd\xe4\xf6\xf0D\xd6\xbfl\xbe\x10['
    b'\x94\x91d\x82(\xe2w\x19\x8a_@\xff\x00\x82;\xff\x00\xc1\xa8\x7f\xb3\x07\xc0\xcf\x83Z?\xc5\x7f\xf8)\xaf\xc2\xed'
    b'?\xe2\x0f\xc5\x8b\xfdB\xcfX_\x0b\\j\xf3>\x8d\xe15\x84\xf9\x91\xe9\xf2Go*\xc1\xaa\xca\xc4\x83u\xe7\x89\xadX\xa8'
    b'\x864x\xd1\xe6\xba\xf6\xff\x00\xf89\xeb\xe1?\xc2\xcd\x13\xfe\x08\x1f\xf1+\xc3\xba7\xc3O\x0f\xdai\xfe\x06\xff'
    b'\x00\x84W\xfe\x10\xab\x1b]\x1a\x08\xe1\xf0\xff\x00\x97\xad\xe9\xd61\xfd\x85\x15\x02\xdam\xb4\x9eka\xe5\x05'
    b'\xc43I\x18\xf9\x1d\x94\xff\x00$U\xfd\x07\x7f\xc1\x12\xff\x00\xe0\xd3o\n\xaf\x85|Y\xf17\xfe\x0b-\xf0/P}m\xf5\x03'
    b'\xa5\xf8K\xe1\xac~1D\xb5\x82\xd5R\t[W\x92\xf3E\xbe/,'
    b'\xae\xec\xf6\xe9\x01\x91\x165\x86gt\x94\xcd\x0bC\xfa\xfd\xfb\x02|\x08\xf1W\xec\xa9\xf0kT\xfd\x96\xef\xb4\xbd@xS'
    b'\xc0>0\xd4,>\x17j\xba\x9f\x88\x1e\xfeK\xef\x0b\xceSP\xb0\xb7\x1et\xd3O\x04Zp\xbc}\x164\x9aFw\x8fFI\xc0D\x9e8'
    b'\xd3\xdc(\xa2\xbe`\xff\x00\x82\x84\xff\x00\xc16<\t\xff\x00\x05,'
    b'\xf1\xdf\xc3O\x01~\xd3\x8d\xfd\xb3\xf0K\xc2\x1f\xdb:\xdf\x89|\x07o\xaaKc6\xb7\xe2F\x8a\xda\xd3G\x99\xe7\xb7'
    b'\x8dn\x16\xda\xde\xda\xe3ZgXn`-4\xb6\xbb\x84\xc8\xac\xab\xf9\x01\xff\x00\x05y\xff\x00\x83C~)\xff\x00\xc2\xd3'
    b'\xbd\xf8\xbb\xff\x00\x04\x90\xf0W\x87\xff\x00\xe1\t\xff\x00\x84~\xc3\xcd\xf8['
    b'\xac\xf8\xee\x7f\xed_\xed_=\xa1\xb8\xfb\x04\xba\x82y?f\xf2|\x9b\x86\xfbU\xf6\xfd\xff\x00i\t\xf2\xf9\x10\xd7\xf4'
    b'=\\\xff\x00\xc5\x9f\x1f\xff\x00\xc2\xa8\xf8Y\xe2o\x8a_\xf0\x85x\x83\xc4\xbf\xf0\x8dx~\xf7U\xff\x00\x84s\xc2zo'
    b'\xdb5]W\xec\xf0<\xdfd\xb3\xb7\xdc\xbe}\xcc\xbb<\xb8\xa3\xdc7\xbb*\xe4g5\xf3\x07\xfc\x11\x93\xfe\n\xfd\xf0\xb3'
    b'\xfe\x0b\x11\xfb8\xea\xdf\x18\xbc\'\xe0O\xf8B\xbcO\xe1\x8f\x10>\x95\xe2\xdf\x02\xdcx\x8a\rFk\r\xca%\xb5\xbbI'
    b'\x11c\x91\xed\xa7\x88\x90\x92I\x049\x9a\xde\xea5\x0e '
    b'\xf3\x1b\xeb\xfa\xf9C\xf6\xb8\xff\x00\x82\xb7\xfc\x1a\xfd\x95?o?\x82?\xf0N\xc8\xbe\x17\xf8\xc3\xc6\xbf\x10\xbe1'
    b'\xea\x11\xbc\xf6~\x15\xd3\x0c\xab\xe1\xcd\x1aCs\x12j\xb3\x96\x00M\x10\xb8\xb6\x90\xca\x91\x9c\xc1kmys!_*\x18'
    b'\xae~\xaf\xaf\x98?\xe0\xb3?\xb6\xb7\xc5?\xf8\'o\xfc\x13c\xe2G\xed\x8b\xf0S@\xf0\xfe\xa9\xe2\x7f\x07\xff\x00c'
    b'\xff\x00fX\xf8\xa6\xd6y\xec%\xfb^\xb1cc\'\x9a\x90M\x0c\x8d\x88\xaed+\xb6E\xc3\x05\' '
    b'\x15?\x96\x1f\xf0l\xbf\xfc\x17\xeb\xc5^4\xd4~\x04\x7f\xc1\x1b<c\xf0\x0bP\xd5\xae\xe1\xd3\xf5\xbb\x08~*\xea\x7f'
    b'\x10\xdey\x12\xd6\xd6\xdfR\xd5-m\xc5\x8b\xd9\x92"\x86\xde\x18\xaccAs\xb5#\x89\n\x80\xaa"\x1f\xbd\xd5\xcf\xf8w'
    b'\xe1?\xc2\xcf\x08x\xef\xc4\x7f\x14\xbc\'\xf0\xd3\xc3\xfa_\x89\xfca\xf6?\xf8K|G\xa7h\xd0A\x7f\xad\xfd\x92#\r\xaf'
    b'\xdb.\x11\x04\x97>LLc\x8f\xccf\xf2\xd4\x95\\\x03\x8a\xe8('
    b'\xa2\xbf\x94/\xf8.\x87\xfc\x1c\x87\xe3\xbf\xf8*\xef\x81,'
    b'?g\x1f\x82\x9f\x0e<A\xf0\xd3\xe1\x96\x9f\xe2\x0b\xcb\xadr\xca\xeb\xc4\xd1\\M\xe3HRX\x8e\x98\xf7\xd0\xc5n\x9fe'
    b'\xf2<\xb9&6\xab=\xc4&icb\xce\xd6\xb0\xc9_\x18\x7f\xc17\xbfm\xef\x15\x7f\xc18\x7fm\xaf\x00\xfe\xda>\x0e\xf0>\x9f'
    b'\xe2[\xbf\x05j\x17\x0f6\x81\xa9\xdc<1\xdfZ\xddZOeu\x10\x952a\x94\xdb\xdc\xcb\xe5\xcaU\xd696;G*\xa9\x8d\xbf\xb4'
    b'\xcf\xd9W\xf6\x97\xf8Y\xfbd~\xce>\x0b\xfd\xa8\xfe\nj\xdfk\xf0\xc7\x8e|?o\xaa\xe9\x9b\xe7\x82I\xad|\xc5\xfd\xe5'
    b'\xa5\xc7\x91$\x91\xa5\xcc\x12\x89 \x9a5v\xf2\xe6\x86D\'('
    b'k\xf3C\xfe\x0b%\xff\x00\x05\xf1\xff\x00\x82\x85\xff\x00\xc1\'\xbfm\xabm\x16\xfb\xfe\t\xdf\xa7\xeb\xff\x00\xb3'
    b'\xb8\xd3\xec\xa2\xb3\xf1\xbd\xed\xd5\xe42x\x97Q\xb8\xb4\xb8\x94\xc7\x06\xab\x10\x92\xd3N\x969\xa3t6S['
    b'\xcdp\xf1\xd8\xcb0+\x1d\xccM\x1f\xce\x1f\xf1\x1c\xe7\xfdb\xeb\xff\x003g\xff\x00yk\xee\xff\x00\xf87\xe7\xfe\n'
    b'\x7f\xff\x00\x05\x0b\xff\x00\x82\xa5|\x1a\xd7~6~\xd6?\xb2o\x83\xfc!\xe0\xd8\xb5\t\xa0\xf0\x8f\x8f\xbc7}ye\x1e'
    b'\xbf"\x18\xe3{{m6\xe8\xdc<\xb1B\xe9r%\xbf\xfbRFd)o\x1c.\xf1\\\xbc_O\xff\x00\xc1E\x7fo/\x83_\xf0M\xcf\xd9\x1f'
    b'\xc5\x9f\xb5_\xc6mkOH\xb4]>T\xf0\xd6\x85{'
    b'\xa8\x9bi<I\xac\xb4R5\x9e\x95\x03$r\xbf\x9b;\xa6\x0b\xacn"\x8de\x9d\xc0\x8a\x19\x19\x7f\x87:+\xee\xff\x00\xf8'
    b'!\xc7\xfc\x17\x1f\xe3/\xfc\x12\x17\xe3+\xe9z\xa4Z\x87\x8a\xbe\x0b\xf8\xabPG\xf1\xe7\x80\xe2\x98\x19 '
    b'\x93\x0b\x1f\xf6\xae\x9b\xe60H\xaf\x91\x15C!+\x1d\xd4q\xacR\x95)\x04\xf6\xff\x00\xd4w\x80>)\x7f\xc1>\xff\x00'
    b'\xe0\xb3?\xb1\xb6\xb7\x1f\x82\xb5\xdf\x0f\xfc]\xf8E\xe3\x0f\xb4\xe8\x9a\xfd\x94\xd6\xb7\x10bh]KC43,'
    b'WV71\xb7\x93q\x13\x15\x8ad\xcd\xbd\xc4Dn\x8aC\xf1\x7f\x86\x7f\xe0\xcfO\xf8#\xf6\x83\xf1\x96O\x89\xfa\xa5\xb7'
    b'\xc5\rkD}B\xee\xe1~\x1c\xea~7D\xd1\xa3\x8ea '
    b'\x8e\xd8Koo\x16\xa1\xe5@]Ld\xde\x19\t\x85<\xd7\x94\x17\x0f\xf6\x87\xed\x8b\xfbt\xfe\xc3\xbf\xf0I\xff\x00\xd9'
    b'\xc6\x1f\x16|r\xf1\x9f\x87\xfc\x17\xe1\xfd\x0b\xc3\xed\x0f\x82\xbc\x03\xa2-\xb47\xfa\xac6k\x04\x11\xe9\xfa>\x9c'
    b'\xad\x1f\x9b\xe5\xf9\xb6\xd1m@\xb0\xc0\xb2#J\xf0\xc4\xac\xeb\xfc\x90\xff\x00\xc1W?\xe0\xab\x9f\xb4w\xfc\x15\xab'
    b'\xf6\x8e\x97\xe3_\xc6\xbb\xaf\xec\xaf\x0f\xe9^u\xaf\x80<\x01cv\xd2Xxf\xc1\xd9ID$/\x9fs.\xc8\xda{'
    b'\xa6Ui\x99\x14\x05\x8e(\xa0\x82/\x98(\xa2\xbd\x03\xf6h\xfd\xaa\xbfh\xef\xd8\xdf\xe2\x9d\xa7\xc6\xbf\xd9s\xe3G'
    b'\x88<\r\xe2{O-\x7f\xb4\xf4\x0b\xf6\x87\xedP\xa4\xf1O\xf6k\x98\xf9\x8e\xee\xd9\xa5\x82&{'
    b'i\x95\xe1\x93\xcbP\xe8\xc0b\xbe\xaf\xf1g\xfc\x1c\xd1\xff\x00\x05\xc6\xf1\xa7\x85u?\x07k\x1f\xb7v\xa1\r\xa6\xad'
    b'\xa7\xcdeu6\x93\xe0\x8d\x02\xc2\xe9#\x95\n3Cuka\x1c\xf6\xd2\x80\xc4\xac\xd1:H\x8d\x86FV\x00\x8f\x8c>)|X\xf8\xa7'
    b'\xf1\xc7\xc7w\xdf\x14\xbe5\xfcK\xf1\x07\x8c<O\xaay_\xda~#\xf1N\xb3>\xa1\x7fw\xe5\xc4\x90\xc7\xe6\xdcN\xef$\x9b'
    b'"\x8e8\xd7s\x1d\xaa\x8a\xa3\x00\x01\\\xfd\x15\xff\xd9 '
    , np.uint8), cv2.IMREAD_GRAYSCALE)
