import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * (experimental) Statement provider for service [deeplens](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsdeeplens.html).
 *
 * @experimental
 */
export declare class Deeplens extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [deeplens](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsdeeplens.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Associates the user's account with IAM roles controlling various permissions needed by AWS DeepLens for proper functionality.
     *
     * Access Level: Permissions management
     *
     * @experimental
     */
    toAssociateServiceRoleToAccount(): this;
    /**
     * (experimental) Retrieves a list of AWS DeepLens devices.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toBatchGetDevice(): this;
    /**
     * (experimental) Retrieves a list of AWS DeepLens Models.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toBatchGetModel(): this;
    /**
     * (experimental) Retrieves a list of AWS DeepLens Projects.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toBatchGetProject(): this;
    /**
     * (experimental) Creates a certificate package that is used to successfully authenticate and Register an AWS DeepLens device.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toCreateDeviceCertificates(): this;
    /**
     * (experimental) Creates a new AWS DeepLens Model.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toCreateModel(): this;
    /**
     * (experimental) Creates a new AWS DeepLens Project.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toCreateProject(): this;
    /**
     * (experimental) Deletes an AWS DeepLens Model.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toDeleteModel(): this;
    /**
     * (experimental) Deletes an AWS DeepLens Project.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toDeleteProject(): this;
    /**
     * (experimental) Deploys an AWS DeepLens project to a registered AWS DeepLens device.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toDeployProject(): this;
    /**
     * (experimental) Begins a device de-registration workflow for a registered AWS DeepLens device.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toDeregisterDevice(): this;
    /**
     * (experimental) Retrieves the account level resources associated with the user's account.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toGetAssociatedResources(): this;
    /**
     * (experimental) Retrieves the the deployment status of a particular AWS DeepLens device, along with any associated metadata.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toGetDeploymentStatus(): this;
    /**
     * (experimental) Retrieves information about an AWS DeepLens device.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toGetDevice(): this;
    /**
     * (experimental) Retrieves an AWS DeepLens Model.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toGetModel(): this;
    /**
     * (experimental) Retrieves an AWS DeepLens Project.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toGetProject(): this;
    /**
     * (experimental) Creates a new AWS DeepLens project from a sample project template.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toImportProjectFromTemplate(): this;
    /**
     * (experimental) Retrieves a list of AWS DeepLens Deployment identifiers.
     *
     * Access Level: List
     *
     * @experimental
     */
    toListDeployments(): this;
    /**
     * (experimental) Retrieves a list of AWS DeepLens device identifiers.
     *
     * Access Level: List
     *
     * @experimental
     */
    toListDevices(): this;
    /**
     * (experimental) Retrieves a list of AWS DeepLens Model identifiers.
     *
     * Access Level: List
     *
     * @experimental
     */
    toListModels(): this;
    /**
     * (experimental) Retrieves a list of AWS DeepLens Project identifiers.
     *
     * Access Level: List
     *
     * @experimental
     */
    toListProjects(): this;
    /**
     * (experimental) Begins a device registration workflow for an AWS DeepLens device.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toRegisterDevice(): this;
    /**
     * (experimental) Removes a deployed AWS DeepLens project from an AWS DeepLens device.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toRemoveProject(): this;
    /**
     * (experimental) Updates an existing AWS DeepLens Project.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toUpdateProject(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type device to the statement.
     *
     * @param deviceName - Identifier for the deviceName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onDevice(deviceName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type project to the statement.
     *
     * @param projectName - Identifier for the projectName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onProject(projectName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type model to the statement.
     *
     * @param modelName - Identifier for the modelName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onModel(modelName: string, account?: string, region?: string, partition?: string): this;
}
