"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Iotroborunner = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [iotroborunner](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotroborunner.html).
 *
 * @experimental
 */
class Iotroborunner extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [iotroborunner](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotroborunner.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid) {
        super(sid);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'iotroborunner';
        /**
         * @experimental
         */
        this.accessLevelList = {
            Write: [
                'CreateAction',
                'CreateActionTemplate',
                'CreateActionTemplateDependency',
                'CreateActivity',
                'CreateActivityDependency',
                'CreateDestination',
                'CreateDestinationRelationship',
                'CreateSite',
                'CreateTask',
                'CreateTaskDependency',
                'CreateWorker',
                'CreateWorkerFleet',
                'DeleteAction',
                'DeleteActionTemplate',
                'DeleteActionTemplateDependency',
                'DeleteActivity',
                'DeleteActivityDependency',
                'DeleteDestination',
                'DeleteDestinationRelationship',
                'DeleteSite',
                'DeleteTask',
                'DeleteTaskDependency',
                'DeleteWorker',
                'DeleteWorkerFleet',
                'UpdateActionState',
                'UpdateActivity',
                'UpdateDestination',
                'UpdateSite',
                'UpdateTask',
                'UpdateWorker',
                'UpdateWorkerFleet'
            ],
            Read: [
                'GetAction',
                'GetActionTemplate',
                'GetActivity',
                'GetDestination',
                'GetDestinationRelationship',
                'GetSite',
                'GetTask',
                'GetWorker',
                'GetWorkerFleet',
                'ListActionTemplates',
                'ListActions',
                'ListActivities',
                'ListDestinationRelationships',
                'ListDestinations',
                'ListSites',
                'ListTasks',
                'ListWorkerFleets',
                'ListWorkers'
            ]
        };
    }
    /**
     * (experimental) Grants permission to create an action.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_CreateAction.html
     *
     * @experimental
     */
    toCreateAction() {
        return this.to('CreateAction');
    }
    /**
     * (experimental) Grants permission to create an action template.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_CreateActionTemplate.html
     *
     * @experimental
     */
    toCreateActionTemplate() {
        return this.to('CreateActionTemplate');
    }
    /**
     * (experimental) Grants permission to create an action template dependency.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_CreateActionTemplateDependency.html
     *
     * @experimental
     */
    toCreateActionTemplateDependency() {
        return this.to('CreateActionTemplateDependency');
    }
    /**
     * (experimental) Grants permission to create an activity.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_CreateActivity.html
     *
     * @experimental
     */
    toCreateActivity() {
        return this.to('CreateActivity');
    }
    /**
     * (experimental) Grants permission to create an activity dependency.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_CreateActivityDependency.html
     *
     * @experimental
     */
    toCreateActivityDependency() {
        return this.to('CreateActivityDependency');
    }
    /**
     * (experimental) Grants permission to create a destination.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_CreateDestination.html
     *
     * @experimental
     */
    toCreateDestination() {
        return this.to('CreateDestination');
    }
    /**
     * (experimental) Grants permission to create a destination relationship.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_CreateDestinationRelationship.html
     *
     * @experimental
     */
    toCreateDestinationRelationship() {
        return this.to('CreateDestinationRelationship');
    }
    /**
     * (experimental) Grants permission to create a site.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_CreateSite.html
     *
     * @experimental
     */
    toCreateSite() {
        return this.to('CreateSite');
    }
    /**
     * (experimental) Grants permission to create a task.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_CreateTask.html
     *
     * @experimental
     */
    toCreateTask() {
        return this.to('CreateTask');
    }
    /**
     * (experimental) Grants permission to create a task dependency.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_CreateTaskDependency.html
     *
     * @experimental
     */
    toCreateTaskDependency() {
        return this.to('CreateTaskDependency');
    }
    /**
     * (experimental) Grants permission to create a worker.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_CreateWorker.html
     *
     * @experimental
     */
    toCreateWorker() {
        return this.to('CreateWorker');
    }
    /**
     * (experimental) Grants permission to create a worker fleet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_CreateWorkerFleet.html
     *
     * @experimental
     */
    toCreateWorkerFleet() {
        return this.to('CreateWorkerFleet');
    }
    /**
     * (experimental) Grants permission to delete an action.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_DeleteAction.html
     *
     * @experimental
     */
    toDeleteAction() {
        return this.to('DeleteAction');
    }
    /**
     * (experimental) Grants permission to delete an action template.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_DeleteActionTemplate.html
     *
     * @experimental
     */
    toDeleteActionTemplate() {
        return this.to('DeleteActionTemplate');
    }
    /**
     * (experimental) Grants permission to delete an action template dependency.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_DeleteActionTemplateDependency.html
     *
     * @experimental
     */
    toDeleteActionTemplateDependency() {
        return this.to('DeleteActionTemplateDependency');
    }
    /**
     * (experimental) Grants permission to delete an activity.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_DeleteActivity.html
     *
     * @experimental
     */
    toDeleteActivity() {
        return this.to('DeleteActivity');
    }
    /**
     * (experimental) Grants permission to delete an activity dependency.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_DeleteActivityDependency.html
     *
     * @experimental
     */
    toDeleteActivityDependency() {
        return this.to('DeleteActivityDependency');
    }
    /**
     * (experimental) Grants permission to delete a destination.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_DeleteDestination.html
     *
     * @experimental
     */
    toDeleteDestination() {
        return this.to('DeleteDestination');
    }
    /**
     * (experimental) Grants permission to delete a destination relationship.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_DeleteDestinationRelationship.html
     *
     * @experimental
     */
    toDeleteDestinationRelationship() {
        return this.to('DeleteDestinationRelationship');
    }
    /**
     * (experimental) Grants permission to delete a site.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_DeleteSite.html
     *
     * @experimental
     */
    toDeleteSite() {
        return this.to('DeleteSite');
    }
    /**
     * (experimental) Grants permission to delete a task.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_DeleteTask.html
     *
     * @experimental
     */
    toDeleteTask() {
        return this.to('DeleteTask');
    }
    /**
     * (experimental) Grants permission to delete a task dependency.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_DeleteTaskDependency.html
     *
     * @experimental
     */
    toDeleteTaskDependency() {
        return this.to('DeleteTaskDependency');
    }
    /**
     * (experimental) Grants permission to delete a worker.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_DeleteWorker.html
     *
     * @experimental
     */
    toDeleteWorker() {
        return this.to('DeleteWorker');
    }
    /**
     * (experimental) Grants permission to delete a worker fleet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_DeleteWorkerFleet.html
     *
     * @experimental
     */
    toDeleteWorkerFleet() {
        return this.to('DeleteWorkerFleet');
    }
    /**
     * (experimental) Grants permission to get an action.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_GetAction.html
     *
     * @experimental
     */
    toGetAction() {
        return this.to('GetAction');
    }
    /**
     * (experimental) Grants permission to get an action template.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_GetActionTemplate.html
     *
     * @experimental
     */
    toGetActionTemplate() {
        return this.to('GetActionTemplate');
    }
    /**
     * (experimental) Grants permission to get an activity.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_GetActivity.html
     *
     * @experimental
     */
    toGetActivity() {
        return this.to('GetActivity');
    }
    /**
     * (experimental) Grants permission to get a destination.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_GetDestination.html
     *
     * @experimental
     */
    toGetDestination() {
        return this.to('GetDestination');
    }
    /**
     * (experimental) Grants permission to get a destination relationship.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_GetDestinationRelationship.html
     *
     * @experimental
     */
    toGetDestinationRelationship() {
        return this.to('GetDestinationRelationship');
    }
    /**
     * (experimental) Grants permission to get a site.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_GetSite.html
     *
     * @experimental
     */
    toGetSite() {
        return this.to('GetSite');
    }
    /**
     * (experimental) Grants permission to get a task.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_GetTask.html
     *
     * @experimental
     */
    toGetTask() {
        return this.to('GetTask');
    }
    /**
     * (experimental) Grants permission to get a worker.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_GetWorker.html
     *
     * @experimental
     */
    toGetWorker() {
        return this.to('GetWorker');
    }
    /**
     * (experimental) Grants permission to get a worker fleet.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_GetWorkerFleet.html
     *
     * @experimental
     */
    toGetWorkerFleet() {
        return this.to('GetWorkerFleet');
    }
    /**
     * (experimental) Grants permission to list action templates.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_ListActionTemplates.html
     *
     * @experimental
     */
    toListActionTemplates() {
        return this.to('ListActionTemplates');
    }
    /**
     * (experimental) Grants permission to list actions.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_ListActions.html
     *
     * @experimental
     */
    toListActions() {
        return this.to('ListActions');
    }
    /**
     * (experimental) Grants permission to list activities.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_ListActivities.html
     *
     * @experimental
     */
    toListActivities() {
        return this.to('ListActivities');
    }
    /**
     * (experimental) Grants permission to list destination relationships.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_ListDestinationRelationships.html
     *
     * @experimental
     */
    toListDestinationRelationships() {
        return this.to('ListDestinationRelationships');
    }
    /**
     * (experimental) Grants permission to list destinations.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_ListDestinations.html
     *
     * @experimental
     */
    toListDestinations() {
        return this.to('ListDestinations');
    }
    /**
     * (experimental) Grants permission to list sites.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_ListSites.html
     *
     * @experimental
     */
    toListSites() {
        return this.to('ListSites');
    }
    /**
     * (experimental) Grants permission to list tasks.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_ListTasks.html
     *
     * @experimental
     */
    toListTasks() {
        return this.to('ListTasks');
    }
    /**
     * (experimental) Grants permission to list worker fleets.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_ListWorkerFleets.html
     *
     * @experimental
     */
    toListWorkerFleets() {
        return this.to('ListWorkerFleets');
    }
    /**
     * (experimental) Grants permission to list workers.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_ListWorkers.html
     *
     * @experimental
     */
    toListWorkers() {
        return this.to('ListWorkers');
    }
    /**
     * (experimental) Grants permission to update an action's state.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_UpdateActionState.html
     *
     * @experimental
     */
    toUpdateActionState() {
        return this.to('UpdateActionState');
    }
    /**
     * (experimental) Grants permission to update an activity.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_UpdateActivity.html
     *
     * @experimental
     */
    toUpdateActivity() {
        return this.to('UpdateActivity');
    }
    /**
     * (experimental) Grants permission to update a destination.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_UpdateDestination.html
     *
     * @experimental
     */
    toUpdateDestination() {
        return this.to('UpdateDestination');
    }
    /**
     * (experimental) Grants permission to update a site.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_UpdateSite.html
     *
     * @experimental
     */
    toUpdateSite() {
        return this.to('UpdateSite');
    }
    /**
     * (experimental) Grants permission to update a task.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_UpdateTask.html
     *
     * @experimental
     */
    toUpdateTask() {
        return this.to('UpdateTask');
    }
    /**
     * (experimental) Grants permission to update a worker.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_UpdateWorker.html
     *
     * @experimental
     */
    toUpdateWorker() {
        return this.to('UpdateWorker');
    }
    /**
     * (experimental) Grants permission to update a worker fleet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/API_UpdateWorkerFleet.html
     *
     * @experimental
     */
    toUpdateWorkerFleet() {
        return this.to('UpdateWorkerFleet');
    }
    /**
     * (experimental) Adds a resource of type ActionResource to the statement.
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/
     *
     * @param actionId - Identifier for the actionId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onActionResource(actionId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:iotroborunner:${region || '*'}:${account || '*'}:action/${actionId}`);
    }
    /**
     * (experimental) Adds a resource of type ActionTemplateResource to the statement.
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/
     *
     * @param actionTemplateId - Identifier for the actionTemplateId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onActionTemplateResource(actionTemplateId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:iotroborunner:${region || '*'}:${account || '*'}:action-template/${actionTemplateId}`);
    }
    /**
     * (experimental) Adds a resource of type ActivityResource to the statement.
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/
     *
     * @param activityId - Identifier for the activityId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onActivityResource(activityId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:iotroborunner:${region || '*'}:${account || '*'}:activity/${activityId}`);
    }
    /**
     * (experimental) Adds a resource of type DestinationRelationshipResource to the statement.
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/
     *
     * @param destinationRelationshipId - Identifier for the destinationRelationshipId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDestinationRelationshipResource(destinationRelationshipId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:iotroborunner:${region || '*'}:${account || '*'}:destination-relationship/${destinationRelationshipId}`);
    }
    /**
     * (experimental) Adds a resource of type DestinationResource to the statement.
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/
     *
     * @param destinationId - Identifier for the destinationId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDestinationResource(destinationId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:iotroborunner:${region || '*'}:${account || '*'}:destination/${destinationId}`);
    }
    /**
     * (experimental) Adds a resource of type SiteResource to the statement.
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/
     *
     * @param siteId - Identifier for the siteId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onSiteResource(siteId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:iotroborunner:${region || '*'}:${account || '*'}:site/${siteId}`);
    }
    /**
     * (experimental) Adds a resource of type TaggingResource to the statement.
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/
     *
     * @param tagKey - Identifier for the tagKey.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onTaggingResource(tagKey, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:iotroborunner:${region || '*'}:${account || '*'}:tag/${tagKey}`);
    }
    /**
     * (experimental) Adds a resource of type TaskResource to the statement.
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/
     *
     * @param taskId - Identifier for the taskId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onTaskResource(taskId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:iotroborunner:${region || '*'}:${account || '*'}:task/${taskId}`);
    }
    /**
     * (experimental) Adds a resource of type WorkerFleetResource to the statement.
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/
     *
     * @param workerFleetId - Identifier for the workerFleetId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onWorkerFleetResource(workerFleetId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:iotroborunner:${region || '*'}:${account || '*'}:worker-fleet/${workerFleetId}`);
    }
    /**
     * (experimental) Adds a resource of type WorkerResource to the statement.
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/
     *
     * @param workerId - Identifier for the workerId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onWorkerResource(workerId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:iotroborunner:${region || '*'}:${account || '*'}:worker/${workerId}`);
    }
    /**
     * (experimental) Filters access by the action's identifier.
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/#Action
     *
     * Applies to resource types:
     * - ActionResource
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifActionResourceId(value, operator) {
        return this.if(`ActionResourceId`, value, operator || 'StringLike');
    }
    /**
     * (experimental) Filters access by the action template's identifier.
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/#ActionTemplate
     *
     * Applies to resource types:
     * - ActionTemplateResource
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifActionTemplateResourceId(value, operator) {
        return this.if(`ActionTemplateResourceId`, value, operator || 'StringLike');
    }
    /**
     * (experimental) Filters access by the activity's identifier.
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/#Activity
     *
     * Applies to resource types:
     * - ActivityResource
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifActivityResourceId(value, operator) {
        return this.if(`ActivityResourceId`, value, operator || 'StringLike');
    }
    /**
     * (experimental) Filters access by the destination relationship's identifier.
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/#DestinationRelationship
     *
     * Applies to resource types:
     * - DestinationRelationshipResource
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifDestinationRelationshipResourceId(value, operator) {
        return this.if(`DestinationRelationshipResourceId`, value, operator || 'StringLike');
    }
    /**
     * (experimental) Filters access by the destination's identifier.
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/#Destination
     *
     * Applies to resource types:
     * - DestinationResource
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifDestinationResourceId(value, operator) {
        return this.if(`DestinationResourceId`, value, operator || 'StringLike');
    }
    /**
     * (experimental) Filters access by the site's identifier.
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/#Site
     *
     * Applies to resource types:
     * - SiteResource
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifSiteResourceId(value, operator) {
        return this.if(`SiteResourceId`, value, operator || 'StringLike');
    }
    /**
     * (experimental) Filters access by the metadata tag name.
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/#Tagging
     *
     * Applies to resource types:
     * - TaggingResource
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifTaggingResourceTagKey(value, operator) {
        return this.if(`TaggingResourceTagKey`, value, operator || 'StringLike');
    }
    /**
     * (experimental) Filters access by the task's identifer.
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/#Task
     *
     * Applies to resource types:
     * - TaskResource
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifTaskResourceId(value, operator) {
        return this.if(`TaskResourceId`, value, operator || 'StringLike');
    }
    /**
     * (experimental) Filters access by the worker fleet's identifier.
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/#WorkerFleet
     *
     * Applies to resource types:
     * - WorkerFleetResource
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifWorkerFleetResourceId(value, operator) {
        return this.if(`WorkerFleetResourceId`, value, operator || 'StringLike');
    }
    /**
     * (experimental) Filters access by the workers identifier.
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/#Worker
     *
     * Applies to resource types:
     * - WorkerResource
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifWorkerResourceId(value, operator) {
        return this.if(`WorkerResourceId`, value, operator || 'StringLike');
    }
}
exports.Iotroborunner = Iotroborunner;
_a = JSII_RTTI_SYMBOL_1;
Iotroborunner[_a] = { fqn: "iam-floyd.Iotroborunner", version: "0.311.0" };
//# sourceMappingURL=data:application/json;base64,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