import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * (experimental) Statement provider for service [lakeformation](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awslakeformation.html).
 *
 * @experimental
 */
export declare class Lakeformation extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [lakeformation](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awslakeformation.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to attach Lake Formation tags to catalog resources.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-AddLFTagsToResource
     *
     * @experimental
     */
    toAddLFTagsToResource(): this;
    /**
     * (experimental) Grants permission to data lake permissions to one or more principals in a batch.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-BatchGrantPermissions
     *
     * @experimental
     */
    toBatchGrantPermissions(): this;
    /**
     * (experimental) Grants permission to revoke data lake permissions from one or more principals in a batch.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-BatchRevokePermissions
     *
     * @experimental
     */
    toBatchRevokePermissions(): this;
    /**
     * (experimental) Grants permission to cancel the given transaction.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-transactions-api.html#aws-lake-formation-api-transactions-api-CancelTransaction
     *
     * @experimental
     */
    toCancelTransaction(): this;
    /**
     * (experimental) Grants permission to commit the given transaction.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-transactions-api.html#aws-lake-formation-api-transactions-api-CommitTransaction
     *
     * @experimental
     */
    toCommitTransaction(): this;
    /**
     * (experimental) Grants permission to create a Lake Formation data cell filter.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-data-filter.html#aws-lake-formation-api-data-filter-CreateDataCellsFilter
     *
     * @experimental
     */
    toCreateDataCellsFilter(): this;
    /**
     * (experimental) Grants permission to create a Lake Formation tag.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-CreateLFTag
     *
     * @experimental
     */
    toCreateLFTag(): this;
    /**
     * (experimental) Grants permission to delete a Lake Formation data cell filter.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-data-filter.html#aws-lake-formation-api-data-filter-DeleteDataCellsFilter
     *
     * @experimental
     */
    toDeleteDataCellsFilter(): this;
    /**
     * (experimental) Grants permission to delete a Lake Formation tag.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-DeleteLFTag
     *
     * @experimental
     */
    toDeleteLFTag(): this;
    /**
     * (experimental) Grants permission to delete the specified objects if the transaction is canceled.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-transactions-api.html#aws-lake-formation-api-transactions-api-DeleteObjectsOnCancel
     *
     * @experimental
     */
    toDeleteObjectsOnCancel(): this;
    /**
     * (experimental) Grants permission to deregister a registered location.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-DeregisterResource
     *
     * @experimental
     */
    toDeregisterResource(): this;
    /**
     * (experimental) Grants permission to describe a registered location.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-DescribeResource
     *
     * @experimental
     */
    toDescribeResource(): this;
    /**
     * (experimental) Grants permission to get status of the given transaction.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-transactions-api.html#aws-lake-formation-api-transactions-api-DescribeTransaction
     *
     * @experimental
     */
    toDescribeTransaction(): this;
    /**
     * (experimental) Grants permission to extend the timeout of the given transaction.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-transactions-api.html#aws-lake-formation-api-transactions-api-ExtendTransaction
     *
     * @experimental
     */
    toExtendTransaction(): this;
    /**
     * (experimental) Grants permission to virtual data lake access.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-GetDataAccess
     *
     * @experimental
     */
    toGetDataAccess(): this;
    /**
     * (experimental) Grants permission to retrieve data lake settings such as the list of data lake administrators and database and table default permissions.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-GetDataLakeSettings
     *
     * @experimental
     */
    toGetDataLakeSettings(): this;
    /**
     * (experimental) Grants permission to retrieve permissions attached to resources in the given path.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-GetEffectivePermissionsForPath
     *
     * @experimental
     */
    toGetEffectivePermissionsForPath(): this;
    /**
     * (experimental) Grants permission to retrieve a Lake Formation tag.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-GetLFTag
     *
     * @experimental
     */
    toGetLFTag(): this;
    /**
     * (experimental) Grants permission to retrieve the state of the given query.
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - lakeformation:StartQueryPlanning
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-querying.html#aws-lake-formation-api-querying-GetQueryState
     *
     * @experimental
     */
    toGetQueryState(): this;
    /**
     * (experimental) Grants permission to retrieve the statistics for the given query.
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - lakeformation:StartQueryPlanning
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-querying.html#aws-lake-formation-api-querying-GetQueryStatistics
     *
     * @experimental
     */
    toGetQueryStatistics(): this;
    /**
     * (experimental) Grants permission to retrieve lakeformation tags on a catalog resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-GetResourceLFTags
     *
     * @experimental
     */
    toGetResourceLFTags(): this;
    /**
     * (experimental) Grants permission to retrieve objects from a table.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-objects.html#aws-lake-formation-api-objects-GetTableObjects
     *
     * @experimental
     */
    toGetTableObjects(): this;
    /**
     * (experimental) Grants permission to retrieve the results for the given work units.
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - lakeformation:GetWorkUnits
     * - lakeformation:StartQueryPlanning
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-querying.html#aws-lake-formation-api-querying-GetWorkUnitResults
     *
     * @experimental
     */
    toGetWorkUnitResults(): this;
    /**
     * (experimental) Grants permission to retrieve the work units for the given query.
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - lakeaformation:StartQueryPlanning
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-querying.html#aws-lake-formation-api-querying-GetWorkUnits
     *
     * @experimental
     */
    toGetWorkUnits(): this;
    /**
     * (experimental) Grants permission to data lake permissions to a principal.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-GrantPermissions
     *
     * @experimental
     */
    toGrantPermissions(): this;
    /**
     * (experimental) Grants permission to list cell filters.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-data-filter.html#aws-lake-formation-api-data-filter-ListDataCellsFilter
     *
     * @experimental
     */
    toListDataCellsFilter(): this;
    /**
     * (experimental) Grants permission to list Lake Formation tags.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-ListLFTags
     *
     * @experimental
     */
    toListLFTags(): this;
    /**
     * (experimental) Grants permission to list permissions filtered by principal or resource.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-ListPermissions
     *
     * @experimental
     */
    toListPermissions(): this;
    /**
     * (experimental) Grants permission to List registered locations.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-ListResources
     *
     * @experimental
     */
    toListResources(): this;
    /**
     * (experimental) Grants permission to list all the storage optimizers for the Governed table.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-optimizers.html#aws-lake-formation-api-optimizers-ListTableStorageOptimizers
     *
     * @experimental
     */
    toListTableStorageOptimizers(): this;
    /**
     * (experimental) Grants permission to list all transactions in the system.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-transactions-api.html#aws-lake-formation-api-transactions-api-ListTransactions
     *
     * @experimental
     */
    toListTransactions(): this;
    /**
     * (experimental) Grants permission to overwrite data lake settings such as the list of data lake administrators and database and table default permissions.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-PutDataLakeSettings
     *
     * @experimental
     */
    toPutDataLakeSettings(): this;
    /**
     * (experimental) Grants permission to register a new location to be managed by Lake Formation.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-RegisterResource
     *
     * @experimental
     */
    toRegisterResource(): this;
    /**
     * (experimental) Grants permission to remove lakeformation tags from catalog resources.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-RemoveLFTagsFromResource
     *
     * @experimental
     */
    toRemoveLFTagsFromResource(): this;
    /**
     * (experimental) Grants permission to revoke data lake permissions from a principal.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-RevokePermissions
     *
     * @experimental
     */
    toRevokePermissions(): this;
    /**
     * (experimental) Grants permission to list catalog databases with Lake Formation tags.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-SearchDatabasesByLFTags
     *
     * @experimental
     */
    toSearchDatabasesByLFTags(): this;
    /**
     * (experimental) Grants permission to list catalog tables with Lake Formation tags.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-SearchTablesByLFTags
     *
     * @experimental
     */
    toSearchTablesByLFTags(): this;
    /**
     * (experimental) Grants permission to initiate the planning of the given query.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-querying.html#aws-lake-formation-api-querying-StartQueryPlanning
     *
     * @experimental
     */
    toStartQueryPlanning(): this;
    /**
     * (experimental) Grants permission to start a new transaction.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-transactions-api.html#aws-lake-formation-api-transactions-api-StartTransaction
     *
     * @experimental
     */
    toStartTransaction(): this;
    /**
     * (experimental) Grants permission to update a Lake Formation tag.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-UpdateLFTag
     *
     * @experimental
     */
    toUpdateLFTag(): this;
    /**
     * (experimental) Grants permission to update a registered location.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-UpdateResource
     *
     * @experimental
     */
    toUpdateResource(): this;
    /**
     * (experimental) Grants permission to add or delete the specified objects to or from a table.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-objects.html#aws-lake-formation-api-objects-UpdateTableObjects
     *
     * @experimental
     */
    toUpdateTableObjects(): this;
    /**
     * (experimental) Grants permission to update the configuration of the storage optimizer for the Governed table.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-optimizers.html#aws-lake-formation-api-optimizers-UpdateTableStorageOptimizer
     *
     * @experimental
     */
    toUpdateTableStorageOptimizer(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
}
