"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Ec2messages = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [ec2messages](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmessagedeliveryservice.html).
 *
 * @experimental
 */
class Ec2messages extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [ec2messages](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmessagedeliveryservice.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid) {
        super(sid);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'ec2messages';
        /**
         * @experimental
         */
        this.accessLevelList = {
            Write: [
                'AcknowledgeMessage',
                'DeleteMessage',
                'FailMessage',
                'SendReply'
            ],
            Read: [
                'GetEndpoint',
                'GetMessages'
            ]
        };
    }
    /**
     * (experimental) Grants permission to acknowledge a message, ensuring it will not be delivered again.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmessagedeliveryservice.html
     *
     * @experimental
     */
    toAcknowledgeMessage() {
        return this.to('AcknowledgeMessage');
    }
    /**
     * (experimental) Grants permission to delete a message.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmessagedeliveryservice.html
     *
     * @experimental
     */
    toDeleteMessage() {
        return this.to('DeleteMessage');
    }
    /**
     * (experimental) Grants permission to fail a message, signifying the message could not be processed successfully, ensuring it cannot be replied to or delivered again.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmessagedeliveryservice.html
     *
     * @experimental
     */
    toFailMessage() {
        return this.to('FailMessage');
    }
    /**
     * (experimental) Grants permission to route traffic to the correct endpoint based on the given destination for the messages.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmessagedeliveryservice.html
     *
     * @experimental
     */
    toGetEndpoint() {
        return this.to('GetEndpoint');
    }
    /**
     * (experimental) Grants permission to deliver messages to clients/instances using long polling.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmessagedeliveryservice.html
     *
     * @experimental
     */
    toGetMessages() {
        return this.to('GetMessages');
    }
    /**
     * (experimental) Grants permission to send replies from clients/instances to upstream service.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmessagedeliveryservice.html
     *
     * @experimental
     */
    toSendReply() {
        return this.to('SendReply');
    }
}
exports.Ec2messages = Ec2messages;
_a = JSII_RTTI_SYMBOL_1;
Ec2messages[_a] = { fqn: "iam-floyd.Ec2messages", version: "0.311.0" };
//# sourceMappingURL=data:application/json;base64,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