import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * (experimental) Statement provider for service [rbin](https://docs.aws.amazon.com/service-authorization/latest/reference/list_recyclebin.html).
 *
 * @experimental
 */
export declare class Rbin extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [rbin](https://docs.aws.amazon.com/service-authorization/latest/reference/list_recyclebin.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to create a Recycle Bin retention rule.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/recyclebin/latest/APIReference/API_CreateRule.html
     *
     * @experimental
     */
    toCreateRule(): this;
    /**
     * (experimental) Grants permission to delete a Recycle Bin retention rule.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/recyclebin/latest/APIReference/API_DeleteRule.html
     *
     * @experimental
     */
    toDeleteRule(): this;
    /**
     * (experimental) Grants permission to get detailed information about a Recycle Bin retention rule.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/recyclebin/latest/APIReference/API_GetRule.html
     *
     * @experimental
     */
    toGetRule(): this;
    /**
     * (experimental) Grants permission to list the Recycle Bin retention rules in the Region.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recyclebin/latest/APIReference/API_ListRules.html
     *
     * @experimental
     */
    toListRules(): this;
    /**
     * (experimental) Grants permission to list the tags associated with a resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recyclebin/latest/APIReference/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to add or update tags of a resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/recyclebin/latest/APIReference/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to remove tags associated with a resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/recyclebin/latest/APIReference/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update an existing Recycle Bin retention rule.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/recyclebin/latest/APIReference/API_UpdateRule.html
     *
     * @experimental
     */
    toUpdateRule(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type rule to the statement.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshot-recycle-bin.html#recycle-bin-concepts
     *
     * @param resourceName - Identifier for the resourceName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onRule(resourceName: string, account?: string, region?: string, partition?: string): this;
}
