"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BastionAccessPolicy = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const security_tag_1 = require("./security-tag");
class BastionAccessPolicy extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const securityTag = (props === null || props === void 0 ? void 0 : props.securityTag) ? props.securityTag
            : security_tag_1.DefaultSecurityTag;
        this.policy = new aws_cdk_lib_1.aws_iam.PolicyDocument({
            statements: [
                new aws_cdk_lib_1.aws_iam.PolicyStatement({
                    effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                    actions: [
                        'cloudwatch:DescribeAlarms',
                        'ec2:DescribeInstances',
                        'ec2:DescribeInstanceStatus',
                        'ec2:DescribeSecurityGroup*',
                        'identitystore:DescribeUser',
                        'ssm-guiconnect:CancelConnection',
                        'ssm-guiconnect:GetConnection',
                        'ssm-guiconnect:StartConnection',
                        'ssm:DescribeInstance*',
                        'ssm:GetCommandInvocation',
                        'ssm:GetInventorySchema',
                        'sso:ListDirectoryAssociations*',
                        'rds:Describe*',
                        'secretsmanager:ListSecrets',
                        'kms:ListAliases',
                    ],
                    resources: ['*'],
                }),
                new aws_cdk_lib_1.aws_iam.PolicyStatement({
                    effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                    actions: [
                        'ec2:GetPasswordData',
                        'ec2:StartInstances',
                        'ssm:GetConnectionStatus',
                        'ssm:SendCommand',
                        'ssm:StartSession',
                    ],
                    resources: ['arn:aws:ec2:*:*:instance/*'],
                    conditions: {
                        StringEquals: JSON.parse(`{"aws:ResourceTag/${securityTag.key}": "${securityTag.value}"}`),
                    },
                }),
                new aws_cdk_lib_1.aws_iam.PolicyStatement({
                    effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                    actions: [
                        'secretsmanager:DescribeSecret',
                        'secretsmanager:GetSecretValue',
                    ],
                    resources: ['*'],
                    conditions: {
                        StringEquals: JSON.parse(`{"aws:ResourceTag/${securityTag.key}": "${securityTag.value}"}`),
                    },
                }),
                new aws_cdk_lib_1.aws_iam.PolicyStatement({
                    effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                    actions: ['ssm:TerminateSession'],
                    resources: ['*'],
                    conditions: {
                        StringLike: {
                            'ssm:resourceTag/aws:ssmmessages:session-id': '${aws:userName}',
                        },
                    },
                }),
                new aws_cdk_lib_1.aws_iam.PolicyStatement({
                    effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                    actions: ['ssm:GetDocument'],
                    resources: [
                        'arn:aws:ssm:*:*:document/AWS-StartPortForwardingSession',
                        'arn:aws:ssm:*:*:document/SSM-SessionManagerRunShell',
                    ],
                }),
                new aws_cdk_lib_1.aws_iam.PolicyStatement({
                    effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                    actions: ['ssm:SendCommand', 'ssm:StartSession'],
                    resources: [
                        'arn:aws:ssm:*:*:document/AWS-StartPortForwardingSession',
                        'arn:aws:ssm:*:*:document/AWSSSO-CreateSSOUser',
                        'arn:aws:ssm:*:*:managed-instance/*',
                    ],
                    conditions: {
                        BoolIfExists: {
                            'ssm:SessionDocumentAccessCheck': 'true',
                        },
                    },
                }),
            ],
        });
    }
}
exports.BastionAccessPolicy = BastionAccessPolicy;
_a = JSII_RTTI_SYMBOL_1;
BastionAccessPolicy[_a] = { fqn: "pwed-cdk.pwed_bastion.BastionAccessPolicy", version: "0.0.51" };
//# sourceMappingURL=data:application/json;base64,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