"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ScheduleShutdown = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const security_tag_1 = require("./security-tag");
class ScheduleShutdown extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const securityTag = (props === null || props === void 0 ? void 0 : props.securityTag) ? props.securityTag
            : security_tag_1.DefaultSecurityTag;
        const maintanenceWindow = new aws_cdk_lib_1.aws_ssm.CfnMaintenanceWindow(this, 'BastionMaintanenceWindow', {
            allowUnassociatedTargets: false,
            cutoff: 0,
            duration: 1,
            name: aws_cdk_lib_1.Stack.of(scope).stackName + '-Maintanence-Window',
            schedule: (props === null || props === void 0 ? void 0 : props.shutdownSchedule) ? props.shutdownSchedule
                : 'cron(0 2 ? * * *)',
            scheduleTimezone: (props === null || props === void 0 ? void 0 : props.timezone) ? props.timezone
                : 'Australia/Melbourne',
        });
        const maintanenceTarget = new aws_cdk_lib_1.aws_ssm.CfnMaintenanceWindowTarget(this, 'BastionMaintanenceTarget', {
            resourceType: 'INSTANCE',
            targets: [
                {
                    key: `tag:${securityTag.key}`,
                    values: [securityTag.value],
                },
            ],
            windowId: maintanenceWindow.ref,
        });
        const taskRole = new aws_cdk_lib_1.aws_iam.Role(this, 'AutomationRole', {
            inlinePolicies: {
                ec2Stop: new aws_cdk_lib_1.aws_iam.PolicyDocument({
                    statements: [
                        new aws_cdk_lib_1.aws_iam.PolicyStatement({
                            effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                            resources: ['*'],
                            actions: ['ec2:StopInstances'],
                            conditions: {
                                StringEquals: JSON.parse(`{"aws:ResourceTag/${securityTag.key}": "${securityTag.value}"}`),
                            },
                        }),
                        new aws_cdk_lib_1.aws_iam.PolicyStatement({
                            effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                            resources: ['*'],
                            actions: ['ec2:DescribeInstances', 'ec2:DescribeInstanceStatus'],
                        }),
                    ],
                }),
            },
            assumedBy: new aws_cdk_lib_1.aws_iam.ServicePrincipal('ssm.amazonaws.com'),
        });
        new aws_cdk_lib_1.aws_ssm.CfnMaintenanceWindowTask(this, 'BastionStop', {
            priority: 1,
            taskArn: 'AWS-StopEC2Instance',
            taskType: 'AUTOMATION',
            windowId: maintanenceWindow.ref,
            taskInvocationParameters: {
                maintenanceWindowAutomationParameters: {
                    documentVersion: '1',
                    parameters: {
                        InstanceId: ['{{RESOURCE_ID}}'],
                        AutomationAssumeRole: [taskRole.roleArn],
                    },
                },
            },
            maxErrors: '1',
            maxConcurrency: '1',
            targets: [
                {
                    key: 'WindowTargetIds',
                    values: [maintanenceTarget.ref],
                },
            ],
        });
    }
}
exports.ScheduleShutdown = ScheduleShutdown;
_a = JSII_RTTI_SYMBOL_1;
ScheduleShutdown[_a] = { fqn: "pwed-cdk.pwed_bastion.ScheduleShutdown", version: "0.0.51" };
//# sourceMappingURL=data:application/json;base64,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