import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * (experimental) Statement provider for service [mediapackage](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awselementalmediapackage.html).
 *
 * @experimental
 */
export declare class Mediapackage extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Grants permission to configure access logs for a Channel.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:CreateServiceLinkedRole
     *
     * https://docs.aws.amazon.com/mediapackage/latest/apireference/channels-id-configure_logs.html#channels-id-configure_logsput
     *
     * @experimental
     */
    toConfigureLogs(): this;
    /**
     * (experimental) Grants permission to create a channel in AWS Elemental MediaPackage.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mediapackage/latest/apireference/channels.html#channelspost
     *
     * @experimental
     */
    toCreateChannel(): this;
    /**
     * (experimental) Grants permission to create a harvest job in AWS Elemental MediaPackage.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mediapackage/latest/apireference/harvest_jobs.html#harvest_jobspost
     *
     * @experimental
     */
    toCreateHarvestJob(): this;
    /**
     * (experimental) Grants permission to create an endpoint in AWS Elemental MediaPackage.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mediapackage/latest/apireference/origin_endpoints.html#origin_endpointspost
     *
     * @experimental
     */
    toCreateOriginEndpoint(): this;
    /**
     * (experimental) Grants permission to delete a channel in AWS Elemental MediaPackage.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediapackage/latest/apireference/channels-id.html#channels-iddelete
     *
     * @experimental
     */
    toDeleteChannel(): this;
    /**
     * (experimental) Grants permission to delete an endpoint in AWS Elemental MediaPackage.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediapackage/latest/apireference/origin_endpoints-id.html#origin_endpoints-iddelete
     *
     * @experimental
     */
    toDeleteOriginEndpoint(): this;
    /**
     * (experimental) Grants permission to view the details of a channel in AWS Elemental MediaPackage.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediapackage/latest/apireference/channels-id.html#channels-idget
     *
     * @experimental
     */
    toDescribeChannel(): this;
    /**
     * (experimental) Grants permission to view the details of a harvest job in AWS Elemental MediaPackage.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediapackage/latest/apireference/harvest_jobs-id.html#harvest_jobs-idget
     *
     * @experimental
     */
    toDescribeHarvestJob(): this;
    /**
     * (experimental) Grants permission to view the details of an endpoint in AWS Elemental MediaPackage.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediapackage/latest/apireference/origin_endpoints-id.html#origin_endpoints-idget
     *
     * @experimental
     */
    toDescribeOriginEndpoint(): this;
    /**
     * (experimental) Grants permission to view a list of channels in AWS Elemental MediaPackage.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediapackage/latest/apireference/channels.html#channelsget
     *
     * @experimental
     */
    toListChannels(): this;
    /**
     * (experimental) Grants permission to view a list of harvest jobs in AWS Elemental MediaPackage.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediapackage/latest/apireference/harvest_jobs.html#harvest_jobsget
     *
     * @experimental
     */
    toListHarvestJobs(): this;
    /**
     * (experimental) Grants permission to view a list of endpoints in AWS Elemental MediaPackage.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediapackage/latest/apireference/origin_endpoints.html#origin_endpointsget
     *
     * @experimental
     */
    toListOriginEndpoints(): this;
    /**
     * (experimental) Grants permission to list the tags assigned to a Channel or OriginEndpoint.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediapackage/latest/apireference/tags-resource-arn.html#tags-resource-arnget
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to rotate credentials for the first IngestEndpoint of a Channel in AWS Elemental MediaPackage.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediapackage/latest/apireference/channels-id-credentials.html#channels-id-credentialsput
     *
     * @experimental
     */
    toRotateChannelCredentials(): this;
    /**
     * (experimental) Grants permission to rotate IngestEndpoint credentials for a Channel in AWS Elemental MediaPackage.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediapackage/latest/apireference/channels-id-ingest_endpoints-ingest_endpoint_id-credentials.html#channels-id-ingest_endpoints-ingest_endpoint_id-credentialsput
     *
     * @experimental
     */
    toRotateIngestEndpointCredentials(): this;
    /**
     * (experimental) Grants permission to tag a MediaPackage resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mediapackage/latest/apireference/hj-create.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to delete tags to a Channel or OriginEndpoint.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mediapackage/latest/apireference/tags-resource-arn.html#tags-resource-arndelete
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to make changes to a channel in AWS Elemental MediaPackage.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediapackage/latest/apireference/channels-id.html#channels-idput
     *
     * @experimental
     */
    toUpdateChannel(): this;
    /**
     * (experimental) Grants permission to make changes to an endpoint in AWS Elemental MediaPackage.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediapackage/latest/apireference/origin_endpoints-id.html#origin_endpoints-idput
     *
     * @experimental
     */
    toUpdateOriginEndpoint(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type channels to the statement.
     *
     * https://docs.aws.amazon.com/mediapackage/latest/ug/channels.html
     *
     * @param channelIdentifier - Identifier for the channelIdentifier.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onChannels(channelIdentifier: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type origin_endpoints to the statement.
     *
     * https://docs.aws.amazon.com/mediapackage/latest/ug/endpoints.html
     *
     * @param originEndpointIdentifier - Identifier for the originEndpointIdentifier.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onOriginEndpoints(originEndpointIdentifier: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type harvest_jobs to the statement.
     *
     * https://docs.aws.amazon.com/mediapackage/latest/ug/harvest-jobs.html
     *
     * @param harvestJobIdentifier - Identifier for the harvestJobIdentifier.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onHarvestJobs(harvestJobIdentifier: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Statement provider for service [mediapackage](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awselementalmediapackage.html).
     *
     * @experimental
     */
    constructor(props?: iam.PolicyStatementProps);
}
