import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * (experimental) Statement provider for service [launchwizard](https://docs.aws.amazon.com/service-authorization/latest/reference/list_launchwizard.html).
 *
 * @experimental
 */
export declare class Launchwizard extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Delete an application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/launchwizard/
     *
     * @experimental
     */
    toDeleteApp(): this;
    /**
     * (experimental) Describe provisioning applications.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/launchwizard/
     *
     * @experimental
     */
    toDescribeProvisionedApp(): this;
    /**
     * (experimental) Describe provisioning events.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/launchwizard/
     *
     * @experimental
     */
    toDescribeProvisioningEvents(): this;
    /**
     * (experimental) Get infrastructure suggestion.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/launchwizard/
     *
     * @experimental
     */
    toGetInfrastructureSuggestion(): this;
    /**
     * (experimental) Get customer's ip address.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/launchwizard/
     *
     * @experimental
     */
    toGetIpAddress(): this;
    /**
     * (experimental) Get resource cost estimate.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/launchwizard/
     *
     * @experimental
     */
    toGetResourceCostEstimate(): this;
    /**
     * (experimental) List provisioning applications.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/launchwizard/
     *
     * @experimental
     */
    toListProvisionedApps(): this;
    /**
     * (experimental) Start a provisioning.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/launchwizard/
     *
     * @experimental
     */
    toStartProvisioning(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Statement provider for service [launchwizard](https://docs.aws.amazon.com/service-authorization/latest/reference/list_launchwizard.html).
     *
     * @experimental
     */
    constructor(props?: iam.PolicyStatementProps);
}
