"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Nimble = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [nimble](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonnimblestudio.html).
 *
 * @experimental
 */
class Nimble extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [nimble](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonnimblestudio.html).
     *
     * @experimental
     */
    constructor(props) {
        super(props);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'nimble';
        /**
         * @experimental
         */
        this.accessLevelList = {
            Write: [
                'AcceptEulas',
                'CreateLaunchProfile',
                'CreateStreamingImage',
                'CreateStreamingSession',
                'CreateStreamingSessionStream',
                'CreateStudio',
                'CreateStudioComponent',
                'DeleteLaunchProfile',
                'DeleteLaunchProfileMember',
                'DeleteStreamingImage',
                'DeleteStreamingSession',
                'DeleteStudio',
                'DeleteStudioComponent',
                'DeleteStudioMember',
                'PutLaunchProfileMembers',
                'PutStudioLogEvents',
                'PutStudioMembers',
                'StartStreamingSession',
                'StartStudioSSOConfigurationRepair',
                'StopStreamingSession',
                'UpdateLaunchProfile',
                'UpdateLaunchProfileMember',
                'UpdateStreamingImage',
                'UpdateStudio',
                'UpdateStudioComponent'
            ],
            Read: [
                'GetEula',
                'GetFeatureMap',
                'GetLaunchProfile',
                'GetLaunchProfileDetails',
                'GetLaunchProfileInitialization',
                'GetLaunchProfileMember',
                'GetStreamingImage',
                'GetStreamingSession',
                'GetStreamingSessionStream',
                'GetStudio',
                'GetStudioComponent',
                'GetStudioMember',
                'ListEulaAcceptances',
                'ListEulas',
                'ListLaunchProfileMembers',
                'ListLaunchProfiles',
                'ListStreamingImages',
                'ListStreamingSessions',
                'ListStudioComponents',
                'ListStudioMembers',
                'ListStudios',
                'ListTagsForResource'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * (experimental) Grants permission to accept EULAs.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_AcceptEulas.html
     *
     * @experimental
     */
    toAcceptEulas() {
        return this.to('AcceptEulas');
    }
    /**
     * (experimental) Grants permission to create a launch profile.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * Dependent actions:
     * - ec2:CreateNetworkInterface
     * - ec2:RunInstances
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_CreateLaunchProfile.html
     *
     * @experimental
     */
    toCreateLaunchProfile() {
        return this.to('CreateLaunchProfile');
    }
    /**
     * (experimental) Grants permission to create a streaming image.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * Dependent actions:
     * - ec2:DescribeImages
     * - ec2:DescribeSnapshots
     * - ec2:ModifyInstanceAttribute
     * - ec2:ModifySnapshotAttribute
     * - ec2:RegisterImage
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_CreateStreamingImage.html
     *
     * @experimental
     */
    toCreateStreamingImage() {
        return this.to('CreateStreamingImage');
    }
    /**
     * (experimental) Grants permission to create a streaming session.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * Dependent actions:
     * - ec2:CreateNetworkInterface
     * - ec2:CreateNetworkInterfacePermission
     * - nimble:GetLaunchProfile
     * - nimble:GetLaunchProfileInitialization
     * - nimble:ListEulaAcceptances
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_CreateStreamingSession.html
     *
     * @experimental
     */
    toCreateStreamingSession() {
        return this.to('CreateStreamingSession');
    }
    /**
     * (experimental) Grants permission to create a StreamingSessionStream.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRequesterPrincipalId()
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_CreateStreamingSessionStream.html
     *
     * @experimental
     */
    toCreateStreamingSessionStream() {
        return this.to('CreateStreamingSessionStream');
    }
    /**
     * (experimental) Grants permission to create a studio.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * Dependent actions:
     * - iam:PassRole
     * - sso:CreateManagedApplicationInstance
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_CreateStudio.html
     *
     * @experimental
     */
    toCreateStudio() {
        return this.to('CreateStudio');
    }
    /**
     * (experimental) Grants permission to create a studio component.
     *
     * A studio component designates a network resource to which a launch profile will provide access
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * Dependent actions:
     * - ds:AuthorizeApplication
     * - ds:DescribeDirectories
     * - ec2:DescribeSecurityGroups
     * - fsx:DescribeFileSystems
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_CreateStudioComponent.html
     *
     * @experimental
     */
    toCreateStudioComponent() {
        return this.to('CreateStudioComponent');
    }
    /**
     * (experimental) Grants permission to delete a launch profile.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_DeleteLaunchProfile.html
     *
     * @experimental
     */
    toDeleteLaunchProfile() {
        return this.to('DeleteLaunchProfile');
    }
    /**
     * (experimental) Grants permission to delete a launch profile member.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_DeleteLaunchProfileMember.html
     *
     * @experimental
     */
    toDeleteLaunchProfileMember() {
        return this.to('DeleteLaunchProfileMember');
    }
    /**
     * (experimental) Grants permission to delete a streaming image.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ec2:DeleteSnapshot
     * - ec2:DeregisterImage
     * - ec2:ModifyInstanceAttribute
     * - ec2:ModifySnapshotAttribute
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_DeleteStreamingImage.html
     *
     * @experimental
     */
    toDeleteStreamingImage() {
        return this.to('DeleteStreamingImage');
    }
    /**
     * (experimental) Grants permission to delete a streaming session.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRequesterPrincipalId()
     *
     * Dependent actions:
     * - ec2:DeleteNetworkInterface
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_DeleteStreamingSession.html
     *
     * @experimental
     */
    toDeleteStreamingSession() {
        return this.to('DeleteStreamingSession');
    }
    /**
     * (experimental) Grants permission to delete a studio.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - sso:DeleteManagedApplicationInstance
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_DeleteStudio.html
     *
     * @experimental
     */
    toDeleteStudio() {
        return this.to('DeleteStudio');
    }
    /**
     * (experimental) Grants permission to delete a studio component.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ds:UnauthorizeApplication
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_DeleteStudioComponent.html
     *
     * @experimental
     */
    toDeleteStudioComponent() {
        return this.to('DeleteStudioComponent');
    }
    /**
     * (experimental) Grants permission to delete a studio member.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_DeleteStudioMember.html
     *
     * @experimental
     */
    toDeleteStudioMember() {
        return this.to('DeleteStudioMember');
    }
    /**
     * (experimental) Grants permission to get a EULA.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_GetEula.html
     *
     * @experimental
     */
    toGetEula() {
        return this.to('GetEula');
    }
    /**
     * (experimental) Grants permission to allow Nimble Studio portal to show the appropriate features for this account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/userguide/security-iam-service-with-iam.html
     *
     * @experimental
     */
    toGetFeatureMap() {
        return this.to('GetFeatureMap');
    }
    /**
     * (experimental) Grants permission to get a launch profile.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_GetLaunchProfile.html
     *
     * @experimental
     */
    toGetLaunchProfile() {
        return this.to('GetLaunchProfile');
    }
    /**
     * (experimental) Grants permission to get a launch profile's details, which includes the summary of studio components and streaming images used by the launch profile.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_GetLaunchProfileDetails.html
     *
     * @experimental
     */
    toGetLaunchProfileDetails() {
        return this.to('GetLaunchProfileDetails');
    }
    /**
     * (experimental) Grants permission to get a launch profile initialization.
     *
     * A launch profile initialization is a dereferenced version of a launch profile, including attached studio component connection information
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - ds:DescribeDirectories
     * - ec2:DescribeSecurityGroups
     * - fsx:DescribeFileSystems
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_GetLaunchProfileInitialization.html
     *
     * @experimental
     */
    toGetLaunchProfileInitialization() {
        return this.to('GetLaunchProfileInitialization');
    }
    /**
     * (experimental) Grants permission to get a launch profile member.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_GetLaunchProfileMember.html
     *
     * @experimental
     */
    toGetLaunchProfileMember() {
        return this.to('GetLaunchProfileMember');
    }
    /**
     * (experimental) Grants permission to get a streaming image.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_GetStreamingImage.html
     *
     * @experimental
     */
    toGetStreamingImage() {
        return this.to('GetStreamingImage');
    }
    /**
     * (experimental) Grants permission to get a streaming session.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifRequesterPrincipalId()
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_GetStreamingSession.html
     *
     * @experimental
     */
    toGetStreamingSession() {
        return this.to('GetStreamingSession');
    }
    /**
     * (experimental) Grants permission to get a streaming session stream.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifRequesterPrincipalId()
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_GetStreamingSessionStream.html
     *
     * @experimental
     */
    toGetStreamingSessionStream() {
        return this.to('GetStreamingSessionStream');
    }
    /**
     * (experimental) Grants permission to get a studio.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_GetStudio.html
     *
     * @experimental
     */
    toGetStudio() {
        return this.to('GetStudio');
    }
    /**
     * (experimental) Grants permission to get a studio component.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_GetStudioComponent.html
     *
     * @experimental
     */
    toGetStudioComponent() {
        return this.to('GetStudioComponent');
    }
    /**
     * (experimental) Grants permission to get a studio member.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_GetStudioMember.html
     *
     * @experimental
     */
    toGetStudioMember() {
        return this.to('GetStudioMember');
    }
    /**
     * (experimental) Grants permission to list EULA acceptances.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_ListEulaAcceptances.html
     *
     * @experimental
     */
    toListEulaAcceptances() {
        return this.to('ListEulaAcceptances');
    }
    /**
     * (experimental) Grants permission to list EULAs.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_ListEulas.html
     *
     * @experimental
     */
    toListEulas() {
        return this.to('ListEulas');
    }
    /**
     * (experimental) Grants permission to list launch profile members.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_ListLaunchProfileMembers.html
     *
     * @experimental
     */
    toListLaunchProfileMembers() {
        return this.to('ListLaunchProfileMembers');
    }
    /**
     * (experimental) Grants permission to list launch profiles.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifPrincipalId()
     * - .ifRequesterPrincipalId()
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_ListLaunchProfiles.html
     *
     * @experimental
     */
    toListLaunchProfiles() {
        return this.to('ListLaunchProfiles');
    }
    /**
     * (experimental) Grants permission to list streaming images.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_ListStreamingImages.html
     *
     * @experimental
     */
    toListStreamingImages() {
        return this.to('ListStreamingImages');
    }
    /**
     * (experimental) Grants permission to list streaming sessions.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifCreatedBy()
     * - .ifOwnedBy()
     * - .ifRequesterPrincipalId()
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_ListStreamingSessions.html
     *
     * @experimental
     */
    toListStreamingSessions() {
        return this.to('ListStreamingSessions');
    }
    /**
     * (experimental) Grants permission to list studio components.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_ListStudioComponents.html
     *
     * @experimental
     */
    toListStudioComponents() {
        return this.to('ListStudioComponents');
    }
    /**
     * (experimental) Grants permission to list studio members.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_ListStudioMembers.html
     *
     * @experimental
     */
    toListStudioMembers() {
        return this.to('ListStudioMembers');
    }
    /**
     * (experimental) Grants permission to list all studios.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_ListStudios.html
     *
     * @experimental
     */
    toListStudios() {
        return this.to('ListStudios');
    }
    /**
     * (experimental) Grants permission to list all tags on a Nimble Studio resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * (experimental) Grants permission to add/update launch profile members.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - sso-directory:DescribeUsers
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_PutLaunchProfileMembers.html
     *
     * @experimental
     */
    toPutLaunchProfileMembers() {
        return this.to('PutLaunchProfileMembers');
    }
    /**
     * (experimental) Grants permission to report metrics and logs for the Nimble Studio portal to monitor application health.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/userguide/security-iam-service-with-iam.html
     *
     * @experimental
     */
    toPutStudioLogEvents() {
        return this.to('PutStudioLogEvents');
    }
    /**
     * (experimental) Grants permission to add/update studio members.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - sso-directory:DescribeUsers
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_PutStudioMembers.html
     *
     * @experimental
     */
    toPutStudioMembers() {
        return this.to('PutStudioMembers');
    }
    /**
     * (experimental) Grants permission to start a streaming session.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRequesterPrincipalId()
     *
     * Dependent actions:
     * - nimble:GetLaunchProfile
     * - nimble:GetLaunchProfileMember
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_StartStreamingSession.html
     *
     * @experimental
     */
    toStartStreamingSession() {
        return this.to('StartStreamingSession');
    }
    /**
     * (experimental) Grants permission to repair the studio's AWS SSO configuration.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - sso:CreateManagedApplicationInstance
     * - sso:GetManagedApplicationInstance
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_StartStudioSSOConfigurationRepair.html
     *
     * @experimental
     */
    toStartStudioSSOConfigurationRepair() {
        return this.to('StartStudioSSOConfigurationRepair');
    }
    /**
     * (experimental) Grants permission to stop a streaming session.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRequesterPrincipalId()
     *
     * Dependent actions:
     * - nimble:GetLaunchProfile
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_StopStreamingSession.html
     *
     * @experimental
     */
    toStopStreamingSession() {
        return this.to('StopStreamingSession');
    }
    /**
     * (experimental) Grants permission to add or overwrite one or more tags for the specified Nimble Studio resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_TagResource.html
     *
     * @experimental
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * (experimental) Grants permission to disassociate one or more tags from the specified Nimble Studio resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * (experimental) Grants permission to update a launch profile.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_UpdateLaunchProfile.html
     *
     * @experimental
     */
    toUpdateLaunchProfile() {
        return this.to('UpdateLaunchProfile');
    }
    /**
     * (experimental) Grants permission to update a launch profile member.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_UpdateLaunchProfileMember.html
     *
     * @experimental
     */
    toUpdateLaunchProfileMember() {
        return this.to('UpdateLaunchProfileMember');
    }
    /**
     * (experimental) Grants permission to update a streaming image.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_UpdateStreamingImage.html
     *
     * @experimental
     */
    toUpdateStreamingImage() {
        return this.to('UpdateStreamingImage');
    }
    /**
     * (experimental) Grants permission to update a studio.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_UpdateStudio.html
     *
     * @experimental
     */
    toUpdateStudio() {
        return this.to('UpdateStudio');
    }
    /**
     * (experimental) Grants permission to update a studio component.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ds:AuthorizeApplication
     * - ds:DescribeDirectories
     * - ec2:DescribeSecurityGroups
     * - fsx:DescribeFileSystems
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_UpdateStudioComponent.html
     *
     * @experimental
     */
    toUpdateStudioComponent() {
        return this.to('UpdateStudioComponent');
    }
    /**
     * (experimental) Adds a resource of type studio to the statement.
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_Studio.html
     *
     * @param studioId - Identifier for the studioId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onStudio(studioId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:nimble:${region || '*'}:${account || '*'}:studio/${studioId}`);
    }
    /**
     * (experimental) Adds a resource of type streaming-image to the statement.
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_StreamingImage.html
     *
     * @param streamingImageId - Identifier for the streamingImageId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onStreamingImage(streamingImageId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:nimble:${region || '*'}:${account || '*'}:streaming-image/${streamingImageId}`);
    }
    /**
     * (experimental) Adds a resource of type studio-component to the statement.
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_StudioComponent.html
     *
     * @param studioComponentId - Identifier for the studioComponentId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onStudioComponent(studioComponentId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:nimble:${region || '*'}:${account || '*'}:studio-component/${studioComponentId}`);
    }
    /**
     * (experimental) Adds a resource of type launch-profile to the statement.
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_LaunchProfile.html
     *
     * @param launchProfileId - Identifier for the launchProfileId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onLaunchProfile(launchProfileId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:nimble:${region || '*'}:${account || '*'}:launch-profile/${launchProfileId}`);
    }
    /**
     * (experimental) Adds a resource of type streaming-session to the statement.
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_StreamingSession.html
     *
     * @param streamingSessionId - Identifier for the streamingSessionId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onStreamingSession(streamingSessionId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:nimble:${region || '*'}:${account || '*'}:streaming-session/${streamingSessionId}`);
    }
    /**
     * (experimental) Adds a resource of type eula to the statement.
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_Eula.html
     *
     * @param eulaId - Identifier for the eulaId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onEula(eulaId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:nimble:${region || '*'}:${account || '*'}:eula/${eulaId}`);
    }
    /**
     * (experimental) Adds a resource of type eula-acceptance to the statement.
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_EulaAcceptance.html
     *
     * @param eulaAcceptanceId - Identifier for the eulaAcceptanceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onEulaAcceptance(eulaAcceptanceId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:nimble:${region || '*'}:${account || '*'}:eula-acceptance/${eulaAcceptanceId}`);
    }
    /**
     * (experimental) Filters access by the createdBy request parameter or the ID of the creator of the resource.
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/userguide/security-iam-service-with-iam.html
     *
     * Applies to actions:
     * - .toListStreamingSessions()
     *
     * Applies to resource types:
     * - streaming-session
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifCreatedBy(value, operator) {
        return this.if(`createdBy`, value, operator || 'StringLike');
    }
    /**
     * (experimental) Filters access by the ownedBy request parameter or the ID of the owner of the resource.
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/userguide/security-iam-service-with-iam.html
     *
     * Applies to actions:
     * - .toListStreamingSessions()
     *
     * Applies to resource types:
     * - streaming-session
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifOwnedBy(value, operator) {
        return this.if(`ownedBy`, value, operator || 'StringLike');
    }
    /**
     * (experimental) Filters access by the principalId request parameter.
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/userguide/security-iam-service-with-iam.html
     *
     * Applies to actions:
     * - .toListLaunchProfiles()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifPrincipalId(value, operator) {
        return this.if(`principalId`, value, operator || 'StringLike');
    }
    /**
     * (experimental) Filters access by the ID of the logged in user.
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/userguide/security-iam-service-with-iam.html
     *
     * Applies to actions:
     * - .toCreateStreamingSessionStream()
     * - .toDeleteStreamingSession()
     * - .toGetStreamingSession()
     * - .toGetStreamingSessionStream()
     * - .toListLaunchProfiles()
     * - .toListStreamingSessions()
     * - .toStartStreamingSession()
     * - .toStopStreamingSession()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifRequesterPrincipalId(value, operator) {
        return this.if(`requesterPrincipalId`, value, operator || 'StringLike');
    }
    /**
     * (experimental) Filters access by a specific studio.
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/userguide/security-iam-service-with-iam.html
     *
     * Applies to resource types:
     * - studio
     * - streaming-image
     * - studio-component
     * - launch-profile
     * - eula-acceptance
     *
     * @param value The value(s) to check.
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`.
     * @experimental
     */
    ifStudioId(value, operator) {
        return this.if(`studioId`, value, operator || 'ArnLike');
    }
}
exports.Nimble = Nimble;
_a = JSII_RTTI_SYMBOL_1;
Nimble[_a] = { fqn: "cdk-iam-floyd.Nimble", version: "0.300.0" };
//# sourceMappingURL=data:application/json;base64,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